<?php

$fontstyles = array('italic', 'bold', 'smallcaps', 'color', 'bgcolor', 'underline', 'overline', 'strikethrough', 'fontfamily');

/**
 * Checks if a user can use a specific text markup
 *
 * @param string Name of the font-style used
 *
 * @return bool
 */
function can_use($style)
{
    global $vbulletin, $permissions;
    if(
        ($vbulletin->options['op_user_html_markup_allowed'] & $vbulletin->bf_misc_op_user_html_markup['allow'. $style])
        AND
        ($permissions['op_user_html_markup_permissions'] & $vbulletin->bf_ugp_op_user_html_markup_permissions['op_can_use_'. $style])
    )
    {
        return true;
    }
    return false;
}
/**
 * Fetch list of fonts based on those define in options as
 * font|font css returned as [font] => [font css]
 *
 * @return array
 */
function fetch_font_list()
{
    global $vbulletin;
    if(!empty($vbulletin->options['op_user_html_markup_fontoptions']))
    {
        $fontlist = explode("\n", $vbulletin->options['op_user_html_markup_fontoptions']);
        foreach($fontlist as $fontitem)
        {
            $fontitem = explode('|', $fontitem);
            $fontarr[$fontitem[0]] = trim($fontitem[1]);
        }
        
        return $fontarr;
    }
    
    return false;
}

?>