<?php

class EWRporta_Option_StyleChooser
{
	/**
	 * Renders the chosen style option.
	 *
	 * @param XenForo_View $view View object
	 * @param string $fieldPrefix Prefix for the HTML form field name
	 * @param array $preparedOption Prepared option info
	 * @param boolean $canEdit True if an "edit" link should appear
	 *
	 * @return XenForo_Template_Abstract Template object
	 */
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$value = $preparedOption['option_value'];

		$editLink = $view->createTemplateObject('option_list_option_editlink', array(
			'preparedOption' => $preparedOption,
			'canEditOptionDefinition' => $canEdit
		));

		$styleModel = self::_getStyleModel();

		$styleOptions = $styleModel->getStylesForOptionsTag(
			$value['style']
		);

		return $view->createTemplateObject('option_template_styleChooser_EWRporta', array(
			'fieldPrefix' => $fieldPrefix,
			'listedFieldName' => $fieldPrefix . '_listed[]',
			'preparedOption' => $preparedOption,
			'formatParams' => $styleOptions,
			'editLink' => $editLink
		));
	}

	/**
	 * Verifies and prepares the style option to the correct format.
	 *
	 * @param array $options List of returned options
	 * @param XenForo_DataWriter $dw Calling DW
	 * @param string $fieldName Name of field/option
	 *
	 * @return true
	 */
	public static function verifyOption(array &$options, XenForo_DataWriter $dw, $fieldName)
	{
		if (!empty($options['force']))
		{
			echo "FORCED!"; exit;
		}

		echo "NOT FORCED!"; exit;
	}

	/**
	 * @return XenForo_Model_Style
	 */
	protected static function _getStyleModel()
	{
		return XenForo_Model::create('XenForo_Model_Style');
	}
}