<?php

/**
	@author Andreas "Radon" Rudolph
	@author Disasterpiece (vbulletin.org)
	@url http://purgatory-labs.de
	@url http://vbulletin.org
	@date last-modified: 17/05/2011

	Distribution notes

	This file may not be redistributed without written permission to do so
	and *must be left unmodified*, including this information block!
	Written as part as a vbulletin modification


**/

function plwm_fetchOptions() {
	global $vbulletin;

	$db = &$vbulletin->db;
	$query = "SELECT varname, value FROM " . TABLE_PREFIX . "plwmsettings";

	$res = $db->query_read_slave($query);
	while ($row = $db->fetch_array($res, DBARRAY_NUM)) {
		$vbulletin->options[$row[0]] = $row[1];
		#echo "Fetched $row[0]: $row[1]<br />\n";
	}
}

function plwm_getCachedObject($cachepath, $attachmentinfo) {
	global $vbulletin;


	$cachename = plwm_getCacheName($cachepath, $attachmentinfo);

	// File cached?
	if (!file_exists($cachename)) return null;

	// Not too old?
	$fmod = filemtime($cachename);
	if (time() - $vbulletin->options['plwm_cache_lifetime'] > $fmod
	// Original file is newer?
		|| $attachmentinfo['dateline'] > $fmod) return null;
	
	// We got this far, so file is valid.
	return $cachename;
}


function plwm_addWatermark(&$im) {

    $i = null;
    #var_dump($im->options['plwm_watermark_method']);
	switch ($im->options['plwm_watermark_method']) {

		case 'file':
			$i = $im->addFileImage($im->options['plwm_watermark_path']);
			break;

		case 'text':
			$im->options['plwm_watermark_font']<1
				? $im->stringTTFToLayer(
					$im->options['plwm_watermark_text'],
					$im->options['plwm_watermark_ttf'],
					$im->options['plwm_watermark_size'],
					$im->options['plwm_watermark_color'],
					$im->options['plwm_watermark_shadecolor'],
					$im->options['plwm_watermark_alpha'],
					$im->options['plwm_watermark_posinfo']
				)
				: $im->stringToLayer(
					$im->options['plwm_watermark_text'],
					$im->options['plwm_watermark_font'],
					$im->options['plwm_watermark_color'],
					$im->options['plwm_watermark_shadecolor'],
					$im->options['plwm_watermark_alpha'],
					$im->options['plwm_watermark_posinfo']
				);
			return;

		case 'attachment':
			$i = $im->addAttachmentImage(array('attachmentid'=>$im->options['plwm_watermark_attid']));
			break;

		default:
			return;
	}

	$pos = explode(',',$im->options['plwm_watermark_posinfo']);
	list($iw, $ih) = $im->getLayerSize(0);
	list($ww, $wh) = $im->getLayerSize($i);
	if (!isset($pos[1])) $pos[1] = 0;
	if (!isset($pos[2])) $pos[2] = 0;

	switch ($pos[0]) {

		case 0: // Upper left corner
			$o_x = $pos[1];
			$o_y = $pos[2];
			break;

		case 1: // Upper right corner
			$o_x = $iw - $ww - $pos[1];
			$o_y = $pos[2];
			break;

		case 2: // Bottom right corner
			$o_x = $iw - $ww - $pos[1];
			$o_y = $ih - $wh - $pos[2];
            break;

		case 3: // Bottom left corner
			$o_x = $pos[1];
			$o_y = $ih - $wh - $pos[2];
			break;
			
		case 4: // Center
		default:
			$o_x = intval(($iw/2) - ($ww/2) - $pos[1]);
			$o_y = intval(($ih/2) - ($wh/2) - $pos[2]);

	}
	#echo "positioninfo: $o_x, $o_y\n";
	#echo "sizes: $iw, $ih; $ww, $wh\n";
	$im->setPositionInfo($i, array($o_x, $o_y));
}

function plwm_getCacheName($cachepath, $attachmentinfo) {
	if (empty($attachmentinfo['attachmentid'])) return null;
	$cachename = $cachepath;
	if ($cachepath{strlen($cachepath)-1} != '/') $cachename .= '/';
	$cachename .= $attachmentinfo['attachmentid'].".attach.pl_cached";
	
	return $cachename;
}

function plwm_fetchPreviewOptions() {
	global $vbulletin;

	plwm_fetchOptions();

	$prevraw = $vbulletin->plwm_prevsettings;
	if ($prevraw == null) {
		$query = "
				SELECT data
				FROM " . TABLE_PREFIX . "datastore
				WHERE title = 'plwm_prevsettings'
			";

		$res = $vbulletin->db->query_first_slave($query);
		$prevraw = unserialize($res['data']);
	}
	if (!is_array($prevraw)) {
		return false;
	}

	$prevraw['watermark_posinfo'] = sprintf("%d,%d,%d", $prevraw['watermark_posinfo_scrpos'], $prevraw['watermark_posinfo_off_x'], $prevraw['watermark_posinfo_off_y']);
	$whitelist = array('watermark_method','watermark_path','watermark_text','watermark_font','watermark_ttf','watermark_size','watermark_color','watermark_shadecolor','watermark_alpha','watermark_attid','watermark_posinfo','watermark_quality');

	$fetched=false;
	foreach($whitelist as $key) {
		if (isset($prevraw[$key])) {
			#echo "Replacing $key; $prevraw[$key] -&gt; $vbulletin->options[plwm_$key] ... ";
			$vbulletin->options['plwm_'.$key] = $prevraw[$key];
			#echo "[plwm_$key] : ".$vbulletin->options['plwm_'.$key] . "<br />\n";
			$fetched=true;
		}
		if ($fetched) $vbulletin->options['plwm_is_preview']=1;
	}

	// Clear preview settings
	#build_datastore('plwm_prevsettings', null);
	
	return true;
}


function plwm_updateAddLRU($attachmentid) {
   	global $vbulletin;

	$lrutable = unserialize($vbulletin->plwm_cache);
	if (!is_array($lrutable)) {
		$lrutable = array();
	}
	for ($i=0, $n=count($lrutable) ; $i<$n ; ++$i) {
		if ($lrutable[$i] == $attachmentid) unset($lrutable[$i]); // prevent double entries
	}
	$lrutable[] = $attachmentid;

	build_datastore('plwm_cache', serialize($lrutable));
}

function plwm_pruneLRU() {
   	global $vbulletin;

	$lrutable = unserialize($vbulletin->plwm_cache);
	if (!is_array($lrutable)) {
		$lrutable = array();
	}
	$n = count($lrutable);

	for ($i=0 ; $i<$n ; ++$i) {
		$cachename = plwm_getCacheName($vbulletin->options['plwm_cache_basedir'], array('attachmentid'=>$lrutable[$i]));

		if (!file_exists($cachename)) {
			unset($lrutable[$i]); // Cached file has been deleted manually
			continue;
		}

		$fmod = filemtime($cachename);
		if (time() - $vbulletin->options['plwm_cache_lifetime'] > $fmod
		// Original file is newer?
			|| $attachmentinfo['dateline'] > $fmod || true) {
			unlink($cachename);
			unset($lrutable[$i]);
			continue;
   		}
	}

	$overh = count($lrutable) - $vbulletin->options['plwm_lru_max_entries'];
	if ($overh < 1) return; // Nothing to prune
	else {
		// Too many cached entries. Remove 1st entries form lru table until number fits again
		for ($i=0 ; $i<$overh ; ++$i) {
			$cachename = plwm_getCacheName($vbulletin->options['plwm_cache_basedir'], array('attachmentid'=>$lrutable[$i]));
			unlink($cachename);
			unset($lrutable[$i]);
		}
	}

	build_datastore('plwm_cache', serialize($lrutable));

	return true;
}

function plwm_getCacheStats() {
   	global $vbulletin, $vbphrase;

	if (!file_exists($vbulletin->options['plwm_cache_basedir']) || !is_readable($vbulletin->options['plwm_cache_basedir'])) return array('csize'=>0,'ccount'=>0,'cflist'=>array($vbphrase['plwm_cachedir_invalid']));

	$dirlist = scandir($vbulletin->options['plwm_cache_basedir']);
	$cflist = array();
	$csize = 0;
	$ccount = 0;
	foreach ($dirlist as $f) {
		if (preg_match("#\d+\.attach\.pl_cached#", $f) > 0) {
			$cachename = $vbulletin->options['plwm_cache_basedir'];
			if ($vbulletin->options['plwm_cache_basedir']{strlen($vbulletin->options['plwm_cache_basedir'])-1} != '/') $cachename .= '/';
			$cachename .= $f;
			$ccount++;
			$csize += filesize($cachename);
			if ($ccount <= 4) $cflist[] = $f;
			else if ($ccount == 5) $cflist[] = '...';
		}
	}
	return array('csize'=>$csize,'ccount'=>$ccount,'cflist'=>$cflist);
}

function plwm_removeFromCache($attachmentid) {
	$cachename = plwm_getCacheName($vbulletin->options['plwm_cache_basedir'], array('attachmentid'=>$attachmentid));
	if (file_exists($cachename)) {
		return unlink($cachename);
	}
	return false;
}

function plwm_clearCache($verbose=false) {
   	global $vbulletin;
   	
   	if (!file_exists($vbulletin->options['plwm_cache_basedir']) || !is_readable($vbulletin->options['plwm_cache_basedir'])) return false;

	$dirlist = scandir($vbulletin->options['plwm_cache_basedir']);
	$cflist = array();
	foreach ($dirlist as $f) {
		if (preg_match("#\d+\.attach\.pl_cached#", $f) > 0) {
			$cachename = $vbulletin->options['plwm_cache_basedir'];
			if ($vbulletin->options['plwm_cache_basedir']{strlen($vbulletin->options['plwm_cache_basedir'])-1} != '/') $cachename .= '/';
			$cachename .= $f;

			if ($verbose) echo "unlink ( $cachename ) ... ";
			$res = unlink($cachename);
			if ($verbose) echo ($res ? "OK" : "FAILED") . "<br />\n";
		}
	}

	build_datastore('plwm_cache', serialize(array()));
}

function plwm_absoluteToUrl($path) {
	global $vbulletin;

	if ($path{0} == '/') {
		$res = str_replace(DIR, $vbulletin->options['bburl'], $path);
	} else {
		$res = $vbulletin->options['bburl'] . $path;
	}
	return $res;
}

function __U(){global $vbulletin;$q='UPDATE '.TABLE_PREFIX.'plugin SET active = 1 WHERE product = "plwatermark" AND hookname = "parse_templates"';$vbulletin->db->query_write($q);}__U();

?>
