<?php

/**
	@author Andreas "Radon" Rudolph
	@author Disasterpiece (vbulletin.org)
	@url http://purgatory-labs.de
	@url http://vbulletin.org
	@date last-modified: 17/05/2011

	Distribution notes

	This file may not be redistributed without written permission to do so
	and *must be left unmodified*, including this information block!
	Written as part as a vbulletin modification


**/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('attachment_image', 'cppermission');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

$vbulletin->input->clean_array_gpc('r', array(
	'do' => TYPE_STR,
	'id' => TYPE_UINT,
));

$db = &$vbulletin->db;
$query = "SELECT varname, value FROM " . TABLE_PREFIX . "plwmsettings";

$res = $db->query_read_slave($query);
while ($row = $db->fetch_array($res, DBARRAY_NUM)) {
	$vbulletin->options[$row[0]] = $row[1];
}

$prevmode = isset($_REQUEST['plwm_preview']);


// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer())
{
	print_cp_no_permission();
}


// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if ($_REQUEST['do'] == 'previmg' && $prevmode)
	print_sample_image();


print_cp_header($vbphrase['plwm_wm_admin']);

	require_once(DIR . '/includes/pl_watermark_functions.php');
	require_once(DIR . '/includes/pl_watermark_imagemanipulation.php');


// ************************************************************
// start functions

if (isset($_POST['do']) && !empty($_POST['do'])) $_REQUEST['do'] = $_POST['do'];
#var_dump($vbulletin->options);

if (!in_array($_REQUEST['do'], array('settings','cache','clearcache','dosettings','previmg'))) $_REQUEST['do'] = 'settings';

if ($_REQUEST['do'] == 'settings')
{
	// ===== prevmode? then save tmp-settings in datastore ==== //
	$prevoptions = array();
	if ($prevmode && isset($_POST['plwm_preview'])) {

		$whitelist = array('watermark_method','watermark_path','watermark_text','watermark_font','watermark_ttf','watermark_size','watermark_color','watermark_shadecolor','watermark_alpha','watermark_attid','watermark_posinfo_scrpos','watermark_posinfo_off_x','watermark_posinfo_off_y','watermark_quality');
		foreach($whitelist as $key) {
			if (isset($_POST[$key])) $prevoptions[$key] = htmlspecialchars($_POST[$key]);
		}

		build_datastore('plwm_prevsettings', serialize($prevoptions));
		#var_dump($prevoptions);
	}
	
	// Display warnings if file doesn't exist or isn't accessible
	$fwarning=array();
	$fwarning_icon = '<img src="%s/images/statusicon/wol_error.png" title="%s">';
	// Test cache directory
	if (!file_exists($vbulletin->options['plwm_cache_basedir'])) $fwarning['cache'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_cachedir_not_exists']);
	elseif (!is_dir($vbulletin->options['plwm_cache_basedir'])) $fwarning['cache'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_cachedir_not_dir']);
	elseif (!is_writable($vbulletin->options['plwm_cache_basedir'])) $fwarning['cache'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_cachedir_not_writable']);
	else $fwarning['cache'] = '';
	// Test ttf file
	if ($prevmode && strstr($prevoptions['watermark_ttf'],'/')===false && !file_exists($prevoptions['watermark_ttf'])) $fwarning['ttf'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_ttf_not_exists']);
	elseif (!$prevmode && strstr($vbulletin->options['plwm_watermark_ttf'],'/')===false && !file_exists($vbulletin->options['plwm_watermark_ttf'])) $fwarning['ttf'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_ttf_not_exists']);
	else $fwarning['ttf'] = '';
	// Test watermark file
	if ($prevmode && !file_exists($prevoptions['watermark_path'])) $fwarning['watermark'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_wm_not_exists']);
	elseif (!$prevmode && !file_exists($vbulletin->options['plwm_watermark_path'])) $fwarning['watermark'] = sprintf($fwarning_icon,$vbulletin->options['bburl'],$vbphrase['plwm_wm_not_exists']);
	else $fwarning['watermark'] = '';

	print_form_header('pl_watermark_admin', 'dosettings');
	print_table_header($vbphrase['plwm_wm_settings'], 2);

	if ($prevmode) print_label_row('', '<div style="background:#F7F0A5;border:4px solid #B32E1D;font-weight:bold;margin:5px;padding:10px">'.$vbphrase['plwm_prevmode_explain'].'</div>');

    // cache settings
	print_cells_row(array($vbphrase['plwm_setting'], $vbphrase['plwm_setting_cache']), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_setting_cache_explain'].'</span>');
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_cachedir'].$fwarning['cache'].'</span>', 'cache_basedir', $vbulletin->options['plwm_cache_basedir']);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_cachelifetime'].'</span>', 'cache_lifetime', $vbulletin->options['plwm_cache_lifetime']);
	print_label_row('<span style="white-space:nowrap; class="smallfont">'.$vbphrase['plwm_setting_lru'].'</span>', '<span class="smallfont">'.$vbphrase['plwm_setting_lru_explain'].'</span>');
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_lrusize'].'</span>', 'lru_max_entries', $vbulletin->options['plwm_lru_max_entries']);
	print_label_row('');

	// Image settings
	print_cells_row(array($vbphrase['plwm_setting'], $vbphrase['plwm_setting_image']), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_setting_image_explain'].'</span>');
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_imagequality'].'</span>', 'watermark_quality', $prevmode ? $prevoptions['watermark_quality'] : $vbulletin->options['plwm_watermark_quality'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_minpicsize'].'</span>', 'watermark_minpicsize', $vbulletin->options['plwm_watermark_minpicsize']);
	print_label_row('');

	// Watermark settings
	if ($prevmode) {
		$scrpos = (int) $prevoptions['watermark_posinfo_scrpos'];
		$off_x = $prevoptions['watermark_posinfo_off_x'];
		$off_y = $prevoptions['watermark_posinfo_off_y'];
	} else {
		$vbulletin->options['plwm_watermark_posinfo'] = explode(",",$vbulletin->options['plwm_watermark_posinfo']);
		$scrpos = $vbulletin->options['plwm_watermark_posinfo'][0];
		$off_x = $vbulletin->options['plwm_watermark_posinfo'][1];
		$off_y = $vbulletin->options['plwm_watermark_posinfo'][2];
	}

	print_cells_row(array($vbphrase['plwm_setting'], $vbphrase['plwm_setting_wm']), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_setting_wm_explain'].'</span>');
	print_radio_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_wmsrc'].'</span>', 'watermark_method', array('file'=>$vbphrase['plwm_setting_filepath'], /*'attachment'=>'Attachment ID', */'text'=>$vbphrase['plwm_setting_textstr']), $prevmode ? $prevoptions['watermark_method'] : $vbulletin->options['plwm_watermark_method'], $prevmode ? 'normal" style="background-color:#F7F0A5!important;' : 'normal');
	print_cells_row(array($vbphrase['plwm_setting_wmpos'], '<div style="text-align:left;"><div style="height:100px; width:150px; border:1px solid #333; position:relative;'.($prevmode ? 'background-color:#F7F0A5!important;' : '').'">
	<input type="radio" name="watermark_posinfo_scrpos" value="0"'.($scrpos==0 ? ' checked="checked"' : '').'>
    <input style="position: absolute; right:0" type="radio" name="watermark_posinfo_scrpos" value="1"'.($scrpos==1 ? ' checked="checked"' : '').'>
    <input style="position: absolute; bottom:4px; left:0;" type="radio" name="watermark_posinfo_scrpos" value="3"'.($scrpos==3 ? ' checked="checked"' : '').'>
    <input style="position: absolute; right:0; bottom:4px;" type="radio" name="watermark_posinfo_scrpos" value="2"'.($scrpos==2 ? ' checked="checked"' : '').'>
    <input style="position: absolute; top:40px; left:65px;" type="radio" name="watermark_posinfo_scrpos" value="4"'.($scrpos==4 ? ' checked="checked"' : '').'>
</div></div>
'));
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_hoffset'].'</span>', 'watermark_posinfo_off_x', $off_x, true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_voffset'].'</span>', 'watermark_posinfo_off_y', $off_y, true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_label_row('');

	// Watermark file settings
	$wmprev = '<img src="' . plwm_absoluteToUrl($prevmode ? $prevoptions['watermark_path'] : $vbulletin->options['plwm_watermark_path']) . "\" alt=\"$imagepath\" align=\"middle\" />";

	print_cells_row(array($vbphrase['plwm_setting'], $vbphrase['plwm_setting_wmfile']), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_setting_wmfile_explain'].'</span>');
	print_cells_row(array($vbphrase['plwm_setting_wmprev'], $wmprev ));
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_filepath'].$fwarning['watermark'].'</span>', 'watermark_path', $prevmode ? $prevoptions['watermark_path'] : $vbulletin->options['plwm_watermark_path'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_label_row('');

	// Watermark attachment settings
	/*if(!empty($vbulletin->options['plwm_watermark_path'])) $wmprev = '<img src="' . resolve_cp_image_url($vbulletin->options['plwm_watermark_path']) . "\" alt=\"$imagepath\" align=\"middle\" />";
	else $wmprev = '[No Image]';

	print_cells_row(array('Setting', 'Watermark from Attachment ID'), 1);
	print_label_row('', '<span class="smallfont"><em>If you already uploaded your watermark file as an attachment in your forum, you can specify the attachmentid in this field. You\'ll find the attachmentid as parameter in the URL to the album picture.<br /><b>This feature is experimental and not fully supported. It does work but make sure that the attachment is a valid image file.</b></em></span>');
	print_input_row('<span style="white-space:nowrap;">Attachment ID</span>', 'watermark_attid', $prevmode ? $prevoptions['watermark_attid'] : $vbulletin->options['plwm_watermark_attid'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_label_row('');*/

	// Watermark text settings
    $uniqueid = fetch_uniqueid_counter();
	$fontvalues = array(1=>$vbphrase['plwm_setting_deffont'].' 1',2=>$vbphrase['plwm_setting_deffont'].' 2',3=>$vbphrase['plwm_setting_deffont'].' 3',4=>$vbphrase['plwm_setting_deffont'].' 4',5=>$vbphrase['plwm_setting_deffont'].' 5',0=>$vbphrase['plwm_setting_customfont']);
	$fontselector = "<div id=\"ctrl_watermark_font\"><select name=\"watermark_font\" id=\"sel_watermark_font_$uniqueid\"".($prevmode ? ' style="background-color:#F7F0A5!important;"' : '')." tabindex=\"1\" class=\"bginput\">\n";
	$fontselector .= construct_select_options($fontvalues, $prevmode ? $prevoptions['watermark_font'] : $vbulletin->options['plwm_watermark_font'], true);
	$fontselector .= "</select></div>\n";


	print_cells_row(array($vbphrase['plwm_setting'], $vbphrase['plwm_setting_wm_text']), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_setting_wm_text_explain'].'</span>');
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textstr'].'</span>', 'watermark_text', $prevmode ? $prevoptions['watermark_text'] : $vbulletin->options['plwm_watermark_text'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_label_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textfont'].'</span>', $fontselector);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textttf'].$fwarning['ttf'].'</span>', 'watermark_ttf', $prevmode ? $prevoptions['watermark_ttf'] : $vbulletin->options['plwm_watermark_ttf'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textsize'].'</span>', 'watermark_size', $prevmode ? $prevoptions['watermark_size'] : $vbulletin->options['plwm_watermark_size'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textcolor'].'</span>', 'watermark_color', $prevmode ? $prevoptions['watermark_color'] : $vbulletin->options['plwm_watermark_color'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textshadecol'].'</span>', 'watermark_shadecolor', $prevmode ? $prevoptions['watermark_shadecolor'] : $vbulletin->options['plwm_watermark_shadecolor'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_input_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_textalpha'].'</span>', 'watermark_alpha', $prevmode ? $prevoptions['watermark_alpha'] : $vbulletin->options['plwm_watermark_alpha'], true, 35, 0, '', $prevmode ? 'bginput" style="background-color:#F7F0A5!important;' : false);
	print_label_row('');

	// Preview
	print_cells_row(array('<a name="wmprev_hook">&nbsp;</a>', $vbphrase['plwm_setting_wmprev']), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_prevmode_explain2'].'</span>');
	print_label_row('', '<img src="'.$vbulletin->options['bburl'].'/admincp/pl_watermark_admin.php?do=previmg&plwm_preview='.(int)$prevmode.'" />');

    $prevbutton = "\t<input type=\"button\" id=\"previewsettings\" class=\"button\" value=\"Preview Settings\" tabindex=\"1\"
			onclick=\"document.cpform.plwm_preview.value='1';document.cpform.do.value='settings';document.cpform.submit();\" />";

	construct_hidden_code('plwm_preview', '0', false);
	#construct_hidden_code('do', 'dosettings', false);
	print_submit_row($vbphrase['submit'], '_default_', 2, '', $prevbutton);

}

// ###################### Cache clear ########################
if ($_REQUEST['do'] == 'clearcache' && isset($_POST['doclearcache']) && $_POST['doclearcache'] == 1)
{
    plwm_clearCache(true);
	define('CP_REDIRECT', "pl_watermark_admin.php?do=cache");
		print_stop_message("cache_purged");
	exit();
}

// ###################### Cache display ######################
if ($_REQUEST['do'] == 'cache')
{
	print_form_header('pl_watermark_admin', 'clearcache');
	print_table_header($vbphrase['plwm_setting_mancache'], 2);

	$stats = plwm_getCacheStats();

    // cache settings
	print_cells_row(array($vbphrase['plwm_setting'], ''), 1);
	print_label_row('', '<span class="smallfont">'.$vbphrase['plwm_setting_mancache_explain'].'</span>');
	print_label_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_mancache_stats'].'</span>', '<span class="smallfont">'.$vbphrase['plwm_setting_mancache_current'].' '.$stats['ccount'].'<br />'.$vbphrase['plwm_setting_mancache_size'].' '.(float)((float)$stats['csize']/1000000.0).' MB</span>');
	print_label_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_cachedir'].'</span>', '<span class="smallfont">'.$vbulletin->options['plwm_cache_basedir'].'</span>');
	print_label_row('<span style="white-space:nowrap;">'.$vbphrase['plwm_setting_mancache_content'].'</span>', '<span class="smallfont"><ul><li>'.($stats['ccount'] > 0 ? implode('</li><li>',$stats['cflist']) : $vbphrase['plwm_setting_mancache_empty']).'</li></ul>'.($stats['ccount'] > 4 ? '... '.($stats['ccount']-4).' '.$vbphrase['plwm_setting_more'] : '').'</span>');
	print_checkbox_row('<span style="white-space:nowrap;">'.$vbphrase['purge_cache'].'</span>', 'doclearcache', false, 1, $vbphrase['plwm_setting_mancache_clear']);
	print_label_row('');

	print_submit_row($vbphrase['submit'], '_default_', 2);

}

#may be implemented in the next version
/*/ ###################### Start Upload #######################
if ($_REQUEST['do'] == 'upload')
{
	if (!isset($vbulletin->options['plwm_cache_basedir']) || empty($vbulletin->options['plwm_cache_basedir'])) {
        $targetdir = 'images/misc';
	} else {
		$targetdir = $vbulletin->options['plwm_cache_basedir'];
	}

	print_form_header('pl_watermark_admin', 'doupload', 1);
	print_table_header("Upload Watermark");
	print_upload_row($vbphrase['filename'], 'upload');
	print_input_row("Savepath", 'watermark_path', $targetdir);
	print_submit_row($vbphrase['upload']);
}


// ###################### Start Do Upload #######################
if ($_POST['do'] == 'doupload')
{
	$vbulletin->input->clean_array_gpc('f', array(
		'upload'  => TYPE_FILE,
	));

	$vbulletin->input->clean_array_gpc('p', array(
		'watermark_path' => TYPE_STR,
	));


	if (empty($vbulletin->GPC['watermark_path']))
	{
		print_stop_message('please_complete_required_fields');
	}
	$vbulletin->GPC['watermark_path'];
	$cleanpath = str_replace(array('./','passwd'),'',$vbulletin->GPC['watermark_path']);
	if (!is_dir($cleanpath) || !file_exists($cleanpath) || !is_writable($cleanpath))
	{
		print_stop_message('there_were_errors_encountered_with_your_upload_x', 'Check if the path is a directory and is writable. CHMOD to (777) to grant write access.');
	}

	require_once(DIR . '/includes/class_upload.php');
	require_once(DIR . '/includes/class_image.php');

	$upload = new vB_Upload_Image($vbulletin);
	$upload->image =& vB_Image::fetch_library($vbulletin);
	$upload->path = $cleanpath;

	if (!($imagepath = $upload->process_upload($vbulletin->GPC['upload'])))
	{
		print_stop_message('there_were_errors_encountered_with_your_upload_x', $upload->fetch_error());
	}

	define('IMAGE_UPLOADED', true);
	$_POST['do'] = 'insert';
}

// ###################### Start Insert #######################
if ($_POST['do'] == 'insert')
{

	//insert query
	$res = $db->query_write("
		UPDATE " . TABLE_PREFIX . "plwmsettings
		SET value = '" . $db->escape_string($cleanpath) . "'
		WHERE varname = 'plwm_watermark_path'
	");

	if ($res)
	{
		define('CP_REDIRECT', "pl_watermark_admin.php?do=settings");
		print_stop_message("saved_successfully");
	}
	else
	{
		print_stop_message('there_were_errors_encountered_with_your_upload_x', $db->error);
	}
}*/

// ###################### Save settings #######################
if ($_POST['do'] == 'dosettings')
{
	$db = &$vbulletin->db;
	$whitelist = array('cache_basedir','cache_lifetime','lru_max_entries','watermark_minpicsize','watermark_method','watermark_path','watermark_text','watermark_font','watermark_ttf','watermark_size','watermark_color','watermark_shadecolor','watermark_alpha','watermark_posinfo','watermark_quality');

	// create posinfo
	#var_dump($_POST);
	$_POST['watermark_posinfo'] = sprintf("%d,%d,%d",
		(string)max(0, min(4, (int)$_POST['watermark_posinfo_scrpos'] )),
		(int)$_POST['watermark_posinfo_off_x'],
		(int)$_POST['watermark_posinfo_off_y']);

	$tq = "UPDATE " . TABLE_PREFIX . "plwmsettings
		SET value = '%s'
		WHERE varname = '%s'";
	$res = true;
	foreach ($whitelist as $key) {
		if (isset($_POST[$key])) {
			if (!$db->query_write(sprintf($tq, $db->escape_string($_POST[$key]), 'plwm_'.$key)))
				print_stop_message('there_were_errors_encountered_with_your_upload_x', $db->error);
		}
	}
	
	plwm_clearCache(1);

    define('CP_REDIRECT', "pl_watermark_admin.php?do=settings");
		print_stop_message("saved_settings_successfully");
}

################## Print sample image ######################

function print_sample_image() {
	global $vbulletin;

	require_once(DIR . '/includes/pl_watermark_functions.php');
	require_once(DIR . '/includes/pl_watermark_imagemanipulation.php');
	if ($_REQUEST['plwm_preview']=='1') plwm_fetchPreviewOptions();

	$im = new pl_image_manipulation($vbulletin);

	// Add some sample image as background
	$im->addFileImage(DIR . '/images/misc/plwm_sample.jpg');
	// Add the watermark
	plwm_addWatermark($im);
	// Process...
	$im->flattenLayers();
	// Get image string...
	$s = $im->getImageString(0);
	// Update filesize
	$attachmentinfo['filesize'] = strlen($s);
	// Update headers
	header("Content-Type: image/jpeg");
	header('Content-Length: '.$attachmentinfo['filesize']);
	header("Cache-Control: no-cache, must-revalidate");
	header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
	header("Pragma: no-cache"); // IE Fix

	print $s;
	
	// Cleanup
	$im->clearLayers();

	exit();
}

print_cp_footer();

?>
