<?php
/**
 *
 * @package jvbPlugin
 * @version $Id: helper.php, v 1.0 2008/05/17 15:37:18 koudanshi Exp $
 * @copyright (c) 2004-2008 BBpixel
 *
 * Minimum Requirement: PHP 4.3.3 | MySQL 4.1
 */


// no direct access
defined('_JEXEC') or die('Restricted access');

class modJvbWhosonlineHelper {

	// show online count
	function getOnlineCount(&$params) {

		global $jvbpixel;

		$cookiesTimeOut = $params->get( 'bbwol_ctimeout', 900 );
		$datecut = time() - $cookiesTimeOut;

		// calculate number of guests and members
		$results    = array();
		$rows = array();
		$sql = "SELECT COUNT(*) AS guest FROM {$jvbpixel->_bbDBprefix}session WHERE userid = 0 AND lastactivity > $datecut";
		$jvbpixel->_bbDB->setQuery($sql);
		$results['guest'] = $jvbpixel->_bbDB->loadResult();

		$sql = "SELECT userid FROM {$jvbpixel->_bbDBprefix}session WHERE userid > 0 AND lastactivity > $datecut GROUP BY userid";
		$jvbpixel->_bbDB->setQuery($sql);
		$rows = $jvbpixel->_bbDB->loadObjectList();
		$results['user'] = count($rows);
 		unset($rows);

		if ( $jvbpixel->_bbDB->getErrorNum() ) {
			JError::raiseWarning( 500, $jvbpixel->_bbDB->stderr() );
		}
		return $results;
	}

	// show online member names
	function getOnlineMemberNames(&$params) {

		global $jvbpixel;
		$rows = null;

		//Get parameters
		$cookiesTimeOut = $params->get( 'bbwol_ctimeout', 900 );
		$limitNo = $params->get( 'bbwol_limitno', 10 );

		$datecut = time() - $cookiesTimeOut;
		$sql = "SELECT distinct user.username, user.userid, IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid
				FROM " . $jvbpixel->_bbDBprefix . "session AS session, " . $jvbpixel->_bbDBprefix . "user AS user
				WHERE session.lastactivity > $datecut
				AND session.userid = user.userid
				ORDER BY user.username
		";

		$jvbpixel->_bbDB->setQuery($sql);
		$rows = $jvbpixel->_bbDB->loadObjectList();

		if ( $jvbpixel->_bbDB->getErrorNum() ) {
			JError::raiseWarning( 500, $jvbpixel->_bbDB->stderr() );
		}
		return $rows;
	}
}
