<?php
	header('Content-type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8" />
	<title>Тест системных требований для XenForo 1.0</title>
	<style type="text/css">
		html {
			background:rgb(240,240,240);
			margin:0;
			padding:0;
		}
		body {
			font:11pt 'Trebuchet MS', Helvetica, Arial, sans-serif;
			color:rgb(20,20,20);
			line-height:1.6;
			margin:0;
			padding:0;
		}
		.pageWidth {
			max-width:760px;
			margin:0 auto;
		}
		#header {
			background:#176093;
			border-bottom:1px solid #2b485c;
		}
		h1 {
			font-size:24pt;
			font-weight:normal;
			color:#fff;
			padding:20px;
			margin:0;
		}
		.contents {
			padding:20px;
			background:rgb(252, 252, 255);
		}
		h2 {
			margin0;
		}
		.success h2 {
			font:20pt Georgia, "Times New Roman", Times, serif;
			color:rgb(0, 120, 0);
		}
		.failure h2 {
			font:20pt Georgia, "Times New Roman", Times, serif;
			color:rgb(120, 0, 0);
		}
		.mysql {
			color:rgb(100, 100, 100);
		}
		#footer {
			color:#fff;
			max-width:760px;
			height:24px;
			line-height:24px;
			margin:0 auto;
			font-size:11px;
			text-indent:20px;
			background:#176093;
			border-bottom-left-radius:10px;
			border-bottom-right-radius:10px;
			-webkit-border-bottom-left-radius:10px;
			-webkit-border-bottom-right-radius:10px;
			-moz-border-radius-bottomleft:10px;
			-moz-border-radius-bottomright:10px;
		}
		#footer a:link,#footer a:visited {
			color:#a5cae4;
			text-decoration:none;
		}
		#footer a:active,#footer a:hover {
			color:#a5cae4;
			text-decoration:underline;
		}
	</style>
</head>
<body>

<div id="header">
	<div class="pageWidth"><h1>Тест системных требований для XenForo 1.0</h1></div>
</div>

<div class="pageWidth">
	<div class="contents">
<?php

$errors = array();

$phpVersion = phpversion();
if (version_compare($phpVersion, '5.2.4', '<'))
{
	$errors['phpVersion'] = 'Необходим PHP версии 5.2.4 или выше. ' . $phpVersion . ' не удовлетворяет этому требованию. Пожалуйста, обратитесь к вашему хостеру для обновления PHP.';
}

if (@ini_get('safe_mode'))
{
	$errors['safe_mode'] = 'PHP не должен быть запущен в безопасном режиме (safe_mode). Пожалуйста, попросите вашего хостера отключить безопасный режим.';
}

if (!function_exists('mysqli_connect'))
{
	$errors['mysqlPhp'] = 'Необходимое расширение MySQLi для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if (!function_exists('iconv'))
{
	$errors['iconv'] = 'Необходимое расширение Iconv для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if (!function_exists('ctype_alnum'))
{
	$errors['ctype'] = 'Необходимое расширение Ctype для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if (!function_exists('gd_info'))
{
	$errors['gd'] = 'Необходимое расширение GD для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}
else if (!function_exists('imagecreatefromjpeg'))
{
	$errors['gdJpeg'] = 'Необходимое расширение GD для PHP найдено, но поддержка JPEG отсутствует. Пожалуйста, попросите вашего хостера добавить поддержку JPEG изображений.';
}

if (!function_exists('preg_replace'))
{
	$errors['pcre'] = 'Необходимое расширение PCRE для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if (!function_exists('spl_autoload_register'))
{
	$errors['spl'] = 'Необходимое расширение SPL для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if (!function_exists('json_encode'))
{
	$errors['json'] = 'Необходимое расширение JSON для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if (!class_exists('DOMDocument') || !class_exists('SimpleXMLElement'))
{
	$errors['xml'] = 'Необходимое расширение для управления XML (DOM и SimpleXML) для PHP не найдено. Пожалуйста, попросите вашего хостера установить это расширение.';
}

if ($errors)
{
?>
<div class="failure">
	<h2>Требования не удовлетворены</h2>
	<p>Нижеследующие требования для XenForo не удовлетворены. Пожалуйста, обратитесь к вашему хостеру за помощью.</p>
	<ol>
	<?php foreach ($errors AS $error) { echo "<li>$error</li>"; } ?>
	</ol>
</div>
<?php
}
else
{
?>
<div class="success">
	<h2>Требования удовлетворены</h2>
	<p>Ваш сервер отвечает всем PHP требованиям для XenForo.</p>
</div>
<?php
}

?>
		<p class="mysql">XenForo также требует установленного MySQL версии 5.0 или выше. Пожалуйста, проверьте самостоятельно, соответствует ли ваша система этому требованию.</p>
	</div>
</div>
<div id="footer">©2010-2011 XenForo Ltd. Перевод: <a href="http://www.xf-russia.ru">XF-Russia.ru</a></div>

</body>
</html>