var LinkDialog = {
	init : function() {
		var f = document.forms[0], ed = tinyMCEPopup.editor;

		if (e = ed.dom.getParent(ed.selection.getNode(), 'A')) {
			f.href.value = ed.dom.getAttrib(e, 'href');
		}
	},

	update : function() {
		var f = document.forms[0], ed = tinyMCEPopup.editor, e, b;

		tinyMCEPopup.restoreSelection();
		e = ed.dom.getParent(ed.selection.getNode(), 'A');

		// Remove element if there is no href
		if (!f.href.value) {
			if (e) {
				tinyMCEPopup.execCommand("mceBeginUndoLevel");
				b = ed.selection.getBookmark();
				ed.dom.remove(e, 1);
				ed.selection.moveToBookmark(b);
				tinyMCEPopup.execCommand("mceEndUndoLevel");
				tinyMCEPopup.close();
				return;
			}
		}

		LinkDialog.checkPrefix(f.href);

		tinyMCEPopup.execCommand("mceBeginUndoLevel");

		// Create new anchor elements
		if (e == null) {
			ed.getDoc().execCommand("unlink", false, null);
			tinyMCEPopup.execCommand("CreateLink", false, "#mce_temp_url#", {skip_undo : 1});

			tinymce.each(ed.dom.select("a"), function(n) {
				if (ed.dom.getAttrib(n, 'href') == '#mce_temp_url#') {
					e = n;

					ed.dom.setAttribs(e, {
						href : $.trim(f.href.value)
					});
				}
			});
		} else {
			ed.dom.setAttribs(e, {
				href : $.trim(f.href.value)
			});
		}

		// Don't move caret if selection was image
		if (e && (e.childNodes.length != 1 || e.firstChild.nodeName != 'IMG')) {
			ed.focus();
			ed.selection.select(e);
			ed.selection.collapse(0);
			tinyMCEPopup.storeSelection();
		}

		tinyMCEPopup.execCommand("mceEndUndoLevel");
		tinyMCEPopup.close();
	},

	checkPrefix : function(n) {
		n.value = $.trim(n.value);

		var primaryValue = n.value.replace(/\?.*$/, '');

		if (n.value && Validator.isEmail(primaryValue) && !/^\s*mailto:/i.test(n.value))
		{
			n.value = 'mailto:' + n.value;
		}
		else if (!/^((https?|ftp):\/\/|mailto:)/i.test(n.value))
		{
			n.value = 'http://' + n.value;
		}
	}
};

tinyMCEPopup.onInit.add(LinkDialog.init, LinkDialog);
