/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.3 Beta 1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions, Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vB_Blog_AJAX_TagSuggest
// #############################################################################

/**
* Class to read input and suggest tags from the typed fragment. Extends vB_AJAX_TagSuggest
*
* @package	vBulletin
* @version	$Revision: 24798 $
* @date		$Date: 2007-11-22 13:59:49 +0000 (Thu, 22 Nov 2007) $
* @author	Freddie Bingham
* @copyright	vBulletin Solutions, Inc.
*
* @param	string	Name of variable instantiating this class
* @param	string	ID of the text input element to monitor
* @param	string	Unique key of the popup menu in which to show suggestions
*/
function vB_Blog_AJAX_TagSuggest(varname, textobjid, menukey)
{
	vB_Blog_AJAX_TagSuggest.baseConstructor.call(this, varname, textobjid, menukey);

	/**
	* Sends the fragment to search the database
	*/
	this.tag_search = function()
	{
		if (this.active)
		{
			this.tags = new Array();

			this.ajax_req = YAHOO.util.Connect.asyncRequest("POST", "blog_tag.php?do=tagsearch", {
				success: this.handle_ajax_response,
				failure: vBulletin_AJAX_Error_Handler,
				timeout: vB_Default_Timeout,
				scope: this
			}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=tagsearch&fragment=" + PHP.urlencode(this.fragment));
		}
	}

}

vBulletin.extend(vB_Blog_AJAX_TagSuggest, vB_AJAX_TagSuggest);

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 15547 $
|| ####################################################################
\*======================================================================*/
