<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin Blog 2.0.3 Beta 1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions, Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

/**
* Adds tags to an entry. Errors are silently ignored, but returned.
*
* @param	array			Array of blog info
* @param	string|array	List of tags to add (comma delimited, or an array as is). If array, ensure there are no commas.
* @param	array			Userinfo of owner of blog
*
* @return	array			Array of errors, if any
*/
function add_tags_to_entry($bloginfo, $taglist, &$userinfo)
{
	global $vbulletin;

	$blogid = intval($bloginfo['blogid']);
	if (!$blogid)
	{
		return array();
	}

	$taglist = fetch_valid_entry_tags($bloginfo, $taglist, $errors, $userinfo);

	if (!$taglist)
	{
		return $errors;
	}

	insert_tags_entry($bloginfo, $taglist);

	return $errors;
}

/**
* Fetch the valid tags from a list. Filters are length, censorship, perms (if desired).
*
* @param	array			Array of existing blog info (including the existing tags)
* @param	string|array	List of tags to add (comma delimited, or an array as is). If array, ensure there are no commas.
* @param	array			(output) List of errors that happens
* @param	array			Userinfo of owner of blog
* @param	boolean		Whether to check the browsing user's create tag perms
* @param	boolean		Whether to expand the error phrase
*
* @return	array			List of valid tags
*/
function fetch_valid_entry_tags($bloginfo, $taglist, &$errors, &$userinfo, $check_browser_perms = true, $evalerrors = true)
{
	global $vbulletin;

	$errors = array();

	if (!is_array($taglist))
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$taglist = split_tag_list($taglist);
	}

	if (!trim($bloginfo['taglist']))
	{
		$existing_tags = array();
	}
	else
	{
		$existing_tags = explode(',', trim($bloginfo['taglist']));
	}

	if ($vbulletin->options['vbblog_maxtag'] AND count($existing_tags) >= $vbulletin->options['vbblog_maxtag'])
	{
		$errors['entrymax'] = $evalerrors ? fetch_error('entry_has_max_allowed_tags') : 'entry_has_max_allowed_tags';
		return array();
	}

	if ($vbulletin->options['vbblog_tagmaxlen'] <= 0 OR $vbulletin->options['vbblog_tagmaxlen'] >= 100)
	{
		$vbulletin->options['vbblog_tagmaxlen'] = 100;
	}

	$valid_raw = array();

	// stop words: too common
	require(DIR . '/includes/searchwords.php'); // get the stop word list; allow multiple requires

	foreach ($taglist AS $tagtext)
	{
		$tagtext = trim(preg_replace('#[ \r\n\t]+#', ' ', $tagtext));
		if ($tagtext === '')
		{
			continue;
		}

		$char_strlen = vbstrlen($tagtext, true);

		if ($vbulletin->options['vbblog_tagminlen'] AND $char_strlen < $vbulletin->options['vbblog_tagminlen'])
		{
			$errors['min_length'] = $evalerrors ? fetch_error('tag_too_short_min_x', $vbulletin->options['vbblog_tagminlen']) : array('tag_too_short_min_x', $vbulletin->options['vbblog_tagminlen']);
			continue;
		}

		if ($char_strlen > $vbulletin->options['vbblog_tagmaxlen'])
		{
			$errors['max_length'] =  $evalerrors ? fetch_error('tag_too_long_max_x', $vbulletin->options['vbblog_tagmaxlen']) : array('tag_too_long_max_x', $vbulletin->options['vbblog_tagmaxlen']);
			continue;
		}

		if (strlen($tagtext) > 100)
		{
			// only have 100 bytes to store a tag
			$errors['max_length'] =  $evalerrors ? fetch_error('tag_too_long_max_x', $vbulletin->options['vbblog_tagmaxlen']) : array('tag_too_long_max_x', $vbulletin->options['vbblog_tagmaxlen']);
			continue;
		}

		$censored = fetch_censored_text($tagtext);
		if ($censored != $tagtext)
		{
			// can't have tags with censored text
			$errors['censor'] = $evalerrors ? fetch_error('tag_no_censored') : 'tag_no_censored';
			continue;
		}

		require_once(DIR . '/includes/functions_newpost.php');
		if (count(split_tag_list($tagtext)) > 1)
		{
			$errors['comma'] = $evalerrors ? fetch_error('tag_no_comma') : 'tag_no_comma';
			continue;
		}

		if (in_array(strtolower($tagtext), $badwords))
		{
			$errors['common'] = $evalerrors ? fetch_error('tag_x_not_be_common_words', $tagtext) : array('tag_x_not_be_common_words', $tagtext);
			continue;
		}

		$valid_raw[] = ($vbulletin->options['vbblog_tagforcelower'] ? vbstrtolower($tagtext) : $tagtext);
	}

	// we need to essentially do a case-insensitive array_unique here
	$valid_unique = array_unique(array_map('vbstrtolower', $valid_raw));
	$valid = array();
	foreach (array_keys($valid_unique) AS $key)
	{
		$valid[] = $valid_raw["$key"];
	}
	$valid_unique = array_values($valid_unique); // make the keys jive with $valid

	if ($valid)
	{
		$existing_sql = $vbulletin->db->query_read("
			SELECT tag.tagtext, IF(tagentry.tagid IS NULL, 0, 1) AS taginentry
			FROM " . TABLE_PREFIX . "blog_tag AS tag
			LEFT JOIN " . TABLE_PREFIX . "blog_tagentry AS tagentry ON
				(tag.tagid = tagentry.tagid AND tagentry.blogid = " . intval($blogdinfo['blogid']) . ")
			WHERE tag.tagtext IN ('" . implode("','", array_map(array(&$vbulletin->db, 'escape_string'), $valid)) . "')
		");

		if ($check_browser_perms AND !($vbulletin->userinfo['permissions']['vbblog_entry_permissions'] & $vbulletin->bf_ugp_vbblog_entry_permissions['blog_cancreatetag']))
		{
			// can't create tags, need to throw errors about bad ones
			$new_tags = array_flip($valid_unique);

			while ($tag = $vbulletin->db->fetch_array($existing_sql))
			{
				unset($new_tags[vbstrtolower($tag['tagtext'])]);
			}

			if ($new_tags)
			{
				// trying to create tags without permissions. Remove and throw an error
				$errors['no_create'] = $evalerrors ? fetch_error('tag_no_create') : 'tag_no_create';

				foreach ($new_tags AS $new_tag => $key)
				{
					// remove those that we can't add from the list
					unset($valid["$key"], $valid_unique["$key"]);
				}
			}
		}

		$vbulletin->db->data_seek($existing_sql, 0);

		// determine which tags are already in the entry and just ignore them
		while ($tag = $vbulletin->db->fetch_array($existing_sql))
		{
			if ($tag['taginentry'])
			{
				// tag is in entry, find it and remove
				if (($key = array_search(vbstrtolower($tag['tagtext']), $valid_unique)) !== false)
				{
					unset($valid["$key"], $valid_unique["$key"]);
				}
			}
		}

		$user_tags_remain = null;

		if ($vbulletin->options['vbblog_maxtag'])
		{
			// check global limit
			$user_tags_remain = $vbulletin->options['vbblog_maxtag'] - count($existing_tags) - count($valid);
		}

		if (!can_moderate_blog('caneditentries') AND $bloginfo['blogid'])
		{
			$my_tag_count_array = $vbulletin->db->query_first("
				SELECT COUNT(*) AS count
				FROM " . TABLE_PREFIX . "blog_tagentry
				WHERE blogid = " . intval($bloginfo['blogid']) . "
					AND userid = " . $vbulletin->userinfo['userid']
			);
			$my_tag_count = $my_tag_count_array['count'] + count($valid);

			$tags_remain = null;
			if ($vbulletin->options['vbblog_maxtagstarter'] AND is_member_of_blog($vbulletin->userinfo, $userinfo))
			{
				$tags_remain = $vbulletin->options['vbblog_maxtagstarter'] - $my_tag_count;
			}
			else if ($vbulletin->options['vbblog_maxtaguser'])
			{
				$tags_remain = $vbulletin->options['vbblog_maxtaguser'] - $my_tag_count;
			}

			if ($tags_remain !== null)
			{
				$user_tags_remain = ($user_tags_remain == null ? $tags_remain : min($tags_remain, $user_tags_remain));
			}
		}

		if ($user_tags_remain < 0)
		{
			$errors['entrymax'] = $evalerrors ? fetch_error('number_entry_tags_add_exceeded_x', vb_number_format($user_tags_remain * -1)) : array('number_entry_tags_add_exceeded_x', vb_number_format($user_tags_remain * -1));
			$allowed_tag_count = count($valid) + $user_tags_remain;
			if ($allowed_tag_count > 0)
			{
				$valid = array_slice($valid, 0, count($valid) + $user_tags_remain);
			}
			else
			{
				$valid = array();
			}
		}
	}

	return $valid;
}

/**
* Inserts tags into the DB and adds them to the specified entry.
*
* @param	array	Array of Blog information
* @param	array	Array of tags. Should already be validated!
*/
function insert_tags_entry($bloginfo, $taglist)
{
	global $vbulletin;

	if (!$taglist OR !is_array($taglist))
	{
		return;
	}

	$taglist_db = array();
	$taglist_insert = array();
	foreach ($taglist AS $tag)
	{
		$tag = $vbulletin->db->escape_string($tag);

		$taglist_db[] = $tag;
		$taglist_insert[] = "('$tag', " . TIMENOW . ")";
	}

	// create new tags
	$vbulletin->db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "blog_tag
			(tagtext, dateline)
		VALUES
			" . implode(',', $taglist_insert)
	);

	// now associate with entry
	$tagentry = array();
	$tagid_sql = $vbulletin->db->query_read("
		SELECT tagid
		FROM " . TABLE_PREFIX . "blog_tag
		WHERE tagtext IN ('" . implode("', '", $taglist_db) . "')
	");
	while ($tag = $vbulletin->db->fetch_array($tagid_sql))
	{
		$tagentry[] = "($bloginfo[blogid], $tag[tagid], " . $vbulletin->userinfo['userid'] . ", $bloginfo[userid], " . TIMENOW . ")";
	}

	if ($tagentry)
	{
		// this should always happen
		$vbulletin->db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "blog_tagentry
				(blogid, tagid, userid, bloguserid, dateline)
			VALUES
				" . implode(',', $tagentry)
		);
	}

	// now build the tag list for the entry
	build_entry_taglist($bloginfo['blogid']);
}

/**
* builds the data in the taglist column of an entry.
*
* @param	integer	Blog ID to build
*
* @return	string	Comma delimited tag list
*/
function build_entry_taglist($blogid)
{
	global $vbulletin;

	$blogid = intval($blogid);
	$bloginfo = fetch_bloginfo($blogid);
	if (!$bloginfo)
	{
		return '';
	}

	$tags = array();
	$tags_sql = $vbulletin->db->query_read("
		SELECT tag.tagtext
		FROM " . TABLE_PREFIX . "blog_tagentry AS tagentry
		INNER JOIN " . TABLE_PREFIX . "blog_tag AS tag ON (tag.tagid = tagentry.tagid)
		WHERE tagentry.blogid = $blogid
		ORDER BY tag.tagtext
	");
	while ($tag = $vbulletin->db->fetch_array($tags_sql))
	{
		$tags[] = $tag['tagtext'];
	}

	$taglist = implode(', ', $tags);

	$dataman =& datamanager_init('Blog', $vbulletin, ERRTYPE_SILENT, 'blog');
	$dataman->set_existing($bloginfo);
	$dataman->set('taglist', $taglist);
	$dataman->save();

	return $taglist;
}

/**
* Fetches the tagbits for display in an entry
*
* @param	array	Blog info
*
* @return	string	Tag bits
*/
function fetch_entry_tagbits($bloginfo, &$userinfo)
{
	global $vbulletin, $stylevar, $vbphrase, $show, $template_hook;

	if ($bloginfo['taglist'])
	{
		$tag_array = explode(',', $bloginfo['taglist']);

		$tag_list = '';
		foreach ($tag_array AS $tag)
		{
			$tag = trim($tag);
			if ($tag === '')
			{
				continue;
			}
			$tag_url = urlencode(unhtmlspecialchars($tag));
			$tag = fetch_word_wrapped_string($tag);

			($hook = vBulletinHook::fetch_hook('blog_tag_fetchbit')) ? eval($hook) : false;

			$tag_list .= ($tag_list != '' ? ', ' : '');
			eval('$tag_list .= trim("' . fetch_template('blog_tagbit') . '");');
		}
	}
	else
	{
		$tag_list = '';
	}

	($hook = vBulletinHook::fetch_hook('blog_tag_fetchbit_complete')) ? eval($hook) : false;

	return $tag_list;
}

/*======================================================================*\
|| ####################################################################
|| # SVN: $Revision: 25612 $
|| ####################################################################
\*======================================================================*/
?>
