/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.3 Beta 1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions, Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

vBulletin.events.systemInit.subscribe(function()
{
	if (AJAX_Compatible)
	{
		vB_QuickEditor_Factory = new vB_QuickEditor_Factory_Blog_Entry();
	}
});

/**
* Quick Edit class for Blog entries
*
* @package	vBulletin
* @version	$Revision: 24798 $
* @date		$Date: 2007-11-22 13:59:49 +0000 (Thu, 22 Nov 2007) $
* @author	Freddie Bingham, Kier Darby, vBulletin Development Team
* @copyright	vBulletin Solutions, Inc.
*
* @param	string	Form name that contains the controls
* @param	string	Minimum allowed characters
* @param	string	Are the returning posts ordered in asc or desc order?
*/
function vB_QuickEditor_Factory_Blog_Entry()
{
	vB_QuickEditor_Factory_Blog_Entry.baseConstructor.call(this);
	this.id = this;
}

vBulletin.extend(vB_QuickEditor_Factory_Blog_Entry, vB_QuickEditor_Factory);

// #############################################################################
// vB_AJAX_QuickEditor
// #############################################################################

// =============================================================================
// vB_AJAX_QuickEditor methods

vB_QuickEditor_Factory_Blog_Entry.prototype.init = function()
{
	this.target = "blog_post.php";
	this.postaction = "updateblog";

	this.objecttype = "b";
	this.getaction = "editblog";

	this.ajaxtarget = "blog_ajax.php";
	this.ajaxaction = "quickeditentry";
	this.deleteaction = "deleteblog";

	this.messagetype = "entry_text_";
	this.containertype = "entry";
	this.responsecontainer = "entrybits";

	if (vBulletin.elements["vB_QuickEdit_Blog_Entry"])
	{
		for (var i = 0; i < vBulletin.elements["vB_QuickEdit_Blog_Entry"].length; i++)
		{
			var objectid = vBulletin.elements["vB_QuickEdit_Blog_Entry"][i];
			var editbutton = YAHOO.util.Dom.get(this.containertype + "_edit_" + objectid);
			if (editbutton)
			{
				this.controls[objectid] = new vB_QuickEditor(objectid, this);
			}
		}
		vBulletin.elements["vB_QuickEdit_Blog_Entry"] = null;
	}
}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 25662 $
|| ####################################################################
\*======================================================================*/
