/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.3 Beta 1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions, Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Class to handle the mini calendar
*
* @param	object	The form object containing the vote options
*/
function vB_AJAX_BlogCalendar(varname, calobj, month, year, userid)
{
	// AJAX handler
	this.xml_sender = null;

	this.month = month;
	this.year = year;
	this.calobj = calobj;
	this.varname = varname;
	this.userid = userid;

	this.init = function()
	{
		if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2) && calobj)
		{
			if (nextmonth = fetch_object("vb_blogcalendar_nextmonth"))
			{
				nextmonth.style.cursor = pointer_cursor;
				YAHOO.util.Event.on("vb_blogcalendar_nextmonth", "click", this.next_month, this, true);
			}

			if (prevmonth = fetch_object("vb_blogcalendar_prevmonth"))
			{
				prevmonth.style.cursor = pointer_cursor;
				YAHOO.util.Event.on("vb_blogcalendar_prevmonth", "click", this.prev_month, this, true);
			}
		}
	}

	/**
	* OnReadyStateChange callback. Uses a closure to keep state.
	* Remember to use me instead of this inside this function!
	*/
	this.handle_ajax_response = function(ajax)
	{
		if (ajax.responseXML)
		{
			var obj = fetch_object(this.objid);
			// check for error first
			var error = ajax.responseXML.getElementsByTagName('error');
			if (error.length)
			{
				alert(error[0].firstChild.nodeValue);
			}
			else
			{
				var calendar = ajax.responseXML.getElementsByTagName('calendar')[0].firstChild.nodeValue;
				if (calendar != '')
				{
					fetch_object(this.calobj).innerHTML = calendar;
					this.init();
				}
			}

		}
	}

	this.prev_month = function(e)
	{
		YAHOO.util.Event.stopEvent(e);

		var currentmonth = this.month;
		this.month = (this.month == 1) ? 12 : this.month - 1;
		this.year = (currentmonth == 1) ? (this.year == 1970 ? 2037 : this.year - 1) : this.year;
		this.swap_month();

		return false;
	}

	this.next_month = function(e)
	{
		YAHOO.util.Event.stopEvent(e);

		var currentmonth = this.month;
		this.month = (this.month == 12) ? 1 : this.month + 1;
		this.year = (currentmonth == 12) ? (this.year == 2037 ? 1970 : this.year + 1) : this.year;
		this.swap_month();

		return false;
	}

	this.swap_month = function()
	{
		YAHOO.util.Connect.asyncRequest("POST", "blog_ajax.php?do=calendar", {
	  	success: this.handle_ajax_response,
	    failure: vBulletin_AJAX_Error_Handler,
	    timeout: vB_Default_Timeout,
	    scope: this
	  }, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=calendar&m=" + this.month + "&ajax=1&y=" + this.year + (typeof this.userid != "undefined" ? "&u=" + this.userid : ""));
	}

	this.init();
};

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 25612 $
|| ####################################################################
\*======================================================================*/
