/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 2.0.3 Beta 1
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions, Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

vBulletin.events.systemInit.subscribe(function()
{
	if (AJAX_Compatible)
	{
		vB_QuickLoader_Factory = new vB_QuickLoader_Factory();
	}
});

// #############################################################################
// vB_QuickLoader
// #############################################################################

/**
* Class to allow quick loading of items via AJAX
*
* @package	vBulletin
* @version	$Revision: 25662 $
* @date		$Date: 2008-02-04 14:33:20 -0800 (Mon, 04 Feb 2008) $
* @author	Freddie Bingham, vBulletin Development Team
*/
function vB_QuickLoader_Factory()
{
	this.editorcounter = 0;
	this.controls = new Array();

	this.init();
}

// =============================================================================
// vB_QuickLoader methods

vB_QuickLoader_Factory.prototype.init = function()
{
	this.objecttype =    "bt";
	this.containertype = "comment";
	this.ajaxtarget =    "blog_ajax.php";
	this.ajaxaction =    "loadcomment";
	this.returnbit =     "commentbit";

	if (vBulletin.elements["vB_QuickLoad"])
	{
		for (var i = 0; i < vBulletin.elements["vB_QuickLoad"].length; i++)
		{
			var objectid = vBulletin.elements["vB_QuickLoad"][i];
			var loadlink = YAHOO.util.Dom.get("view_" + this.containertype + objectid);
			if (loadlink)
			{
				this.controls[objectid] = new vB_QuickLoader(objectid, this);
			}
		}
		vBulletin.elements["vB_QuickLoad"] = null;
	}
}

/**
* Initialize Object
*
* @param	integer	Object ID
*/
vB_QuickLoader_Factory.prototype.obj_init = function(objectid)
{
	Comment_Init(YAHOO.util.Dom.get(this.containertype + objectid));
}

/**
* Redirect upon failed Ajax
*
*/
vB_QuickLoader_Factory.prototype.redirect = function(objectid)
{
	window.location = "blog.php?" + SESSIONURL + "bt=" + objectid + "#comment" + objectid;
}

// #############################################################################

/**
* Loads a single item
*
* @package	vBulletin
* @version	$Revision: 24798 $
* @date		$Date: 2007-11-22 13:59:49 +0000 (Thu, 22 Nov 2007) $
* @author	Freddie Bingham, Kier Darby, vBulletin Development Team
*
* @param	string	Objectid of the message to be edited
* @param	vB_QuickLoader_Factory	Controlling factory class
*/
function vB_QuickLoader(objectid, factory)
{
	this.init(objectid, factory);
}

/**
* Initialize the onclick action
*
* @return	boolean
*/
vB_QuickLoader.prototype.init = function(objectid, factory)
{
	if (objectid)
	{
		this.objectid = objectid;
	}
	if (factory)
	{
		this.factory = factory;
	}

	this.node = YAHOO.util.Dom.get(this.factory.containertype + this.objectid);
	this.progress_indicator = YAHOO.util.Dom.get(this.factory.containertype + "_progress_" + this.objectid);
	var loadlink = YAHOO.util.Dom.get("view_" + this.factory.containertype + objectid);

	YAHOO.util.Event.on(loadlink, "click", this.load, this, true);
}

/**
* Prepare to edit a single post
*
* @return	boolean	false
*/
vB_QuickLoader.prototype.load = function(e)
{
	if (e)
	{
		YAHOO.util.Event.stopEvent(e);
	}

	if (this.progress_indicator)
	{
		this.progress_indicator.style.display = "";
	}

	YAHOO.util.Connect.asyncRequest("POST", this.factory.ajaxtarget + "?do=" + this.factory.ajaxaction + "&" + this.factory.objecttype + "=" + this.objectid, {
		success: this.display,
		failure: this.handle_ajax_error,
		timeout: vB_Default_Timeout,
		scope: this
	}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=" + this.factory.ajaxaction + "&" + this.factory.objecttype + "=" + this.objectid);

	return false;
};

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_QuickLoader.prototype.handle_ajax_error = function(ajax)
{
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
};


/**
* Display the editor HTML when AJAX says fetch_editor() is ready
*
* @param	object	YUI AJAX
*/
vB_QuickLoader.prototype.display = function(ajax)
{
	if (ajax.responseXML)
	{
		if (this.progress_indicator)
		{
			this.progress_indicator.style.display = 'none';
		}
		var returnbit = ajax.responseXML.getElementsByTagName(this.factory.returnbit);

		if (returnbit.length)
		{
			var newnode = string_to_node(returnbit[0].firstChild.nodeValue);
			this.node.parentNode.replaceChild(newnode, this.node);
			this.factory.obj_init(this.objectid);
		}
		else
		{	// parsing of XML failed, probably IE
			this.factory.redirect(this.objectid);
		}

	}
}

/*======================================================================*\
|| ####################################################################
|| # CVS: $RCSfile$ - $Revision: 25662 $
|| ####################################################################
\*======================================================================*/
