<?php
/*======================================================================*\
|| #################################################################### ||
|| # Product Name: Liberty Reserve Payment API Module for vBulletin		Version: 4.X.X
|| #################################################################### ||
\*======================================================================*/

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

/**
* Class that provides payment verification and form generation functions
*
* @package	libertyreserve Module
*/
class vB_PaidSubscriptionMethod_libertyreserve extends vB_PaidSubscriptionMethod
{
	/**
	* The variable indicating if this payment provider supports recurring transactions
	*
	* @var	bool
	*/
	var $supports_recurring = false;

	/**
	* Perform verification of the payment, this is called from the payment gateway
	*
	* @return	bool	Whether the payment is valid
	*/
	function verify_payment()
	{
		
	// ONLY ON PRO VERSION	           


    }

	/**
	* Test that required settings are available, and if we can communicate with the server (if required)
	*
	* @return	bool	If the vBulletin has all the information required to accept payments
	*/
	function test()
	{
		return (!empty($this->settings['lraccount']));

		
	}

	/**
	* Generates HTML for the subscription form page
	*
	* @param	string		Hash used to indicate the transaction within vBulletin
	* @param	string		The cost of this payment
	* @param	string		The currency of this payment
	* @param	array		Information regarding the subscription that is being purchased
	* @param	array		Information about the user who is purchasing this subscription
	* @param	array		Array containing specific data about the cost and time for the specific subscription period
	*
	* @return	array		Compiled form information
	*/
	function generate_form_html($hash, $cost, $currency, $subinfo, $userinfo, $timeinfo)
	{
		global $vbphrase, $vbulletin, $show;
        
		$item = $hash;
		$currency = str_replace($currency, lr.$currency, $currency);
		$currency = strtoupper($currency);		
        $cost = $cost;
		$form['action'] = 'https://sci.libertyreserve.com';
		$form['method'] = 'GET';
        $account = $this->settings['lraccount'];
		// load settings into array so the template system can access them
		$settings =& $this->settings;

		$templater = vB_Template::create('subscription_payment_libertyreserve');
	     	$templater->register('account', $account);
			$templater->register('cost', $cost);
			$templater->register('currency', $currency);
			$templater->register('item', $item);
			$templater->register('settings', $settings);
			$templater->register('subinfo', $subinfo);
			$templater->register('timeinfo', $timeinfo);
			$templater->register('userinfo', $userinfo);
		$form['hiddenfields'] .= $templater->render();
		return $form;
	}
}

/*======================================================================*\
|| #################################################################### ||
|| # Product Name: Liberty Reserve Payment API Module for vBulletin		Version: 4.X.X
|| #################################################################### ||
\*======================================================================*/
?>