<?php
/*
=================================================================
Bullet Energy - by White-Master 
-----------------------------------------------------------------
http://white-master.ru/
-----------------------------------------------------------------
Copyright (c) 2011 White-Master
=================================================================
    
=================================================================
: sql.php
-----------------------------------------------------------------
:   sql   .
=================================================================
*/
$tableSchema = array();
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_advertising";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_advertising  (
  `advertising_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `advertising_name` varchar(255) NOT NULL,
  `advertising_group` mediumblob NOT NULL COMMENT 'serialize array group view advertising',
  `advertising_tree` mediumblob NOT NULL COMMENT 'serialize array tree view advertising',
  `advertising_topic` enum('none','top','footer','random') NOT NULL DEFAULT 'none',
  `advertising_tree_display` enum('none','top','footer','random') NOT NULL DEFAULT 'none',
  `advertising_display` enum('none','display') NOT NULL DEFAULT 'none',
  `advertising_content` mediumblob NOT NULL,
  PRIMARY KEY (`advertising_id`),
  KEY `advertising_display` (`advertising_display`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_attachment";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_attachment  (
  `attachment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `attachment_date` int(10) unsigned NOT NULL,
  `attachment_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `attachment_name` varchar(255) NOT NULL DEFAULT '',
  `attachment_user_name` varchar(40) NOT NULL DEFAULT '',
  `attachment_user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `attachment_content_id` int(11) unsigned NOT NULL DEFAULT '0',
  `attachment_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `size` int(11) unsigned NOT NULL DEFAULT '0',
  `topic_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`attachment_id`),
  KEY `attachment_content_id` (`attachment_content_id`),
  KEY `topic_id` (`topic_id`),
  KEY `attachment_count` (`attachment_count`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_complaint";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_complaint  (
  `ct_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ct_msg_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ct_date` int(10) unsigned NOT NULL,
  `ct_text` text NOT NULL,
  `ct_from` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`ct_id`),
  KEY `ct_msg_id` (`ct_msg_id`),
  KEY `ct_date` (`ct_date`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_feed";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_feed  (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(11) unsigned NOT NULL DEFAULT '0',
  `id_topic` int(11) unsigned NOT NULL DEFAULT '0',
  `id_tree` int(10) unsigned NOT NULL DEFAULT '0',
  `date` int(10) unsigned NOT NULL DEFAULT '0',
  `is_mail` enum('no','yes') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `id_topic` (`id_topic`),
  KEY `id_tree` (`id_tree`),
  KEY `is_mail` (`is_mail`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_groups";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_groups  (
  `be_groups_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `be_style_name_css` varchar(255) NOT NULL DEFAULT '',
  `be_style_group_css` varchar(255) NOT NULL DEFAULT '',
  `be_access_view_forum` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_view_forum_off` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_flood_check_none` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_thanks` tinyint(1) NOT NULL DEFAULT '0',
  `be_upload` tinyint(1) NOT NULL DEFAULT '0',
  `be_upload_img` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_topic_new_private` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_search` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_del_my_post` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_edit_my_post` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_del_my_topic` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_hide` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_download` tinyint(1) NOT NULL DEFAULT '0',
  `be_access_mat_check` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_topic_wanted` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_topic_moder_param` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_edit_message_user` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_del_message_user` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_moder_access` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_moder_view` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_del_user_topic` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_close_to_open_topic` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_ip_view` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_top_rename` tinyint(1) NOT NULL DEFAULT '0',
  `be_moder_top_view_private` tinyint(1) NOT NULL DEFAULT '0',
  `be_complaint` tinyint(1) NOT NULL DEFAULT '0',
  `be_status` tinyint(1) NOT NULL DEFAULT '0',
  `be_time_step_msg` smallint(5) NOT NULL DEFAULT '0',
  `be_captha_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`be_groups_id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 6";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_message";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_message  (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_topic` int(11) unsigned NOT NULL DEFAULT '0',
  `autors_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `message_autor` varchar(40) NOT NULL DEFAULT '',
  `message_autor_ip` int(11) NOT NULL DEFAULT '0',
  `message_date` int(10) unsigned NOT NULL,
  `message_text` text NOT NULL,
  `message_approve` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tree_id` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_msg` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `fixap_msg` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `msg_edit_date` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_autor` varchar(40) NOT NULL DEFAULT '',
  `edit_quote` varchar(255) NOT NULL DEFAULT '',
  `user_thanks` mediumblob NOT NULL COMMENT 'serialize array 3 user like',
  `thanks` int(11) unsigned NOT NULL DEFAULT '0',
  `attachment` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_topic` (`id_topic`),
  KEY `autors_id` (`autors_id`),
  KEY `message_autor` (`message_autor`),
  KEY `message_date` (`message_date`),
  KEY `parent_msg` (`parent_msg`),
  KEY `fixap_msg` (`fixap_msg`),
  KEY `tree_id` (`tree_id`),
  KEY `thanks` (`thanks`),
  FULLTEXT KEY `message_text` (`message_text`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_moderator";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_moderator  (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `moderator_id` int(10) unsigned NOT NULL DEFAULT '0',
  `moderator_name` varchar(40) NOT NULL DEFAULT '',
  `moderator_super` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `moderator_tree_id` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `moderator_id` (`moderator_id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_question";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_question  (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` varchar(255) NOT NULL,
  `answers` mediumblob NULL COMMENT 'serialize array answers to questions',
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `is_active` (`is_active`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 7";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_read_topic";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_read_topic  (
  `ber_read_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ber_user_id` int(10) unsigned NOT NULL,
  `ber_topic_id` int(10) unsigned NOT NULL,
  `ber_tree_id` int(10) unsigned NOT NULL,
  `ber_read_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`ber_read_id`),
  UNIQUE KEY `ber_ut_id` (`ber_user_id`,`ber_topic_id`),
  KEY `ber_read_date` (`ber_read_date`),
  KEY `ber_tree_id` (`ber_tree_id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_read_tree";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_read_tree  (
  `bert_read_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bert_user_id` int(10) unsigned NOT NULL,
  `bert_tree_id` int(10) unsigned NOT NULL,
  `bert_read_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bert_read_id`),
  UNIQUE KEY `bert_user_tree` (`bert_user_id`,`bert_tree_id`),
  KEY `tree_read_date` (`bert_read_date`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_session";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_session  (
  `session_id` varchar(32) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `key` int(10) NOT NULL DEFAULT '0',
  `ip` int(10) NOT NULL DEFAULT '0',
  `date` int(10) unsigned NOT NULL,
  `user_group` int(11) unsigned NOT NULL DEFAULT '5',
  `info_type` int(10) unsigned NOT NULL,
  `param_state` mediumblob NULL COMMENT 'serialize info view tree',
  PRIMARY KEY (`user_id`,`key`),
  KEY `date` (`date`),
  KEY `user_id` (`user_id`),
  KEY `info_type` (`info_type`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_thanks";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_thanks  (
  `thanks_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `thanks_msg_id` int(11) unsigned NOT NULL,
  `thanks_id_user` int(10) unsigned NOT NULL,
  `thanks_date` int(10) unsigned NOT NULL,
  `thanks_msg_id_user` int(10) unsigned NOT NULL,
  PRIMARY KEY (`thanks_id`),
  UNIQUE KEY `msg_id_user` (`thanks_msg_id`,`thanks_id_user`),
  KEY `user_msg_id_date` (`thanks_msg_id_user`,`thanks_date`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_topic";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_topic  (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `reply_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `view_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `autor_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `autor` varchar(40) NOT NULL DEFAULT '',
  `post_date` int(10) unsigned NOT NULL,
  `last_reply_date` int(10) unsigned NOT NULL,
  `last_reply_info` mediumblob NULL COMMENT 'serialize info last post info',
  `rating` smallint(5) NOT NULL DEFAULT '0',
  `topic_fixed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `topic_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `topic_private_user` mediumblob NULL COMMENT 'serialize user is topic private',
  `topic_descr_site` varchar(255) NOT NULL DEFAULT '',
  `topic_approve` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `topic_viewer_full` enum('none','fixed') NOT NULL DEFAULT 'none',
  `topic_vote` mediumblob NOT NULL,
  `topic_meta` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_parent` (`id_parent`),
  KEY `autor` (`autor`),
  KEY `autor_id` (`autor_id`),
  KEY `topic_fixed` (`topic_fixed`),
  KEY `topic_approve` (`topic_approve`),
  KEY `post_date` (`post_date`),
  KEY `last_reply_date` (`last_reply_date`),
  KEY `reply_count` (`reply_count`),
  KEY `rating` (`rating`),
  KEY `view_count` (`view_count`),
  FULLTEXT KEY `title` (`title`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_topic_log";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_topic_log  (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user` varchar(40) NOT NULL DEFAULT '',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_ip` int(11) NOT NULL DEFAULT '0',
  `stack` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `is_vote` (`topic_id`,`user_id`),
  KEY `topic_id` (`topic_id`),
  KEY `user_id` (`user_id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_topic_vote";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_topic_vote  (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user` varchar(40) NOT NULL DEFAULT '',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_ip` int(11) NOT NULL DEFAULT '0',
  `user_stack` blob NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `is_vote` (`topic_id`,`user_id`),
  KEY `topic_id` (`topic_id`),
  KEY `user_id` (`user_id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_tree";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_tree  (
  `tree_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tree_title` varchar(255) NOT NULL,
  `tree_description` text NOT NULL,
  `tree_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tree_display` int(10) unsigned NOT NULL DEFAULT '1',
  `tree_type` tinyint(5) unsigned NOT NULL DEFAULT '0',
  `tree_type_sub` varchar(255) NOT NULL,
  `tree_approve` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tree_count` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tree_pass` mediumblob NULL COMMENT 'is pass',
  `tree_info_titl` varchar(255) NOT NULL,
  `tree_info_text` text NOT NULL,
  `tree_last_date` int(10) unsigned NOT NULL DEFAULT '0',
  `tree_last_info` mediumblob NOT NULL,
  `tree_topic` int(10) unsigned NOT NULL DEFAULT '0',
  `tree_answer` int(10) unsigned NOT NULL DEFAULT '0',
  `tree_access_topic_new` varchar(255) NOT NULL,
  `tree_access_topic_read` varchar(255) NOT NULL,
  `tree_access_topic_replic` varchar(255) NOT NULL,
  `tree_access_view` varchar(255) NOT NULL,
  `tree_is_pass_no` varchar(255) NOT NULL,
  PRIMARY KEY (`tree_id`),
  KEY `tree_parent_id` (`tree_parent_id`),
  KEY `tree_display` (`tree_display`),
  KEY `tree_approve` (`tree_approve`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_user_title";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_user_title  (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `bals` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_user_warning";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_user_warning  (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `moderator_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `post_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date` int(10) unsigned NOT NULL DEFAULT '0',
  `description` tinytext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `moderator_id` (`moderator_id`),
  KEY `post_id` (`post_id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "DROP TABLE IF EXISTS " . PREFIX . "_be_honor";
$tableSchema[] = "CREATE TABLE " . PREFIX . "_be_honor  (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bals` int(10) unsigned NOT NULL DEFAULT '0',
  `criteria` mediumblob NOT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE=MyISAM  DEFAULT CHARSET=" . COLLATE . " AUTO_INCREMENT = 1";
/**/
$tableSchema[] = "ALTER TABLE " . PREFIX . "_users ADD forum_post_count smallint(5) DEFAULT '0'";
$tableSchema[] = "ALTER TABLE " . PREFIX . "_users ADD forum_topic_count smallint(5) DEFAULT '0'";
$tableSchema[] = "ALTER TABLE " . PREFIX . "_users ADD forum_thanks_count mediumint(7) DEFAULT '0'";
$tableSchema[] = "ALTER TABLE " . PREFIX . "_users ADD forum_warning smallint(5) DEFAULT '0'";
$tableSchema[] = "ALTER TABLE " . PREFIX . "_users ADD forum_inseption mediumblob COMMENT 'array honor,title and other info'";
/**/
$tableSchema[] = "INSERT INTO " . PREFIX . "_be_groups (be_groups_id, be_style_name_css, be_style_group_css, be_access_view_forum, be_access_view_forum_off, be_access_flood_check_none, be_access_thanks, be_upload, be_upload_img, be_access_topic_new_private, be_access_search, be_access_del_my_post, be_access_edit_my_post, be_access_del_my_topic, be_access_hide, be_access_download, be_access_mat_check, be_moder_topic_wanted, be_moder_topic_moder_param, be_moder_edit_message_user, be_moder_del_message_user, be_moder_moder_access, be_moder_moder_view, be_moder_del_user_topic, be_moder_close_to_open_topic, be_moder_ip_view, be_moder_top_rename, be_moder_top_view_private, be_complaint, be_status, be_time_step_msg, be_captha_status) VALUES
(1, 'administrator-name', 'administrator', 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1),
(4, 'visitors-name', 'visitors', 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 30, 0),
(5, 'guest-name', 'guest', 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(3, 'journalist-name', 'journalist', 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 20, 0),
(2, 'editors-name', 'editors', 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 10, 0)";
/**/
$tableSchema[] = "INSERT INTO " . PREFIX . "_be_question (id, question, answers, is_active) VALUES
(1, '  ?', 0xdef0e8e93c7365703edef0e0, '1'),
(2, '   ?', 0xc7e5ecebff, '1'),
(3, '   ?', 0xd1eeebedf6e53c7365703eebf3ede0, '1'),
(4, '2+2=', 0x343c7365703ef7e5f2fbf0e5, '1'),
(5, '8+8=', 0x31363c7365703ef8e5f1f2ede0e4f6e0f2fc, '1'),
(6, '     ?', 0xd0eef1f1e8ff, '1')";
/**/

?>