<?php
/*
=================================================================
Bullet Energy - by White-Master 
-----------------------------------------------------------------
http://white-master.ru/
-----------------------------------------------------------------
Copyright (c) 2011 White-Master
=================================================================
    
=================================================================
: debug.class.php
=================================================================
*/
class BulletEnergyDebug extends BulletEnergy
{
  public function __construct()
  {
  }
  public static function getDebug()
  {
    $includeFile = self::getIncludeFile();
    $db = self::dbInfo();
    return "<div id=\"bulletDebug\"><h3>    MySQL : {$db[time]}</h3>
    <h3>  MySQL : {$db[count]}</h3>
    <h4> :</h4>
    {$db[query]}
    <h3>    {$includeFile[includeFileCount]} ,   {$includeFile[includeFileBulletEnergy]}  .</h3>
    <h4> :</h4>{$includeFile[includedFile]}</div>";
  }
  public static function dbInfo()
  {
    $db = array('time' => round(parent::$handler->db->MySQL_time_taken, 5), 'query' => '<ol>', 'count' => parent::$handler->db->query_num);
    foreach (parent::$handler->db->query_list as $query) {
      $query = htmlspecialchars(trim($query));
      $db['query'] .= '<li>' . $query . '</li>' . "\n";
    }
    $db['query'] .= '</ol>';
    return $db;
  }
  public static function getIncludeFile()
  {
    $includedFile = get_included_files();
    $return = array('includeFileCount' => count($includedFile), 'includedFile' => '<ol>', 'includeFileBulletEnergy' => 0);
    $rootDir = dirname(reset($includedFile));
    foreach ($includedFile as $file) {
      $file = preg_replace('#^' . preg_quote($rootDir, '#') . '(\\\\|/)#', '', $file);
      $file = htmlspecialchars($file);
      if (preg_match('#^engine(/|\\\\)bullet_energy(/|\\\\)#', $file)) {
        $return['includeFileBulletEnergy']++;
      } else {
        unset($file);
      }
      $file = preg_replace('#^engine(/|\\\\)bullet_energy(/|\\\\)#', '<b>$0</b>', $file);
      $return['includedFile'] .= '<li>' . $file . '</li>' . "\n";
    }
    $return['includedFile'] .= '</ol>';
    return $return;
  }
}

?>