<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IDM url file storage handling
 * Last Updated: $Date: 2010-11-09 20:03:06 -0500 (Tue, 09 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		6/24/2008
 * @version		$Revision: 7125 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class urlStorageEngine extends storageEngine implements interface_storage
{
	/**
	 * Remove a file
	 *
	 * @access	public
	 * @param	array		Record data
	 * @return	boolean		File removed successfully
	 */	
	public function remove( $record )
	{
		//-----------------------------------------
		// Nothing to "remove"
		//-----------------------------------------
		
		return true;
	}

	/**
	 * Stores the uploaded files
	 *
	 * @access	public
	 * @param	array 		File information
	 * @return	array		File details for final storage
	 */	
	public function store( $data=array() )
	{
		if( !$this->registry->getClass('idmFunctions')->canSubmitLinks() )
		{
			return 1;
		}

		//-----------------------------------------
		// What kind of url...
		//-----------------------------------------
		
		switch( $data['type'] )
		{
			case 'file':
				if( $data['url'] AND IPSText::xssCheckUrl( $data['url'] ) )
				{
					if( !$this->settings['idm_ignore_mime_link'] )
					{
						$url_pieces	= explode( "/", trim($data['url']) );
						$file_data	= array_pop( $url_pieces );
						$extension	= $this->getFileExtension( $file_data );
						
						if( !$extension )
						{
							return 2;
						}
						else
						{
							if ( ! in_array( $extension, $this->types['files'] ) )
							{
								return 2;
							}
						}
					}
					
					//-----------------------------------------
					// Set the new details
					//-----------------------------------------

					$this->details[]	= array(
												'record_post_key'		=> $data['post_key'],
												'record_file_id'		=> 0,
												'record_type'			=> 'link',
												'record_location'		=> trim($data['url']),
												'record_db_id'			=> 0,
												'record_thumb'			=> '',
												'record_storagetype'	=> 'web',
												'record_realname'		=> $file_data,
												'record_link_type'		=> $data['link_type'],
												'record_mime'			=> intval($this->mimecache[ $extension ]['mime_id']),
												'record_size'			=> $this->registry->getClass('idmFunctions')->obtainRemoteFileSize( trim($data['url']) ),
												'record_backup'			=> 0,
												);

					return 0;
				}
				else
				{
					return 1;
				}
			break;
			
			case 'screenshot':
				if( $data['url'] AND IPSText::xssCheckUrl( $data['url'] ) )
				{
					if( !$this->settings['idm_ignore_mime_link'] )
					{
						$url_pieces	= explode( "/", trim($data['url']) );
						$file_data	= array_pop( $url_pieces );
						$extension	= $this->getFileExtension( $file_data );
						
						if( !$extension )
						{
							return 2;
						}
						else
						{
							if ( ! in_array( $extension, $this->types['ss'] ) )
							{
								return 2;
							}
						}
					}
					
					//-----------------------------------------
					// Set the new details
					//-----------------------------------------

					$this->details[]	= array(
												'record_post_key'		=> $data['post_key'],
												'record_file_id'		=> 0,
												'record_type'			=> 'sslink',
												'record_location'		=> trim($data['url']),
												'record_db_id'			=> 0,
												'record_thumb'			=> '',
												'record_storagetype'	=> 'web',
												'record_realname'		=> $file_data,
												'record_link_type'		=> '',
												'record_mime'			=> intval($this->mimecache[ $extension ]['mime_id']),
												'record_size'			=> $this->registry->getClass('idmFunctions')->obtainRemoteFileSize( trim($data['url']) ),
												'record_backup'			=> 0,
												'record_default'		=> ( $data['index'] == $this->primaryScreenshot ) ? 1 : 0,
												);

					return 0;
				}
				else
				{
					return 1;
				}
			break;
		}
	}
	
	/**
	 * Undo stored files
	 *
	 * @access	public
	 * @return	bool		Rollback complete
	 */	
	public function rollback()
	{
		unset($this->details);
	}
	
	/**
	 * Finalize the storage
	 *
	 * @access	public
	 * @param	integer		File id
	 * @return	boolean
	 */	
	public function commit( $file_id=0 )
	{
		parent::commit( $file_id );
	}
}