<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Tools skin file
 * Last Updated: $Date: 2010-11-16 20:42:14 -0500 (Tue, 16 Nov 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 7198 $ 
 */
 
class cp_skin_tools extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}

/**
 * Tools overview screen
 *
 * @access	public
 * @return	string	HTML
 */
public function overviewScreen() {

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$this->lang->words['t_title']}</h2>
</div>

<div class='acp-box'>
	<h3>{$this->lang->words['d_filemanage']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<td width='75%'>
				{$this->lang->words['d_bulkimport']}
				<div class='desctext'>{$this->lang->words['d_bulk_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;module=tools&amp;section=bulkimport'>{$this->lang->words['d_fromdir']}</a> | <a href='{$this->settings['base_url']}&amp;module=tools&amp;section=bulkimport&amp;do=bulkZip'>{$this->lang->words['d_fromzip']}</a></td>
		</tr>
		<tr>
			<td>
				{$this->lang->words['d_topiccheck']}
				<div class='desctext'>{$this->lang->words['d_topic_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=check_topics'>{$this->lang->words['d_checktopic']}</a> | <a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_topics&amp;all=1&amp;limit=20'>{$this->lang->words['d_fixalltopic']}</a></td>
		</tr>
		<tr>
			<td>
				{$this->lang->words['d_latestfile']}
				<div class='desctext'>{$this->lang->words['d_latest_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_cats'>{$this->lang->words['d_updateallcats']}</a></td>
		</tr>
		<tr>
			<td>
				{$this->lang->words['d_dlcount']}
				<div class='desctext'>{$this->lang->words['d_dlcount_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=recount_dlcounts'>{$this->lang->words['d_dlcountbutton']}</a></td>
		</tr>
		<tr>
			<td>
				{$this->lang->words['d_thumbs']}
				<div class='desctext'>{$this->lang->words['d_thumbs_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=thumbs'>{$this->lang->words['d_thumbs_button']}</a></td>
		</tr>
		<tr>
			<td>
				{$this->lang->words['d_fixorph']}
				<div class='desctext'>{$this->lang->words['d_fixorph_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=check_orph'>{$this->lang->words['d_fixorph_button']}</a></td>
		</tr>
		<tr>
			<td>
				{$this->lang->words['d_fixbrok']}
				<div class='desctext'>{$this->lang->words['d_fixbrok_info']}</div>
			</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=check_broken'>{$this->lang->words['d_fixbrok_button']}</a></td>
		</tr>
	</table>
</div>
	
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * List broken files
 *
 * @access	public
 * @param	string	No file
 * @param	string	No image
 * @return	string	HTML
 */
public function brokenFileListing( $noFile, $noImg ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<form name='adminForm' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_broken&amp;type=file' method='post'>
<div class='acp-box'>
	<h3>{$this->lang->words['d_norecord']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th width='80%'>{$this->lang->words['d_fname']}</th>
			<th width='20%'>&nbsp;</th>
		</tr>
		{$noFile}
EOF;

if( !$noFile )
{
	$IPBHTML .= <<<EOF
		<tr>
			<td colspan='2'>{$this->lang->words['d_nonefound']}</td>
		</tr>
EOF;
}

$IPBHTML .= <<<EOF
		<tr>
			<td class='pformstrip' colspan='2'>
				{$this->lang->words['bf_with_selected']}: <select name='action' style='vertical-align:middle;'>
									<option value='del'>{$this->lang->words['d_deletefiles']}</option>
									<option value='hide'>{$this->lang->words['d_hidefiles']}</option>
								</select> <input class='realbutton' type='submit' value='{$this->lang->words['d_goright']}' style='vertical-align:middle;' />
			</td>
		</tr>
	</table>
</div>
</form>
<br />

<form name='adminForm' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_broken&amp;type=imgs' method='post'>
<div class='acp-box'>
	<h3>{$this->lang->words['d_ssrecord']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th>{$this->lang->words['d_fname']}</th>
			<th width='20%'>&nbsp;</th>
		</tr>
		{$noImg}
EOF;

if( !$noImg )
{
	$IPBHTML .= <<<EOF
		<tr>
			<td colspan='2'>{$this->lang->words['d_nonefound']}</td>
		</tr>
EOF;
}

$IPBHTML .= <<<EOF
		<tr>
			<td class='pformstrip' colspan='2'>
				{$this->lang->words['bf_with_selected']}: <select name='action' style='vertical-align:middle;'>
									<option value='del'>{$this->lang->words['d_deletefiles']}</option>
									<option value='hide'>{$this->lang->words['d_hidefiles']}</option>
									<option value='rem'>{$this->lang->words['d_removeimgs']}</option>
								</select> <input class='realbutton' type='submit' value='{$this->lang->words['d_goright']}' style='vertical-align:middle;' />
			</td>
		</tr>
	</table>
</div>
</form>
<br />
			
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Broken file row
 *
 * @access	public
 * @param	array 	File info
 * @param	string	Type (file or screenshot)
 * @return	string	HTML
 */
public function brokenFileRow( $file, $type='file' ) {

$checkbox	= $this->registry->output->formCheckbox( $type . '_' . $file['record_id'], true );
$text		= $this->lang->words['t_' . $type ];

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td>{$text}: <a href='{$this->settings['board_url']}/index.php?app=downloads&amp;showfile={$file['file_id']}'>{$file['file_name']}</a></td>
 <td><a href='{$this->settings['board_url']}/index.php?app=downloads&amp;module=post&amp;section=submit&amp;do=edit_main&amp;id={$file['file_id']}'>{$this->lang->words['d_editfile']}</a>&nbsp;{$checkbox}</td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Show orphaned files
 *
 * @access	public
 * @param	string	No files
 * @return	string	HTML
 */
public function orphanedFileListing( $noFile ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<form name='adminForm' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_orph' method='post'>
<div class='acp-box'>
	<h3>{$this->lang->words['d_orphlist']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th width='95%'{$this->lang->words['d_fname']}/th>
			<th width='5%'>&nbsp;</th>
		</tr>
		{$noFile}
EOF;

if( !$noFile )
{
	$IPBHTML .= <<<EOF
		<tr>
			<td colspan='2'>{$this->lang->words['d_nonefound']}</td>
		</tr>
EOF;
}

$IPBHTML .= <<<EOF
		<tr>
			<td class='pformstrip' colspan='2' style='text-align: right; padding-right: 20px;'>
				<input class='realbutton' type='submit' value=' {$this->lang->words['d_removeselected']} ' id='button' style='vertical-align:middle;' />
			</td>
		</tr>
	</table>
</div>
</form>
<br />
		
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Orphaned file row
 *
 * @access	public
 * @param	array 	Data about the file
 * @param	string	Type of orphaned file
 * @return	string	HTML
 */
public function orphanedFileRow( $record, $type='file' ) {

$checkbox	= $this->registry->output->formCheckbox( $type . '_' . urlencode($record), 1, urlencode($record) );
$text		= $this->lang->words['t_' . $type ];

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td>{$text}: {$record}</td>
 <td>{$checkbox}</td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Topics listing
 *
 * @access	public
 * @param	string 	Rows
 * @param	string 	Missing topics
 * @return	string	HTML
 */
public function topicsListing( $topics, $missing ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<form name='adminForm' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_topics' method='post'>
<div class='acp-box'>
	<h3>{$this->lang->words['d_topiclinked']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th width='70%'{$this->lang->words['d_fname']}/th>
			<th width='20%'>{$this->lang->words['d_topic']}</th>
			<th width='10%'>&nbsp;</th>
		</tr>
		{$topics}
EOF;

if( !$topics )
{
	$IPBHTML .= <<<EOF
		<tr>
			<td colspan='3'>{$this->lang->words['d_nonefound']}</td>
		</tr>
EOF;
}

$IPBHTML .= <<<EOF
		<tr>
			<th colspan='3'>{$this->lang->words['d_notopiclinked']}</th>
		</tr>
		{$missing}
EOF;

if( !$missing )
{
	$IPBHTML .= <<<EOF
		<tr>
			<td colspan='3'>{$this->lang->words['d_nonefound']}</td>
		</tr>
EOF;
}

$IPBHTML .= <<<EOF
		<tr>
			<td class='pformstrip' colspan='3'>
				{$this->lang->words['d_createtopics']} <input type='text' size='2' name='limit' value='10' /> at a time <input class='realbutton' type='submit' value='{$this->lang->words['d_goright']}' />
			</td>
		</tr>
	</table>
</div>
</form>
<br />
		
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Topics row
 *
 * @access	public
 * @param	array 	File data
 * @return	string	HTML
 */
public function topicsRow( $row ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td>{$row['file_name']}</td>
 <td>{$row['file_topicid']}</td>
 <td><input type='checkbox' checked='checked' name='file_{$row['file_id']}' value='1' /></td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}


}
