<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Custom fields skin file
 * Last Updated: $Date: 2010-10-14 19:38:17 -0400 (Thu, 14 Oct 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 6983 $ 
 */
 
class cp_skin_cfields extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}

/**
 * Delete custom fields form
 *
 * @access	public
 * @param	array 	Custom field
 * @return	string	HTML
 */
public function deleteForm( $field ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$this->lang->words['cf_title_del']}</h2>
</div>

<div class="acp-box">
	<h3>{$this->lang->words['d_removeconf']}</h3>
	
	<form action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=dodelete' method='post'>
		<input type='hidden' name='id' value='{$this->request['id']}' />
		
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_fieldtorem']}</label>
				{$field['cf_title']}
			</li>
		</ul>
		
		<div class='acp-actionbar'>
			<div class='centeraction'>
				<input type='submit' value=' {$this->lang->words['d_delfield']} ' class='button primary' />
			</div>
		</div>
	</form>
</div>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Field to add/edit custom field
 *
 * @access	public
 * @param	array 	Form elements
 * @param	array 	Cfield information
 * @return	string	HTML
 */
public function cfieldsForm( $form, $field ) {

$IPBHTML = "";
//--starthtml--//

if( $form['code'] == 'doedit' )
{
	$title	= $this->lang->words['cf_editing'] . $field['cf_title'];
}
else
{
	$title	= $this->lang->words['cf_adding'];
}

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$title}</h2>
</div>

<form action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do={$form['code']}' method='post'>
	<input type='hidden' name='id' value='{$this->request['id']}' />
	
	<div class="acp-box">
		<h3>{$this->lang->words['d_fieldset']}</h3>
		
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_fieldtitle']}<span class='desctext'>{$this->lang->words['d_maxchar']} 200</span></label>
				{$form['cf_title']}
			</li>
			<li>
				<label>{$this->lang->words['d_description']}<span class='desctext'>{$this->lang->words['d_maxchar']} 250</span></label>
				{$form['cf_desc']}
			</li>
			<li>
				<label>{$this->lang->words['d_useincats']}</label>
				{$form['categories']}
			</li>
			<li>
				<label>{$this->lang->words['d_fieldtype']}</label>
				{$form['cf_type']}
			</li>
			<li>
				<label>{$this->lang->words['d_maxinput']}<span class='desctext'>{$this->lang->words['d_maxinput_info']}</span></label>
				{$form['cf_max_input']}
			</li>
			<li>
				<label>{$this->lang->words['d_expectedin']}<span class='desctext'>{$this->lang->words['d_expectedin_info']}</span></label>
				{$form['cf_input_format']}
			</li>
			<li>
				<label>{$this->lang->words['d_optcontent']}<span class='desctext'>{$this->lang->words['d_optcontent_info']}</span></label>
				{$form['cf_content']}
			</li>
			<li>
				<label>{$this->lang->words['d_mustcomplete']}</label>
				{$form['cf_not_null']}
			</li>
			<li>
				<label>{$this->lang->words['d_fieldformat']} <span class='desctext'>{$this->lang->words['d_fieldformat_desc']}</span></label>
				{$form['cf_format']}
			</li>
			<li>
				<label>{$this->lang->words['d_fieldauto']}</label>
				{$form['cf_topic']}
			</li>
		</ul>
		<div class='acp-actionbar'>
			<div class='centeraction'>
				<input type='submit' value=' {$form['button']} ' class='button primary' />
			</div>
		</div>
	</div>
</form>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Custom fields wrapper
 *
 * @access	public
 * @param	string	HTML content
 * @return	string	HTML
 */
public function cfieldsWrapper( $content ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$this->lang->words['cf_title']}</h2>
</div>

<script type="text/javascript">
window.onload = function() {
	Sortable.create( 'sortable_handle', { revert: true, format: 'cfield_([0-9]+)', onUpdate: dropItLikeItsHot, handle: 'draghandle' } );
};

dropItLikeItsHot = function( draggableObject, mouseObject )
{
	var options = {
					method : 'post',
					parameters : Sortable.serialize( 'sortable_handle', { tag: 'li', name: 'cfields' } )
				};
 
	new Ajax.Request( "{$this->settings['base_url']}&{$this->form_code_js}&do=reorder&md5check={$this->registry->adminFunctions->getSecurityKey()}".replace( /&amp;/g, '&' ), options );

	return false;
};

</script>
<div class='acp-box'>
	<h3>{$this->lang->words['d_fieldmanage']}</h3>

	<ul id='sortable_handle'>
		{$content}
	</ul>
	<div class='acp-actionbar'>
		<div class='centeraction'>
			<input type='button' class='realbutton' value='{$this->lang->words['d_addnewfield']}' onclick='acp.redirect("&amp;app=downloads&amp;{$this->form_code}&amp;do=add")' />
		</div>
	</div>
</div>
<br />


EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Custom fields row
 *
 * @access	public
 * @param	array 	Custom field info
 * @return	string	HTML
 */
public function cfieldsRow( $row ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<li id='cfield_{$row['cf_id']}'>
	<table width='100%' class='hierarchy double_pad'>
		<tr class='child'>
			<td style='width: 2%; text-align: center'>
				<div class='draghandle'><img src='{$this->settings['skin_acp_url']}/_newimages/drag_icon.png' alt='' /></div>
			</td>
			<td style='width: 61%'>
				<strong>{$row['cf_title']}</strong>
				<div class='desctext'>{$row['cf_desc']}</div>
			</td>
			<td style='width: 34%;'>
				{$row['categories']}
			</td>
			<td style='width: 3%'>
				<img id="menu{$row['cf_id']}" src='{$this->settings['skin_acp_url']}/_newimages/menu_open.png' alt='{$this->lang->words['d_options']}' class='ipbmenu' />
				<ul class='acp-menu' id='menu{$row['cf_id']}_menucontent'>
					<li class='icon edit'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=edit&amp;id={$row['cf_id']}'>{$this->lang->words['d_editfield']}</a></li>
					<li class='icon delete'><a href='#' onclick='return acp.confirmDelete("{$this->settings['base_url']}&amp;{$this->form_code_js}&amp;do=delete&amp;id={$row['cf_id']}","{$this->lang->words['d_surefield']}");'>{$this->lang->words['d_deletefield']}</a></li>
				</ul>
			</td>
		</tr>
	</table>
</li>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * No custom fields row
 *
 * @access	public
 * @return	string	HTML
 */
public function cfieldsRowEmpty() {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td class='tablerow1' colspan='4' align='center'>{$this->lang->words['d_nofields']}</td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

}
