<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Bulk import skin file
 * Last Updated: $Date: 2010-09-15 14:36:01 -0400 (Wed, 15 Sep 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 6878 $ 
 */
 
class cp_skin_bulkimport extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}

/**
 * List zip files
 *
 * @access	public
 * @param	string	HTML content
 * @return	string	HTML
 */
public function zipImportWrapper( $content ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<div class="acp-box">
	<h3>{$this->lang->words['d_zipindir']} {$this->settings['upload_dir']}</h3>
	<table class='alternate_rows'>
		<tr>
			<th width='5%'>&nbsp;</th>
			<th width='40%'>{$this->lang->words['d_archivename']}</th>
			<th width='10%'>{$this->lang->words['d_fcount']}</th>
			<th width='10%'>{$this->lang->words['d_archivesize']}</th>
			<th width='35%'>{$this->lang->words['d_options']}</th>
		</tr>
		{$content}
	</table>
</div>
<br />
EOF;

if ( SAFE_MODE_ON OR $this->settings['safe_mode_skins'] )
{
	$IPBHTML .= <<<EOF
<div>
	{$this->lang->words['d_safemode']} {$this->settings['upload_dir']}
</div>
EOF;
}
else
{
	$IPBHTML .= <<<EOF
<form name='theAdminForm' id='adminform' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkZip&amp;op=upload' method='post' enctype='multipart/form-data'>
	<div class='acp-box'>
		<h3>{$this->lang->words['d_uploadafile']}</h3>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_selectfile']}</label>
				<input type='file' name='zipup' size='30' />
			</li>
		</table>
		<div class='acp-actionbar'>
			<div class='centeraction'>
				<input type='submit' value='{$this->lang->words['d_upload']}' class='button primary' />
			</div>
		</div>
	</div>
</form>
EOF;
}


//--endhtml--//
return $IPBHTML;
}

/**
 * Zip file row
 *
 * @access	public
 * @param	object 	File
 * @param	array 	Zip info
 * @param	array 	Info about the zip
 * @return	string	HTML
 */
public function zipImportRow( $file, $zip, $info ) {

$comment	= $info['comment'] ? '<br /><i>' . $this->lang->words['d_comment'] . ': ' . $info['comment'] . '</i>' : '';
$size		= IPSLib::sizeFormat( $file->getSize() );

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td><img src='{$this->settings['public_dir']}style_extra/mime_types/zip.gif' /></td>
 <td>{$file->getFilename()}{$comment}</td>
 <td>{$info['nb']}</td>
 <td>{$size}</td>
 <td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkZip&amp;op=zipListAll&amp;zip={$file->getFilename()}' class='button'>{$this->lang->words['d_importfiles']}</a>&nbsp;<a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkZip&amp;op=del&amp;zip={$file->getFilename()}' class='realbutton redbutton'>{$this->lang->words['d_deletezip']}</a></td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * List files inside a zip
 *
 * @access	public
 * @param	string	HTML content
 * @return	string	HTML
 */
public function zipFileListing( $content ) {

$category_options	= '';
$categories 		= $this->registry->getClass('categories')->catJumpList( 1, 'none', array( $this->request['cat'] ) );

if( count($categories) )
{
	foreach( $categories as $cat )
	{
		$category_options .= "<option value='{$cat[0]}'>{$cat[1]}</option>\n";
	}
}
		
$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<script type='text/javascript' src='{$this->settings['js_app_url']}acp.downloads.js'></script>
<script type='text/javascript' src='{$this->settings['js_main_url']}acp.forms.js'></script>

<form name='importZip' id='importZip' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkZip&amp;op=zipIndexAdd' method='post'>
	<input type='hidden' name='zip' value='{$this->request['zip']}' />
	
	<div class="acp-box">
		<h3>{$this->lang->words['d_listingfiles']} {$this->request['zip']}</h3>
		
		<table class='alternate_rows'>
			<tr>
				<th width='15%'><input id='checkAll' type='checkbox' title='{$this->lang->words['d_checkuncheck']}' /></th>
				<th width='5%'>&nbsp;</th>
				<th width='40%'>{$this->lang->words['d_fname']}</th>
				<th width='30%'>{$this->lang->words['d_fsize']}</th>
				<th width='10%'>{$this->lang->words['d_imported']}</th>
			</tr>
			{$content}
			<tr>
				<td colspan='5'><em>{$this->lang->words['d_check2import']}</em></td>
			</tr>
		</table>
	</div>
	<br />
	<div class="acp-box">
		<h3>{$this->lang->words['d_importoptions']}</h3>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_selectcat']}<span class='desctext'>{$this->lang->words['d_selectcat_info']}</span></label>
				<select name='cat'>{$category_options}</select>
			</li>
			<li>
				<label>{$this->lang->words['d_fowner']}<span class='desctext'>{$this->lang->words['d_fowner_info']}</span></label>
				<input type='text' id='mem_name' name='mem_name' value='' class='textinput' />
			</li>
		</ul>
		<div class='acp-actionbar'>
			<div class='centeraction'>
				<input type='submit' value='{$this->lang->words['d_import']}' class='button primary' />
			</div>
		</div>
	</div>
</form>	
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * File inside zip row
 *
 * @access	public
 * @param	array 	File information
 * @return	string	HTML
 */
public function zipFileRow( $file ) {

$checkbox	= $this->registry->output->formCheckbox( 'extract_' . $file['index'], $file['is_checked'], $file['index'], '', '', 'checkAll' );
$size		= IPSLib::sizeFormat( $file['size'] );

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
			<tr>
				<td>{$checkbox}</td>
				<td><img src='{$this->settings['img_url']}/{$this->caches['idm_mimetypes'][ $file['ext'] ]['mime_img']}' /></td>
				<td>{$file['filename']}</td>
				<td>{$size}</td>
				<td>{$file['exists']}</td>
			</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}


/**
 * Bulk directory import wrapper
 *
 * @access	public
 * @param	string	HTML content
 * @param	string	Up a directory
 * @return	string	HTML
 */
public function bulkImportWrapper( $content, $up_a_dir='../' ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<div class="acp-box">
	<h3>{$this->lang->words['d_dirfrom']}</h3>

	<table class='alternate_rows'>
		<tr><th colspan='7'>{$this->lang->words['d_curdir']}: {$this->request['lookin']}</th></tr>
		<tr>
			<th width='5%'>&nbsp;</th>
			<th width='60%'>{$this->lang->words['d_directory']}</th>
			<th width='5%'>{$this->lang->words['d_files']}</th>
			<th width='10%'>{$this->lang->words['d_size']}</th>
			<th width='5%'>{$this->lang->words['d_importable']}</th>
			<th width='5%'>{$this->lang->words['d_view']}</th>
			<th width='5%'>{$this->lang->words['d_import']}</th>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkDir&amp;lookin={$up_a_dir}' title='{$this->lang->words['d_clickparent']}'>{$this->lang->words['d_goupdir']}</a></td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
		</tr>
		{$content}
	</table>
</div>
<br />
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * File row for bulk import
 *
 * @access	public
 * @param	object	File
 * @param	array 	Data about the file
 * @return	string	HTML
 */
public function bulkImportRow( $file, $data ) {

$size	= IPSLib::sizeFormat( $data['size'] );

if( $data['importable'] == 1 AND $data['count'] > 0 )
{
	$import 	= "<a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkDir&amp;op=viewDir&amp;directory={$file->getPathname()}' title='{$this->lang->words['d_click2import']}'>{$this->lang->words['d_import']}</a>";
	$view 		= "<a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkDir&amp;op=viewDirFiles&amp;viewdir={$file->getPathname()}' title='{$this->lang->words['d_click2view']}'><img src='{$this->settings['skin_acp_url']}/_newimages/icons/view.png' /></a>";
	$importable = "<img src='{$this->settings['skin_acp_url']}/images/icon_can_write.gif' title='{$this->lang->words['d_filescanbe']}'>";	
}
else
{
	$import 	= '&nbsp;';	
	$view 		= '&nbsp;';	
	
	if( $data['importable'] == 1 )
	{
		$importable = "<img src='{$this->settings['skin_acp_url']}/images/icon_can_write.gif' title='{$this->lang->words['d_filescanbe']}' />";	
	}
	else
	{
		$importable = "<img src='{$this->settings['skin_acp_url']}/images/icon_cannot_write.gif' title='{$this->lang->words['d_filescannotbe']}' />";	
	}
}
					
$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
			<tr>
				<td><img src='{$this->settings['skin_acp_url']}/images/folder.gif' /></td>
				<td><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkDir&amp;lookin={$file->getPathname()}/' title='{$this->lang->words['d_click2view']}'>{$file->getFilename()}</a></td>
				<td>{$data['count']}</td>
				<td>{$size}</td>
				<td>{$importable}</td>
				<td>{$view}</td>
				<td>{$import}</td>
			</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * View files for bulk import wrapper
 *
 * @access	public
 * @param	string	HTML content
 * @return	string	HTML
 */
public function bulkImportViewWrapper( $content ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<div class="acp-box">
	<h3>{$this->lang->words['d_importedfiles']}</h3>
	<table class='alternate_rows'>
		{$content}
EOF;

if( !$content )
{
	$IPBHTML .= <<<EOF
		<tr>
			<td>{$this->lang->words['d_nonefound']}</td>
		</tr>
EOF;
}

$IPBHTML .= <<<EOF
	</table>
</div>
<br />
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * File in bulk import preview
 *
 * @access	public
 * @param	object	File
 * @param	string	Mime type icon
 * @return	string	HTML
 */
public function bulkImportViewRow( $file, $image ) {
				
$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
			<tr>
				<td><img src='{$this->settings['public_dir']}style_extra/{$image}' /></td>
				<td>{$file->getPathname()}</td>
			</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Directory file listing
 *
 * @access	public
 * @return	string	HTML
 */
public function dirFileListing() {

$category_options	= '';
$categories 		= $this->registry->getClass('categories')->catJumpList( 1, 'none', array( $this->request['cat'] ) );

if( count($categories) )
{
	foreach( $categories as $cat )
	{
		$category_options .= "<option value='{$cat[0]}'>{$cat[1]}</option>\n";
	}
}

$num		= $this->registry->output->formSimpleInput( 'num', 20 );
$move		= $this->registry->output->formYesNo( 'remove', 1 );
		
$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<script type='text/javascript' src='{$this->settings['js_app_url']}acp.downloads.js'></script>

<form name='importDir' id='importDir' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=bulkDir&amp;op=doBulkAdd' method='post'>
	<input type='hidden' name='dir' value='{$this->request['directory']}' />
	
	<div class="acp-box">
		<h3>{$this->lang->words['d_importoptions']}</h3>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_howmanyfiles']}<span class='desctext'>{$this->lang->words['d_toohightimeout']}</span></label>
				{$num}
			</li>
			<li>
				<label>{$this->lang->words['d_doremovefiles']}<span class='desctext'>{$this->lang->words['d_nowillmove']}</span></label>
				{$move}
			</li>
			<li>
				<label>{$this->lang->words['d_selectcat']}<span class='desctext'>{$this->lang->words['d_imported2cat']}</span></label>
				<select name='cat'>{$category_options}</select>
			</li>
			<li>
				<label>{$this->lang->words['d_fowner']}<span class='desctext'>{$this->lang->words['d_filesownedby']}</span></label>
				<input type='text' id='mem_name' name='mem_name' value='' autocomplete='off' style='width:210px;' class='textinput' />
			</li>
		</ul>
		<div class='acp-actionbar'>
			<div class='centeraction'>
				<input type='submit' value='{$this->lang->words['d_import']}' class='button primary' />
			</div>
		</div>
	</div>
</form>
EOF;

//--endhtml--//
return $IPBHTML;
}

}