<?php
/*
+--------------------------------------------------------------------------
|   IP.Board v2.3.0
|   ========================================
|   by Matthew Mecham
|   (c) 2001 - 2004 Invision Power Services
|   http://ipb.mxneo.ru
|   ========================================
|   Web: http://www.invisionboard.com
|   Email: matt@invisionpower.com
|   Licence Info: http://mxneo.ru/?license
+---------------------------------------------------------------------------
*/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

require_once( IPS_ROOT_PATH . 'sources/classes/skins/skinFunctions.php' );
require_once( IPS_ROOT_PATH . 'sources/classes/skins/skinCaching.php' );
require_once( IPS_ROOT_PATH . 'sources/classes/skins/skinImportExport.php' );
		
class version_upgrade
{
	/**
	 * Custom HTML to show
	 *
	 * @var		string
	 */
	private $_output = '';
	
	/**
	 * fetchs output
	 * 
	 * @return	string
	 */
	public function fetchOutput()
	{
		return $this->_output;
	}
	
	/**
	 * Execute selected method
	 *
	 * @param	object		Registry object
	 * @return	void
	 */
	public function doExecute( ipsRegistry $registry ) 
	{
		/* Make object */
		$this->registry =  $registry;
		$this->DB       =  $this->registry->DB();
		$this->settings =& $this->registry->fetchSettings();
		$this->request  =& $this->registry->fetchRequest();
		$this->cache    =  $this->registry->cache();
		$this->caches   =& $this->registry->cache()->fetchCaches();
		
		define( 'UPGRADE_THIS_DIR_IS',  IPSLib::getAppDir('downloads') . '/setup/versions/upg_23006' );
		
		$this->skinFunctions = new upgradeTemplates( $registry );
		
		/* Import sking global other */
		$this->skinFunctions->importTemplateAppXml( 'downloads', 'root', 0 );
	
		/* Now do core langs */
		$_PATH        = IPSLib::getAppDir('core') .  '/xml/';
		
		require_once( IPS_ROOT_PATH . 'applications/core/modules_admin/languages/manage_languages.php' );
		$lang            =  new admin_core_languages_manage_languages();
		$lang->makeRegistryShortcuts( $this->registry );

		$this->request['file_location'] = UPGRADE_THIS_DIR_IS . '/language.xml';
		$lang->imprtFromXML( true, true, true, 'core', true );
			
		/* Must return true */
		return true;
	}
	
}

/**
 * Upgrade templates
 */
class upgradeTemplates extends skinImportExport
{
	/**
	 * Import a single app
	 *
	 * @access	public
	 * @param	string		App
	 * @param	string		Skin key to import
	 * @param	int			Set ID
	 * @param	boolean		Set the edited / added flags to 0 (from install, upgrade)
	 * @return	mixed		bool, or array of info
	 */
	public function importTemplateAppXML( $app, $skinKey, $setID=0, $ignoreAddedEditedFlag=false )
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$templateGroups = array();
		$templates      = array();
		$fileXML        = UPGRADE_THIS_DIR_IS . '/templates.xml';
		$infoXML        = IPSLib::getAppDir('core') . '/xml/information.xml';
		$return			= array( 'updateCount' => 0, 'insertCount' => 0, 'updateBits' => array(), 'insertBits' => array() );
		$masterKeys     = $this->fetchMasterKeys();
		
		if( ! file_exists($fileXML) )
		{
			return $return;
		}
		
		if ( ! $setID and ! in_array( $skinKey, $masterKeys ) )
		{
			/* Figure out correct set ID based on key */
			$skinSetData = $this->DB->buildAndFetch( array( 'select' => '*',
															'from'   => 'skin_collections',
															'where'  => "set_key='" . $skinKey . "'" ) );
															
			$setID         = $skinSetData['set_id'];
			$skinMasterKey = $skinSetData['set_master_key'];
		}
		
		/* Set ignore flag correctly */
		if ( ! empty( $skinKey ) AND in_array( $skinKey, $masterKeys ) )
		{
			$ignoreAddedEditedFlag = true;
		}
		
		/* If this is a 'master' skin, then reset master key */
		if ( in_array( $skinKey, $masterKeys ) )
		{
			$skinMasterKey = $skinKey;
			$setID         = 0;
		}
		
		//-----------------------------------------
		// XML
		//-----------------------------------------

		require_once( IPS_KERNEL_PATH.'classXML.php' );
		$xml = new classXML( IPS_DOC_CHAR_SET );
		
		//-----------------------------------------
		// Force only skin_global_other
		//-----------------------------------------
		
		$templateGroups['skin_global_other']    = 'exact';
		$templateGroups['skin_global_comments'] = 'exact';
		
		if ( ! is_array( $templateGroups ) OR ! count( $templateGroups ) )
		{
			$this->_addMessage( $this->lang->words['nothingtoexportfor'] . $app );
			return FALSE;
		}
		
		//-----------------------------------------
		// Fetch templates
		//-----------------------------------------
	
		$_templates = $this->fetchTemplates( $setID        , 'allNoContent' );
		$_MASTER    = $this->fetchTemplates( $skinMasterKey, 'allNoContent' );
		
		//-----------------------------------------
		// Loop through...
		//-----------------------------------------
		
		foreach( $_templates as $group => $data )
		{
			$_okToGo = FALSE;
			
			foreach( $templateGroups as $name => $match )
			{
				if ( $match == 'contains' )
				{
					if ( stristr( $group, $name ) )
					{
						$_okToGo = TRUE;
						break;
					}
				}
				else if ( $group == $name )
				{
					$_okToGo = TRUE;
				}
			}
			
			if ( $_okToGo === TRUE )
			{
				foreach( $data as $name => $templateData )
				{
					$templates[ $group ][ $name ] = $templateData;
				}
			}
		}
		
		//-----------------------------------------
		// Wipe the master skins
		//-----------------------------------------
		
		if ( in_array( $skinKey, $masterKeys ) )
		{
			$this->DB->delete( 'skin_templates', "template_master_key='" . $skinKey . "' AND template_group IN ('" . implode( "','", array_keys( $templates ) ) . "') AND template_user_added=0 AND template_added_to=0" );
			
			/* Now wipe the array so we enforce creation */
			unset( $templates );
		}
					
		//-----------------------------------------
		// Now grab the actual XML files
		//-----------------------------------------

		$xml->load( $fileXML );

		foreach( $xml->fetchElements( 'template' ) as $templatexml )
		{
			$data = $xml->fetchElementsFromRecord( $templatexml );
			
			/* Figure out if this is added by a user or not */
			if ( $ignoreAddedEditedFlag === TRUE )
			{
				$isAdded  = 0;
				$isEdited = 0;
			}
			else
			{
				$isAdded  = ( is_array( $_MASTER[ $data['template_group'] ][ strtolower( $data['template_name'] ) ] ) AND ! $_MASTER[ $data['template_group'] ][ strtolower( $data['template_name'] ) ]['template_user_added'] ) ? 0 : 1;
				$isEdited = 1;
			}
			
			if ( is_array( $templates[ $data['template_group'] ][ strtolower( $data['template_name'] ) ] ) AND $templates[ $data['template_group'] ][ strtolower( $data['template_name'] ) ]['template_set_id'] == $setID )
			{
				/* Update.. */
				$return['updateCount']++;
				$return['updateBits'][] = $data['template_name'];
				$this->DB->update( 'skin_templates', array( 'template_content'     => $data['template_content'],
															'template_data'        => $data['template_data'],
															'template_user_edited' => $isEdited,
														    'template_user_added'  => $isAdded,
														    'template_master_key'  => ( in_array( $skinKey, $masterKeys ) ) ? $skinKey : '',
															'template_updated'     => time() ), 'template_set_id=' . $setID . " AND template_group='" . $data['template_group'] . "' AND template_name='" . $data['template_name'] . "'" );
			}
			else
			{
				/* Add... */
				$return['insertCount']++;
				$return['insertBits'][] = $data['template_name'];
				$this->DB->insert( 'skin_templates', array( 'template_set_id'      => $setID,
															'template_group'       => $data['template_group'],
														    'template_content'     => $data['template_content'],
														    'template_name'        => $data['template_name'],
														    'template_data'        => $data['template_data'],
														    'template_removable'   => ( $setID ) ? $data['template_removable'] : 0,
														    'template_added_to'    => $setID,
														    'template_user_edited' => $isEdited,
														    'template_user_added'  => $isAdded,
														    'template_master_key'  => ( in_array( $skinKey, $masterKeys ) ) ? $skinKey : '',
														    'template_updated'     => time() ) );
			}
		}

		return $return;
	}


}
