<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board vVERSION_NUMBER
 * IDM main posting library
 * Last Updated: $Date: 2010-12-07 10:03:17 -0500 (Tue, 07 Dec 2010) $
 * </pre>
 *
 * @author 		$Author: mark $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		6/24/2008
 * @version		$Revision: 7374 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class public_downloads_post_submit extends ipsCommand
{
	/**
	 * Stored temporary output
	 *
	 * @var 	string 				Page output
	 */
	protected $output				= "";

	/**
	 * Error message encountered
	 *
	 * @var 	string
	 */
	protected $error_message			= '';

	/**
	 * Like object
	 *
	 * @var	object
	 */
	protected $_like;

	/**
	 * Main class entry point
	 *
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */	
	public function doExecute( ipsRegistry $registry )
	{
		//-------------------------------------------
		// Page title and navigation bar
		//-------------------------------------------
		
		$this->registry->output->addNavigation( $this->lang->words['idm_navbar'], 'app=downloads', 'false', 'app=downloads' );

		//-------------------------------------------
		// Do we have access?
		//-------------------------------------------
		
		if( count($this->registry->getClass('categories')->member_access['view']) == 0 )
		{
			$this->registry->output->showError( 'no_downloads_permissions', 108107, null, null, 403 );
		}
		
		//-----------------------------------------
		// Is member blocked from submitting?
		//-----------------------------------------
		
		if( $this->memberData['_cache']['block_file_submissions'] )
		{
			$this->registry->output->showError( 'no_addfile_permissions', 108199, null, null, 403 );
		}
		
		//-------------------------------------------
		// Then what we doing?
		//-------------------------------------------
		
		else
		{
			switch( $this->request['do'] )
			{
				case 'add_cont':
					$this->_continueForm( 'new' );
				break;
				
				case 'edit_main':
					$this->_continueForm( 'edit' );
				break;
					
				case 'edit_cat':
					$this->_startForm( 'edit' );
				break;
					
				case 'add_comp':
					$this->_mainSave( 'new' );
				break;
					
				case 'edit_comp':
					$this->_mainSave( 'edit' );
				break;

				case 'add_start':
				default:
					$this->_startForm( 'new' );
				break;
			}
		}
		
		//-------------------------------------------
		// Print output
		//-------------------------------------------

        $this->registry->output->setTitle( $this->lang->words['file_submit_title_header'] . ' - ' . $this->settings['board_name'] );
		$this->registry->output->addContent( $this->output );
		$this->registry->output->sendOutput();
	}
	
	/**
	 * Choose the category
	 *
	 * @param	string		[new|edit]
	 * @return	void		[Outputs to screen]
	 */	
	protected function _startForm( $type='new' )
	{
		//-------------------------------------------
		// New or edit?
		//-------------------------------------------
		
		if( $type == 'edit' )
		{
			$file_id = intval($this->request['id']);
			
			$file = $this->DB->buildAndFetch( array( 'select' 	=> 'file_id, file_cat, file_name, file_submitter, file_name_furl',
											 		 'from'		=> 'downloads_files',
											 		 'where'	=> 'file_id=' . $file_id
											)		);

			if( !$this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanedit', 'idm_allow_edit' ) )
			{
				$this->registry->output->showError( 'not_your_file', 108107, null, null, 403 );
			}

			$file['code'] = 'edit_main';
		}
		else
		{
			$file = array( 'code' => 'add_cont' );
		}
		
		//-------------------------------------------
		// Grab categories for dropdown
		//-------------------------------------------
		
		$file['default_category'] = $this->request['cid'] ? intval($this->request['cid']) : ( $file['file_cat'] ? $file['file_cat'] : 0 );
			
		if( count($this->registry->getClass('categories')->member_access['add']) == 0 )
		{
			if( $type == 'new' )
			{
				$this->registry->output->showError( 'no_addfile_permissions', 108108, null, null, 403 );
			}
			else
			{
				$file['categories'] = array( $file['file_cat'], $this->registry->getClass('categories')->cat_lookup[ $file['file_cat'] ]['cname'] );
			}
		}
		else
		{
			$file['categories'] = $this->registry->getClass('categories')->catJumpList( true, 'add' );
		}

		//-------------------------------------------
		// And output
		//-------------------------------------------
		
		$this->output .= $this->registry->getClass('output')->getTemplate('downloads_submit')->submissionStart( $file );

		$this->registry->output->addNavigation( $this->lang->words['file_submit_nav_header'], '' );
	}

	/**
	 * Main file information submission page
	 *
	 * @param	string		[new|edit]
	 * @return	void		[Outputs to screen]
	 * @todo 	Need to get rid of call to error_box and just add logic to the startForm template to show an error if present
	 */	
	protected function _continueForm( $type='new' )
	{
		//-------------------------------------------
		// If this is new file, make sure we have cat
		//-------------------------------------------
		
		if( $type == 'new' )
		{
			$catid = intval($this->request['file_cat']);

			if( !$catid )
			{
				$this->registry->output->addContent( $this->registry->getClass('output')->getTemplate('downloads_submit')->error_box( $this->lang->words['no_category_selected'] ) );
				$this->_startForm( $type );
				return;
			}
		}
		
		$links	= array();
		
		//-------------------------------------------
		// Are we editing?
		//-------------------------------------------
		
		if( $type == 'edit' )
		{
			$file_id = intval($this->request['id']);
			
			$file = $this->DB->buildAndFetch( array( 'select' 	=> '*',
												 	 'from'		=> 'downloads_files',
												 	 'where'	=> 'file_id=' . $file_id
											)		);

			if( !$this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanedit', 'idm_allow_edit' ) )
			{
				$this->registry->output->showError( 'not_your_file', 108109, null, null, 403 );
			}
			
			//-----------------------------------------
			// Revision or edit?
			//-----------------------------------------
			
			if( !$this->memberData['idm_bypass_revision'] )
			{
				$this->request['bypass_revision']	= 0;
			}
			
			//-------------------------------------------
			// We've been authorized, set some form data
			//-------------------------------------------
			
			$file['code']			= 'edit_comp';
			$file['button']			= $this->lang->words['edit_button'];
			$file['header_lang']	= $this->lang->words['sform_editfile_header'];

			//-------------------------------------------
			// And set category
			//-------------------------------------------
			
			$catid = $this->request['file_cat'] ? $this->request['file_cat'] : $file['file_cat'];
			
			//-----------------------------------------
			// Sort out default content
			//-----------------------------------------

			if( $this->request['do'] == 'edit_main' )	// Only do this when form initially loads
			{
				$this->DB->delete( 'downloads_temp_records', "record_post_key='{$file['file_post_key']}' AND record_file_id > 0" );
	
				$this->DB->build( array( 'select' => '*', 'from' => 'downloads_files_records', 'where' => "record_post_key='{$file['file_post_key']}' AND record_backup=0" ) );
				$outer	= $this->DB->execute();
				
				while( $r = $this->DB->fetch($outer) )
				{
					if( $r['record_type'] == 'link' )
					{
						$links['files'][ $r['record_location'] ]	= array( $r['record_location'], $r['record_link_type'] );
					}
					elseif( $r['record_type'] == 'sslink' )
					{
						$links['ss'][ $r['record_location'] ]		= array( $r['record_location'], $r['record_default'] );
					}
					else
					{
						$monthly		= '';
						$newLocation	= $r['record_location'];
						
						if( $r['record_storagetype'] == 'web' OR $r['record_storagetype'] == 'nonweb' )
						{
							$newLocation	= $this->registry->idmFunctions->getFileName( $r['record_realname'] );
							$newExt			= strtolower( str_replace( ".", "", substr( $r['record_location'], strrpos( $r['record_location'], '.' ) ) ) );
							
							$newLocation	= md5( uniqid( microtime() ) ) . '-' . $newLocation . '.' . $newExt;

							if( $r['record_type'] == 'upload' )
							{
								$monthly		= $this->registry->idmFunctions->checkForMonthlyDirectory( str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localfilepath'] ) );
								
								@copy( str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localfilepath'] ) . '/' . $r['record_location'], str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localfilepath'] ) . '/' . $monthly . $newLocation );
							}
							else
							{
								$monthly		= $this->registry->idmFunctions->checkForMonthlyDirectory( str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localsspath'] ) );
								
								@copy( str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localsspath'] ) . '/' . $r['record_location'], str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localsspath'] ) . '/' . $monthly . $newLocation );
							}
						}
						
						$temp	= array(
										'record_post_key'	=> $r['record_post_key'],
										'record_file_id'	=> $r['record_file_id'],
										'record_type'		=> $r['record_type'] == 'upload' ? 'files' : 'ss',
										'record_location'	=> $monthly . $newLocation,
										'record_realname'	=> $r['record_realname'],
										'record_mime'		=> $r['record_mime'],
										'record_size'		=> $r['record_size'],
										'record_added'		=> time(),
										'record_default'	=> intval($r['record_default']),
										);
		
						$this->DB->insert( 'downloads_temp_records', $temp );
					}
					
					if( $r['record_storagetype'] == 'db' )
					{
						$storage	= $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_filestorage', 'where' => 'storage_id=' . $r['record_db_id'] ) );
						
						if( $r['record_type'] == 'upload' )
						{
							file_put_contents( str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localfilepath'] ) . '/' . $r['record_location'], base64_decode( $storage['storage_file'] ) );
						}
						else
						{
							file_put_contents( str_replace( '{root_path}', substr( DOC_IPS_ROOT_PATH, 0, -1 ), $this->settings['idm_localsspath'] ) . '/' . $r['record_location'], base64_decode( $storage['storage_ss'] ) );
						}
					}
				}
			}
		}
		
		//-------------------------------------------
		// This is a new file
		//-------------------------------------------
		
		else
		{
			$file = array( 	'code' 				=> 'add_comp',
							'button' 			=> $this->lang->words['add_button'],
							'header_lang'		=> $this->lang->words['sform_addfile_header'],
							'file_name'			=> $this->request['file_name'],
							'file_desc'			=> $_POST['Post'],
							'file_changelog'	=> $this->request['file_changelog'],
							'file_version'		=> $this->request['file_version'],
							'file_post_key'		=> $this->request['post_key'] ? $this->request['post_key'] : md5( uniqid( microtime(), true ) ),
						);
		}

		$category = $this->registry->getClass('categories')->cat_lookup[ $catid ];
		
		//-----------------------------------------
		// Clean/set linked file types
		//-----------------------------------------
		
		$this->settings['idm_linked_types']	= explode( "\n", str_replace( "\r", '', $this->settings['idm_linked_types'] ) );
		
		//-------------------------------------------
		// And....more perm checking
		//-------------------------------------------
		
		if( count($this->registry->getClass('categories')->member_access['add']) == 0 )
		{
			if( $type == 'new' )
			{
				$this->registry->output->showError( 'no_addfile_permissions', 108110, null, null, 403 );
			}
		}
		else if( !in_array( $catid, $this->registry->getClass('categories')->member_access['add'] ) )
		{
			$_showError	= true;
			
			if( $type == 'edit' )
			{
				if( $this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanedit' ) )
				{
					$_showError	= false;
				}
			}
			
			if( $_showError )
			{
				if( $category['coptions']['opt_noperm_add'] )
				{
					$this->registry->output->showError( $category['coptions']['opt_noperm_add'], 108111, null, null, 403 );
				}
				else
				{
					$this->registry->output->showError( 'no_addthiscat_permissions', 108112, null, null, 403 );
				}
			}
		}
		
		//-----------------------------------------
		// Anymore links?
		//-----------------------------------------
		
		if( is_array($this->request['file_url']) AND count($this->request['file_url']) )
		{
			foreach( $this->request['file_url'] as $k => $url )
			{
				if( $url )
				{
					$links['files'][ $url ]	= array( $url, $this->request['file_url_type'][ $k ] );
				}
			}
		}
		
		if( is_array($this->request['file_ssurl']) AND count($this->request['file_ssurl']) )
		{
			foreach( $this->request['file_ssurl'] as $k => $url )
			{
				if( $url )
				{
					$links['ss'][ $url ]	= array( $url );
				}
			}
		}

		//-----------------------------------------
		// Get Mime-Type mask, and it's types
		//-----------------------------------------
		
		$file['allowed_file']		= "";
		$file['allowed_ss']			= "";
		$types						= $this->registry->getClass('idmFunctions')->getAllowedTypes( $category );
		
		natcasesort($types['files']);
		natcasesort($types['ss']);

		$file['allowed_file']	= implode( ", ", $types['files'] );
		$file['allowed_ss']		= implode( ", ", $types['ss'] );
		
		//-----------------------------------------
		// Set some form defaults
		//-----------------------------------------
		
		$file['file_name']		= $this->request['file_name'] ? $this->request['file_name'] : $file['file_name'];
		$file['Post']			= $_POST['Post'] ? $_POST['Post'] : $file['file_desc'];
		$file['file_version']	= $this->request['file_version'] ? $this->request['file_version'] : $file['file_version'];
		$file['file_changelog']	= $this->request['file_changelog'] ? $this->request['file_changelog'] : $file['file_changelog'];

		$file['can_post_links']	= $this->registry->getClass('idmFunctions')->canSubmitLinks();
		$file['can_post_paths']	= $this->registry->getClass('idmFunctions')->canSubmitPaths();

		//-----------------------------------------
		// Show description in editor, get editor
		//-----------------------------------------
		
		if( IPSText::getTextClass('editor')->method == 'rte' )
		{
			$file['Post'] = IPSText::getTextClass('bbcode')->convertForRTE( $file['Post'] );
		}
		else
		{
			IPSText::getTextClass('bbcode')->parse_html		= $category['coptions']['opt_html'] ? 1 : 0;
			IPSText::getTextClass('bbcode')->parse_nl2br	= 1;
			IPSText::getTextClass('bbcode')->parse_smilies	= 1;
			IPSText::getTextClass('bbcode')->parse_bbcode	= $category['coptions']['opt_bbcode'] ? 1 : 0;
			IPSText::getTextClass('bbcode')->parsing_section		= 'idm_submit';
			
			$file['Post'] = IPSText::getTextClass('bbcode')->preEditParse( $file['Post'] );
		}

		//-----------------------------------------
		// Get custom fields
		//-----------------------------------------

		if( $category['ccfields'] )
		{
			$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/classes/cfields.php', 'customFields', 'downloads' );
    		$fields				= new $classToLoad( $this->registry );
    		
    		if( strpos( $this->request['do'], '_comp' ) !== false )
    		{
    			$fields->file_data	= $this->request;
    		}
    		
    		$fields->file_id	= $file['file_id'];
    		$fields->cat_id		= $category['ccfields'];
    		$fields->cache_data	= $this->cache->getCache('idm_cfields');
    	
    		$fields->init_data( 'edit' );
    		$fields->parseToEdit();
		}

		//-----------------------------------------
		// Force a form action?
		//-----------------------------------------
		
		$is_reset	= false;
		
		if( $this->settings['upload_domain'] )
		{
			$is_reset	= true;
			$original	= $this->settings['base_url'];
			
			$this->settings['base_url'] = $this->settings['upload_domain'] . '/index.php?';
		}
		
		//-----------------------------------------
		// Nexus
		//-----------------------------------------
		
		$paid_file_message	= sprintf( $this->lang->words['file_cost_desc'], $this->settings['idm_nexus_percent'] );
		
		$nexusPackages		= '';
		$file['nexus']		= '';
		
		if ( IPSLib::appIsInstalled('nexus') AND $this->settings['idm_nexus_on'] AND $this->memberData['idm_add_paid'] )
		{
			if( $this->memberData['g_access_cp'] )
			{
				require_once( IPSLib::getAppDir('nexus') . '/sources/nexusLib.php' );
				$nexusPackages = nexusLib::getPackageSelector( NULL, TRUE, array(), explode( ',', $file['file_nexus'] ) );
			}
			
			if( $this->request['file_cost_type'] )
			{
				$file['nexus']			= $this->request['file_cost_type'] == 'package' ? 'package' : ( $this->request['file_cost_type'] == 'cost' ? 'paid' : 'free' );
			}
			else
			{
				$file['nexus']			= $file['file_nexus'] ? 'package' : ( $file['file_cost'] ? 'paid' : 'free' );
			}
			
			$file['file_cost']		= $this->request['file_cost'] ? $this->request['file_cost'] : $file['file_cost'];
			$file['renewals']		= $this->request['renewals'] ? $this->request['renewals'] : ( !is_null($file['file_renewal_term']) ? 2 : 1 );
			$file['renewal_term']	= $this->request['renewal_term'] ? $this->request['renewal_term'] : $file['file_renewal_term'];
			$file['renewal_units']	= $this->request['renewal_units'] ? $this->request['renewal_units'] : $file['file_renewal_units'];
			$file['renewal_price']	= $this->request['renewal_price'] ? $this->request['renewal_price'] : $file['file_renewal_price'];
		}
		
		//-----------------------------------------
		// Output
		//-----------------------------------------
		
		$this->output .= $this->registry->getClass('output')->getTemplate('downloads_submit')->mainSubmitForm( $type, $file, $links, $category, $this->error_message, $fields, $paid_file_message, $nexusPackages );

		//-----------------------------------------
		// Reset forced form action?
		//-----------------------------------------
		
		if( $is_reset )
		{
			$this->settings['base_url'] = $original;
		}
	}
	
	/**
	 * Save an added or edited file
	 *
	 * @param	string		[new|edit]
	 * @return	void		[Outputs to screen]
	 */	
	protected function _mainSave( $type='new' )
	{
		/* Security Check */
		if ( $this->request['secure_key'] != $this->member->form_hash )
		{
			$this->registry->output->showError( 'no_permission', 10799, null, null, 403 );
		}

		//-----------------------------------------
		// Init
		//-----------------------------------------
		
		$_POST['Post'] 	= IPSText::stripslashes( $_POST['Post'] );
		$catid			= intval($this->request['file_cat']);
		$file			= array();

		if( !$catid )
		{
			$this->_startForm( $type );
			return;
		}
		
		//-----------------------------------------
		// Get category and check permissions
		//-----------------------------------------
				
		$category = $this->registry->getClass('categories')->cat_lookup[ $catid ];

		//-----------------------------------------
		// Get our storage library...
		//-----------------------------------------
		
		require_once( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/interface_storage.php' );
		
		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/core.php', 'storageEngine', 'downloads' );
		
		if( $this->registry->getClass('idmFunctions')->canSubmitPaths() AND $this->request['file_path'] )
		{
			$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/import.php', 'importStorageEngine', 'downloads' );
			$storageEngine	= new $classToLoad( $this->registry, $category, 'file' );
		}
		else
		{
			switch( $this->settings['idm_filestorage'] )
			{
				case 'web':
				case 'nonweb':
					$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/local.php', 'localStorageEngine', 'downloads' );
					$storageEngine	= new $classToLoad( $this->registry, $category, 'file' );
				break;
	
				case 'ftp':
					$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/ftp.php', 'ftpStorageEngine', 'downloads' );
					$storageEngine	= new $classToLoad( $this->registry, $category, 'file' );
				break;
				
				case 'db':
					$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/database.php', 'databaseStorageEngine', 'downloads' );
					$storageEngine	= new $classToLoad( $this->registry, $category, 'file' );
				break;
			}
		}

		if( $this->registry->getClass('idmFunctions')->canSubmitLinks() )
		{
			$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/url.php', 'urlStorageEngine', 'downloads' );
			$urlStorageEngine	= new $classToLoad( $this->registry, $category, '' );
		}
		
		//-----------------------------------------
		// Storage engine for screenshots
		//-----------------------------------------
		
		if( $this->registry->getClass('idmFunctions')->canSubmitPaths() AND $this->request['file_sspath'] )
		{
			$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/import.php', 'importStorageEngine', 'downloads' );
			$ssStorageEngine	= new $classToLoad( $this->registry, $category, 'screenshot' );
		}
		else
		{
			switch( $this->settings['idm_filestorage'] )
			{
				case 'web':
				case 'nonweb':
					$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/local.php', 'localStorageEngine', 'downloads' );
					$ssStorageEngine	= new $classToLoad( $this->registry, $category, 'screenshot' );
				break;
	
				case 'ftp':
					$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/ftp.php', 'ftpStorageEngine', 'downloads' );
					$ssStorageEngine	= new $classToLoad( $this->registry, $category, 'screenshot' );
				break;
				
				case 'db':
					$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/database.php', 'databaseStorageEngine', 'downloads' );
					$ssStorageEngine	= new $classToLoad( $this->registry, $category, 'screenshot' );
				break;
			}
		}
		
		//-----------------------------------------
		// Are we editing
		//-----------------------------------------
		
		if( $type == 'edit' )
		{
			//-----------------------------------------
			// Get file info and check permissions
			//-----------------------------------------
		
			$file_id = intval($this->request['id']);
			
			$file = $this->DB->buildAndFetch( array( 'select' => '*',
													 'from'   => 'downloads_files',
													 'where'  => 'file_id=' . $file_id
											 )		);

			if( !$this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanedit', 'idm_allow_edit' ) )
			{
				$this->registry->output->showError( 'not_your_file', 108113, null, null, 403 );
			}

			//-----------------------------------------
			// Get existing file records
			//-----------------------------------------
			
			$existing		= array();
			
			$this->DB->build( array( 'select' => '*', 'from' => 'downloads_files_records', 'where' => 'record_file_id=' . $file['file_id'] . ' AND record_backup=0' ) );
			$this->DB->execute();
			
			while( $r = $this->DB->fetch() )
			{
				$existing[ $r['record_location'] ]	= $r;
			}
			
			$_origFile	= $file;
		}

		if( count($this->registry->getClass('categories')->member_access['add']) == 0 )
		{
			if( $type == 'new' )
			{
				$this->registry->output->showError( 'no_addfile_permissions', 108114, null, null, 403 );
			}
			else
			{
				$catid = $file['file_cat'];
			}
		}
		else if( !in_array( $catid, $this->registry->getClass('categories')->member_access['add'] ) )
		{
			$_showError	= true;
			
			if( $type == 'edit' )
			{
				if( $this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanedit' ) )
				{
					$_showError	= false;
				}
			}
			
			if( $_showError )
			{
				if( $category['coptions']['opt_noperm_add'] )
				{
					$this->registry->output->showError( $category['coptions']['opt_noperm_add'], 108115, null, null, 403 );
				}
				else
				{
					$this->registry->output->showError( 'no_addthiscat_permissions', 108116, null, null, 403 );
				}
			}
		}

		//-----------------------------------------
		// Some Basic Checks First
		//-----------------------------------------
		
		$file['file_name']		= IPSText::stripslashes( $this->request['file_name'] );
		$file['file_name']		= trim( IPSText::getTextClass('bbcode')->stripBadWords( $file['file_name'] ) );
		$file['file_name_furl']	= IPSText::makeSeoTitle( $file['file_name'] );
		$file['post_key']		= IPSText::md5Clean( $this->request['post_key'] );
		$file['file_desc']		= trim( IPSText::stripslashes( $_POST['Post'] ) );
		
		if( !$file['file_name'] )
		{
			$this->error_message = $this->lang->words['addfile_error_filename'];
			$this->_continueForm( $type );
			return;
		}

		if( IPSText::mbstrlen( $file['file_desc'] ) < 1 )
		{
			$this->error_message = $this->lang->words['addfile_error_filedesc'];
			$this->_continueForm( $type );
			return;
		}
				
		//--------------------------------------
		// Nexus
		//--------------------------------------
		
		$file['file_cost']	= 0;
		$file['file_nexus']	= 0;

		if ( IPSLib::appIsInstalled( 'nexus' ) && $this->settings['idm_nexus_on'] && $this->memberData['idm_add_paid'] )
		{
			if ( $this->request['file_cost_type'] == 'cost' )
			{
				$file['file_cost'] = is_numeric( $this->request['file_cost'] ) ? $this->request['file_cost'] : 0;
			}
			elseif ( $this->memberData['g_access_cp'] AND is_array($this->request['file_package']) AND count($this->request['file_package']) )
			{
				$file['file_nexus'] = implode( ',', array_map( 'intval', $this->request['file_package'] ) );
								
				if ( !$file['file_nexus'] )
				{
					$this->error_message = $this->lang->words['addfile_error_nexus'];
					$this->_continueForm( $type );
					return;
				}
			}
		}
				
		if( $type != 'edit' and in_array( $this->request['renewal_units'], array( 'd', 'w', 'm', 'y' ) ) )
		{
			$file['file_renewal_term']	= intval( $this->request['renewal_term'] );
			$file['file_renewal_units']	= $this->request['renewal_units'];
			$file['file_renewal_price'] = floatval( $this->request['renewal_price'] );
		}
				
		//-----------------------------------------
		// Format description
		//-----------------------------------------

		IPSText::getTextClass('bbcode')->parse_html			= $category['coptions']['opt_html'] ? 1 : 0;
		IPSText::getTextClass('bbcode')->parse_nl2br		= 0;
		IPSText::getTextClass('bbcode')->parse_smilies		= 1;
		IPSText::getTextClass('bbcode')->parse_bbcode		= $category['coptions']['opt_bbcode'] ? 1 : 0;
		IPSText::getTextClass('bbcode')->parsing_section	= 'idm_submit';

		$file['file_desc'] = IPSText::getTextClass('bbcode')->preDbParse( IPSText::getTextClass('editor')->processRawPost( 'Post' ) );

		//-----------------------------------------
		// Check for path import first
		//-----------------------------------------
		
		$error_number	= 0;
		$_didUrl		= false;
		$_didSsUrl		= false;
		
		if( !$this->request['file_path'] )
		{
			//-----------------------------------------
			// Store any links
			//-----------------------------------------

			if( is_array($this->request['file_url']) AND count($this->request['file_url']) AND is_object($urlStorageEngine) )
			{
				foreach( $this->request['file_url'] as $_index => $_url )
				{
					if( !$_url )
					{
						continue;
					}
					
					$_type	= $this->request['file_url_type'][ $_index ];
					$_error	= $urlStorageEngine->store( array( 'url' => $_url, 'type' => 'file', 'link_type' => $_type, 'post_key' => $file['post_key'], 'index' => $_index ) );
					
					if( $_error > $error_number )
					{
						$error_number	= $_error;
					}
					else
					{
						$_didUrl		= true;
					}
				}
			}
		}

		if( !$this->request['file_sspath'] )
		{
			//-----------------------------------------
			// Store any links
			//-----------------------------------------
			
			if( is_array($this->request['file_ssurl']) AND count($this->request['file_ssurl']) AND is_object($urlStorageEngine) )
			{
				foreach( $this->request['file_ssurl'] as $_index => $_url )
				{
					if( !$_url )
					{
						continue;
					}

					$_error	= $urlStorageEngine->store( array( 'url' => $_url, 'type' => 'screenshot', 'post_key' => $file['post_key'], 'index' => $_index ) );

					if( $_error > $error_number )
					{
						$error_number	= $_error;
					}
					else
					{
						$_didSsUrl		= true;
					}
				}
			}
		}

		$_error	= $storageEngine->store( $file );

		if( $_error > $error_number )
		{
			if( $_error == 1 AND $_didUrl )
			{
				// If there was no upload but we submitted a link, that's fine
			}
			else
			{
				$error_number = $_error;
			}
		}
		
		//-----------------------------------------
		// If we are editing and error is "1" that's ok
		//-----------------------------------------
								
		if( !$error_number )
		{
			$_error	= $ssStorageEngine->store( $file );
		}

		//-----------------------------------------
		// Error?
		//-----------------------------------------

		if ( $error_number )
		{
			if( is_object($urlStorageEngine) )
			{
				$urlStorageEngine->rollback();
			}
			
			$storageEngine->rollback();
			$ssStorageEngine->rollback();
			
			$this->error_message = $this->lang->words['addfile_upload_error' . $error_number ];
			$this->_continueForm( $type );
			return;
		}

		//-----------------------------------------
		// Screenshots required?
		//-----------------------------------------

		if( $category['coptions']['opt_allowss'] )
		{	
			if( $category['coptions']['opt_reqss'] AND !$ssStorageEngine->checkForScreenshot() AND (!is_object($urlStorageEngine) OR !$urlStorageEngine->checkForScreenshot()) )
			{
				if( is_object($urlStorageEngine) )
				{
					$urlStorageEngine->rollback();
				}
				
				$storageEngine->rollback();
				$ssStorageEngine->rollback();
				
				$this->error_message = $this->lang->words['addfile_upload_error6' ];
				$this->_continueForm( $type );
				return;
			}
		}

		//-----------------------------------------
		// File open?  new?
		//-----------------------------------------
		
		$file_new	= 0;
		
		if( $type == 'new' )
		{
			$open		= in_array( $catid, $this->registry->getClass('categories')->member_access['auto'] ) ? 1 : 0;
			$file_new	= $open ? 0 : 1;
		}
		else
		{
			$open = !$file['file_open'] ? 0 : ( in_array( $catid, $this->registry->getClass('categories')->member_access['auto'] ) ? 1 : $this->settings['idm_allow_autoedit'] );
		}

		//-----------------------------------------
		// Create the save array
		//-----------------------------------------
		
		$save_array = array( 'file_name'		=> $file['file_name'],
							 'file_name_furl'	=> $file['file_name_furl'],
							 'file_desc'		=> $file['file_desc'],
							 'file_cat'			=> $catid,
							 'file_open'		=> $open,
							 'file_ipaddress'	=> $this->member->ip_address,
							 'file_updated'		=> time(),
							 'file_new'			=> $file_new,
							 'file_post_key'	=> $file['post_key'],
							 'file_cost'		=> $file['file_cost'],
							 'file_nexus'		=> $file['file_nexus'],
							 'file_version'		=> IPSText::mbsubstr( $this->request['file_version'], 0, 24 ),
							 'file_changelog'	=> trim( IPSText::br2nl( $this->request['file_changelog'] ) ),
							);
		
		if( $type != 'edit' and in_array( $this->request['renewal_units'], array( 'd', 'w', 'm', 'y' ) ) AND $save_array['file_cost'] > 0 )
		{
			$save_array['file_renewal_term']	= $file['file_renewal_term'];
			$save_array['file_renewal_units']	= $file['file_renewal_units'];
			$save_array['file_renewal_price']	= $file['file_renewal_price'];
		}
		
		//-----------------------------------------
		// File size...
		//-----------------------------------------
		
		if( is_object($urlStorageEngine) )
		{
			$save_array['file_size']	= $urlStorageEngine->getFileSize();
		}

		$save_array['file_size']	+= $storageEngine->getFileSize();

		//-----------------------------------------
		// Check custom fields
		//-----------------------------------------
		
		if( $category['ccfields'] )
		{
			$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/classes/cfields.php', 'customFields', 'downloads' );
    		$fields				= new $classToLoad( $this->registry );
    		$fields->file_id	= 0;
    		$fields->cat_id		= $category['ccfields'];
    		$fields->cache_data	= $this->cache->getCache('idm_cfields');
    	
    		$fields->init_data( 'save' );
    		$fields->parseToSave( $this->request );
    		
			if ( count( $fields->error_fields ) )
			{
				foreach( $fields->error_fields as $_fieldData )
				{
					if( $_fieldData[0] == 'empty' )
					{
						if( is_object($urlStorageEngine) )
						{
							$urlStorageEngine->rollback();
						}
						
						$storageEngine->rollback();
						$ssStorageEngine->rollback();
				
						$this->error_message = $this->lang->words['addfile_error_cfield'];
						$this->_continueForm( $type );
						return;
					}
					else if( $_fieldData[0] == 'too_big' )
					{
						if( is_object($urlStorageEngine) )
						{
							$urlStorageEngine->rollback();
						}
						
						$storageEngine->rollback();
						$ssStorageEngine->rollback();
				
						$this->error_message = $this->lang->words['addfile_error_cfield1'];
						$this->_continueForm( $type );
						return;
					}
					else if( $_fieldData[0] == 'invalid' )
					{
						if( is_object($urlStorageEngine) )
						{
							$urlStorageEngine->rollback();
						}
						
						$storageEngine->rollback();
						$ssStorageEngine->rollback();
				
						$this->error_message = $this->lang->words['addfile_error_cfield2'];
						$this->_continueForm( $type );
						return;
					}
				}
			}
		}

		//-----------------------------------------
		// Remove the old files (if necessary)
		//-----------------------------------------

		if( $type == 'edit' )
		{
			//-----------------------------------------
			// Version control backup file
			//-----------------------------------------
			
			if( $this->settings['idm_versioning'] AND ( !$this->memberData['idm_bypass_revision'] OR !$this->request['bypass_revision'] ) )
			{
				$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/classes/versioning.php', 'versioningLibrary', 'downloads' );
				$versions 		= new $classToLoad( $this->registry );
				$versions->backup( $_origFile );
			}
			//else
			//{
				//-----------------------------------------
				// Remove previous files
				//-----------------------------------------

				if( count($existing) )
				{
					foreach( $existing as $_oldRecord )
					{
						switch( $_oldRecord['record_storagetype'] )
						{
							case 'web':
							case 'nonweb':
								$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/local.php', 'localStorageEngine', 'downloads' );
								$oldStorageEngine	= new $classToLoad( $this->registry, $this->registry->getClass('categories')->cat_lookup[ $file['file_cat'] ] );
							break;
				
							case 'ftp':
								$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/ftp.php', 'ftpStorageEngine', 'downloads' );
								$oldStorageEngine	= new $classToLoad( $this->registry, $this->registry->getClass('categories')->cat_lookup[ $file['file_cat'] ] );
							break;
							
							case 'db':
								$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/storage/database.php', 'databaseStorageEngine', 'downloads' );
								$oldStorageEngine	= new $classToLoad( $this->registry, $this->registry->getClass('categories')->cat_lookup[ $file['file_cat'] ] );
							break;
						}
						if( !$storageEngine->isCurrent( $_oldRecord ) AND !$ssStorageEngine->isCurrent( $_oldRecord ) )
						{
							$oldStorageEngine->remove( $_oldRecord );
						}
					}
				}
			//}
			
			$this->DB->delete( "downloads_files_records", 'record_file_id=' . $file['file_id'] . ' AND record_backup=0' );
		}
		
		//-----------------------------------------
		// Save the file
		//-----------------------------------------

		$cat_stats = array();
		
		if( $type == 'new' )
		{
			$save_array['file_submitted']	= time();
			$save_array['file_submitter']	= $this->memberData['member_id'];
			
			/* Data Hook Location */
			IPSLib::doDataHooks( $save_array, 'downloadAddFile' );
			
			$this->DB->insert( "downloads_files", $save_array );
			
			$file['file_id'] = $this->DB->getInsertId();

			$author_name = $this->memberData['members_display_name'];
		}
		else
		{
			/* Data Hook Location */
			IPSLib::doDataHooks( $save_array, 'downloadEditFile' );
			
			$this->DB->update( "downloads_files", $save_array, "file_id=".$file['file_id'] );
					
			/* Sort out submitter name */
			if( $save_array['file_open'] )
			{
				/* Avoid query? */
				if( $this->memberData['member_id'] == $file['file_submitter'] )
				{
					$author_name = $this->memberData['members_display_name'];
				}
				else
				{
					$name = $this->DB->buildAndFetch( array( 'select' => 'members_display_name', 'from' => 'members', 'where' => 'member_id=' . $file['file_submitter'] ) );
					
					$author_name = $name['members_display_name'];
				}
			}
		}
		
		//-----------------------------------------
		// Finalize storage
		//-----------------------------------------

		$this->DB->delete( "downloads_temp_records", "record_post_key='{$save_array['file_post_key']}'" );
		
		if( is_object($urlStorageEngine) )
		{
			$urlStorageEngine->commit( $file['file_id'] );
		}
		
		$storageEngine->commit( $file['file_id'] );
		$ssStorageEngine->commit( $file['file_id'] );
		
		//-----------------------------------------
		// Save the custom fields
		//-----------------------------------------

		if( $category['ccfields'] )
		{
			if ( count( $fields->out_fields ) )
			{
				$check = $this->DB->buildAndFetch( array( 'select' => 'file_id', 'from' => 'downloads_ccontent', 'where' => 'file_id=' . $file['file_id'] ) );
				
				if ( $check['file_id'] )
				{
					$this->DB->update( 'downloads_ccontent', $fields->out_fields, 'file_id=' . $file['file_id'] );
				}
				else
				{
					$fields->out_fields['file_id'] = $file['file_id'];
					
					$this->DB->insert( 'downloads_ccontent', $fields->out_fields );
				}
			}
		}

		//-----------------------------------------
		// Rebuild category stats
		//-----------------------------------------
		
		$this->registry->getClass('categories')->rebuildFileinfo( $catid );
		
		if( $type == 'edit' AND $catid <> $file['file_cat'] )
		{
			$this->registry->getClass('categories')->rebuildFileinfo( $file['file_cat'] );
		}
		
		$this->registry->getClass('categories')->rebuildStatsCache();

		//---------------------------------------------------------
		// Auto-posting of topics
		//---------------------------------------------------------

		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/classes/topics.php', 'topicsLibrary', 'downloads' );
		$lib_topics		= new $classToLoad( $this->registry );
		
		$file['file_submitter_name'] = $author_name;

		$lib_topics->sortTopic( array_merge( $file, $save_array ), $category, $type );
		
		//---------------------------------------------------------
		// Member subscription notifications
		//---------------------------------------------------------
		
		if( $save_array['file_open'] )		
		{
			if( $type == 'edit' )
			{
				$_url	= $this->registry->output->buildSEOUrl( 'app=downloads&amp;showfile=' . $file['file_id'], 'public', $save_array['file_name_furl'], 'idmshowfile' );
				
				//-----------------------------------------
				// Like class
				//-----------------------------------------
		
				require_once( IPS_ROOT_PATH . 'sources/classes/like/composite.php' );
				$this->_like = classes_like::bootstrap( 'downloads', 'files' );
				$this->_like->sendNotifications( $file['file_id'], array( 'immediate', 'offline' ), array(
																										'notification_key'		=> 'updated_file',
																										'notification_url'		=> $_url,
																										'email_template'		=> 'subsription_notifications',
																										'email_subject'			=> sprintf( $this->lang->words['sub_notice_subject'], $_url, $save_array['file_name'] ),
																										'build_message_array'	=> array(
																																		'NAME'  		=> '-member:members_display_name-',
																																		'AUTHOR'		=> $this->memberData['members_display_name'],
																																		'TITLE' 		=> $save_array['file_name'],
																																		'URL'			=> $_url,
																																		)
																								) 		);

			}
			else
			{
				$_url	= $this->registry->output->buildSEOUrl( 'app=downloads&amp;showfile=' . $file['file_id'], 'public', $save_array['file_name_furl'], 'idmshowfile' );
				
				//-----------------------------------------
				// Like class
				//-----------------------------------------
		
				require_once( IPS_ROOT_PATH . 'sources/classes/like/composite.php' );
				$this->_like = classes_like::bootstrap( 'downloads', 'categories' );
				$this->_like->sendNotifications( $save_array['file_cat'], array( 'immediate', 'offline' ), array(
																										'notification_key'		=> 'new_file',
																										'notification_url'		=> $_url,
																										'email_template'		=> 'subsription_notifications_new',
																										'email_subject'			=> sprintf( $this->lang->words['sub_notice_subject_new'], $_url, $save_array['file_name'] ),
																										'build_message_array'	=> array(
																																		'NAME'  		=> '-member:members_display_name-',
																																		'AUTHOR'		=> $this->memberData['members_display_name'],
																																		'TITLE' 		=> $save_array['file_name'],
																																		'URL'			=> $_url,
																																		)
																								) 		);
			}
		}
		else
		{
			$moderators	= $this->registry->getClass('idmFunctions')->returnModerators();
			
			if( is_array($moderators) AND count($moderators) )
			{
				$_url		= $this->registry->output->buildSEOUrl( 'app=downloads&amp;showfile=' . $file['file_id'], 'public', $save_array['file_name_furl'], 'idmshowfile' );
				$_modPanel	= $this->registry->output->buildSEOUrl( 'app=downloads&amp;module=moderate', 'public' );
				
				$classToLoad		= IPSLib::loadLibrary( IPS_ROOT_PATH . '/sources/classes/member/notifications.php', 'notifications' );
				$notifyLibrary		= new $classToLoad( $this->registry );
				
				foreach( $moderators as $moderator )
				{
					//-----------------------------------------
					// Don't send notification to yourself
					//-----------------------------------------
					
					if( $moderator['member_id'] == $this->memberData['member_id'] )
					{
						continue;
					}
	
					$notifyLibrary->setMember( $moderator );
					$notifyLibrary->setFrom( $this->memberData );
					$notifyLibrary->setNotificationKey( 'file_pending' );
					$notifyLibrary->setNotificationUrl( $_url );
					$notifyLibrary->setNotificationText( sprintf( $this->lang->words['moderate_filepending'], $moderator['members_display_name'], $save_array['file_name'], $_modPanel ) );
					$notifyLibrary->setNotificationTitle( sprintf( $this->lang->words['moderate_filependingsub'], $_url, $save_array['file_name'] ) );
					try
					{
						$notifyLibrary->sendNotification();
					}
					catch( Exception $e ){}
				}
			}
		}

		//-----------------------------------------
		// Still here?  Wippii...success
		//-----------------------------------------
		
		$lang	= $save_array['file_open'] ? $this->lang->words['submission_live'] : $this->lang->words['submission_approve'];
		
		$this->registry->output->redirectScreen( $lang, $this->settings['base_url'] . "app=downloads&showfile={$file['file_id']}", $save_array['file_name_furl'], 'idmshowfile' );
	}
}
