<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Index page for IDM
 * Last Updated: $Date: 2010-12-01 22:48:26 -0500 (Wed, 01 Dec 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		6/24/2008
 * @version		$Revision: 7341 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class public_downloads_display_index extends ipsCommand
{
	/**
	 * Stored temporary output
	 *
	 * @access	protected
	 * @var 	string 				Page output
	 */
	protected $output				= "";

	/**
	 * Member can add to a category
	 *
	 * @access	protected
	 * @var 	boolean
	 */
	protected $canadd				= false;

	/**
	 * Member can moderate a category
	 *
	 * @access	protected
	 * @var 	boolean
	 */
	protected $canmod				= false;

	/**
	 * Main class entry point
	 *
	 * @access	public
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */	
	public function doExecute( ipsRegistry $registry )
	{
		//-------------------------------------------
		// Page title and navigation bar
		//-------------------------------------------
		
		$this->registry->output->addNavigation( $this->lang->words['idm_navbar'], 'app=downloads', 'false', 'app=downloads' );
		$this->registry->output->setTitle( $this->lang->words['idm_pagetitle'] . ' - ' . $this->settings['board_name'] );

		//-------------------------------------------
		// Check permissions
		//-------------------------------------------
		
		if( count($this->registry->getClass('categories')->member_access['show']) == 0 )
		{
			if( count($this->registry->getClass('categories')->cat_lookup) == 0 )
			{
				$this->registry->output->showError( 'no_downloads_cats_created', 10871, null, null, 403 );
			}
			else
			{
				$this->registry->output->showError( 'no_downloads_permissions', 10872, null, null, 403 );
			}
		}
		else
		{
			if( count( $this->registry->getClass('categories')->member_access['add'] ) > 0 )
			{
				$this->canadd = true;
			}
			
			$this->canmod = $this->registry->getClass('idmFunctions')->isModerator();
		}
		
		if( count($this->registry->getClass('categories')->cat_cache[ 0 ]) == 0 )
		{
			$this->registry->output->showError( 'no_downloads_categories', 10873, null, null, 403 );
		}
		
		//-----------------------------------------
		// Show portal or index page?
		//-----------------------------------------
		
		if( $this->settings['idm_use_portal'] && !$this->request['showall'] )
		{
			$this->_showPortal();
		}
		else
		{
			$this->_showIndex();
		}
		
		//-------------------------------------------
		// Grab stats
		//-------------------------------------------
		
		$this->output .= $this->registry->getClass('idmFunctions')->getStats();

		//-------------------------------------------
		// Output
		//-------------------------------------------
		
		IPSCookie::set('modfileids', '', 0);	
		
		$this->registry->output->addContent( $this->output );
		$this->registry->output->sendOutput();
	}
	
	/**
	 * Show portal index
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _showPortal()
	{
		//-----------------------------------------
		// Categories
		//-----------------------------------------
		
		$category_rows	= $this->getCategoryRows();
		$categories		= $this->registry->getClass('categories')->member_access['show'];
		
		//-----------------------------------------
		// Get downloads library and API
		//-----------------------------------------
		
		$classToLoad	= IPSLib::loadLibrary( IPS_ROOT_PATH . 'api/api_core.php', 'apiCore' );
		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/api/api_idm.php', 'apiDownloads', 'downloads' );
		
		$idm_api		= new $classToLoad();
		$idm_api->init();
		
		//-----------------------------------------
		// Get generic feeds....
		//-----------------------------------------
		
		$feeds	= array();
		
		$feeds['whatsnew']	= $idm_api->returnDownloads( 0, 18, true );
		$feeds['highrated']	= $idm_api->returnDownloads( 0, 18, true, "f.file_rating DESC, LENGTH(f.file_votes) DESC" );
		
		if( IPSLib::appIsInstalled( 'nexus' ) && $this->settings['idm_nexus_on'] )		
		{			
			//-----------------------------------------
			// We want to order by number of purchases
			//-----------------------------------------
			
			$categories = $this->registry->getClass('categories')->member_access['show'];
			$paidFiles	= array();
			
			$this->DB->build( array(
									'select'	=> "COUNT(*) as purchases, p.ps_item_id", 
									'from'		=> array( 'nexus_purchases' => 'p' ), 
									'group'		=> 'p.ps_item_id',
									'where'		=> "p.ps_app='downloads' AND p.ps_type='file' AND f.file_open=1 AND f.file_cat IN(" . implode( ',', $categories ) . ")", 
									'order'		=> "purchases DESC",
									'limit'		=> array( 0, 5 ),
									'add_join'	=> array(
														array(
															'from'	=> array( 'downloads_files' => 'f' ),
															'type'	=> 'left',
															'where'	=> 'f.file_id=p.ps_item_id',
															),
														)
							)		);
			$this->DB->execute();
			
			while( $r = $this->DB->fetch() )
			{
				$paidFiles[ $r['ps_item_id'] ]	= $r['ps_item_id'];
			}
			
			// If there's no paid files, don't show Top Free & Top Paid, just show Top Downloads
			if( count( $paidFiles ) )
			{
				$feeds['topfree']	= $idm_api->returnDownloads( 0, 5, true, "f.file_downloads DESC", array( "f.file_cost=0" ) );
				$toppaid	= $idm_api->returnDownloads( 0, 5, true, null, array( "f.file_id IN(" . implode( ',', $paidFiles ) . ')' ) );

				foreach( $paidFiles as $_file )
				{
					foreach( $toppaid as $paidFile )
					{
						if( $paidFile['file_id'] == $_file )
						{
							$feeds['toppaid'][]	= $paidFile;
						}
					}
				}
			}
			else
			{
				$feeds['topfiles']	= $idm_api->returnDownloads( 0, 10, true, "f.file_downloads DESC" );
			}
		}
		else
		{
			$feeds['topfiles']	= $idm_api->returnDownloads( 0, 10, true, "f.file_downloads DESC" );
		}
		
		//-----------------------------------------
		// Now get top authors
		//-----------------------------------------
		
		$_authors	= array();
		$_authorIds	= array();
		
		$this->DB->build( array( 'select' => 'file_submitter, SUM(file_downloads) as totalfiles', 'from' => 'downloads_files', 'where' => 'file_open=1 AND file_cat IN (' . implode( ',', $categories ) . ')', 'order' => 'totalfiles DESC', 'limit' => array( 0, 5 ), 'group' => 'file_submitter' ) );
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			if( !$r['file_submitter'] )
			{
				continue;
			}
			
			$_authors[]		= $r;
			$_authorIds[]	= $r['file_submitter'];
		}
		
		$members	= IPSMember::load( $_authorIds, 'core,extendedProfile,groups' );
		
		foreach( $_authors as $_author )
		{
			$_member				= $members[ $_author['file_submitter'] ];
			$_member['total_files']	= $_author['totalfiles'];
			
			$feeds['topusers'][]	= IPSMember::buildDisplayData( $_member );
		}
		
		//-----------------------------------------
		// And get top liked files
		//-----------------------------------------

		$_files		= array();
		$_fileIds	= array();
		
		$this->DB->build( array(
							'select'	=>	'l.like_rel_id, COUNT(*) as totalliked', 
							'from'		=> array( 'core_like' => 'l' ), 
							'order'		=> 'totalliked DESC',
							'where'		=> "l.like_app='downloads' AND l.like_area='files' AND f.file_id " . $this->DB->buildIsNull(false) . ' AND f.file_open=1 AND f.file_cat IN (' . implode( ',', $categories ) . ')',
							'limit'		=> array( 0, 18 ),
							'group'		=> 'like_rel_id',
							'add_join'	=> array(
												array(
													'select'	=> 'f.file_id',
													'from'		=> array( 'downloads_files' => 'f' ),
													'where'		=> 'f.file_id=l.like_rel_id',
													'type'		=> 'left',
													)
												)
						)		);
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			if( !$r['file_id'] )
			{
				continue;
			}

			$_files[ $r['like_rel_id'] ]	= array( 'total_liked' => $r['totalliked'] );
			$_fileIds[]						= $r['like_rel_id'];
		}
		
		if( count($_fileIds) )
		{
			$this->DB->build( array( 'select'	=> 'f.*',
									 'from'		=> array( 'downloads_files' => 'f' ),
									 'where'	=> 'f.file_id IN(' . implode( ',', $_fileIds ) . ') AND f.file_open=1 AND f.file_cat IN (' . implode( ',', $categories ) . ')',
									 'add_join'	=> array( 
										 				array(
										 						'type'		=> 'left',
									 							'select'	=> 'c.cname as category_name, c.cname_furl',
									 							'from'		=> array( 'downloads_categories' => 'c' ),
									 							'where'		=> "c.cid=f.file_cat",
										 					),
										 				array(
									 							'type'		=> 'left',
									 							'select'	=> 'm.*',
									 							'from'		=> array( 'members' => 'm' ),
									 							'where'		=> "m.member_id=f.file_submitter",
										 					),
										 				array(
									 							'type'		=> 'left',
									 							'select'	=> 'pp.*',
									 							'from'		=> array( 'profile_portal' => 'pp' ),
									 							'where'		=> "m.member_id=pp.pp_member_id",
										 					),
									 					),
							)		);
			$this->DB->execute();
			
			while( $r = $this->DB->fetch() )
			{
				$r['_isRead']				= $this->registry->classItemMarking->isRead( array( 'forumID' => $r['file_cat'], 'itemID' => $r['file_id'], 'itemLastUpdate' => $r['file_updated'] ), 'downloads' );
				$r['members_display_name']	= $r['members_display_name'] ? $r['members_display_name'] : $this->lang->words['global_guestname'];
				//$r							= IPSMember::buildDisplayData( $r );
				$_files[ $r['file_id'] ]	= array_merge( $_files[ $r['file_id'] ], $r );
			}
		}
		
		$feeds['watched']	= $_files;
		
		//-----------------------------------------
		// Get featured file
		//-----------------------------------------

		$feeds['featured']	= $this->DB->buildAndFetch( array(	'select'	=> 'f.*',
																'from'		=> array( 'downloads_files' => 'f' ),
																'where'		=> 'f.file_featured=1 AND f.file_open=1 AND f.file_cat IN (' . implode( ',', $categories ) . ')',
																'add_join'	=> array( 
																	 				array(
																	 						'type'		=> 'left',
																 							'select'	=> 'c.cname as category_name, c.cname_furl',
																 							'from'		=> array( 'downloads_categories' => 'c' ),
																 							'where'		=> "c.cid=f.file_cat",
																	 					),
																	 				array(
																 							'type'		=> 'left',
																 							'select'	=> 'm.*',
																 							'from'		=> array( 'members' => 'm' ),
																 							'where'		=> "m.member_id=f.file_submitter",
																	 					),
																	 				array(
																 							'type'		=> 'left',
																 							'select'	=> 'pp.*',
																 							'from'		=> array( 'profile_portal' => 'pp' ),
																 							'where'		=> "m.member_id=pp.pp_member_id",
																	 					),
																 					),
														)		);

		if( $feeds['featured']['file_id'] )
		{
			$_comments			= $this->DB->buildAndFetch( array( 'select' => 'count(*) as total', 'from' => 'downloads_comments', 'where' => 'comment_open=1 AND comment_fid=' . $feeds['featured']['file_id'] ) );
			
			$feeds['featured']['_comments']	= $_comments['total'];
			
			//-----------------------------------------
			// Purchased?
			//-----------------------------------------
			
			$feeds['featured']['_purchased']		= 'NO_PURCHASE';
			$feeds['featured']['_renewal_terms']	= '';
			
			if ( $this->memberData['idm_bypass_paid'] or $feeds['featured']['file_submitter'] == $this->memberData['member_id'] )
			{
				$feeds['featured']['_purchased']	= 'ACTIVE';
			}
			elseif ( ( $feeds['featured']['file_cost'] or $feeds['featured']['file_nexus'] ) and IPSLib::appIsInstalled('nexus') )
			{
				require_once( IPSLib::getAppDir('nexus') . '/sources/nexusApi.php' );
	
				if ( $feeds['featured']['file_cost'] )
				{
					$feeds['featured']['_purchased']	= ( nexusApi::itemIsPurchased( $this->memberData['member_id'], 'downloads', 'file', $feeds['featured']['file_id'] ) );
				}
				elseif ( $feeds['featured']['file_nexus'] )
				{
					$items	= explode( ',', $feeds['featured']['file_nexus'] );
	
					while ( $purchased === FALSE and !empty( $items ) )
					{
						$id			= array_pop( $items );
						$feeds['featured']['_purchased']	= ( nexusApi::itemIsPurchased( $this->memberData['member_id'], 'nexus', 'package', $id ) );
					}
				}
				
				if ( $feeds['featured']['file_renewal_term'] )
				{
					require_once( IPSLib::getAppDir('nexus') . '/sources/nexusLib.php' );
	
					$feeds['featured']['_renewal_terms'] = $this->lang->words['renew_term_prefix'] . nexusLib::formatRenewalTerms( array(
																												'unit'	=> $feeds['featured']['file_renewal_units'],
																												'term'	=> $feeds['featured']['file_renewal_term'],
																												'price'	=> $feeds['featured']['file_renewal_price']
																										)		);
				}
			}
			
			if( $this->settings['idm_dynamic_urls'] )
			{
				$insert	= array(
								'url_id'		=> md5( uniqid( microtime(), true ) ),
								'url_file'		=> $feeds['featured']['file_id'],
								'url_ip'		=> $this->member->ip_address,
								'url_created'	=> time(),
								'url_expires'	=> $this->settings['idm_dynamic_expire'] ? time() + ( 60 * $this->settings['idm_dynamic_expire'] ) : time() + ( 60 * 60 * 24 * 7 ),
								);
		
				$this->DB->insert( 'downloads_urls', $insert );
				
				$feeds['featured']['_hash']	= $insert['url_id'];
			}
		}
		
		$this->output	.= $this->registry->getClass('output')->getTemplate('downloads')->downloadsPortal( $this->canadd, $this->canmod, $category_rows, $feeds );
	}
	
	/**
	 * Show category index
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _showIndex()
	{
		//-----------------------------------------
		// Categories
		//-----------------------------------------
		
		$category_rows	= $this->getCategoryRows();

		$this->output	.= $this->registry->getClass('output')->getTemplate('downloads')->indexPage( $this->canadd, $this->canmod, $category_rows );
	}

	/**
	 * Get the category rows
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function getCategoryRows()
	{
		//-------------------------------------------
		// Get the cat and loop
		//-------------------------------------------
		
		$category		= $this->registry->getClass('categories')->cat_lookup[0];
		$category_rows	= array();
		
		if( count( $this->registry->getClass('categories')->cat_cache[ 0 ] ) > 0 )
		{
			foreach( $this->registry->getClass('categories')->cat_cache[ 0 ] as $cid => $cinfo )
			{
				if( in_array( $cid, $this->registry->getClass('categories')->member_access['show'] ) )
				{
					$cinfo['can_approve']		= $this->registry->getClass('idmFunctions')->checkPerms( array( 'file_cat' => $cid ) );
					$cinfo['subcategories']		= "";
					
					$rtime						= $this->registry->classItemMarking->fetchTimeLastMarked( array( 'forumID' => $cinfo['cid'] ), 'downloads' );
					
					if( !isset($cinfo['_has_unread']) )
					{
						$cinfo['_has_unread']	= ( $cinfo['cfileinfo']['date'] && $cinfo['cfileinfo']['date'] > $rtime ) ? 1 : 0;
					}

					if( count($this->registry->getClass('categories')->subcat_lookup[$cid]) > 0 )
					{
						$sub_links = array();
						
						foreach( $this->registry->getClass('categories')->subcat_lookup[$cid] as $blank_key => $subcat_id )
						{
							if( in_array( $subcat_id, $this->registry->getClass('categories')->member_access['show'] ) )
							{
								$subcat_data = $this->registry->getClass('categories')->cat_lookup[ $subcat_id ];
							
								if ( is_array( $subcat_data ) )
								{
									$subcattime	= $this->registry->classItemMarking->fetchTimeLastMarked( array( 'forumID' => $subcat_data['cid'] ), 'downloads' );
									
									if( !isset($subcat_data['new']) )
									{
										$subcat_data['new']	= ( $subcat_data['cfileinfo']['date'] && $subcat_data['cfileinfo']['date'] > $subcattime ) ? 1 : 0;
									}

									$sub_links[] = $subcat_data;
								}
							}
						}
						
						$cinfo['subcategories'] = $sub_links;
					}

					$category_rows[] = $cinfo;
				}
			}

			if( !count($category_rows) )
			{
				$this->registry->output->showError( 'no_permitted_categories', 10874, null, null, 403 );
			}
		}
		
		return $category_rows;
	}
}
