<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IP.Download Manager Custom Field Management
 * Last Updated: $Date: 2010-10-14 19:38:17 -0400 (Thu, 14 Oct 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		1st April 2004
 * @version		$Revision: 6983 $
 */

if ( ! defined( 'IN_ACP' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly.";
	exit();
}

class admin_downloads_customize_cfields extends ipsCommand
{
	/**
	 * Shortcut for url
	 *
	 * @access	private
	 * @var		string			URL shortcut
	 */
	private $form_code;
	
	/**
	 * Shortcut for url (javascript)
	 *
	 * @access	private
	 * @var		string			JS URL shortcut
	 */
	private $form_code_js;
	
	/**
	 * Skin object
	 *
	 * @access	private
	 * @var		object			Skin templates
	 */	
	private $html;

	/**
	 * Main class entry point
	 *
	 * @access	public
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */
	public function doExecute( ipsRegistry $registry ) 
	{
		//-----------------------------------------
		// Load HTML
		//-----------------------------------------
		
		$this->html = $this->registry->output->loadTemplate( 'cp_skin_cfields' );
		
		//-----------------------------------------
		// Set up stuff
		//-----------------------------------------
		
		$this->form_code	= $this->html->form_code	= 'module=customize&amp;section=cfields';
		$this->form_code_js	= $this->html->form_code_js	= 'module=customize&section=cfields';

		//-----------------------------------------
		// Load Language
		//-----------------------------------------
		
		ipsRegistry::getClass( 'class_localization')->loadLanguageFile( array( 'admin_downloads' ) );

		//-----------------------------------------
		// What to do?
		//-----------------------------------------
		
		switch( $this->request['do'] )
		{
			case 'add':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_manage' );
				$this->_mainForm('add');
			break;
			case 'doadd':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_manage' );
				$this->_mainSave('add');
			break;
			case 'edit':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_manage' );
				$this->_mainForm('edit');
			break;
			case 'doedit':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_manage' );
				$this->_mainSave('edit');
			break;
			case 'reorder':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_manage' );
				$this->_doReorder();
			break;
			case 'delete':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_delete' );
				$this->_deleteForm();
			break;
			case 'dodelete':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cf_delete' );
				$this->_doDelete();
			break;
			default:
				$this->_mainScreen();
			break;
		}
		
		//-----------------------------------------
		// Pass to CP output hander
		//-----------------------------------------
		
		$this->registry->getClass('output')->html_main .= $this->registry->getClass('output')->global_template->global_frame_wrapper();
		$this->registry->getClass('output')->sendOutput();
	}
	
	/**
	 * Main class entry point
	 *
	 * @access	public
	 * @return	void
	 */
	public function rebuildCache()
	{
		$cache = array();
				
		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_cfields', 'order' => 'cf_position' ) );
		$this->DB->execute();
		
		while ( $r = $this->DB->fetch() )
		{
			$cache[ $r['cf_id'] ] = $r;
		}
		
		$this->cache->setCache( 'idm_cfields', $cache, array( 'array' => 1 ) );	
	}
	
	/**
	 * Deletion form
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _deleteForm()
	{
		if ( !$this->request['id'] )
		{
			$this->registry->output->showError( $this->lang->words['cf_noid'], 1185 );
		}

		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_cfields', 'where' => "cf_id=".intval($this->request['id']) ) );
		$this->DB->execute();
		
		if ( ! $field = $this->DB->fetch() )
		{
			$this->registry->output->showError( $this->lang->words['cf_404'], 1186 );
		}

		$this->registry->output->html .= $this->html->deleteForm( $field );
	}
	
	/**
	 * Delete the custom field
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _doDelete()
	{
		if ($this->request['id'] == "")
		{
			$this->registry->output->showError( $this->lang->words['cf_noid'], 1187 );
		}
		
		//-----------------------------------------
		// Verify field existence
		//-----------------------------------------
		
		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_cfields', 'where' => "cf_id=".intval($this->request['id']) ) );
		$this->DB->execute();
		
		if ( ! $row = $this->DB->fetch() )
		{
			$this->registry->output->showError( $this->lang->words['cf_noid'], 1188 );
		}
		
		$this->DB->dropField( 'downloads_ccontent', "field_{$row['cf_id']}" );
		
		$this->DB->delete( 'downloads_cfields', "cf_id=" . $row['cf_id'] );
		
		$this->rebuildCache();
		
		$this->registry->output->global_message = $this->lang->words['cf_deleted'];
		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code );
	}
	
	/**
	 * Save added/edited custom field
	 *
	 * @access	private
	 * @param	string		[add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _mainSave( $type='edit' )
	{
		$id = intval($this->request['id']);
		
		if ( $this->request['cf_title'] == "" )
		{
			$this->registry->output->showError( $this->lang->words['cf_entertitle'], 1189 );
		}
		
		//-----------------------------------------
		// check-da-motcha
		//-----------------------------------------
		
		if ($type == 'edit')
		{
			if( !$id )
			{
				$this->registry->output->showError( $this->lang->words['cf_noid'], 11810 );
			}
		}
		
		$content	= "";
		
		if ( $_POST['cf_content'] != "")
		{
			/* Custom Fields Class */
			$classToLoad	= IPSLib::loadLibrary( IPS_KERNEL_PATH . 'classCustomFields.php', 'classCustomFields' );
			$cfields_class	= new $classToLoad( array() );
			
			$content = $cfields_class->formatContentForSave( $_POST['cf_content'] );
		}
		
		$db_string = array( 'cf_title'			=> $this->request['cf_title'],
							'cf_desc'			=> $this->request['cf_desc'],
							'cf_content'		=> IPSText::stripslashes($content),
							'cf_type'			=> $this->request['cf_type'],
							'cf_not_null'		=> intval($this->request['cf_not_null']),
							'cf_max_input'		=> intval($this->request['cf_max_input']),
							'cf_input_format'	=> $this->request['cf_input_format'],
							'cf_file_format'	=> $this->request['cf_file_format'],
							'cf_topic'			=> intval($this->request['cf_topic']),
							'cf_search'			=> intval($this->request['cf_search']),
							'cf_format'			=> IPSText::stripslashes($_POST['cf_format']),
						  );

		if ($type == 'edit')
		{
			$this->DB->update( 'downloads_cfields', $db_string, 'cf_id=' . $id );

			$this->registry->output->global_message = $this->lang->words['cf_edited'];
		}
		else
		{
			$max = $this->DB->buildAndFetch( array( 'select'	=> 'MAX(cf_position) as newpos',
															'from'	=> 'downloads_cfields' ) );

			$db_string['cf_position'] = $max['newpos']+1;
			
			$this->DB->insert( 'downloads_cfields', $db_string );
			
			$id = $this->DB->getInsertId();
			
			$this->DB->addField( 'downloads_ccontent', "field_{$id}", 'text' );
			
			$this->DB->optimize( 'downloads_ccontent' );

			$this->registry->output->global_message = $this->lang->words['cf_added'];
		}
		
		$this->rebuildCache();
		
		if( is_array($this->request['cats_apply']) AND count($this->request['cats_apply']) )
		{
			$did_at_least_one = 0;
			
			foreach( $this->registry->getClass( 'categories' )->cat_lookup as $cid => $cdata )
			{
				$cfields = explode( ',', $cdata['ccfields'] );
				
				if( !in_array( $id, $cfields ) )
				{
					if( in_array( $cid, $this->request['cats_apply'] ) )
					{
						array_push( $cfields, $id );
						
						$this->DB->update( 'downloads_categories', array( 'ccfields' => implode( ',', $cfields ) ), 'cid=' . $cid );
						
						$did_at_least_one = 1;
					}
				}
				else
				{
					if( !in_array( $cid, $this->request['cats_apply'] ) )
					{
						$new_cfields = array();
						
						foreach( $cfields as $fid )
						{
							if( $fid != $id )
							{
								$new_cfields[] = $fid;
							}
						}
						
						$this->DB->update( 'downloads_categories', array( 'ccfields' => implode( ',', $new_cfields ) ), 'cid=' . $cid );
						
						$did_at_least_one = 1;
					}
				}
			}
			
			if( $did_at_least_one )
			{
				$this->registry->getClass( 'categories' )->rebuildCatCache();
			}
		}

		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code );
	}
	
	/**
	 * Add/edit custom field
	 *
	 * @access	private
	 * @param	string		[add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _mainForm($type='edit')
	{
		$this->request['id'] =  intval($this->request['id'] );
		
		$form	= array();
		
		if ( $type == 'edit' )
		{
			if ( ! $this->request['id'] )
			{
				$this->registry->output->showError( $this->lang->words['cf_noid'], 11811 );
			}
			
			$form['code']	= 'doedit';
			$form['button']	= $this->lang->words['field_complete_edit'];

			$fields 		= $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_cfields', 'where' => "cf_id=" . $this->request['id'] ) );
		}
		else
		{
			$form['code']	= 'doadd';
			$form['button']	= $this->lang->words['field_add_field'];
			
			$fields			= array();
		}

		//-----------------------------------------
		// Format...
		//-----------------------------------------

		/* Custom Fields Class */		
		$classToLoad	= IPSLib::loadLibrary( IPS_KERNEL_PATH . 'classCustomFields.php', 'classCustomFields' );
		$cfields_class	= new $classToLoad( array() );
		
		$fields['cf_content'] 		= $cfields_class->formatContentForEdit($fields['cf_content'] );
		
		$form['cf_title']			= $this->registry->output->formInput("cf_title", $fields['cf_title'] );
		$form['cf_desc']			= $this->registry->output->formInput("cf_desc", $fields['cf_desc'] );
		$form['cf_type']			= $this->registry->output->formDropdown("cf_type",
																					  array(
																							   0 => array( 'text' , 'Text Input' ),
																							   1 => array( 'drop' , 'Drop Down Box' ),
																							   2 => array( 'area' , 'Text Area' ),
																						   ),
																			$fields['cf_type'] );
		$form['cf_max_input']		= $this->registry->output->formInput("cf_max_input", $fields['cf_max_input'] );
		$form['cf_input_format']	= $this->registry->output->formInput("cf_input_format", $fields['cf_input_format'] );
		$form['cf_content']			= $this->registry->output->formTextarea("cf_content", $fields['cf_content'] );
		$form['cf_not_null']		= $this->registry->output->formYesNo("cf_not_null", $fields['cf_not_null'] );
		$form['cf_topic']			= $this->registry->output->formYesNo("cf_topic", $fields['cf_topic'] );
		$form['cf_format']			= $this->registry->output->formTextarea("cf_format", $fields['cf_format'] );

		//-----------------------------------------
		// Apply to categories
		//-----------------------------------------
		
		$form['categories']			= "<select name='cats_apply[]' size='5' multiple='multiple'>\n";
		$cur						= $this->registry->getClass( 'categories' )->getCatsCfield( $fields['cf_id'] );
		$opts						= $this->registry->getClass( 'categories' )->catJumpList( 1, 'none', $cur );

		if( is_array($opts) AND count($opts) )
		{
			foreach( $opts as $cdata )
			{
				if( is_array($cur) AND in_array( $cdata[0], $cur ) )
				{
					$cdata[2] = " selected='selected'";
				}
				
				$form['categories'] .= "<option value='{$cdata[0]}'{$cdata[2]}>{$cdata[1]}</option>\n";
			}
		}
		
		$form['categories']			.= "</select>";

		$this->registry->output->html .= $this->html->cfieldsForm( $form, $fields );
	}
	
	/**
	 * Reorder custom fields
	 *
	 * @access	private
	 * @param	string		[add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _doReorder()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------

		$classToLoad	= IPSLib::loadLibrary( IPS_KERNEL_PATH . 'classAjax.php', 'classAjax' );
		$ajax			= new $classToLoad();
		
		//-----------------------------------------
		// Checks...
		//-----------------------------------------

		if( $this->registry->adminFunctions->checkSecurityKey( $this->request['md5check'], true ) === false )
		{
			$ajax->returnString( $this->lang->words['postform_badmd5'] );
			exit();
		}
 		
 		//-----------------------------------------
 		// Save new position
 		//-----------------------------------------

 		$position	= 1;
 		
 		if( is_array($this->request['cfields']) AND count($this->request['cfields']) )
 		{
 			foreach( $this->request['cfields'] as $this_id )
 			{
 				$this->DB->update( 'downloads_cfields', array( 'cf_position' => $position ), 'cf_id=' . $this_id );
 				
 				$position++;
 			}
 		}
 		
 		$this->rebuildCache();

 		$ajax->returnString( 'OK' );
 		exit();
	}	

	/**
	 * Show the splash screen
	 *
	 * @access	private
	 * @param	string		[add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _mainScreen()
	{
		$rows		= '';

		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_cfields', 'order' => 'cf_position' ) );
		$this->DB->execute();
		
		if ( $this->DB->getTotalRows() )
		{
			while ( $r = $this->DB->fetch() )
			{
				$cat_ids 			= $this->registry->getClass( 'categories' )->getCatsCfield( $r['cf_id'] );
				$r['categories'] 	= "";
				
				if( ! count( $cat_ids ) )
				{
					$r['categories'] = $this->lang->words['cf_none'];
				}
				else
				{
					foreach( $cat_ids as $k => $v )
					{
						$r['categories'] .= "&middot;{$this->registry->getClass( 'categories' )->cat_lookup[ $v ]['cname']}<br />";
					}
				}

				$rows	.= $this->html->cfieldsRow( $r );
			}
		}
		else
		{
			$rows = $this->html->cfieldsRowEmpty();
		}

		$this->registry->output->html .= $this->html->cfieldsWrapper( $rows );
	}
}

