<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IP.Download Manager Category Management
 * Last Updated: $Date: 2010-11-22 19:34:49 -0500 (Mon, 22 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		1st April 2004
 * @version		$Revision: 7261 $
 */

if ( ! defined( 'IN_ACP' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly.";
	exit();
}

class admin_downloads_categories_categories extends ipsCommand
{
	/**
	 * Shortcut for url
	 *
	 * @access	private
	 * @var		string			URL shortcut
	 */
	private $form_code;
	
	/**
	 * Shortcut for url (javascript)
	 *
	 * @access	private
	 * @var		string			JS URL shortcut
	 */
	private $form_code_js;
	
	/**
	 * Skin object
	 *
	 * @access	private
	 * @var		object			Skin templates
	 */	
	private $html;

	/**
	 * Main class entry point
	 *
	 * @access	public
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */
	public function doExecute( ipsRegistry $registry ) 
	{
		//-----------------------------------------
		// Load HTML
		//-----------------------------------------
		
		$this->html = $this->registry->output->loadTemplate( 'cp_skin_categories' );
		
		//-----------------------------------------
		// Set up stuff
		//-----------------------------------------
		
		$this->form_code	= $this->html->form_code	= 'module=categories&amp;section=categories';
		$this->form_code_js	= $this->html->form_code_js	= 'module=categories&section=categories';
		
		//-----------------------------------------
		// Load Language
		//-----------------------------------------
		
		ipsRegistry::getClass( 'class_localization')->loadLanguageFile( array( 'admin_downloads' ) );

		//-----------------------------------------
		// What to do?
		//-----------------------------------------
		
		switch($this->request['do'])
		{
			case 'main':
			default:
				$this->_mainScreen();
			break;
							
			case 'new':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_manage' );
				$this->_mainForm('new');
			break;
			case 'donew':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_manage' );
				$this->_mainSave('new');
			break;

			case 'edit':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_manage' );
				$this->_mainForm('edit');
			break;
			case 'doedit':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_manage' );
				$this->_mainSave('edit');
			break;

			case 'doreorder':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_manage' );
				$this->_doReorder();
			break;

			case 'modform':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_mods' );
				$this->_showModForm('add');
			break;
			case 'editmod':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_mods' );
				$this->_showModForm('edit');
			break;				
			case 'domod':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_mods' );
				$this->_doModerator('add');
			break;
			case 'doeditmod':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_mods' );
				$this->_doModerator('edit');
			break;
			case 'delmod':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_mods' );
				$this->_deleteModerator();
			break;				

			case 'dodelete':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_delete' );
				$this->_doDelete();
			break;
			case 'resynch':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_manage' );
				$this->_recount();
			break;
			case 'doempty':
				$this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'idm_cat_empty' );
				$this->_doEmpty();
			break;
		}
		
		//-----------------------------------------
		// Pass to CP output hander
		//-----------------------------------------
		
		$this->registry->getClass('output')->html_main .= $this->registry->getClass('output')->global_template->global_frame_wrapper();
		$this->registry->getClass('output')->sendOutput();	
	}
	
	/**
	 * Category overview screen
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _mainScreen()
	{
		//-----------------------------------------
		// Nav
		//-----------------------------------------
		
		if ( $this->request['c'] )
		{
			$nav = $this->registry->getClass('categories')->getNav( $this->request['c'], '&amp;' . $this->form_code . '&amp;c=', true );
			
			if ( is_array($nav) and count($nav) > 1 )
			{
				array_shift($nav);
				
				$this->registry->output->html .= $this->html->navigationBar( $nav );
			}
		}

		//-----------------------------------------
		// Print screen
		//-----------------------------------------

		$total_items	= 0;

		if( count( $this->registry->getClass('categories')->cat_cache[ 0 ] ) )
		{
			if( $this->request['c'] AND $this->registry->getClass('categories')->cat_lookup[ $this->request['c'] ]  )
			{
				$depth_guide	= $this->registry->getClass('categories')->parent_lookup[ $this->request['c'] ];
			}
			else
			{
				$depth_guide	= 0;
			}
			
			foreach( $this->registry->getClass('categories')->cat_cache[ $depth_guide ] as $id => $outer_data )
			{
				$temp_html			= "";
				$total_items++;
				
				if ( is_array( $this->registry->getClass('categories')->cat_cache[ $outer_data['cid'] ] ) )
				{
					$temp_html = $this->html->subCategories( $this->registry->getClass('categories')->cat_cache[ $outer_data['cid'] ] );
				}
				
				if( is_array($this->registry->getClass('categories')->cat_mods[ $outer_data['cid'] ] ) )
				{
					$temp_html .= $this->html->moderators( $this->registry->getClass('categories')->cat_mods[ $outer_data['cid'] ], $outer_data['cid'] );
				}					

				$categories .= $this->html->renderCategory( $temp_html, $outer_data, $total_items );
			}
		}
		
		if( $total_items )
		{
			$choose			= "";
			$options_cats	= "";
			$jump_cats		= $this->registry->getClass('categories')->catJumpList( true );
			
			if( is_array($jump_cats) AND count($jump_cats) > 0 )
			{
				foreach( $jump_cats as $k => $v )
				{
					if( count( $this->registry->getClass('categories')->subcat_lookup[ $v[0] ] ) > 0 )
					{
						$options_cats .= "<option value='{$v[0]}'>{$v[1]}</option>";
					}
				}
				
				if( $options_cats != '' )
				{
					$choose = "<select name='roots' id='roots' class='realbutton'>";
					$choose .= $options_cats;
					$choose .= "</select>";
				}
			}		
		}

		$this->registry->output->html .= $this->html->mainScreen( $total_items, $categories, $choose );
	}
	
	/**
	 * Actually perform the reorder
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _doReorder()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------

		$classToLoad			= IPSLib::loadLibrary( IPS_KERNEL_PATH . 'classAjax.php', 'classAjax' );
		$ajax					= new $classToLoad();
		
		//-----------------------------------------
		// Checks...
		//-----------------------------------------

		if( $this->registry->adminFunctions->checkSecurityKey( $this->request['md5check'], true ) === false )
		{
			$ajax->returnString( $this->lang->words['postform_badmd5'] );
			exit();
		}
 		
 		//-----------------------------------------
 		// Save new position
 		//-----------------------------------------

 		$position	= 1;
 		
 		if( is_array($this->request['cats']) AND count($this->request['cats']) )
 		{
 			foreach( $this->request['cats'] as $this_id )
 			{
 				$this->DB->update( 'downloads_categories', array( 'cposition' => $position ), 'cid=' . $this_id );
 				
 				$position++;
 			}
 		}
 		
 		$this->registry->getClass('categories')->rebuildCatCache();

 		$ajax->returnString( 'OK' );
 		exit();
	}		
	
	/**
	 * Recount the category
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _recount()
	{
		$this->registry->getClass('categories')->rebuildFileinfo( intval($this->request['c']) );
 		
 		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code . '&c=' . $this->request['c'] );
	}
	
	/**
	 * Empty the category
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _doEmpty()
	{
		$catid	= intval($this->request['c']);
		$cnt	= 0;
		
		if( !$catid )
		{
			$this->registry->output->global_message = $this->lang->words['c_nocat_empty'];
			$this->_mainScreen();
			return;
		}
		
		$file_ids = array();
		
		$this->DB->build( array( 'select' => 'file_id', 'from' => 'downloads_files', 'where' => 'file_cat='.$catid )	);
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			$file_ids[ $r['file_id'] ] = $r['file_id'];
		}
		
		if( count($file_ids) > 0 )
		{
			$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/classes/moderate.php', 'idm_moderate', 'downloads' );
			$mod			= new $classToLoad( $this->registry );
			$cnt			= $mod->doMultiDelete( $file_ids );
		}

		$this->registry->getClass('categories')->rebuildFileinfo( $catid );
		$this->registry->getClass('categories')->rebuildStatsCache();
 		
 		$this->registry->output->global_message = sprintf( $this->lang->words['c_emptydel'], $this->registry->getClass('categories')->cat_lookup[$catid]['cname'], $cnt );
 		$this->registry->getClass('adminFunctions')->saveAdminLog( sprintf( $this->lang->words['c_emptydel'], $this->registry->getClass('categories')->cat_lookup[$catid]['cname'], $cnt ) );

 		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code );
	}	
	
	/**
	 * Delete the category
	 *
	 * @access	private
	 * @return	void		[Outputs to screen]
	 */
	private function _doDelete()
	{
		$catid	= intval($this->request['c']);
		$cnt	= 0;
		
		if( !$catid )
		{
			$this->registry->output->global_message = $this->lang->words['c_nocat_del'];
			$this->_mainScreen();
			return;
		}
		
		//-----------------------------------------
		// Subcategories?
		//-----------------------------------------
		
		$children	= $this->registry->getClass('categories')->getChildren( $catid );
		
		$_where		= array_merge( array( $catid ), $children );
		
		$file_ids = array();
		
		$this->DB->build( array( 'select' => 'file_id', 'from' => 'downloads_files', 'where' => 'file_cat IN ('. implode( ',', $_where ) . ')' ) );
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			$file_ids[ $r['file_id'] ] = $r['file_id'];
		}
		
		if( count($file_ids) > 0 )
		{
			$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/classes/moderate.php', 'idm_moderate', 'downloads' );
			$mod			= new $classToLoad( $this->registry );
			$cnt			= $mod->doMultiDelete( $file_ids );
		}

		$this->DB->delete( 'downloads_categories', 'cid IN ('. implode( ',', $_where ) . ')' );
		$this->DB->delete( 'permission_index', "app='downloads' AND perm_type='cat' AND perm_type_id IN (". implode( ',', $_where ) . ')' );
		$this->DB->delete( 'core_like', "like_app='downloads' AND like_area='categories' AND like_rel_id IN (". implode( ',', $_where ) . ')' );
		$this->DB->delete( 'core_like_cache', "like_cache_app='downloads' AND like_cache_area='categories' AND like_cache_rel_id IN (". implode( ',', $_where ) . ')' );
		
		$this->registry->getClass('categories')->rebuildCatCache();
		$this->registry->getClass('categories')->rebuildStatsCache();

 		$this->registry->output->global_message = sprintf( $this->lang->words['c_delrem'], $this->registry->getClass('categories')->cat_lookup[$catid]['cname'], $cnt );
 		$this->registry->getClass('adminFunctions')->saveAdminLog(sprintf( $this->lang->words['c_delrem'], $this->registry->getClass('categories')->cat_lookup[$catid]['cname'], $cnt ));
 		
 		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code );
	}	
	
	/**
	 * Save add/edit category
	 *
	 * @access	private
	 * @param	string		Type [new|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _mainSave($type='new')
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$this->request['cname'] =  trim($this->request['cname'] );
		$this->request['c'] =  intval($this->request['c'] );
		
		//-----------------------------------------
		// Check
		//-----------------------------------------
		
		if ($this->request['cname'] == "")
		{
			$this->registry->output->global_message = $this->lang->words['c_entername'];
			$this->_mainForm( $type );
			return;
		}

		if ( $this->request['cparent'] != $this->registry->getClass('categories')->cat_lookup[ $this->request['c'] ]['cparent'] )
		{
			if( $this->request['cparent'] != 0 AND $this->request['c'] != 0 )
			{
				$ids	= $this->registry->getClass('categories')->getChildren( $this->request['c'] );
				$ids[]	= $this->request['c'];
				
				if ( in_array( $this->request['cparent'], $ids ) )
				{
					$this->registry->output->global_message = $this->lang->words['c_invparent'];
					$this->_mainForm( $type );
					return;
				}
			}
		}
		
		//-----------------------------------------
		// Check topic generation config
		//-----------------------------------------
		
		if( $this->request['opt_topice'] )
		{
			if( !$this->request['opt_topicf'] )
			{
				$this->registry->output->global_message = $this->lang->words['c_selectforum'];
				$this->_mainForm( $type );
				return;
			}
			
			$forum = $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'forums', 'where' => 'id=' . intval($this->request['opt_topicf']) ) );
			
			if( !$forum['id'] )
			{
				$this->registry->output->global_message = $this->lang->words['c_forum404'];
				$this->_mainForm( $type );
				return;
			}

			if( !$forum['sub_can_post'] )
			{
				$this->registry->output->global_message = $this->lang->words['c_noroot'];
				$this->_mainForm( $type );
				return;
			}
			
			if( $forum['redirect_on'] )
			{
				$this->registry->output->global_message = $this->lang->words['c_noredirect'];
				$this->_mainForm( $type );
				return;
			}			
		}
		
		/* This code works, however sometimes people try to configure cats before raising the limit and then have to reconfigure
			every category, so we'll just let them enter what they want

		$max_upload = @ini_get('upload_max_filesize') ? @ini_get('upload_max_filesize') : 0;
		
		if( substr( $max_upload, -1, 1 ) == "M" )
		{
			$max_upload = substr( $max_upload, 0, -1 );
			$max_upload = $max_upload*1024;
		}
		
		if( $this->request['opt_maxfile'] > $max_upload || $this->request['opt_maxss'] > $max_upload )
		{
			$this->registry->output->global_message = "The maximum upload file size you can specify is {$max_upload}.  If you require larger file uploads, please contact your host to have this limit raised in your php.ini configuration file.";
			$this->_mainForm( $type );
			return;
		}*/
		
		//-----------------------------------------
		// Other options
		//-----------------------------------------
		
		$options = array(	'opt_mimemask'			=> $this->request['opt_mimemask'],
							'opt_bbcode'			=> intval($this->request['opt_bbcode']),
							'opt_html'				=> intval($this->request['opt_html']),
							'opt_catss'				=> intval($this->request['opt_catss']),
							'opt_comments'			=> intval($this->request['opt_comments']),
							'opt_allowss'			=> intval($this->request['opt_allowss']),
							'opt_reqss'				=> intval($this->request['opt_reqss']),
							'opt_sortorder'			=> $this->request['opt_sortorder'],
							'opt_sortby'			=> $this->request['opt_sortby'],
							'opt_maxfile'			=> intval($this->request['opt_maxfile']),
							'opt_maxss'				=> intval($this->request['opt_maxss']),
							'opt_thumb_x'			=> intval($this->request['opt_thumb_x']),
							'opt_topice'			=> intval($this->request['opt_topice']),
							'opt_topicf'			=> intval($this->request['opt_topicf']),
							'opt_topicp'			=> $this->request['opt_topicp'],
							'opt_topics'			=> $this->request['opt_topics'],
							'opt_topicd'			=> intval($this->request['opt_topicd']),
							'opt_topicss'			=> intval($this->request['opt_topicss']),
							'opt_disfiles'			=> intval($this->request['opt_disfiles']),
							'opt_noperm_view'		=> nl2br( IPSText::stripslashes($_POST['opt_noperm_view']) ),
							'opt_noperm_add'		=> nl2br( IPSText::stripslashes($_POST['opt_noperm_add']) ),
							'opt_noperm_dl'			=> nl2br( IPSText::stripslashes($_POST['opt_noperm_dl']) ),
						);
						
		$coptions	 = serialize( $options );

		//-----------------------------------------
		// Check custom fields
		//-----------------------------------------
		
		$ccfields	= is_array( $this->request['ccfields'] ) ? implode( ",", $this->request['ccfields'] ) : '';

		//-----------------------------------------
		// Save array
		//-----------------------------------------
  
		$save = array(  'cname' 				=> $this->request['cname'],
						'cname_furl'			=> IPSText::makeSeoTitle( $this->request['cname'] ),
						'cdesc'  				=> nl2br( IPSText::stripslashes($_POST['cdesc']) ),
						'cdisclaimer'			=> nl2br( IPSText::stripslashes($_POST['cdisclaimer']) ),
						'copen'					=> intval($this->request['copen']),
						'cparent'				=> intval($this->request['cparent']),
						'coptions'				=> $coptions,
						'ccfields'				=> $ccfields,
					 );

		//-----------------------------------------
		// ADD
		//-----------------------------------------
		
		if ( $type == 'new' )
		{
			$max = $this->DB->buildAndFetch( array( 'select' => 'MAX(cid) as maxcid', 'from' => 'downloads_categories' ) );

			$max['maxcid']			= intval($max['maxcid']) + 1;
			$save['cposition']		= $max['maxcid'];
			$save['cfileinfo']      = '';
			$save['cperms']         = '';
			
			$this->DB->insert( 'downloads_categories', $save );
			
			$category_id			= $this->DB->getInsertId();
			
			$this->registry->output->global_message = sprintf( $this->lang->words['c_createdlog'], $save['cname'] );
			
			$this->registry->getClass('adminFunctions')->saveAdminLog( sprintf( $this->lang->words['c_createdlog'], $save['cname'] ) );
		}
		else
		{
			$this->DB->update( 'downloads_categories', $save, "cid={$this->request['c']}" );
			
			$this->registry->output->global_message = sprintf( $this->lang->words['c_editedlog'], $save['cname'] );
			
			$this->registry->getClass('adminFunctions')->saveAdminLog( sprintf( $this->lang->words['c_editedlog'], $save['cname'] ) );
		}

		//-----------------------------------------
		// Permissions
		//-----------------------------------------
		
		$classToLoad	= IPSLib::loadLibrary( IPS_ROOT_PATH . 'sources/classes/class_public_permissions.php', 'classPublicPermissions' );
		$permissions	= new $classToLoad( ipsRegistry::instance() );
		$permissions->savePermMatrix( $this->request['perms'], $type == 'new' ? $category_id : $this->request['c'], 'cat' );
		
		$this->registry->getClass('categories')->rebuildCatCache();
		
		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code . '&c=' . ( $type == 'new' ? $category_id : $this->request['c'] ) );
	}
	
	/**
	 * Save add/edit category
	 *
	 * @access	private
	 * @param	string		Type [new|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _mainForm( $type='edit' )
	{
		$nav = $this->registry->getClass('categories')->getNav( $this->request['c'], '&' . $this->form_code . '&c=', true );
		
		if ( is_array($nav) and count($nav) > 1 )
		{
			array_shift($nav);
			
			if( $this->request['c'] )
			{
				$nav[]	= "<a href='" . $this->settings['base_url'] .  '&' . $this->form_code . '&c=' . $this->registry->getClass('categories')->cat_lookup[ $this->request['c'] ]['cid'] . "'>{$this->registry->getClass('categories')->cat_lookup[ $this->request['c'] ]['cname']}</a>";	
			}
			
			$this->registry->output->html .= $this->html->navigationBar( $nav );
		}
		
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$form			= array();
		$cat_id			= intval($this->request['c']);
		$parentid		= intval($this->request['p']) ? intval($this->request['p']) : 0;
		$cname			= IPSText::parseCleanValue(urldecode($_REQUEST['cname']));
		$perm_matrix	= "";
		
		$dd_order		= array( 
							 0 => array( 'submitted'		, $this->lang->words['c_subdate'] ),
							 1 => array( 'updated'			, $this->lang->words['c_lastupdate'] ),
							 2 => array( 'name'    			, $this->lang->words['c_filetitle'] ),
							 3 => array( 'downloads'    	, $this->lang->words['c_downloads'] ),
							 4 => array( 'views'    		, $this->lang->words['c_views'] ),
							 5 => array( 'rating'			, $this->lang->words['c_rating'] ),
							 6 => array( 'comments'			, $this->lang->words['c_comments'] ),
							);
																							
		$dd_by			= array( 
							 0 => array( 'Z-A', $this->lang->words['c_dsc'] ),
							 1 => array( 'A-Z', $this->lang->words['c_asc']  )
							);

		//-----------------------------------------
		// ini_get max upload size?
		//-----------------------------------------
				
		$max_upload			= @ini_get('upload_max_filesize') ? @ini_get('upload_max_filesize') : 0;
		$max_upload_display	= $max_upload != '0' ? $max_upload : $this->lang->words['c_phpini'];
		
		if( substr( $max_upload, -1, 1 ) == "M" )
		{
			$max_upload		= substr( $max_upload, 0, -1 );
			$max_upload		= $max_upload*1024;
		}
		
		//-----------------------------------------
		// EDIT
		//-----------------------------------------
		
		if ( $type == 'edit' )
		{
			//-----------------------------------------
			// Check
			//-----------------------------------------
			
			if ( ! $cat_id )
			{
				$this->registry->output->showError( $this->lang->words['c_nocat'], 1182 );
			}
			
			//-----------------------------------------
			// Get this forum
			//-----------------------------------------
			
			$cat = $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_categories', 'where' => 'cid=' . $cat_id ) );
			
			//-----------------------------------------
			// Check
			//-----------------------------------------
			
			if ( !$cat['cid'] )
			{
				$this->registry->output->showError( sprintf( $this->lang->words['c_nocatid'], $cat_id ), 1183 );
			}
			
			$coptions	= unserialize( $cat['coptions'] );
			$coptions	= ( is_array($coptions) && count($coptions) ) ? $coptions : array();
			$cat 		= array_merge( $cat, $coptions );
			
			$cat['ccfields']	= explode( ",", $cat['ccfields'] );
			
			//-----------------------------------------
			// Set up code buttons
			//-----------------------------------------
			
			$form['form_title']		= sprintf( $this->lang->words['c_edittitle'], $cat['cname'] );
			$form['form_button']	= $this->lang->words['c_editbutton'];
			$form['form_code']		= "doedit";
		}
		
		//-----------------------------------------
		// NEW
		//-----------------------------------------
		
		else
		{
			$cat		= array(
							'cid'			=> 0,
							'sub_can_post' 	=> 1,
							'cname'         => $cname ? $cname : $this->lang->words['c_newcat'],
							'cparent'    	=> $parentid,
							'opt_html'      => 0,
							'opt_bbcode'	=> 1,
							'sort_key'     	=> 'updated',
							'sort_order'   	=> 'Z-A',
							'ccfields'		=> $_POST['ccfields'],
							'copen'			=> 1,
							'opt_disfiles'	=> 1,
						  );

			$form['form_title']			= $this->lang->words['c_addtitle'];
			$form['form_button']		= $this->lang->words['c_addbutton'];
			$form['form_code']			= "donew";
		}
		
		//-----------------------------------------
		// Build forumlist for topic submission
		//-----------------------------------------

		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'forums' ) . '/sources/classes/forums/class_forums.php', 'class_forums', 'forums' );
		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'forums' ) . '/sources/classes/forums/admin_forum_functions.php', 'admin_forum_functions', 'forums' );
		$aff			= new $classToLoad( $this->registry );
		
		$aff->forumsInit();
		$dropdown = $aff->adForumsForumList(1);
		
		//-----------------------------------------
		// Build category list for parent cat
		//-----------------------------------------
		
		$catlist = $this->registry->getClass('categories')->catJumpList();
		
		//-----------------------------------------
		// Build Mime-type masks
		//-----------------------------------------		

		$masks = array();

		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_mimemask' ) );
		$this->DB->execute();

		while( $getmasks = $this->DB->fetch() )
		{
			$masks[] = array( $getmasks['mime_maskid'], $getmasks['mime_masktitle'] );
		}

		//-----------------------------------------
		// Build per-cat Custom Fields
		//-----------------------------------------

		$cfields = array();
		
		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_cfields', 'order' => 'cf_position' ) );
		$this->DB->execute();

		while( $fields = $this->DB->fetch() )
		{
			$cfields[] = array( $fields['cf_id'], $fields['cf_title'] );
		}

		//-----------------------------------------
		// Generate form items
		//-----------------------------------------

		# Main settings
		$form['cname']     		= $this->registry->output->formInput(			"cname"			, $_POST['cname'] ? IPSText::parseCleanValue( $_POST['cname'] ) : $cat['cname'] );
		$form['cdesc']  		= $this->registry->output->formTextarea(		"cdesc" 		, IPSText::br2nl( IPSText::stripslashes( $_POST['cdesc'] ? $_POST['cdesc'] : $cat['cdesc'] ) ) );
		$form['cparent']    	= $this->registry->output->formDropdown(		"cparent"		, $catlist, $_POST['cparent'] ? $_POST['cparent'] : $cat['cparent'] );
		$form['copen']       	= $this->registry->output->formYesNo(			"copen"			, $_POST['copen'] ? $_POST['copen'] : $cat['copen'] );
		$form['opt_disfiles'] 	= $this->registry->output->formYesNo(			"opt_disfiles"	, $_POST['opt_disfiles'] ? $_POST['opt_disfiles'] : $cat['opt_disfiles'] );
		$form['cdisclaimer']	= $this->registry->output->formTextarea(		"cdisclaimer"	, IPSText::br2nl( IPSText::stripslashes( $_POST['cdisclaimer'] ? $_POST['cdisclaimer'] : $cat['cdisclaimer'] ) ) );

		# Per-Cat Options
		$form['opt_mimemask']  	= $this->registry->output->formDropdown(		"opt_mimemask"	, $masks, $_POST['opt_mimemask'] ? $_POST['opt_mimemask'] : $cat['opt_mimemask'] );
		$form['ccfields']  		= $this->registry->output->formMultiDropdown(	"ccfields[]"	, $cfields, $cat['ccfields'], '6' );
		$form['opt_bbcode']  	= $this->registry->output->formYesNo(			"opt_bbcode"	, $_POST['opt_bbcode'] ? $_POST['opt_bbcode'] : $cat['opt_bbcode'] );
		$form['opt_html']   	= $this->registry->output->formYesNo(			"opt_html"		, $_POST['opt_html'] ? $_POST['opt_html'] : $cat['opt_html'] );
		$form['opt_catss'] 		= $this->registry->output->formYesNo(			"opt_catss"		, $_POST['opt_catss'] ? $_POST['opt_catss'] : $cat['opt_catss'] );
		$form['opt_comments']	= $this->registry->output->formYesNo(			"opt_comments"	, $_POST['opt_comments'] ? $_POST['opt_comments'] : $cat['opt_comments'] );
		$form['opt_allowss']	= $this->registry->output->formYesNo(			"opt_allowss"	, $_POST['opt_allowss'] ? $_POST['opt_allowss'] : $cat['opt_allowss'] );
		$form['opt_reqss']		= $this->registry->output->formYesNo(			"opt_reqss"		, $_POST['opt_reqss'] ? $_POST['opt_reqss'] : $cat['opt_reqss'] );
		$form['opt_sortorder']	= $this->registry->output->formDropdown(		"opt_sortorder"	, $dd_order, $_POST['opt_sortorder'] ? $_POST['opt_sortorder'] : $cat['opt_sortorder'] );
		$form['opt_sortby']		= $this->registry->output->formDropdown(		"opt_sortby"	, $dd_by, $_POST['opt_sortby'] ? $_POST['opt_sortby'] : $cat['opt_sortby'] );
		$form['opt_maxfile']	= $this->registry->output->formInput(			"opt_maxfile"	, $_POST['opt_maxfile'] ? intval($_POST['opt_maxfile']) : $cat['opt_maxfile']   );
		$form['opt_maxss']		= $this->registry->output->formInput(			"opt_maxss"		, $_POST['opt_maxss'] ? intval($_POST['opt_maxss']) : $cat['opt_maxss'] );
		$form['opt_thumb_x']	= $this->registry->output->formSimpleInput(	"opt_thumb_x"	, $_POST['opt_thumb_x'] ? intval($_POST['opt_thumb_x']) : $cat['opt_thumb_x'] );

		# Topic auto-generation
		$form['opt_topice'] 	= $this->registry->output->formYesNo(			"opt_topice"	, $_POST['opt_topice'] ? $_POST['opt_topice'] : $cat['opt_topice'] );
		$form['opt_topicf'] 	= $this->registry->output->formDropdown(		"opt_topicf"	, $dropdown, $_POST['opt_topicf'] ? $_POST['opt_topicf'] : $cat['opt_topicf'] );
		$form['opt_topicp'] 	= $this->registry->output->formInput(			"opt_topicp"	, IPSText::parseCleanValue( $_POST['opt_topicp'] ) ? IPSText::parseCleanValue( $_POST['opt_topicp'] ) : $cat['opt_topicp'] );
		$form['opt_topics'] 	= $this->registry->output->formInput(			"opt_topics"	, IPSText::parseCleanValue( $_POST['opt_topics'] ) ? IPSText::parseCleanValue( $_POST['opt_topics'] ) : $cat['opt_topics'] );
		$form['opt_topicd'] 	= $this->registry->output->formYesNo(			"opt_topicd"	, $_POST['opt_topicd'] ? $_POST['opt_topicd'] : $cat['opt_topicd'] );
		$form['opt_topicss'] 	= $this->registry->output->formYesNo(			"opt_topicss"	, $_POST['opt_topicss'] ? $_POST['opt_topicss'] : $cat['opt_topicss'] );

		# Custom permission denied messages		
		$form['opt_noperm_view']	= $this->registry->output->formTextarea(	"opt_noperm_view"	, IPSText::br2nl( IPSText::stripslashes( $_POST['opt_noperm_view'] ? $_POST['opt_noperm_view'] : $cat['opt_noperm_view'] ) ) );
		$form['opt_noperm_add']		= $this->registry->output->formTextarea(	"opt_noperm_add"	, IPSText::br2nl( IPSText::stripslashes( $_POST['opt_noperm_add'] ? $_POST['opt_noperm_add'] : $cat['opt_noperm_add'] ) ) );
		$form['opt_noperm_dl']		= $this->registry->output->formTextarea(	"opt_noperm_dl"		, IPSText::br2nl( IPSText::stripslashes( $_POST['opt_noperm_dl'] ? $_POST['opt_noperm_dl'] : $cat['opt_noperm_dl'] ) ) );

		#Permissions

		$classToLoad	= IPSLib::loadLibrary( IPS_ROOT_PATH . 'sources/classes/class_public_permissions.php', 'classPublicPermissions' );
		$permissions	= new $classToLoad( ipsRegistry::instance() );
		$form['permissions']	= $permissions->adminPermMatrix( 'cat', $this->registry->getClass('categories')->cat_lookup[ $cat['cid'] ] );
		
		//-----------------------------------------
		// Nav and print
		//-----------------------------------------
		
		$this->registry->output->extra_nav[] = array( '', ucwords($type).' Category' );
		
		$this->registry->output->html .= $this->html->categoryForm( $cat, $form, $max_upload_display, $form['form_title'] );
	}
		
	/**
	 * Show the moderator form
	 *
	 * @access	private
	 * @param	string		Type [add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _showModForm( $type='add' )
	{
		//-----------------------------------------
		// Nav
		//-----------------------------------------
		
		if ( $this->request['c'] )
		{
			$nav = $this->registry->getClass('categories')->getNav( $this->request['c'], '&amp;' . $this->form_code . '&amp;c=', 1);
			
			if ( is_array($nav) and count($nav) > 1 )
			{
				array_shift($nav);
				
				$this->registry->output->html .= $this->html->navigationBar( $nav );
			}
		}
		
		//-----------------------------------------
		// Some init
		//-----------------------------------------
		
		$catlist	= $this->registry->getClass('categories')->catJumpList(true);
		$form		= array();
		
		$mod_cats[]	= $this->request['c'];
		
		//-----------------------------------------
		// Add or edit
		//-----------------------------------------
		
		if( $type == 'edit' )
		{
			$row = $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_mods', 'where' => 'modid=' . intval($this->request['modid']) ) );
			
			if( $row['modid'] )
			{
				$thiscats = explode( ",", $row['modcats'] );
				
				if( count($thiscats) )
				{
					foreach( $thiscats as $k => $v )
					{
						$mod_cats[] = $v;
					}
				}
			}
			
			$form['code'] = 'doeditmod';
		}
		else
		{
			$form['code'] = 'domod';
		}

		if( !$catlist )
		{
			$this->registry->output->showError( $this->lang->words['c_addmodcat'], 1184 );
		}
		
		//-----------------------------------------
		// Generate form
		//-----------------------------------------

		$dropdown = array( array( 1, $this->lang->words['c_member'] ), array( 0, $this->lang->words['c_group'] ) );
		
		$groups[] = array( 0, $this->lang->words['c_member'] );
		
		$this->DB->build( array( 'select' => 'g_id, g_title', 'from' => 'groups', 'order' => 'g_title' ) );
		$this->DB->execute();
		
		while( $g = $this->DB->fetch() )
		{
			$groups[] = array( $g['g_id'], $g['g_title'] );
		}
		
		if( $type == 'edit' )
		{
			$formdefault = explode( ":", $row['modgmid'] );
		}

		$form['modtype']		= $this->registry->output->formDropdown( "modtype", $dropdown, $_POST['modtype'] ? $_POST['modtype'] : $row['modtype'] );		
		$form['modgid']			= $this->registry->output->formDropdown( "modgid", $groups, $_POST['modgid'] ? $_POST['modgid'] : ( $row['modtype'] == 0 ? $formdefault[0] : 0 ) );
		$form['modmid']			= $this->registry->output->formInput( "modmid", IPSText::parseCleanValue( $_POST['modmid'] ? $_POST['modmid'] : ( $row['modtype'] == 1 ? $formdefault[1] : '' ) ) );
		$form['modcanedit']		= $this->registry->output->formYesNo( "modcanedit", $_POST['modcanedit'] ? $_POST['modcanedit'] : $row['modcanedit'] );
		$form['modcandel']		= $this->registry->output->formYesNo( "modcandel", $_POST['modcandel'] ? $_POST['modcandel'] : $row['modcandel'] );
		$form['modcanapp']		= $this->registry->output->formYesNo( "modcanapp", $_POST['modcanapp'] ? $_POST['modcanapp'] : $row['modcanapp'] );
		$form['modcanbrok']		= $this->registry->output->formYesNo( "modcanbrok", $_POST['modcanbrok'] ? $_POST['modcanbrok'] : $row['modcanbrok'] );
		$form['modcancomm']		= $this->registry->output->formYesNo( "modcancomments", $_POST['modcancomments'] ? $_POST['modcancomments'] : $row['modcancomments'] );
		$form['modcats']		= $this->registry->output->formMultiDropdown( "modcats[]", $catlist, $_POST['modcats'] ? $_POST['modcats'] : $mod_cats, "8");
		$form['modchangeauth']	= $this->registry->output->formYesNo( "modchangeauthor", $_POST['modchangeauthor'] ? $_POST['modchangeauthor'] : $row['modchangeauthor'] );
		$form['modusefeature']	= $this->registry->output->formYesNo( "modusefeature", $_POST['modusefeature'] ? $_POST['modusefeature'] : $row['modusefeature'] );
		$form['modcanpin']		= $this->registry->output->formYesNo( "modcanpin", $_POST['modcanpin'] ? $_POST['modcanpin'] : $row['modcanpin'] );

		$this->registry->output->html .= $this->html->moderatorForm( $form );
	}
	
	/**
	 * Save the moderator
	 *
	 * @access	private
	 * @param	string		Type [add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _doModerator( $type='add' )
	{
		$moderator = array();
		
		if( $type == 'edit' && !$this->request['modid'] )
		{
			$this->registry->output->global_message = $this->lang->words['c_probmod'];
			$this->_showModForm( $type );
			return;
		}
		
		if( $type == 'edit' && $this->request['modid'] )
		{
			$this->DB->build( array( 'select' => '*', 'from' => 'downloads_mods', 'where' => "modid=".intval($this->request['modid']) ) );
			$this->DB->execute();
			
			if (! $this->DB->getTotalRows() )
			{
				$this->registry->output->global_message = $this->lang->words['c_whatmod'];
				$this->_showModForm( $type );
				return;
			}
			else
			{
				$moderator = $this->DB->fetch();
			}
		}		
					
		if( count($this->request['modcats']) == 0 )
		{
			$this->registry->output->global_message = $this->lang->words['c_nocatsmod'];
			$this->_showModForm( $type );
			return;
		}
		
		if( $this->request['modtype'] == 0 && !$this->request['modgid'] )
		{
			$this->registry->output->global_message = $this->lang->words['c_nogroup'];
			$this->_showModForm( $type );
			return;
		}			
		
		if( $this->request['modtype'] == 1 && !$this->request['modmid'] )
		{
			$this->registry->output->global_message = $this->lang->words['c_nomember'];
			$this->_showModForm( $type );
			return;
		}
		
		if( $this->request['modtype'] == 0 )
		{
			$group = $this->DB->buildAndFetch( array( 'select' => 'g_id, g_title', 'from' => 'groups', 'where' => 'g_id=' . intval($this->request['modgid']) ) ); 
			
			if( !$group['g_id'] )
			{
				$this->registry->output->global_message = $this->lang->words['c_invgroup'];
				$this->_showModForm( $type );
				return;
			}
		}
		else
		{
			$member = IPSMember::load( $this->request['modmid'], 'core', 'displayname' );
			
			if (! $member['member_id'] )
			{
				$this->registry->output->global_message = $this->lang->words['c_invname'];
				$this->_showModForm( $type );
				return;
			}
		}
		
		$cats = implode( ",", $this->request['modcats'] );
		
		$save_array = array( 'modtype'			=> intval($this->request['modtype']),
							 'modgmid'			=> count($member)? $member['member_id'] . ":" . $member['members_display_name'] : $group['g_id'] . ':' . $group['g_title'],
							 'modcanedit'		=> intval($this->request['modcanedit']),
							 'modcandel'		=> intval($this->request['modcandel']),
							 'modcanapp'		=> intval($this->request['modcanapp']),
							 'modcanbrok'		=> intval($this->request['modcanbrok']),
							 'modcancomments'	=> intval($this->request['modcancomments']),
							 'modchangeauthor'	=> intval($this->request['modchangeauthor']),
							 'modusefeature'	=> intval($this->request['modusefeature']),
							 'modcanpin'		=> intval($this->request['modcanpin']),
							 'modcats'			=> $cats,
							);
							
		if( $type == 'add' )
		{
			$this->DB->insert( "downloads_mods", $save_array );
		}
		else
		{
			$this->DB->update( "downloads_mods", $save_array, "modid=" . intval($this->request['modid']) );
		}
		
		$this->registry->getClass('categories')->rebuildModCache();
		
		$this->registry->output->global_message = $this->lang->words['c_modsaved'];
		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code );
	}
	
	/**
	 * Save the moderator
	 *
	 * @access	private
	 * @param	string		Type [add|edit]
	 * @return	void		[Outputs to screen]
	 */
	private function _deleteModerator( )
	{
		if( !$this->request['modid'] )
		{
			$this->registry->output->global_message = $this->lang->words['c_probdel'];
			$this->_showModForm();
			return;
		}
		
		if( $this->request['modid'] )
		{
			$this->DB->build( array( 'select' => '*', 'from' => 'downloads_mods', 'where' => "modid=" . intval($this->request['modid']) ) );
			$this->DB->execute();
			
			if (! $this->DB->getTotalRows() )
			{
				$this->registry->output->global_message = $this->lang->words['c_404moddel'];
				$this->_showModForm();
				return;
			}
			else
			{
				$moderator = $this->DB->fetch();
				
				$cats = explode( ",", $moderator['modcats'] );
				
				if( count($cats) == 1 && $this->request['c'] == $cats[0] )
				{
					$this->DB->delete( "downloads_mods", "modid=" . intval($this->request['modid']) );
				}
				else if( count($cats) > 1 && $this->request['c'] )
				{
					$new_cats = array();
					
					foreach( $cats as $k => $v )
					{
						if( $v != $this->request['c'] )
						{
							$new_cats[] = $v;
						}
					}
					
					if( count($new_cats) > 0 )
					{
						$this->DB->update( "downloads_mods", array( 'modcats' => implode( ",", $new_cats ) ), "modid=" . intval($this->request['modid']) );
					}
				}
				else
				{
					$this->DB->delete( "downloads_mods", "modid=" . intval($this->request['modid']) );
				}
			}
		}		
					
		$this->registry->getClass('categories')->rebuildModCache();
		
		$this->registry->output->global_message = $this->lang->words['mod_success_delete'];
		$this->registry->output->silentRedirectWithMessage( $this->settings['base_url'] . '&' . $this->form_code . '&c=' . $this->request['c'] );
	}
		

}
