<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Sphinx template file
 * Last Updated: $Date: 2010-11-12 20:00:34 -0500 (Fri, 12 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 7180 $
 * @since		3.0.0
 *
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

$appSphinxTemplate	= <<<EOF

############################ --- DOWNLOADS --- ##############################

source downloads_search_main : ipb_source_config
{
	# Set our forum PID counter
	sql_query_pre	= REPLACE INTO <!--SPHINX_DB_PREFIX-->cache_store VALUES( 'sphinx_downloads_counter', (SELECT max(file_id) FROM <!--SPHINX_DB_PREFIX-->downloads_files), '', 0, UNIX_TIMESTAMP() )
	
	# Query posts for the main source
	sql_query		= SELECT *, file_id as search_id, file_name as fordinal \
					  FROM <!--SPHINX_DB_PREFIX-->downloads_files \
					  WHERE file_id <= ( SELECT cs_value FROM <!--SPHINX_DB_PREFIX-->cache_store WHERE cs_key='sphinx_downloads_counter' )
	
	# Fields	
	sql_attr_uint			= search_id
	sql_attr_uint			= file_cat
	sql_attr_uint			= file_open
	sql_attr_uint			= file_views
	sql_attr_uint			= file_rating
	sql_attr_uint			= file_downloads
	sql_attr_timestamp		= file_updated
	sql_attr_timestamp		= file_submitted
	sql_attr_uint			= file_submitter
	sql_attr_str2ordinal	= fordinal
	sql_attr_float			= file_cost
	
	sql_ranged_throttle	= 0
}

source downloads_search_delta : downloads_search_main
{
	# Override the base sql_query_pre
	sql_query_pre	= 
	
	# Query posts for the main source
	sql_query		= SELECT *, file_id as search_id, file_name as fordinal \
					  FROM <!--SPHINX_DB_PREFIX-->downloads_files \
					  WHERE file_id > ( SELECT cs_value FROM <!--SPHINX_DB_PREFIX-->cache_store WHERE cs_key='sphinx_downloads_counter' )
}

index downloads_search_main
{
	source			= downloads_search_main
	path			= <!--SPHINX_BASE_PATH-->/downloads_search_main
	
	docinfo			= extern
	mlock			= 0
	morphology		= none
	min_word_len	= 2
	charset_type	= sbcs
	html_strip		= 0	
}

index downloads_search_delta : downloads_search_main
{
   source			= downloads_search_delta
   path				= <!--SPHINX_BASE_PATH-->/downloads_search_delta
}


EOF;
