<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Formats downloads search results
 * Last Updated: $Date: 2010-02-19 01:29:54 +0000 (Fri, 19 Feb 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Board
 * @subpackage	Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 5855 $
 **/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class search_format_downloads extends search_format
{
	/**
	 * Constructor
	 */
	public function __construct( ipsRegistry $registry )
	{
		parent::__construct( $registry );
		
		/* Set up wrapper */
		$this->templates = array( 'group' => 'downloads_external', 'template' => 'searchResultsWrapper' );
		
		/* Get langs */
		$this->lang->loadLanguageFile( array( 'public_downloads' ), 'downloads' );
		
		/* Get category class */
		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . "/sources/classes/categories.php", 'class_categories', 'downloads' );
		
		$this->registry->setClass( 'categories', new $classToLoad( $this->registry ) );
		$this->registry->getClass('categories')->normalInit();
		$this->registry->getClass('categories')->setMemberPermissions();
	}
	
	/**
	 * Parse search results
	 *
	 * @access	private
	 * @param	array 	$r				Search result
	 * @return	array 	$html			Blocks of HTML
	 */
	public function parseAndFetchHtmlBlocks( $rows )
	{
		return parent::parseAndFetchHtmlBlocks( $rows );
	}
	
	/**
	 * Formats the forum search result for display
	 *
	 * @access	public
	 * @param	array   $search_row		Array of data
	 * @return	mixed	Formatted content, ready for display, or array containing a $sub section flag, and content
	 **/
	public function formatContent( $data )
	{
		return array( ipsRegistry::getClass( 'output' )->getTemplate( 'downloads_external' )->fileSearchResult( $data, IPSSearchRegistry::get('display.onlyTitles'), 0 ) );
	}

	/**
	 * Formats / grabs extra data for results
	 * Takes an array of IDS (can be IDs from anything) and returns an array of expanded data.
	 *
	 * @access public
	 * @return array
	 */
	public function processResults( $ids )
	{
		$rows	= array();
		$_files	= array();

		/* Load the data if needed */
		if( is_int($ids[0]) )
		{
			$_fids	= implode( ',', $ids );
			
			$this->DB->build( array( 
										'select'   => "f.*",
										'from'	   => array( 'downloads_files' => 'f' ),
										'where'	   => "f.file_id IN(" . $_fids . ")",
										'add_join' => array(
																array(
																		'select' => 'i.*',
																		'from'   => array( 'permission_index' => 'i' ),
																		'where'  => "i.app='downloads' AND i.perm_type='cat' AND i.perm_type_id=f.file_cat",
																		'type'   => 'left',
																	),
																array(
																		'select' => 'mem.member_id, mem.members_seo_name, mem.members_display_name, mem.member_group_id, mem.mgroup_others',
																		'from'   => array( 'members' => 'mem' ),
																		'where'  => "mem.member_id=f.file_submitter",
																		'type'   => 'left',
																	),
																array(
																		'from'   => array( 'profile_friends' => 'friend' ),
																		'where'  => 'friend.friends_member_id=f.file_submitter AND friend.friends_friend_id=' . $this->memberData['member_id'],
																		'type'   => 'left',
																	)
																)													
															)	
							);
			$this->DB->execute();
			
			/* Sort */
			while( $r = $this->DB->fetch() )
			{
				$_files[ $r['file_id'] ] = $r;
			}
		}

		foreach( $ids as $i => $d )
		{
			if( is_int($d) )
			{
				if( !$_files[ $d ]['file_id'] )
				{
					continue;
				}
				
				$rows[ $i ] = $this->genericizeResults( $_files[ $d ] );
			}
			else
			{
				if( !$d['file_id'] )
				{
					continue;
				}
				
				$rows[ $i ] = $this->genericizeResults( $d );
			}
		}
		
		return $rows;	
	}
	
	/**
	 * Reassigns fields in a generic way for results output
	 *
	 * @param  array  $r
	 * @return array
	 **/
	public function genericizeResults( $r )
	{
		$r['app']				= 'downloads';
		$r['content']			= $r['file_desc'];
		$r['content_title']		= $r['file_name'];
		$r['updated']			= $r['file_submitted'];
		$r['type_2']			= 'file';
		$r['type_id_2']			= $r['file_id'];
		$r['_isRead']			= $this->registry->classItemMarking->isRead( array( 'forumID' => $r['file_cat'], 'itemID' => $r['file_id'], 'itemLastUpdate' => $r['file_updated'] ), 'downloads' );
		$r['_breadcrumb']		= $this->registry->getClass('categories')->getNav( $r['file_cat'] );

		return $r;
	}

}