<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Group property updater (Downloads)
 * Last Updated: $Date: 2010-11-12 10:58:36 -0500 (Fri, 12 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		1st march 2002
 * @version		$Revision: 7170 $
 *
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class admin_group_form__downloads implements admin_group_form
{	
	/**
	 * Tab name
	 * This can be left blank and the application title will
	 * be used
	 *
	 * @access	public
	 * @var		string
	 */
	public $tab_name	= "";

	/**
	 * Returns content for the page.
	 *
	 * @access	public
	 * @author	Brandon Farber
	 * @param	array 				Group data
	 * @param	integer				Number of tabs used so far
	 * @return	array 				Array of tabs, content
	 */
	public function getDisplayContent( $group=array(), $tabsUsed = 2 )
	{
		//-----------------------------------------
		// Load skin
		//-----------------------------------------
		
		$this->html = ipsRegistry::getClass('output')->loadTemplate('cp_skin_idm_group_form', 'downloads');
		
		//-----------------------------------------
		// Load lang
		//-----------------------------------------
				
		ipsRegistry::getClass('class_localization')->loadLanguageFile( array( 'admin_downloads' ), 'downloads' );

		//-----------------------------------------
		// Show...
		//-----------------------------------------

		return array( 'tabs' => $this->html->acp_group_form_tabs( $group, ( $tabsUsed + 1 ) ), 'content' => $this->html->acp_group_form_main( $group, ( $tabsUsed + 1 ) ), 'tabsUsed' => 1 );
	}
	
	/**
	 * Process the entries for saving and return
	 *
	 * @access	public
	 * @author	Brandon Farber
	 * @return	array 				Array of keys => values for saving
	 */
	public function getForSave()
	{
		$return = array(
						'idm_restrictions'	=> serialize( 
							array(
								'enabled'		=> intval( ipsRegistry::$request['enabled'] ),
								'limit_sim'		=> intval( ipsRegistry::$request['limit_sim'] ),
								'min_posts'		=> intval( ipsRegistry::$request['min_posts'] ),
								'posts_per_dl'	=> intval( ipsRegistry::$request['posts_per_dl'] ),
								'daily_bw'		=> intval( ipsRegistry::$request['daily_bw'] ),
								'weekly_bw'		=> intval( ipsRegistry::$request['weekly_bw'] ),
								'monthly_bw'	=> intval( ipsRegistry::$request['monthly_bw'] ),
								'daily_dl'		=> intval( ipsRegistry::$request['daily_dl'] ),
								'weekly_dl'		=> intval( ipsRegistry::$request['weekly_dl'] ),
								'monthly_dl'	=> intval( ipsRegistry::$request['monthly_dl'] ),
							)	
						 ),
						 'idm_add_paid'			=> intval( ipsRegistry::$request['idm_add_paid'] ),
						 'idm_bypass_paid'		=> intval( ipsRegistry::$request['idm_bypass_paid'] ),
						 'idm_report_files'		=> intval( ipsRegistry::$request['idm_report_files'] ),
						 'idm_view_downloads'	=> intval( ipsRegistry::$request['idm_view_downloads'] ),
						 'idm_bypass_revision'	=> intval( ipsRegistry::$request['idm_bypass_revision'] ),
						);

		return $return;
	}
}