<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IDM FTP file storage handling
 * Last Updated: $Date: 2010-12-01 22:48:26 -0500 (Wed, 01 Dec 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		6/24/2008
 * @version		$Revision: 7341 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class ftpStorageEngine extends storageEngine implements interface_storage
{
	/**
	 * FTP connection id
	 *
	 * @access	protected
	 * @var 		resource
	 */
	protected $connection				= null;
		
	/**
	 * Constructor
	 *
	 * @access	public
	 * @param	object		Registry object
	 * @param	array 		Category information
	 * @param	string		Type of engine
	 * @return	void
	 */
	public function __construct( ipsRegistry $registry, $category=array(), $type='file' )
	{
		parent::__construct( $registry, $category, $type );
		
		if( $this->settings['idm_remoteurl'] AND
			$this->settings['idm_remoteport'] AND
			$this->settings['idm_remoteuser'] AND
			$this->settings['idm_remotepass'] AND
			$this->settings['idm_remotefilepath'] )
		{
			$this->connection = @ftp_connect( $this->settings['idm_remoteurl'], $this->settings['idm_remoteport'], 999999 );
			
			if( !$this->connection )
			{
				$this->registry->output->showError( 'addfile_ftp_error1', 10827, true );
			}
			
			if( !@ftp_login( $this->connection, $this->settings['idm_remoteuser'], $this->settings['idm_remotepass'] ) )
			{
				$this->registry->output->showError( 'addfile_ftp_error2', 10828, true );
			}
		}
		else
		{
			$this->registry->output->showError( 'addfile_ftp_error1', 10829 );
		}
	}
	
	/**
	 * Remove a file
	 *
	 * @access	public
	 * @param	array		Record data
	 * @return	boolean		File removed successfully
	 */	
	public function remove( $record )
	{
		$path	= $record['record_type'] == 'upload' ? $this->settings['idm_remotepath'] : $this->settings['idm_remotesspath'];

		@ftp_delete( $this->connection, $path . '/' . $record['record_location'] );
		
		if( $record['record_type'] == 'ssupload' )
		{
			@ftp_delete( $this->connection, $path . '/thumb-' . $record['record_location'] );
		}
		
		return true;
	}
	
	/**
	 * Stores the uploaded files
	 *
	 * @access	public
	 * @param	array 		File information
	 * @return	bool		Record stored ok
	 */	
	public function store( $data=array() )
	{
		@ftp_pasv( $this->connection, TRUE );
		
		//-----------------------------------------
		// Get all the temp records
		//-----------------------------------------
		
		$_where	= $this->type == 'file' ? 'files' : 'ss';
		
		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_temp_records', 'where' => "record_type='{$_where}' AND record_post_key='{$data['post_key']}'" ) );
		$outer	= $this->DB->execute();
		
		while( $r = $this->DB->fetch($outer) )
		{
			//-----------------------------------------
			// Fix extension
			//-----------------------------------------
			
			$extension	= '';
			
			foreach( $this->mimecache as $ext => $data )
			{
				if( $data['mime_id'] == $r['record_mime'] )
				{
					$extension	= $ext;
				}
			}
			
			$newLocation	= preg_replace( "#^(.+?)\.ipb$#", "\\1.{$extension}", $r['record_location'] );
			
			//-----------------------------------------
			// Transfer
			//-----------------------------------------
			
			if( $r['record_type'] == 'ss' )
			{
				@ftp_put( $this->connection, $this->settings['idm_remotesspath'] . "/" . $newLocation, $this->image_path . "/" . $r['record_location'], FTP_BINARY );
			}
			else
			{
				@ftp_put( $this->connection, $this->settings['idm_remotefilepath'] . "/" . $newLocation, $this->file_path . "/" . $r['record_location'], FTP_BINARY );
			}

			//-----------------------------------------
			// Set the new details
			//-----------------------------------------
	
			$this->details[]	= array(
										'record_post_key'		=> $r['record_post_key'],
										'record_file_id'		=> $data['file_id'],
										'record_type'			=> $r['record_type'] == 'ss' ? 'ssupload' : 'upload',
										'record_location'		=> $newLocation,
										'record_db_id'			=> 0,
										'record_thumb'			=> '',
										'record_storagetype'	=> $this->settings['idm_filestorage'],
										'record_realname'		=> $r['record_realname'],
										'record_link_type'		=> '',
										'record_mime'			=> $r['record_mime'],
										'record_size'			=> $r['record_size'],
										'record_backup'			=> 0,
										'record_default'		=> ( $r['record_type'] == 'ss' AND $r['record_id'] == $this->primaryScreenshot ) ? 1 : 0,
										);
		}

		return 0;
	}

	/**
	 * Undo stored files
	 *
	 * @access	public
	 * @return	bool		Rollback complete
	 */	
	public function rollback()
	{
		if( count($this->details) )
		{
			foreach( $this->details as $_details )
			{
				$this->remove( $_details );
			}
		}
		
		unset($this->details);
	}
	
	/**
	 * Finalize the storage
	 *
	 * @access	public
	 * @param	integer		File id
	 * @return	boolean
	 */	
	public function commit( $file_id=0 )
	{
		parent::commit( $file_id );
	}
	
	/**
	 * Destructor
	 *
	 * @access	public
	 * @return	void
	 */
	public function __destruct()
	{
		@ftp_close( $this->connection );
		
		$this->_clearUploadsDirectory();
	}
}