<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Overview skin file
 * Last Updated: $Date: 2010-05-19 21:06:53 -0400 (Wed, 19 May 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 6326 $ 
 */
 
class cp_skin_overview extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}

/**
 * Overview screen
 *
 * @access	public
 * @param	array 	Data to show
 * @param	array 	Latest files
 * @param	array 	Pending files
 * @param	array 	Broken files
 * @return	string	HTML
 */
public function overviewSplash( $data, $latest=array(), $pending=array(), $broken=array() ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<HTML
<script type='text/javascript' src='{$this->settings['js_app_url']}acp.downloads.js'></script>
<table width='100%'>
	<tr>
		<td valign='top' width='50%' style='padding-right:2px;'>
			<div class="acp-box">
				<h3>{$this->lang->words['d_overview']}</h3>
				<table class='double_pad alternate_rows' cellspacing='0'>
					<tr>
						<td><strong>{$this->lang->words['d_totaldisk']}</strong></td>
						<td>{$data['overview']['total_size']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_totalfiles']}</strong></td>
						<td>{$data['overview']['total_files']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_totaldls']}</strong></td>
						<td>{$data['overview']['total_downloads']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_totalviews']}</strong></td>
						<td>{$data['overview']['total_views']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_totalbw']}</strong></td>
						<td>{$data['overview']['total_bw']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_currentbw']}</strong></td>
						<td>{$data['overview']['this_bw']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_largest']} ({$data['overview']['largest_file_size']})</strong></td>
						<td>{$data['overview']['largest_file_name']}</td>
					</tr>
					<tr>
						<td><strong>{$this->lang->words['d_mostviewed']} ({$data['overview']['views_file_views']})</strong></td>
						<td>{$data['overview']['views_file_name']}</td>
					</tr>																														
					<tr>
						<td><strong>{$this->lang->words['d_mostdl']} ({$data['overview']['dls_file_downloads']})</strong></td>
						<td>{$data['overview']['dls_file_name']}</td>
					</tr>
				</table>
			</div>
		</td>
		<td valign='top' width='50%' style='padding-left:2px;'>
			<div class="acp-box">
				<h3>{$this->lang->words['d_information']}</h3>
				<table class='double_pad alternate_rows' cellspacing='0'>
					<tr>
						<td>{$this->lang->words['d_sysonline']}</td>
						<td><img src='{$this->settings['skin_acp_url']}/images/{$data['info']['online_image']}' alt='X' /></td>
					</tr>
					<tr>
						<td>{$this->lang->words['d_version']}</td>
						<td>{$data['info']['version']}</td>
					</tr>
				</table>
			</div>
			<br />
			<center><img src='{$data['info']['version_check']}' alt='{$this->lang->words['d_versioncheck']}' width='210' height='40' /></center>
			<br />
			<div class="acp-box">
				<h3>{$this->lang->words['d_runreports']}</h3>
				<form action='{$this->settings['base_url']}&amp;module=index&amp;section=stats&amp;do=report' method='post' id='runReport'>
					<table class='double_pad alternate_rows' cellspacing='0'>
						<tr>
							<td>{$this->lang->words['d_filereport']}</td>
							<td>{$data['reports']['file']}</td>
						</tr>
						<tr>
							<td>{$this->lang->words['d_memreport']}</td>
							<td><input type='text' id='member' name='member' value='{$this->request['member']}' autocomplete='off' style='width:170px;' class='textinput' /></td>
						</tr>
					</table>
					<div class='acp-actionbar'>
						<div class='centeraction'>
							<input type='submit' value=' {$this->lang->words['d_runbutton']} ' class='button primary' />
						</div>
					</div>
				</form>
			</div>
		</td>
	</tr>
</table>

<br />
<div class="acp-box">
	<h3>{$this->lang->words['d_last5']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th width='30%'>{$this->lang->words['d_fname']}</th>
			<th width='30%'>{$this->lang->words['d_fauthor']}</th>
			<th width='30%'>{$this->lang->words['d_submitted']}</th>
			<th width='10%'>{$this->lang->words['d_approved']}</th>
		</tr>
HTML;

foreach( $latest as $row )
{
	$IPBHTML .= <<<HTML
		<tr>
			<td><a href='{$this->settings['board_url']}/index.php?app=downloads&amp;showfile={$row['file_id']}'>{$row['file_name']}</a></td>
			<td>{$row['user_link']}</td>
			<td>{$row['date']}</td>
			<td><img src='{$this->settings['skin_acp_url']}/images/{$row['image']}' alt='X' /></td>
		</tr>
HTML;
}
$IPBHTML .= <<<HTML
	</table>
</div>

<br />
<div class="acp-box">
	<h3>{$this->lang->words['d_pendapprove']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th width='30%'>{$this->lang->words['d_fname']}</th>
			<th width='30%'>{$this->lang->words['d_fauthor']}</th>
			<th width='30%'>{$this->lang->words['d_submitted']}</th>
			<th width='10%'>{$this->lang->words['d_approvequest']}</th>
		</tr>
HTML;

foreach( $pending as $row )
{
	$IPBHTML .= <<<HTML
		<tr>
			<td><a href='{$this->settings['board_url']}/index.php?app=downloads&amp;showfile={$row['file_id']}'>{$row['file_name']}</a></td>
			<td>{$row['user_link']}</td>
			<td>{$row['date']}</td>
			<td><a href='{$this->settings['board_url']}/index.php?app=downloads&amp;module=moderate&amp;section=moderate&amp;do=togglefile&amp;id={$row['file_id']}'><img src='{$this->settings['skin_acp_url']}/images/aff_tick.png' alt='X' /></a></td>
		</tr>
HTML;
}
$IPBHTML .= <<<HTML
	</table>
</div>

<br />
<div class="acp-box">
	<h3>{$this->lang->words['d_reportbroke']}</h3>
	<table class='alternate_rows' width='100%'>
		<tr>
			<th width='30%'>{$this->lang->words['d_fname']}</th>
			<th width='30%'>{$this->lang->words['d_fauthor']}</th>
			<th width='30%'>{$this->lang->words['d_submitted']}</th>
			<th width='10%'>{$this->lang->words['d_removequest']}</th>
		</tr>
HTML;

foreach( $broken as $row )
{
	$IPBHTML .= <<<HTML
		<tr>
			<td><a href='{$this->settings['board_url']}/index.php?app=downloads&amp;showfile={$row['file_id']}'>{$row['file_name']}</a></td>
			<td>{$row['user_link']}</td>
			<td>{$row['date']}</td>
			<td><a href='{$this->settings['board_url']}/index.php?app=downloads&amp;module=moderate&amp;section=moderate&amp;do=delete&amp;id={$row['file_id']}'><img src='{$this->settings['skin_acp_url']}/images/aff_cross.png' alt='X' /></a></td>
		</tr>
HTML;
}
$IPBHTML .= <<<HTML
	</table>
</div>
HTML;

//--endhtml--//
return $IPBHTML;
}

}