<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Mimetypes skin file
 * Last Updated: $Date: 2010-05-19 21:06:53 -0400 (Wed, 19 May 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 6326 $ 
 */
 
class cp_skin_mimetypes extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}

/**
 * Masks wrapper
 *
 * @access	public
 * @param	string	HTML content
 * @param	string	Dropdown list
 * @return	string	HTML
 */
public function masksWrapper( $content, $dlist ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$this->lang->words['m_title']}</h2>
</div>

<div class="acp-box">
	<h3>{$this->lang->words['d_mimemask']}</h3>
	<table class='alternate_rows'>
		<tr>
			<th width='30%'>{$this->lang->words['d_maskname']}</th>
			<th width='65%'>{$this->lang->words['d_usedbycats']}</th>
			<th width='5%'>&nbsp;</th>
		</tr>
		{$content}
	</table>
</div>
<br />

<form name='theAdminForm' id='adminform' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=mask_add' method='post'>
<div class="acp-box">
	<h3>{$this->lang->words['d_createmask']}</h3>
	<table class='alternate_rows'>
		<tr>
			<td>{$this->lang->words['d_strongmaskname']}</td>
			<td><input type='text' class='input' size='30' name='new_mask_name' /></td>
		</tr>
		<tr>
			<td>{$this->lang->words['d_inheritmask']}</td>
			<td><select name='new_mask_copy' class='dropdown'>{$dlist}</select></td>
		</tr>
	</table>
	<div class='tablefooter' align='center'><input type='submit' value='{$this->lang->words['d_create']}' class='realbutton' /></div>
</div>
</form>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Mime mask row
 *
 * @access	public
 * @param	array 	Mime type
 * @return	string	HTML
 */
public function masksRow( $row ) {

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td>{$row['mime_masktitle']}</td>
 <td>{$row['categories']}</td>
 <td>
 	<img id="menu{$row['mime_maskid']}" src='{$this->settings['skin_acp_url']}/_newimages/menu_open.png' alt='{$this->lang->words['d_options']}' class='ipbmenu' />
		<ul class='acp-menu' id='menu{$row['mime_maskid']}_menucontent'>
			<li class='icon edit'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=types&amp;id={$row['mime_maskid']}'>{$this->lang->words['d_editmask']}</a></li>
			<li class='icon delete'>{$row['delete']}</li>
		</ul>
 </td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Mime types form
 *
 * @access	public
 * @param	array 	Form elements
 * @param	array 	Mime type info
 * @return	string	HTML
 */
public function mimeForm( $form, $mime ) {

if( !$form['baseon'] )
{
	$title	= $form['button'];
}
else
{
	$title = <<<EOF
<div style='float:right;width:auto;padding: 0px 3px;margin-top: -4px;'>
	<form method='post' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=mime_add&amp;id={$this->request['id']}'>
		<select name='baseon'>{$form['baseon']}</select> &nbsp;<input type='submit' value='Go' class='button' />
	</form>
</div>
{$form['button']}
EOF;
}

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<div class='acp-box'>
	<h3>{$title}</h3>
	

	<form action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do={$form['code']}' method='post'>
	<input type='hidden' name='id' value='{$this->request['id']}' />
	<input type='hidden' name='mid' value='{$this->request['mid']}' />

	<ul class='acp-form alternate_rows'>
		<li>
			<label>{$this->lang->words['d_fileex']} <span class='desctext'>{$this->lang->words['d_fileext_info']}</span></label>
			{$form['mime_extension']}
		</li>
		<li>
			<label>{$this->lang->words['d_mimetype']} <span class='desctext'>{$this->lang->words['d_mimetype_info']}</span></label>
			{$form['mime_type']}
		</li>
		<li>
			<label>{$this->lang->words['d_allowmime']}</label>
			{$form['mime_file']}
		</li>
		<li>
			<label>{$this->lang->words['d_allowss']}</label>
			{$form['mime_screenshot']}
		</li>
		<li>
			<label>{$this->lang->words['d_fileinline']} <span class='desctext'>{$this->lang->words['d_fileinline_info']}</span></label>
			{$form['mime_inline']}
		</li>
		<li>
			<label>{$this->lang->words['d_mimeimg']}</label>
			{$form['mime_img']}
		</li>
	</ul>
	<div class='acp-actionbar'>
		<div class='centeraction'>
			<input type='submit' value=' {$form['button']} ' class='button primary' />
		</div>
	</div>

	</form>
</div>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Mime types wrapper listing
 *
 * @access	public
 * @param	string	HTML content
 * @param	array 	Mime type mask
 * @return	string	HTML
 */
public function mimesWrapper( $content, $mask ) {

$mask_name	= $this->registry->output->formInput( "new_mask_name", $mask['mime_masktitle']  );

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF

<form name='theAdminForm' id='adminform' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=do_mask_edit' method='post'>
<input type='hidden' name='mask_id' value='{$this->request['id']}' />
<div class='acp-box'>
	<h3>{$this->lang->words['d_renamemask']}</h3>

	<table class='alternate_rows'>
		<tr>
			<td>{$this->lang->words['d_newmask']}</td>
			<td>{$mask_name} <input type='submit' value=' {$this->lang->words['d_rename']} ' class='button primary' /></td>
		</tr>
	</table>
</div>
</form>
<br />

<div class='acp-box'>
	<h3>
		<div style='float:right;font-weight:normal;'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=mime_export'><span class='button'>{$this->lang->words['d_export']}</span></a></div>
		{$this->lang->words['d_renamemask']}
	</h3>

	<table class='alternate_rows'>
		<tr>
			<th width='5%'>&nbsp;</th>
			<th width='25%'>{$this->lang->words['d_extension']}</th>
			<th width='35%'>{$this->lang->words['d_mimetype']}</th>
			<th width='10%'>+{$this->lang->words['d_file']}</th>
			<th width='10%'>+{$this->lang->words['d_screenshot']}</th>
			<th width='10%'>+{$this->lang->words['d_inline']}</th>
			<th width='5%'>&nbsp;</th>
		</tr>
		{$content}
	</table>
	<div class='acp-actionbar'>
		<div class='centeraction'>
			<input type='button' class='realbutton' value='{$this->lang->words['d_addnewtype']}' onclick='acp.redirect("&amp;app=downloads&amp;{$this->form_code}&amp;do=mime_add&amp;id={$this->request['id']}")' />
		</div>
	</div>
</div>
<br />

<form name='theAdminForm' id='adminform2' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=mime_import' method='post' enctype='multipart/form-data'>
<input type='hidden' name='id' value='{$this->request['id']}' />

<div class='acp-box'>
	<h3>{$this->lang->words['d_importtypes']}</h3>

	<table class='alternate_rows'>
		<tr>
			<td class='tablerow1'>{$this->lang->words['d_uploadtypes']}</td>
			<td class='tablerow2'><input type='file' name='FILE_UPLOAD' /></td>
		</tr>
	</table>
	<div class='acp-actionbar'>
		<div class='centeraction'>
			<input type='submit' value='{$this->lang->words['d_import']}' class='button primary' />
		</div>
	</div>
</div>
</form>
EOF;

//--endhtml--//
return $IPBHTML;
}

/**
 * Mime type row
 *
 * @access	public
 * @param	array 	Mime type
 * @return	string	HTML
 */
public function mimesRow( $row ) {

$checked_img	= "<img src='{$this->settings['skin_acp_url']}/images/aff_tick.png' alt='X' />";
$file_checked	= $row['mime_file']  ? $checked_img : '&nbsp;';
$ss_checked		= $row['mime_screenshot'] ? $checked_img : '&nbsp;';
$inline_checked	= $row['mime_inline'] ? $checked_img : '&nbsp;';

$IPBHTML = "";
//--starthtml--//

$IPBHTML .= <<<EOF
<tr>
 <td><img src='{$this->settings['public_dir']}style_extra/{$row['mime_img']}' /></td>
 <td>.<strong>{$row['mime_extension']}</strong></td>
 <td>{$row['mime_mimetype']}</td>
 <td>{$file_checked}</td>
 <td>{$ss_checked}</td>
 <td>{$inline_checked}</td>
 <td>
 	<img id="menu{$row['mime_id']}" src='{$this->settings['skin_acp_url']}/_newimages/menu_open.png' alt='{$this->lang->words['d_options']}' class='ipbmenu' />
	<ul class='acp-menu' id='menu{$row['mime_id']}_menucontent'>
		<li class='icon edit'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=mime_edit&amp;mid={$row['mime_id']}&amp;id={$this->request['id']}'>{$this->lang->words['d_edittype']}</a></li>
		<li class='icon delete'><a href='#' onclick='return acp.confirmDelete("{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=mime_delete&amp;mid={$row['mime_id']}&amp;id={$this->request['id']}");'>{$this->lang->words['d_deletetype']}</a></li>
	</ul>
 </td>
</tr>
EOF;

//--endhtml--//
return $IPBHTML;
}

}
