<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Group form skin file
 * Last Updated: $Date: 2010-12-03 11:19:51 -0500 (Fri, 03 Dec 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 7358 $ 
 */
class cp_skin_idm_group_form extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}

/**
 * Main form to edit group settings
 *
 * @access	public
 * @param	array 	Group
 * @param	mixed	Tab id
 * @return	string	HTML
 */
public function acp_group_form_main( $group, $tabId ) {

$restrictions	= is_array( @unserialize( $group['idm_restrictions'] ) ) ? unserialize( $group['idm_restrictions'] ) : array();
$group			= array_merge( $group, $restrictions );

$form					= array();
$form['enabled']		= $this->registry->output->formYesNo( "enabled", $group['enabled'] );
$form['limit_sim']		= $this->registry->output->formInput( "limit_sim", $group['limit_sim'] );
$form['min_posts']		= $this->registry->output->formInput( "min_posts", $group['min_posts'] );
$form['posts_per_dl']	= $this->registry->output->formInput( "posts_per_dl", $group['posts_per_dl'] );
$form['daily_bw']		= $this->registry->output->formInput( "daily_bw", $group['daily_bw'] );
$form['weekly_bw']		= $this->registry->output->formInput( "weekly_bw", $group['weekly_bw'] );
$form['monthly_bw']		= $this->registry->output->formInput( "monthly_bw", $group['monthly_bw'] );
$form['daily_dl']		= $this->registry->output->formInput( "daily_dl", $group['daily_dl'] );
$form['weekly_dl']		= $this->registry->output->formInput( "weekly_dl", $group['weekly_dl'] );
$form['monthly_dl']		= $this->registry->output->formInput( "monthly_dl", $group['monthly_dl'] );
$form['add_paid']		= $this->registry->output->formYesNo( "idm_add_paid", $group['idm_add_paid'] );
$form['bypass_paid']	= $this->registry->output->formYesNo( "idm_bypass_paid", $group['idm_bypass_paid'] );
$form['report_files']	= $this->registry->output->formYesNo( "idm_report_files", $group['idm_report_files'] );
$form['view_dls']		= $this->registry->output->formYesNo( "idm_view_downloads", $group['idm_view_downloads'] );
$form['bypass_rev']		= $this->registry->output->formYesNo( "idm_bypass_revision", $group['idm_bypass_revision'] );

$IPBHTML = "";

$IPBHTML .= <<<EOF

<div id='tabpane-GROUPS|{$tabId}' class='acp-box'>
	<ul class='acp-form alternate_rows'>
	 	<li class='guest_legend'>
	 		<label>{$this->lang->words['gf_d_reports']}<span class='desctext'>{$this->lang->words['d_reports_desc']}</span></label>
	 		{$form['report_files']}
	 		{$this->lang->words['g_appguests']}
	 	</li>
	 	<li>
	 		<label>{$this->lang->words['gf_d_viewdls']}<span class='desctext'>{$this->lang->words['g_d_viewdls_desc']}</span></label>
	 		{$form['view_dls']}
	 	</li>
	 	<li>
	 		<label>{$this->lang->words['gf_bypass_revisions']}<span class='desctext'>{$this->lang->words['g_d_bypass_rev_desc']}</span></label>
	 		{$form['bypass_rev']}
	 	</li>
EOF;

if ( IPSLib::appIsInstalled( 'nexus' ) and ipsRegistry::$settings['idm_nexus_on'] )
{
$IPBHTML .= <<<EOF
	 	<li>
	 		<label>{$this->lang->words['gf_paid_add']}</label>
	 		{$form['add_paid']}
	 	</li>
	 	<li>
	 		<label>{$this->lang->words['gf_paid_bypass']}</label>
	 		{$form['bypass_paid']}
	 	</li>
EOF;
}

$IPBHTML .= <<<EOF
	 	<li>
	 		<label>{$this->lang->words['gf_d_enabler']}<span class='desctext'>{$this->lang->words['d_enabler_info']}</span></label>
	 		{$form['enabled']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxstim']}<span class='desctext'>{$this->lang->words['d_maxstim_info']}</span></label>
	 		{$form['limit_sim']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_poststodl']}<span class='desctext'>{$this->lang->words['d_poststodl_info']}</span></label>
	 		{$form['min_posts']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_postsperdl']}<span class='desctext'>{$this->lang->words['d_postsperdl_info']}</span></label>
	 		{$form['posts_per_dl']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxbwd']}<span class='desctext'>{$this->lang->words['d_maxbwd_info']}</span></label>
	 		{$form['daily_bw']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxbww']}<span class='desctext'>{$this->lang->words['d_maxbww_info']}</span></label>
	 		{$form['weekly_bw']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxbwm']}<span class='desctext'>{$this->lang->words['d_maxbwm_info']}</span></label>
	 		{$form['monthly_bw']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxdld']}<span class='desctext'>{$this->lang->words['d_maxdld_info']}</span></label>
	 		{$form['daily_dl']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxdlw']}<span class='desctext'>{$this->lang->words['d_maxdlw_info']}</span></label>
	 		{$form['weekly_dl']}
	 	</li>
	 	
	 	<li>
	 		<label>{$this->lang->words['gf_d_maxdlm']}<span class='desctext'>{$this->lang->words['d_maxdlm_info']}</span></label>
	 		{$form['monthly_dl']}
	 	</li>
	</ul>
</div>

EOF;

return $IPBHTML;
}

/**
 * Tabs for the group form
 *
 * @access	public
 * @param	array 	Group
 * @param	mixed	Tab id
 * @return	string	HTML
 */
public function acp_group_form_tabs( $group, $tabId ) {

$IPBHTML = "";

$IPBHTML .= <<<EOF
	<li id='tabtab-GROUPS|{$tabId}' class=''>{$this->lang->words['d_idmrestrictions']}</li>
EOF;

return $IPBHTML;
}

}
