<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Category skin file
 * Last Updated: $Date: 2010-11-19 19:24:33 -0500 (Fri, 19 Nov 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 7250 $ 
 */
 
class cp_skin_categories extends output
{

/**
 * Prevent our main destructor being called by this class
 *
 * @access	public
 * @return	void
 */
public function __destruct()
{
}


/**
 * Navigation bar
 *
 * @access	public
 * @param	array 	Nav links
 * @return	string	HTML
 */
public function navigationBar( $nav ) {

$nav_string	= implode( ' &gt; ', $nav );

$IPBHTML = "";

$IPBHTML .= <<<EOF
<div class='navstrip'><a href='{$this->settings['base_url']}&amp;{$this->form_code}'>{$this->lang->words['d_categories']}</a> &gt; {$nav_string}</div><br />
EOF;

return $IPBHTML;
}

/**
 * Home screen
 *
 * @access	public
 * @param	int		Total items
 * @param	string 	Categories
 * @return	string	HTML
 */
public function mainScreen( $total_items, $categories ) {

$IPBHTML = "";

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$this->lang->words['c_title']}</h2>
</div>

<script type='text/javascript' src='{$this->settings['js_app_url']}acp.downloads.js'></script>
EOF;

if( !$total_items )
{
	$IPBHTML .= <<<EOF
<div class='warning'>
	<table cellpadding='0' cellspacing='0'>
		<tr>
			<td width='1%' valign='middle'>
				<img src='{$this->settings['skin_acp_url']}/images/global-infoicon.gif' alt='{$this->lang->words['d_information']}' />
			</td>
			<td width='71%' valig='top' style='margin-left:10px'>
		 		<div style='font-size:14px;font-weight:bold;border-bottom:1px solid #000;padding-bottom:5px;margin-bottom:5px;margin-right:5px'>{$this->lang->words['d_attention']}</div>
		 		<div>{$this->lang->words['d_nocats']}</div>
			</td>
		</tr>
	</table>
</div>
<br />
EOF;
}
else
{
	$IPBHTML .= <<<EOF
	<div id='sortable_handle'>
	{$categories}
	</div>
EOF;
}

$IPBHTML .= <<<EOF
<div class='tableborder'>
	<table width='100%' class='tablerow1'>
		<tr>
 			<td align='left' valign='middle'>
			</td>
			<td align='right'><input type='button' class='realbutton' value='{$this->lang->words['d_addnewcat']}' onclick='acp.redirect("&amp;app=downloads&amp;{$this->form_code}&amp;do=new&amp;p=0")' />
			</td>
		</tr>
	</table>
</div>
<br />
<script type='text/javascript'>
dropItLikeItsHot = function( draggableObject, mouseObject )
{
	var options = {
					method : 'post',
					parameters : Sortable.serialize( 'sortable_handle', { tag: 'div', name: 'cats' } )
				};
 
	new Ajax.Request( "{$this->settings['base_url']}&{$this->form_code_js}&do=doreorder&md5check={$this->registry->adminFunctions->getSecurityKey()}".replace( /&amp;/g, '&' ), options );

	return false;
};

Sortable.create( 'sortable_handle', { tag: 'div', only: 'isDraggable', revert: true, format: 'cat_([0-9]+)', onUpdate: dropItLikeItsHot, handle: 'draghandle' } );
</script>
EOF;

return $IPBHTML;
}

/**
 * Subcategories HTML
 *
 * @access	public
 * @param	array 	Categories
 * @return	string	HTML
 */
public function subCategories( $categories ) {

$sub		= array();
$IPBHTML	= "";

$IPBHTML .= <<<EOF
<br /><fieldset style="margin-top:4px"><legend><b>{$this->lang->words['d_subcats']}</b></legend>
EOF;

foreach( $categories as $id => $data )
{
	$sub[]	= "<a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;c={$data['cid']}'>{$this->registry->getClass('categories')->cat_lookup[$data['cid']]['cname']}</a>";
}

$IPBHTML .= implode( ', ', $sub );
$IPBHTML .= <<<EOF
</fieldset>
EOF;

return $IPBHTML;
}

/**
 * Moderator HTML
 *
 * @access	public
 * @param	array 	Moderators
 * @param	int 	Category ID
 * @return	string	HTML
 */
public function moderators( $moderators, $category_id ) {

$mod		= array();
$seen_mods	= array();
$IPBHTML	= "";

$IPBHTML .= <<<EOF
<br /><fieldset style="margin-top:4px"><legend><b>{$this->lang->words['d_moderators']}</b></legend>
EOF;

foreach( $moderators as $id => $data )
{
	$data['_fullname']	= !$data['modtype'] ?  $this->lang->words['c_group'] . ": " . $data['group_name'] : $data['mem_name'];

	if( in_array( $data['mem_id'], $seen_mods ) )
	{
		continue;
	}
	else if( in_array( $data['group_id'], $seen_mods ) )
	{
		continue;
	}

	$IPBHTML .= <<<EOF
<div class='ipbmenu realbutton' style='float:left;width:auto;white-space:nowrap;margin-right:3px;' id='modmenu{$category_id}{$data['modid']}'>{$data['_fullname']} <img src='{$this->settings['skin_acp_url']}/_newimages/menu_open.png' /></div>
<ul class='acp-menu' id='modmenu{$category_id}{$data['modid']}_menucontent'>
	<li class='icon edit'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=editmod&amp;modid={$data['modid']}'>{$this->lang->words['d_edit']}</a></li>
	<li class='icon delete'><a href='#' onclick='return acp.confirmDelete("{$this->settings['base_url']}&amp;{$this->form_code}&amp;c={$category_id}&amp;do=delmod&amp;modid={$data['modid']}");'>{$this->lang->words['d_remove']}</a></li>
</ul>
EOF;
	
	$seen_mods[] = !$data['modtype'] ? $data['group_id'] : $data['mem_id'];
}


$IPBHTML .= <<<EOF
</fieldset>
EOF;

return $IPBHTML;
}

/**
 * Category screen
 *
 * @access	public
 * @param	string	Category content
 * @param	array 	Category data
 * @param	int		Current position
 * @param	bool	Show the buttons
 * @return	string	HTML
 */
public function renderCategory( $content, $cat, $cur_position=0, $show_buttons=1 )
{
	$bar_id		= $this->request['c'] ? $this->registry->getClass('categories')->cat_lookup[ $this->request['c'] ]['cparent'] : 0;
	$no_root	= count( $this->registry->getClass('categories')->cat_cache[ $bar_id ] );

$IPBHTML .= <<<EOF
<div class='tableborder isDraggable' id='cat_{$cat['cid']}' style='margin-bottom: 10px;'>
	<div class='tableheaderalt'>
EOF;

	if ( $show_buttons )
	{
		$IPBHTML .= <<<EOF
		<table width='100%'>
			<tr>
				<td align='left' width='95%' title='{$this->lang->words['t_id']}: {$cat['cid']}'>
					<div class='draghandle'><img src='{$this->settings['skin_acp_url']}/_newimages/drag_icon.png' alt='drag' /></div>
					{$cat['cname']}
				</td>
				<td align='right' width='5%' nowrap='nowrap' style='padding-right:8px; font-weight: normal;'>
					<img id="menum-{$cat['cid']}" src='{$this->settings['skin_acp_url']}/_newimages/menu_open.png' alt='{$this->lang->words['d_options']}' class='ipbmenu' />
					<ul class='acp-menu' id='menum-{$cat['cid']}_menucontent'>
						<li class='icon add'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=new&amp;p={$cat['cid']}'>{$this->lang->words['d_newcat']}</a></li>
						<li class='icon edit'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=edit&amp;c={$cat['cid']}'>{$this->lang->words['d_editsettings']}</a></li>
						<li class='icon password'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=modform&amp;c={$cat['cid']}'>{$this->lang->words['d_addmod']}</a></li>
						<li class='icon delete'><a href='#' onclick='ACPDownloads.confirmDelete({$cat['cid']})'>{$this->lang->words['d_deletecat']}</a></li>
						<li class='icon delete'><a href='#' onclick='ACPDownloads.confirmEmpty({$cat['cid']})'>{$this->lang->words['d_emptycat']}</a></li>
						<li class='icon refresh'><a href='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do=resynch&amp;c={$cat['cid']}'>{$this->lang->words['d_resynchcat']}</a></li>
					</ul>
				</td>
			</tr>
		</table>
EOF;
	}
	else
	{
		$IPBHTML .= $cat['cname'];
	}

	$IPBHTML .= <<<EOF
	</div>
	<table cellpadding='0' cellspacing='0' width='100%'>
		<tr>
			<td class='tablerow1' width='95%'>{$cat['cdesc']}<br />
				{$content}
			</td>
		</tr>
	</table>
</div>
EOF;

return $IPBHTML;
}

/**
 * Form to add/edit a category
 *
 * @access	public
 * @param	array 	Category data
 * @param	array 	Form elements
 * @param	int		Max upload size
 * @param	string	Title
 * @return	string	HTML
 */
public function categoryForm( $category, $form, $max_upload=0, $title='' ) {

$IPBHTML = "";

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$title}</h2>
</div>

<form id='adminform' action='{$this->settings['base_url']}&amp;{$this->form_code}&amp;do={$form['form_code']}&amp;c={$category['cid']}' method='post'>
<script type="text/javascript">
//<![CDATA[
document.observe("dom:loaded",function() 
{
ipbAcpTabStrips.register('tab_cats');
});
 //]]>
</script>
<h1>{$form['form_title']}</h1>
<ul id='tab_cats' class='tab_bar no_title'>
	<li id='tabtab-IDM|1' class='taboff'>{$this->lang->words['d_basics']}</li>
	<li id='tabtab-IDM|2' class='taboff'>{$this->lang->words['d_catoptions']}</li>
	<li id='tabtab-IDM|3' class='taboff'>{$this->lang->words['d_topicgeneration']}</li>
	<li id='tabtab-IDM|4' class='taboff'>{$this->lang->words['d_customerrors']}</li>
	<li id='tabtab-IDM|5' class='taboff'>{$this->lang->words['d_permissions']}</li>
</ul>
<div class='acp-box'>
	<div id='tabpane-IDM|1'>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_catname']}</label>
				{$form['cname']}
			</li>
			<li>
				<label>{$this->lang->words['d_catdesc']}<span class='desctext'>{$this->lang->words['d_catdesc_info']}</span></label>
				{$form['cdesc']}
			</li>
			<li>
				<label>{$this->lang->words['d_parentcat']}<span class='desctext'>{$this->lang->words['d_parentcat_info']}</span></label>
				{$form['cparent']}
			<li>
				<label>{$this->lang->words['d_catopen']}<span class='desctext'>{$this->lang->words['d_catopen_info']}</span></label>
				{$form['copen']}
			</li>
			<li>
				<label>{$this->lang->words['d_showfile']}<span class='desctext'>{$this->lang->words['d_showfile_info']}</span></label>
				{$form['opt_disfiles']}
			</li>
			<li>
				<label>{$this->lang->words['d_disclaim']}<span class='desctext'>{$this->lang->words['d_disclaim_info']}</span></label>
				{$form['cdisclaimer']}
			</li>
		</ul>
	</div>

	<div id='tabpane-IDM|2'>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_mimemask']}<span class='desctext'>{$this->lang->words['d_mimemask_info']}</span></label>
				{$form['opt_mimemask']}
			<li>
				<label>{$this->lang->words['d_customfields']}</label>
				{$form['ccfields']}
			</li>
			<li>
				<label>{$this->lang->words['d_allowbbcode']}</label>
				{$form['opt_bbcode']}
			</li>
			<li>
				<label>{$this->lang->words['d_allowhtml']}</label>
				{$form['opt_html']}
			</li>
			<li>
				<label>{$this->lang->words['d_allowscreens']}</label>
				{$form['opt_allowss']}
			</li>
			<li>
				<label>{$this->lang->words['d_requiress']}</label>
				{$form['opt_reqss']}
			</li>
			<li>
				<label>{$this->lang->words['d_displaythumb']}</label>
				{$form['opt_catss']}
			</li>
			<li>
				<label>{$this->lang->words['d_usecomment']}</label>
				{$form['opt_comments']}
			</li>
			<li>
				<label>{$this->lang->words['d_sortorder']}</label>
				{$form['opt_sortorder']}
			</li>
			<li>
				<label>{$this->lang->words['d_sortbyorder']}</label>
				{$form['opt_sortby']}
			<li>
				<label>{$this->lang->words['d_maxsize']}<span class='desctext'>{$this->lang->words['d_maxsize_info']} {$max_upload}.</span></label>
				{$form['opt_maxfile']}
			</li>
			<li>
				<label>{$this->lang->words['d_maxsssize']}<span class='desctext'>{$this->lang->words['d_maxsize_info']} {$max_upload}.</span></label>
				{$form['opt_maxss']} &nbsp;&nbsp; {$this->lang->words['d_thumbwidth']} {$form['opt_thumb_x']}px
			</li>
		</ul>
	</div>

	<div id='tabpane-IDM|3'>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_createtopic']}</label>
				{$form['opt_topice']}
			</li>
			<li>
				<label>{$this->lang->words['d_postinwhich']}</label>
				{$form['opt_topicf']}
			</i>
			<li>
				<label>{$this->lang->words['d_prefix']}<span class='desctext'>{$this->lang->words['d_prefix_info']}</span></label>
				{$form['opt_topicp']}
			</li>
			<li>
				<label>{$this->lang->words['d_suffix']}<span class='desctext'>{$this->lang->words['d_prefix_info']}</span></label>
				{$form['opt_topics']}
			</li>
			<li>
				<label>{$this->lang->words['d_autodelete']}</label>
				{$form['opt_topicd']}
			</li>
			<li>
				<label>{$this->lang->words['d_includess']}<span class='desctext'>{$this->lang->words['d_includess_info']}</span></label>
				{$form['opt_topicss']}
			</li>
		</ul>
	</div>
		
	<div id='tabpane-IDM|4'>
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_cannotviewmsg']}</label>
				{$form['opt_noperm_view']}
			</li>
			<li>
				<label>{$this->lang->words['d_cannotaddmsg']}</label>
				{$form['opt_noperm_add']}
			</li>
			<li>
				<label>{$this->lang->words['d_cannotdlmsg']}</label>
				{$form['opt_noperm_dl']}
			</li>
		</ul>
	</div>
	
	<!-- Permissions -->
	<div id='tabpane-IDM|5'>
		<div style='padding-top:10px'>
			{$form['permissions']}
		</div>
	</div>
	
	<div class='acp-actionbar'>
		<div class='centeraction'>
			<input type='submit' value=' {$form['form_button']} ' class='button primary' />
		</div>
	</div>
	</div>
</form>
EOF;


return $IPBHTML;
}

/**
 * Form to add/edit moderator
 *
 * @access	public
 * @param	array 	Form elements
 * @return	string	HTML
 */
public function moderatorForm( $form ) {

$IPBHTML = "";

$IPBHTML .= <<<EOF
<div class='section_title'>
	<h2>{$this->lang->words['c_title_mod']}</h2>
</div>

<script type='text/javascript' src='{$this->settings['js_app_url']}acp.downloads.js'></script>

<form action='{$this->settings['base_url']}{$this->form_code}&amp;do={$form['code']}' method='post'>
	<input type='hidden' name='modid' value='{$this->request['modid']}' />
	
	<div class="acp-box">
		<h3>{$this->lang->words['d_modsett']}</h3>
		
		<ul class='acp-form alternate_rows'>
			<li>
				<label>{$this->lang->words['d_modtype']}<span class='desctext'>{$this->lang->words['d_modtype_info']}</span></label>
				{$form['modtype']}
			</li>
			<li>
				<label>{$this->lang->words['d_groupormem']}<span class='desctext'>{$this->lang->words['d_modtype_info']}</span></label>
				{$form['modgid']} {$this->lang->words['d_or']} {$form['modmid']}
			</li>
			<li>
				<label>{$this->lang->words['d_categories']}</label>
				{$form['modcats']}
			</li>
			<li>
				<label>{$this->lang->words['d_canedit']}</label>
				{$form['modcanedit']}
			</li>
			<li>
				<label>{$this->lang->words['d_candelete']}</label>
				{$form['modcandel']}
			</li>
			<li>
				<label>{$this->lang->words['d_canapprove']}</label>
				{$form['modcanapp']}
			</li>
			<li>
				<label>{$this->lang->words['d_canmanagebrok']}</label>
				{$form['modcanbrok']}
			</li>
			<li>
				<label>{$this->lang->words['d_canmanagecom']}</label>
				{$form['modcancomm']}
			</li>
			<li>
				<label>{$this->lang->words['d_canpinunpin']}</label>
				{$form['modcanpin']}
			</li>
			<li>
				<label>{$this->lang->words['d_canchangeauthor']}</label>
				{$form['modchangeauth']}
			</li>
			<li>
				<label>{$this->lang->words['d_featureunfeature']}</label>
				{$form['modusefeature']}
			</li>
		</ul>
		
		<div class='acp-actionbar'>
			<div class='centeraction'>
				<input type='submit' value=' {$this->lang->words['d_submit']} ' class='button primary' />
			</div>
		</div>
	</div>
</form>

EOF;

return $IPBHTML;
}


}
