<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IP.Download Manager version upgrader
 * Last Updated: $Date: 2010-03-04 18:23:59 -0500 (Thu, 04 Mar 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		1st Dec 2009
 * @version		$Revision: 5895 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class version_upgrade
{
	/**
	 * Custom HTML to show
	 *
	 * @access	private
	 * @var		string
	 */
	private $_output = '';
	
	/**
	 * fetchs output
	 * 
	 * @access	public
	 * @return	string
	 */
	public function fetchOutput()
	{
		return $this->_output;
	}
		
	/**
	 * Execute selected method
	 *
	 * @access	public
	 * @param	object		Registry object
	 * @return	void
	 */
	public function doExecute( ipsRegistry $registry ) 
	{
		/* Make object */
		$this->registry =  $registry;
		$this->DB       =  $this->registry->DB();
		$this->settings =& $this->registry->fetchSettings();
		$this->request  =& $this->registry->fetchRequest();
		$this->cache    =  $this->registry->cache();
		$this->caches   =& $this->registry->cache()->fetchCaches();
		
		//-----------------------------------------
		// Update comments count
		//-----------------------------------------
		
		$comments	= array();
		
		$this->DB->build( array( 'select' => 'COUNT(*) as num_comments, comment_fid', 'from' => 'downloads_comments', 'group' => 'comment_fid', 'where' => 'comment_open=1' ) );
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			$comments[ $r['comment_fid'] ]	= $r['num_comments'];
		}
		
		if( count($comments) )
		{
			foreach( $comments as $fid => $cnt )
			{
				$this->DB->update( 'downloads_files', array( 'file_comments' => $cnt ), 'file_id=' . $fid );
			}
		}

		//-----------------------------------------
		// Continue with upgrade
		//-----------------------------------------
		
		return true;
	}	
}
	
	
