<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IDM moderation library
 * Last Updated: $Date: 2010-12-06 17:07:54 -0500 (Mon, 06 Dec 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		6/24/2008
 * @version		$Revision: 7368 $
 *
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class public_downloads_moderate_moderate extends ipsCommand
{
	/**
	 * Stored temporary output
	 *
	 * @var 	string 				Page output
	 */
	protected $output				= "";

	/**
	 * Moderator library
	 *
	 * @var 	object
	 */
	protected $moderateLibrary;

	/**
	 * Message to show on the mod CP
	 *
	 * @var 	string
	 */
	protected $message				= "";

	/**
	 * Main class entry point
	 *
	 * @param	object		ipsRegistry reference
	 * @return	void		[Outputs to screen]
	 */	
	public function doExecute( ipsRegistry $registry )
	{
		//-------------------------------------------
		// Page title and navigation bar
		//-------------------------------------------
		
		$this->registry->output->addNavigation( $this->lang->words['idm_navbar'], 'app=downloads', 'false', 'app=downloads' );

		//-------------------------------------------
		// Do we have access?
		//-------------------------------------------
		
		if( count($this->registry->getClass('categories')->member_access['view']) == 0 )
		{
			$this->registry->output->showError( 'no_downloads_permissions', 10875, null, null, 403 );
		}
		
		//-------------------------------------------
		// Get our moderator library
		//-------------------------------------------
		
		$classToLoad			= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/sources/classes/moderate.php', 'idm_moderate', 'downloads' );
		$this->moderateLibrary	= new $classToLoad( $this->registry );

		switch( $this->request['do'] )
		{
			case 'togglefile':
				$this->_doToggleFile( );
			break;
			
			case 'pin':
			case 'unpin':
				$this->_doPinFile( );
			break;

			case 'broken':
				$this->_reportBroken( );
			break;
				
			case 'notbroken':
				$this->_reportUnbroken( );
			break;					
			
			case 'delete':
				$this->_doDelete( );
			break;
				
			case 'modaction':
				$this->_doModAction( );
			break;
				
			case 'versions':
				$this->_versionControlGateway();
			break;

			case 'multimod':
				$this->_multiModeration();
			break;
			
			case 'updateAuthor':
				$this->_updateFileAuthor();
			break;

			case 'setFeatured':
				$this->_setFeatured();
			break;
				
			default:
				$this->_displayPanel();
			break;
		}
		
		//-------------------------------------------
		// Print output
		//-------------------------------------------

        $this->registry->output->setTitle( $this->lang->words['moderate_nav'] . ' - ' . $this->settings['board_name'] );
		$this->registry->output->addContent( $this->output );
		$this->registry->output->sendOutput();
	}
	
	/**
	 * Set or unset featured file
	 *
	 * @return	void
	 */
	protected function _setFeatured()
	{
		//-----------------------------------------
		// Init
		//-----------------------------------------
		
		$id		= intval($this->request['id']);
		
		if( !$id )
		{
			$this->registry->output->showError( $this->lang->words['nofile_for_feature'], 108990.2, null, null, 403 );
		}
		
		$file	= $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_files', 'where' => 'file_id=' . $id ) );
		
		if( !$file['file_id'] )
		{
			$this->registry->output->showError( $this->lang->words['nofile_for_feature'], 108989.2, null, null, 403 );
		}
		
		//-----------------------------------------
		// Check permissions
		//-----------------------------------------
		
		if( !$this->registry->getClass('idmFunctions')->checkPerms( $file, 'modusefeature' ) )
		{
			$this->registry->output->showError( $this->lang->words['noperm_for_feature'], 108988.2, null, null, 403 );
		}
		
		//-----------------------------------------
		// Check member details
		//-----------------------------------------
		
		if( !$file['file_featured'] )
		{
			$langbit	= 'featured_file_ok';
			$this->DB->update( "downloads_files", array( 'file_featured' => 0 ) );
			$this->DB->update( "downloads_files", array( 'file_featured' => 1 ), "file_id=" . $id );
		}
		else
		{
			$langbit	= 'unfeatured_file_ok';
			$this->DB->update( "downloads_files", array( 'file_featured' => 0 ), "file_id=" . $id );
		}
		
		$this->registry->output->redirectScreen( $this->lang->words[ $langbit ], $this->settings['base_url'] . "app=downloads&amp;showfile={$id}", $file['file_name_furl'], 'idmshowfile' );
	}
	
	/**
	 * Update owner of a file
	 *
	 * @return	void
	 */
	protected function _updateFileAuthor()
	{
		//-----------------------------------------
		// Init
		//-----------------------------------------
		
		$id		= intval($this->request['id']);
		
		if( !$id )
		{
			$this->registry->output->showError( $this->lang->words['nofile_for_authchange'], 108990, null, null, 403 );
		}
		
		$file	= $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_files', 'where' => 'file_id=' . $id ) );
		
		if( !$file['file_id'] )
		{
			$this->registry->output->showError( $this->lang->words['nofile_for_authchange'], 108989, null, null, 403 );
		}
		
		//-----------------------------------------
		// Check permissions
		//-----------------------------------------
		
		if( !$this->registry->getClass('idmFunctions')->checkPerms( $file, 'modchangeauthor' ) )
		{
			$this->registry->output->showError( $this->lang->words['changeauth_perms'], 108988, null, null, 403 );
		}
		
		//-----------------------------------------
		// Check member details
		//-----------------------------------------
		
		$name = trim( strtolower( $this->request['change_author_input'] ) );
		
		$member = $this->DB->buildAndFetch( array( 'select' => 'member_id', 'from' => 'members', 'where' => "members_l_display_name='{$name}'" ) );

		if( $member['member_id'] )
		{
			$this->DB->update( 'downloads_files', array( 'file_submitter' => $member['member_id'] ), "file_id=" . $id );
			
			$this->registry->categories->rebuildFileinfo();
			$this->cache->rebuildCache( 'idm_stats', 'downloads' );
			$this->cache->rebuildCache( 'idm_cats', 'downloads' );
		}
		else
		{
			$this->registry->output->showError( $this->lang->words['noauth_for_filechange'], 108987, null, null, 403 );
		}
		
		$this->registry->output->redirectScreen( $this->lang->words['author_changed'], $this->settings['base_url'] . "app=downloads&amp;showfile={$id}", $file['file_name_furl'], 'idmshowfile' );
	}
	
	/**
	 * Pin a file
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _doPinFile( )
	{
		$id = intval($this->request['id']);
		
		if( !$id )
		{
			$this->registry->output->showError( 'cannot_find_to_pin', 108760, null, null, 404 );
		}			
		
		$file = $this->DB->buildAndFetch( array( 'select'	=> '*',
														'from'		=> 'downloads_files',
														'where'		=> 'file_id=' . $id
												)		);
		
		if( !$file['file_id'] )
		{
			$this->registry->output->showError( 'cannot_find_to_pin', 108761, null, null, 404 );
		}

		if( !$this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanpin' ) )
		{
			$this->registry->output->showError( 'no_permitted_categories', 108762, null, null, 403 );
		}
		
		$to_update = array();
		
		if( !$file['file_pinned'] )
		{
			$this->moderateLibrary->doMultiPin( array( $id => $id ) );

			$text = $this->lang->words['moderate_pinned'];
		}
		else
		{
			$this->moderateLibrary->doMultiUnpin( array( $id => $id ) );

			$text = $this->lang->words['moderate_unpinned'];
		}

		$this->registry->output->redirectScreen( $text, $this->settings['base_url'] . "app=downloads&amp;showfile={$id}", $file['file_name_furl'], 'idmshowfile' );
	}

	/**
	 * Approve/unapprove
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _doToggleFile( )
	{
		$id = intval($this->request['id']);
		
		if( !$id )
		{
			$this->registry->output->showError( 'cannot_find_to_toggle', 10876, null, null, 404 );
		}			
		
		$file = $this->DB->buildAndFetch( array( 'select'	=> '*',
														'from'		=> 'downloads_files',
														'where'		=> 'file_id=' . $id
												)		);
		
		if( !$file['file_id'] )
		{
			$this->registry->output->showError( 'cannot_find_to_toggle', 10877, null, null, 404 );
		}
		
		$cantog	= $this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcanapp' );
		
		if( !$cantog )
		{
			$this->registry->output->showError( 'no_permitted_categories', 10878, null, null, 403 );
		}
		
		$to_update = array();
		
		if( $file['file_open'] == 0 )
		{
			$this->moderateLibrary->doMultiApprove( array( $id => $id ) );

			$text = $this->lang->words['moderate_approve'];
		}
		else
		{
			$this->moderateLibrary->doMultiUnapprove( array( $id => $id ) );

			$text = $this->lang->words['moderate_unapprove'];
		}
		
		$this->registry->getClass('categories')->rebuildFileinfo($file['file_cat']);
		$this->registry->getClass('categories')->rebuildStatsCache();
		
		if( $this->request['return'] == 1 )
		{
			$this->registry->output->redirectScreen( $text, $this->settings['base_url'] . "app=downloads&amp;showfile={$id}", $file['file_name_furl'], 'idmshowfile' );
		}
		else
		{
			$this->message = $text;
			$this->_displayPanel();
		}		
	}
	
	/**
	 * Delete a single file
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _doDelete( )
	{
		$count = $this->moderateLibrary->doMultiDelete( array( intval($this->request['id']) ) );

		if( !$count )
		{
			$this->registry->output->showError( 'cannot_find_to_del', 10879, null, null, 404 );
		}
		
		if( $this->request['return'] == 1 )
		{
			$this->registry->output->redirectScreen( $this->lang->words['moderate_filedeleted'], $this->settings['base_url'] . "app=downloads&amp;showcat=" . $this->moderateLibrary->fileCat, $this->registry->getClass('categories')->cat_lookup[ $this->moderateLibrary->fileCat ]['cname_furl'], 'idmshowcat' );
		}
		else
		{
			$this->message = $this->lang->words['moderate_filedeleted'];
			$this->_displayPanel();
		}
	}
	
	/**
	 * File multi-moderation
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _multiModeration()
	{
		/* Security Check */
		if ( $this->request['secure_key'] != $this->member->form_hash )
		{
			$this->registry->output->showError( 'no_permission', 10799, null, null, 403 );
		}
		
		$ids	= IPSLib::cleanIntArray( explode( ',', $this->request['selectedfileids'] ) );
		$cat	= intval($this->request['catid']);
		
		if( !is_array($ids) OR !count($ids) )
		{
			$this->registry->output->showError( 'error_generic', 10880, null, null, 404 );
		}
		
		if( !$cat )
		{
			$this->registry->output->showError( 'error_generic', 10881 );
		}
		
		if( $this->request['doaction'] == 'move' AND !$this->request['moveto'] )
		{
			$categories		= $this->registry->getClass('categories')->catJumpList( 1, 'view' );
			$category_opts	= '';

			if( count($categories) )
			{
				foreach( $categories as $cat )
				{
					if( !$this->registry->getClass('idmFunctions')->checkPerms( array( 'file_cat' => $cat[0] ) ) )
					{
						continue;
					}

					$category_opts .= "<option value='{$cat[0]}'>{$cat[1]}</option>\n";
				}
			}

			$this->output .= $this->registry->getClass('output')->getTemplate('downloads_submit')->moderateSelectCategory( $category_opts );
			return;
		}
		else if( $this->request['doaction'] == 'move' )
		{
			$category = $this->registry->getClass('categories')->cat_lookup[ intval($this->request['moveto']) ];
			
			if( !$category['cid'] OR !$this->registry->getClass('idmFunctions')->checkPerms( array( 'file_cat' => $category['cid'] ) ) )
			{
				$this->registry->output->showError( 'error_generic', 10882, null, null, 403 );
			}
		}

		$fids 		= array();
		$catWhere	= array_merge( $this->registry->categories->getChildren( $cat ), array( $cat ) );
		
		$this->DB->build( array( 'select' => '*', 'from' => 'downloads_files', 'where' => 'file_id IN(' . implode( ',', $ids ) . ') AND file_cat IN(' . implode( ',', $catWhere ) . ')' ) );
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			switch( $this->request['doaction'] )
			{
				case 'del':
					$canmod = $this->registry->getClass('idmFunctions')->checkPerms( $r, 'modcandel', 'idm_allow_delete' );
				break;
				
				case 'app':
				case 'unapp':
					$canmod = $this->registry->getClass('idmFunctions')->checkPerms( $r, 'modcanapp' );
				break;
				
				case 'move':
					$canmod = $this->registry->getClass('idmFunctions')->checkPerms( $r, 'modcanapp', 'idm_allow_edit' );
				break;
				
				case 'pin':
				case 'unpin':
					$canmod = $this->registry->getClass('idmFunctions')->checkPerms( $r, 'modcanpin' );
				break;
			}
			
			if( $canmod )
			{
				$fids[ $r['file_id'] ] = $r['file_id'];
			}
		}
		
		if( !count($fids) )
		{
			$this->registry->output->showError( 'error_generic', 10883 );
		}
		
		switch( $this->request['doaction'] )
		{
			case 'del':
				$cnt			= $this->moderateLibrary->doMultiDelete( $fids );
				$this->message	.= sprintf( $this->lang->words['modact_message_del'], $cnt );
			break;
			
			case 'app':
				$cnt			= $this->moderateLibrary->doMultiApprove( $fids );
				$this->message	.= sprintf( $this->lang->words['modact_message_app'], $cnt );
			break;
			
			case 'unapp':
				$cnt			= $this->moderateLibrary->doMultiUnapprove( $fids );
				$this->message	.= sprintf( $this->lang->words['modact_message_unapp'], $cnt );
			break;
			
			case 'move':
				$this->moderateLibrary->doMultiMove( $fids, intval($this->request['moveto']) );
				$this->registry->getClass('categories')->rebuildFileinfo( intval($this->request['moveto']) );
			break;
			
			case 'pin':
				$cnt			= $this->moderateLibrary->doMultiPin( $fids );
				$this->message	.= sprintf( $this->lang->words['modact_message_pinned'], $cnt );
			break;
			
			case 'unpin':
				$cnt			= $this->moderateLibrary->doMultiUnpin( $fids );
				$this->message	.= sprintf( $this->lang->words['modact_message_unpinned'], $cnt );
			break;
		}
		
		IPSCookie::set('modfileids', '', 0);

		$this->registry->getClass('categories')->rebuildFileinfo( $cat );
		$this->registry->getClass('categories')->rebuildStatsCache();
		
		$this->registry->output->redirectScreen( $this->lang->words['file_mmod_success'], $this->settings['base_url'] . "app=downloads&amp;showcat={$cat}", $this->registry->getClass('categories')->cat_lookup[ $cat ]['cname_furl'], 'idmshowcat' );
	}

	/**
	 * Version control gateway
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _versionControlGateway()
    {
	    $id		= intval($this->request['id']);
	    $vid	= intval($this->request['rid']);

		if( !$id )
		{
			$this->registry->output->showError( 'error_generic', 10887, null, null, 404 );
		}
		
		if( !$vid )
		{
			$this->registry->output->showError( 'error_generic', 10888 );
		}	
	    
	    $file	= $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_files', 'where' => 'file_id=' . $id ) );
	    $ver	= $this->DB->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_filebackup', 'where' => 'b_fileid=' . $id . ' AND b_id=' . $vid ) );
	    
	    if( !$file['file_id'] OR !$ver['b_id'] )
	    {
	    	$this->registry->output->showError( 'error_generic', 10889, null, null, 404 );
		}		    
		    
		$candelete = $this->registry->getClass('idmFunctions')->checkPerms( $file, 'modcandel', 'idm_allow_delete' );
		
		if( !$candelete )
		{
			$this->registry->output->showError( 'not_your_file', 10890, null, null, 403 );
		}
		
		//-------------------------------------------
		// Permissions check out, manage
		//-------------------------------------------
		
		$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/classes/versioning.php', 'versioningLibrary', 'downloads' );
		$versions 		= new $classToLoad( $this->registry );
		$text			= "";
						
		switch( $this->request['process'] )
		{
			case 'restore':
				$versions->restore( $file, $vid );
				$text = 'version_restore_succesful';
			break;
				
			case 'hide':
				$versions->hide( $file, $vid );
				$text = 'version_hide_succesful';
			break;
				
			case 'unhide':
				$versions->unhide( $file, $vid );
				$text = 'version_unhide_succesful';
			break;
				
			case 'delete':
				$versions->remove( $file, $vid, $ver, $file );
				$text = 'version_remove_succesful';
			break;
		}
		
		if( $versions->error )
		{
			$this->registry->output->showError( $versions->error, 10891 );
		}
		else
		{
			$this->registry->output->redirectScreen( $this->lang->words[ $text ], $this->settings['base_url'] . "app=downloads&amp;showfile=" . $id, $file['file_name_furl'], 'idmshowfile' );
		}
	}    
	
	/**
	 * Perform moderator action
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _doModAction( )
	{
		/* Security Check */
		if ( $this->request['secure_key'] != $this->member->form_hash )
		{
			$this->registry->output->showError( 'no_permission', 10799, null, null, 403 );
		}
		
		$this->message = "";

		$ids	= IPSLib::cleanIntArray( $this->request['selectedfileids'] );

		if( !count($ids) )
		{
			$this->registry->output->showError( 'noselectedfiles', 10892.1, null, null, 403 );
		}
		
		$this->DB->build( array( 'select'	=> 'file_id, file_cat',
								 'from'		=> 'downloads_files',
								 'where'	=> 'file_id IN(' . implode( ',', $ids ) . ')' 
						)		);
		$outer = $this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
 			$canapp		= $this->registry->getClass('idmFunctions')->checkPerms( $r );
			$canbroke	= $this->registry->getClass('idmFunctions')->checkPerms( $r, 'modcanbrok' );

	 		switch( $this->request['type'] )
	 		{
		 		case 'app':
		 			if( !$canapp )
		 			{
		 				$this->registry->output->showError( 'no_permitted_categories', 10892, null, null, 403 );
					}
		 		break;

		 		case 'broke':
		 			if( !$canbroke )
		 			{
		 				$this->registry->output->showError( 'no_permitted_categories', 10893, null, null, 403 );
					}
		 		break;
		 		
		 		default:
			 		$this->message = $this->lang->words['modact_message_huh'];
			 		$this->_displayPanel();
			 		return;
			 	break;
		 	}
	 	}

 		switch( $this->request['type'] )
 		{
	 		case 'app':
	 			if( $this->request['doaction'] == 'del' )
	 			{
		 			$cnt = $this->moderateLibrary->doMultiDelete( $ids );
		 			
		 			$this->message .= sprintf( $this->lang->words['modact_message_del'], $cnt );
	 			}
	 			else if( $this->request['doaction'] == 'app' )
	 			{
		 			$cnt = $this->moderateLibrary->doMultiApprove( $ids );
 			
		 			$this->message .= sprintf( $this->lang->words['modact_message_app'], $cnt );
	 			}
	 			else if( $this->request['doaction'] == 'unapp' )
	 			{
		 			$cnt = $this->moderateLibrary->doMultiUnapprove( $ids );
 			
		 			$this->message .= sprintf( $this->lang->words['modact_message_unapp'], $cnt );
	 			}
	 			else
	 			{
		 			$this->message = $this->lang->words['modact_message_huh'];
		 			$this->_displayPanel();
		 			return;
	 			}
	 		break;

	 		case 'broke':
	 			if( $this->request['brokeaction'] == 'del' )
	 			{
		 			$cnt = $this->moderateLibrary->doMultiDelete( $ids );
	 			
		 			$this->message .= sprintf( $this->lang->words['modact_message_del'], $cnt );
	 			}
	 			else if( $this->request['brokeaction'] == 'rem' )
	 			{
	 				$cnt = $this->moderateLibrary->doMultiUnbroke( $ids );

		 			$this->message .= sprintf( $this->lang->words['modact_message_br'], $cnt );
	 			}
	 			else
	 			{
		 			$this->message = $this->lang->words['modact_message_huh'];
		 			$this->_displayPanel();
		 			return;
	 			}
	 		break;
	 	}
	 	
		$this->registry->getClass('categories')->rebuildFileinfo('all');
		$this->registry->getClass('categories')->rebuildStatsCache();

 		$this->_displayPanel();
	}	
	
	/**
	 * Display mod panel
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _displayPanel( )
	{
		if( $this->memberData['g_is_supmod'] )
		{
			$canapp   	= 1;
			$canbroke 	= 1;
			$appcats 	= '*';
			$brokecats 	= '*';
		}
		else
		{
			if( is_array( $this->registry->getClass('categories')->group_mods[ $this->memberData['member_group_id'] ] ) )
			{
				if( count($this->registry->getClass('categories')->group_mods[ $this->memberData['member_group_id'] ]) )
				{
					foreach( $this->registry->getClass('categories')->group_mods[ $this->memberData['member_group_id'] ] as $k => $v )
					{
						if( $v['modcanapp'] )
						{
							$canapp = 1;
							$appcats = $v['modcats'];
						}
						if( $v['modcanbrok'] )
						{
							$canbroke = 1;
							$brokecats = $v['modcats'];
						}
					}
				}
			}
			else if( is_array( $this->registry->getClass('categories')->mem_mods[ $this->memberData['member_id'] ] ) )
			{
				if( count($this->registry->getClass('categories')->mem_mods[ $this->memberData['member_id'] ]) )
				{
					foreach( $this->registry->getClass('categories')->mem_mods[$this->memberData['member_id'] ] as $k => $v )
					{
						if( $v['modcanapp'] )
						{
							$canapp = 1;
							$appcats = $v['modcats'];
						}
						if( $v['modcanbrok'] )
						{
							$canbroke = 1;
							$brokecats = $v['modcats'];
						}
					}
				}
			}
		}

		if( $canapp == 0 AND $canbroke == 0 )
		{
			$this->registry->output->showError( 'no_permitted_categories', 10894, null, null, 403 );
		}

		//----------------------------------
		// Get Files Pending Approval
		//----------------------------------
		
		$limiter	= $appcats == '*' ? '' : " AND f.file_cat IN({$appcats})";
		$results	= array();
		
		if( $canapp AND $canbroke )
		{
			$this->DB->build( array(
										'select'	=> 'f.*',
										'from'		=> array( 'downloads_files' => 'f' ),
										'where'		=> "(f.file_broken=1 OR f.file_open=0)" . $limiter,
										'add_join'	=> array(
															array(
																	'select'	=> 'm.members_display_name, m.members_seo_name',
																	'from'		=> array( 'members' => 'm' ),
																	'where'		=> 'm.member_id=f.file_submitter',
																	'type'		=> 'left',
																)
															)
								)		);
			$this->DB->execute();
			
			while( $row = $this->DB->fetch() )
			{
				$row['_isRead']	= $this->registry->classItemMarking->isRead( array( 'forumID' => $row['file_cat'], 'itemID' => $row['file_id'], 'itemLastUpdate' => $row['file_updated'] ), 'downloads' );
				
				if( $row['file_broken'] == 1 )
				{
					$results['broken'][] = $row;
				}
				
				if( $row['file_open'] == 0 )
				{
					$results['open'][] = $row;
				}
			}
		}
		else if( $canapp )
		{
			$this->DB->build( array(
										'select'	=> 'f.*',
										'from'		=> array( 'downloads_files' => 'f' ),
										'where'		=> "f.file_open=0" . $limiter,
										'add_join'	=> array(
															array(
																	'select'	=> 'm.members_display_name, m.members_seo_name',
																	'from'		=> array( 'members' => 'm' ),
																	'where'		=> 'm.member_id=f.file_submitter',
																	'type'		=> 'left',
																)
															)
								)		);
			$this->DB->execute();
			
			while( $row = $this->DB->fetch() )
			{
				$row['_isRead']	= $this->registry->classItemMarking->isRead( array( 'forumID' => $row['file_cat'], 'itemID' => $row['file_id'], 'itemLastUpdate' => $row['file_updated'] ), 'downloads' );
				
				$results['open'][] = $row;
			}			
		}
		else if( $canbroke )
		{
			$limiter	= $brokecats == '*' ? '' : " AND f.file_cat IN({$brokecats})";
			
			$this->DB->build( array(
										'select'	=> 'f.*',
										'from'		=> array( 'downloads_files' => 'f' ),
										'where'		=> "f.file_broken=1" . $limiter,
										'add_join'	=> array(
															array(
																	'select'	=> 'm.members_display_name, m.members_seo_name',
																	'from'		=> array( 'members' => 'm' ),
																	'where'		=> 'm.member_id=f.file_submitter',
																	'type'		=> 'left',
																)
															)
								)		);
			$this->DB->execute();

			while( $row = $this->DB->fetch() )
			{
				$row['_isRead']	= $this->registry->classItemMarking->isRead( array( 'forumID' => $row['file_cat'], 'itemID' => $row['file_id'], 'itemLastUpdate' => $row['file_updated'] ), 'downloads' );
				
				$results['broken'][] = $row;
			}
		}	
		
		$this->output .= $this->registry->getClass('output')->getTemplate('downloads_other')->moderatorPanel( $this->message, $canapp, $canbroke, $results );				

		$this->registry->output->addNavigation( $this->lang->words['moderate_nav'], '' );

		return;
	}
	
	/**
	 * Show form to report a file broken
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _reportBroken()
    {
		/* Security Check */
		if ( $this->request['secure_key'] != $this->member->form_hash )
		{
			$this->registry->output->showError( 'no_permission', 10799, null, null, 403 );
		}
		
		if( !$this->memberData['idm_report_files'] )
		{
			$this->registry->output->showError( 'no_permission', 107999, null, null, 403 );
		}
		
		$id		= intval($this->request['id']);
		
		$file	= $this->DB->buildAndFetch( array(	'select'	=> 'f.*', 
													'from'		=> array( 'downloads_files' => 'f' ), 
													'where'		=> 'f.file_id=' . $id,
													'add_join'	=> array(
																		array(
																			'select'	=> 'm.*',
																			'from'		=> array( 'members' => 'm' ),
																			'where'		=> 'm.member_id=f.file_submitter',
																			'type'		=> 'left',
																			),
													 					)
											)		);
		
		if( !$file['file_id'] )
		{
			$this->registry->output->showError( 'cannot_find_to_report', 10895, null, null, 404 );
		}

		//-----------------------------------------
		// Load and config the post parser
		//-----------------------------------------

		IPSText::getTextClass('bbcode')->parse_bbcode	= 1;
		IPSText::getTextClass('bbcode')->parse_smilies	= 1;
		IPSText::getTextClass('bbcode')->parse_html		= 0;

		//-----------------------------------------
		// Show form if not submitted
		//-----------------------------------------
		
		if( !$this->request['do_broken'] )
		{
			$this->output = $this->registry->getClass('output')->getTemplate('downloads_submit')->submitBrokenFile( $file, IPSText::getTextClass('editor')->showEditor( '', 'Post' ) );

			return;
		}

		//-----------------------------------------
		// Save report
		//-----------------------------------------
		
		if( IPSText::getTextClass('editor')->method == 'rte' )
		{
			$_POST['Post'] = IPSText::getTextClass('bbcode')->convertForRTE( $_POST['Post'] );
		}

		$reason = IPSText::getTextClass('bbcode')->preDbParse( IPSText::getTextClass('editor')->processRawPost( 'Post' ) );			
	
		if( !trim($reason) )
		{
			$this->registry->output->showError( 'reason_report_req', 10895.2 );
		}

		$this->DB->update( "downloads_files", array( 'file_broken' => 1, 'file_broken_reason' => $reason, 'file_broken_info' => $this->memberData['member_id'] . '|' . $this->memberData['members_display_name'] . '|' . time() ), "file_id=" . $id );
		
		$this->registry->getClass('categories')->rebuildFileinfo( $file['file_cat'] );
		
		//-----------------------------------------
		// Send notification...
		//-----------------------------------------
		
		$_url	= $this->registry->output->buildSEOUrl( 'app=downloads&amp;showfile=' . $file['file_id'], 'public', $file['file_name_furl'], 'idmshowfile' );

		$classToLoad		= IPSLib::loadLibrary( IPS_ROOT_PATH . '/sources/classes/member/notifications.php', 'notifications' );
		$notifyLibrary		= new $classToLoad( $this->registry );

		$notifyLibrary->setMember( $file );
		$notifyLibrary->setFrom( $this->memberData );
		$notifyLibrary->setNotificationKey( 'file_mybroken' );
		$notifyLibrary->setNotificationUrl( $_url );
		$notifyLibrary->setNotificationText( sprintf( $this->lang->words['moderate_filebroke'], $file['members_display_name'], $file['file_name'] ) );
		$notifyLibrary->setNotificationTitle( sprintf( $this->lang->words['moderate_subjectbroke'], $_url, $file['file_name'] ) );
		try
		{
			$notifyLibrary->sendNotification();
		}
		catch( Exception $e ){}
		
		$moderators	= $this->registry->getClass('idmFunctions')->returnModerators();
		
		if( is_array($moderators) AND count($moderators) )
		{
			$_modPanel	= $this->registry->output->buildSEOUrl( 'app=downloads&module=moderate', 'public' );
			
			foreach( $moderators as $moderator )
			{
				//-----------------------------------------
				// Don't send notification to yourself
				//-----------------------------------------
				
				if( $moderator['member_id'] == $this->memberData['member_id'] )
				{
					continue;
				}

				$notifyLibrary->setMember( $moderator );
				$notifyLibrary->setFrom( $this->memberData );
				$notifyLibrary->setNotificationKey( 'file_broken' );
				$notifyLibrary->setNotificationUrl( $_url );
				$notifyLibrary->setNotificationText( sprintf( $this->lang->words['moderate_modfilebroke'], $moderator['members_display_name'], $file['file_name'], $_modPanel ) );
				$notifyLibrary->setNotificationTitle( sprintf( $this->lang->words['moderate_modsubjectbroke'], $_url, $file['file_name'] ) );
				try
				{
					$notifyLibrary->sendNotification();
				}
				catch( Exception $e ){}
			}
		}

		
		//-----------------------------------------
		// Redirect user
		//-----------------------------------------
		
		$this->registry->output->redirectScreen( $this->lang->words['moderate_broken'], $this->settings['base_url'] . "app=downloads&amp;showfile={$id}", $file['file_name_furl'], 'idmshowfile' );
	}
	
	/**
	 * Remove single broken file flag
	 *
	 * @return	void		[Outputs to screen]
	 */	
	protected function _reportUnbroken( )
    {
		$id		= intval($this->request['id']);
		
		$file	= $this->DB->buildAndFetch( array(	'select'	=> '*',
													'from'		=> 'downloads_files',
													'where'		=> 'file_id=' . $id
											)		);
		
		if( !$file['file_id'] )
		{
			$this->registry->output->showError( 'cannot_find_to_unreport', 10896, null, null, 404 );
		}

		if( !$this->moderateLibrary->doMultiUnbroke( array( $id ) ) )
		{
			$this->registry->output->showError( 'cannot_find_to_unreport', 10897, null, null, 403 );
		}
		
		$this->registry->getClass('categories')->rebuildFileinfo( $file['file_cat'] );

		$this->registry->output->redirectScreen( $this->lang->words['moderate_unbroken'], $this->settings['base_url'] . "app=downloads&amp;showfile={$id}", $file['file_name_furl'], 'idmshowfile' );
	}
}
