<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Downloads -> Mark As Read command class
 * Last Updated: $Date: 2010-11-01 21:50:48 -0400 (Mon, 01 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		Tuesday 1st March 2005 (11:52)
 * @version		$Rev: 7076 $
 *
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class public_downloads_display_markasread extends ipsCommand
{
	/**
	 * Main execution point
	 *
	 * @access	public
	 * @param	object	ipsRegistry reference
	 * @return	void
	 */
	public function doExecute( ipsRegistry $registry )
	{
		//-----------------------------------------
		// What are we doing?
		//-----------------------------------------
		
		switch( $this->request['marktype'] )
		{
			default:
			case 'cat':
				return $this->markCategoryAsRead();
			break;
			case 'all':
				return $this->markDownloadsAsRead();
			break;
		}
	}
	
	/**
	 * Mark download manager as read
	 *
	 * @access	public
	 * @return	void
	 */
 	public function markDownloadsAsRead()
 	{
        //-----------------------------------------
        // Check
        //-----------------------------------------
        
        if ( $this->request['k'] != $this->member->form_hash )
        {
        	$this->registry->getClass('output')->showError( 'no_permission', 20812, null, null, 403 );
        }

		$this->registry->classItemMarking->disableInstantSave();
		$this->registry->classItemMarking->markAppAsRead( 'downloads' );

		$this->registry->getClass('output')->silentRedirect( $this->settings['base_url'] . 'app=downloads', 'false', 'app=downloads' );
	}
	
	/**
	 * Mark a category (and possibly subcategories) as read
	 *
	 * @return	void
	 */
	public function markCategoryAsRead()
	{
		//-----------------------------------------
    	// INIT
    	//-----------------------------------------
    	
		$cat_id			= intval( $this->request['catid'] );
        $return_to_id	= intval( $this->request['returntocatid'] );
        $cat_data		= $this->registry->getClass('categories')->cat_lookup[ $cat_id ];
        $children		= $this->registry->getClass('categories')->getChildren( $cat_data['cid'] );
        $save			= array();
        
        //-----------------------------------------
        // Check
        //-----------------------------------------
        
        if ( ! $cat_data['cid'] )
        {
        	$this->registry->getClass('output')->showError( 'markread_no_id', 10340, null, null, 404 );
        }
        
        //-----------------------------------------
        // Come from the index? Add kids
        //-----------------------------------------
       
        if ( $this->request['i'] )
        {
			if ( is_array( $children ) and count($children) )
			{
				foreach( $children as $id )
				{
					$this->registry->classItemMarking->markRead( array( 'forumID' => $id ) );
				}
			}
        }
        
        //-----------------------------------------
        // Add in the current forum...
        //-----------------------------------------
        
        $this->registry->classItemMarking->markRead( array( 'forumID' => $cat_id ) );
        
        //-----------------------------------------
        // Save it...
        //-----------------------------------------
        
        if ( $this->memberData['member_id'] )
        {
        	$this->registry->classItemMarking->writeMyMarkersToDB();
        }
		
		//-----------------------------------------	
        // Where are we going back to?
        //-----------------------------------------
        
        if ( $return_to_id )
        {
        	//-----------------------------------------
        	// Its a sub forum, lets go redirect to parent forum
        	//-----------------------------------------
        	
        	$this->registry->getClass('output')->silentRedirect( $this->settings['base_url'] . "app=downloads&amp;showcat=" . $return_to_id );
        }
        else
        {
        	$this->registry->getClass('output')->silentRedirect( $this->settings['base_url'] . "app=downloads" );
        }
	}
}
