<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * IDM userCP pages
 * Last Updated: $Date: 2010-11-23 18:43:36 -0500 (Tue, 23 Nov 2010) $
 * </pre>
 *
 * @author 		$Author: bfarber $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		6/24/2008
 * @version		$Revision: 7283 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class usercpForms_downloads extends public_core_usercp_manualResolver implements interface_usercp
{
	/**
	 * Tab name
	 * This can be left blank and the application title will
	 * be used
	 *
	 * @access	public
	 * @var		string
	 */
	public $tab_name						= '';
	
	/**
	 * Default area code
	 *
	 * @access	public
	 * @var		string
	 */
	public $defaultAreaCode					= 'myfiles';
	
	/**
	 * OK Message
	 * This is an optional message to return back to the framework
	 * to replace the standard 'Settings saved' message
	 *
	 * @access	public
	 * @var		string
	 */
	public $ok_message						= '';
	
	/**
	 * Hide 'save' button and form elements
	 * Useful if you have custom output that doesn't
	 * require it
	 *
	 * @access	public
	 * @var		boolean
	 */
	public $hide_form_and_save_button		= true;
	
	/**
	 * If you wish to allow uploads, set a value for this
	 *
	 * @access	public
	 * @var		int
	 */
	public $uploadFormMax					= 0;	
	
	/**
	 * Initiate this module
	 *
	 * @access	public
	 * @return	void
	 */
	public function init()
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$this->request['st'] = intval( $this->request['st'] );
		
		//-----------------------------------------
		// Load our class file
		//-----------------------------------------
		
		if( $this->request['tab'] == 'downloads' )
		{
			$classToLoad			= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . '/app_class_downloads.php', 'app_class_downloads', 'downloads' );
			$app_class_downloads	= new $classToLoad( ipsRegistry::instance() );
		}
	}
	
	/**
	 * Return links for this tab
	 * You may return an empty array or FALSE to not have
	 * any links show in the tab.
	 *
	 * The links must have 'area=xxxxx'. The rest of the URL
	 * is added automatically.
	 * 'area' can only be a-z A-Z 0-9 - _
	 *
	 * @access	public
	 * @author	Brandon Farber
	 * @return	array 		array of links
	 */
	public function getLinks()
	{
		$array = array();
		
		$array[] = array( 'url'		=> 'area=myfiles',
						  'title'	=> $this->lang->words['ucp_manage_files'],
						  'area'	=> 'myfiles',
						  'active'	=> $this->request['tab'] == 'downloads' && $this->request['area'] == 'myfiles' ? 1 : 0 );
						
		$array[] = array( 'url'		=> 'area=mydownloads',
						  'title'	=> $this->lang->words['ucp_manage_downloads'],
						  'area'	=> 'mydownloads',
						  'active'	=> $this->request['tab'] == 'downloads' && $this->request['area'] == 'mydownloads' ? 1 : 0 );

		return $array;
	}
	
	
	/**
	 * Run custom event
	 *
	 * If you pass a 'do' in the URL / post form that is not either:
	 * save / save_form or show / show_form then this function is loaded
	 * instead. You can return a HTML chunk to be used in the UserCP (the
	 * tabs and footer are auto loaded) or redirect to a link.
	 *
	 * If you are returning HTML, you can use $this->hide_form_and_save_button = 1;
	 * to remove the form and save button that is automatically placed there.
	 *
	 * @access	public
	 * @author	Brandon Farber
	 * @param	string				Current 'area' variable (area=xxxx from the URL)
	 * @return	mixed				html or void
	 */
	public function runCustomEvent( $currentArea )
	{
		//-----------------------------------------
		// INIT
		//-----------------------------------------
		
		$html = '';
		
		if( count($this->registry->getClass('categories')->member_access['show']) == 0 )
		{
			if( count($this->registry->getClass('categories')->cat_lookup) == 0 )
			{
				$this->registry->output->showError( 'no_downloads_cats_created', 1080, null, null, 403 );
			}
			else
			{
				$this->registry->output->showError( 'no_downloads_permissions', 1081, null, null, 403 );
			}
		}

		//-----------------------------------------
		// Return
		//-----------------------------------------
		
		return $html;
	}

	/**
	 * UserCP Form Show
	 *
	 * @access	public
	 * @author	Brandon Farber
	 * @param	string	Current area as defined by 'get_links'
	 * @param	array 	Errors
	 * @return	string	Processed HTML
	 */
	public function showForm( $current_area, $errors=array() )
	{
		if( count($this->registry->getClass('categories')->member_access['show']) == 0 )
		{
			if( count($this->registry->getClass('categories')->cat_lookup) == 0 )
			{
				$this->registry->output->showError( 'no_downloads_cats_created', 1082, null, null, 403 );
			}
			else
			{
				$this->registry->output->showError( 'no_downloads_permissions', 1083, null, null, 403 );
			}
		}
		
		//-----------------------------------------
		// Where to go, what to see?
		//-----------------------------------------
	
		switch( $current_area )
		{
			default:
			case 'myfiles':
				return $this->_showMyFiles();
			break;
			case 'mydownloads':
				return $this->_showMyDownloads();
			break;
		}
	}
	
	/**
	 * Show my files
	 *
	 * @access	private
	 * @author	Brandon Farber
	 * @return	string  		Processed HTML
	 */
	private function _showMyFiles()
	{
		$orderby 	= $this->request['order'] && in_array( $this->request['order'], 
							array( 'file_submitted', 'file_updated', 'file_downloads', 'file_rating', 'file_views', 'file_name' ) ) ?
							$this->request['order'] : 'file_name';

		$ordertype 	= $this->request['ascdesc'] && in_array( $this->request['ascdesc'],
							array( 'asc', 'desc' ) ) ? $this->request['ascdesc'] : 'asc';

		$st			= intval($this->request['st']) > 0 ? intval($this->request['st']) : 0;
		
		$records	= array();
							
		$this->request['ascdesc'] =  $ordertype == 'asc' ? 'desc' : 'asc' ;
		
		$cnt = $this->DB->buildAndFetch( array ( 'select'	=> 'count(*) as num',
										  				'from'		=> 'downloads_files',
										  				'where'		=> "file_submitter={$this->memberData['member_id']}",
												)		);

		$page_links	= $this->registry->output->generatePagination( array(	'totalItems'		=> $cnt['num'],
																   			'itemsPerPage'		=> 20,
																   			'currentStartValue'	=> $st,
																   			'baseUrl'			=> "app=core&amp;module=usercp&amp;tab=downloads&amp;area=myfiles&amp;order={$orderby}&amp;ascdesc={$ordertype}",
																  )	  	 );		

		$this->DB->build( array ( 'select'	=> '*',
						  				'from'		=> 'downloads_files',
						  				'where'		=> "file_submitter={$this->memberData['member_id']}",
						  				'order'		=> $orderby . " " . $ordertype,
						  				'limit'		=> array( $st, 20 ),
								)		);
		$files = $this->DB->execute();
		
		while( $file = $this->DB->fetch($files) )
		{
			$records[] = $file;
		}

       	return $this->registry->getClass('output')->getTemplate('downloads_external')->myFiles( $page_links, $records );
	}
	
	/**
	 * Show my downloads
	 *
	 * @access	private
	 * @author	Brandon Farber
	 * @return	string  		Processed HTML
	 */
	private function _showMyDownloads()
	{
		$orderby 	= $this->request['order'] && in_array( $this->request['order'], 
							array( 'file_submitted', 'file_updated', 'file_downloads', 'file_rating', 'file_views', 'file_name' ) ) ?
							$this->request['order'] : 'file_name';

		$ordertype 	= $this->request['ascdesc'] && in_array( $this->request['ascdesc'],
							array( 'asc', 'desc' ) ) ? $this->request['ascdesc'] : 'asc';

		$st			= intval($this->request['st']) > 0 ? intval($this->request['st']) : 0;
		
		$records	= array();
							
		$this->request['ascdesc'] =  $ordertype == 'asc' ? 'desc' : 'asc' ;
		
		$cnt = $this->DB->buildAndFetch( array (	'select'	=> 'count(*) as num',
									  				'from'		=> array( 'downloads_downloads' => 'df' ),
									  				'where'		=> "df.dmid={$this->memberData['member_id']} AND f.file_id IS NOT NULL",
									  				'add_join'	=> array(
									  									array(
									  										'from'	=> array( 'downloads_files' => 'f' ),
									  										'where'	=> 'f.file_id=df.dfid',
									  										'type'	=> 'left',
									  										)
									  									)
												)		);

		$page_links	= $this->registry->output->generatePagination( array(	'totalItems'		=> $cnt['num'],
																   			'itemsPerPage'		=> 20,
																   			'currentStartValue'	=> $st,
																   			'baseUrl'			=> "app=core&amp;module=usercp&amp;tab=downloads&amp;area=mydownloads&amp;order={$orderby}&amp;ascdesc={$ordertype}",
																  )	  	 );		

		$this->DB->build( array ( 'select'	=> 'f.*',
						  				'from'		=> array( 'downloads_downloads' => 'd' ),
						  				'where'		=> "d.dmid={$this->memberData['member_id']} AND f.file_id IS NOT NULL",
						  				'order'		=> 'f.' . $orderby . " " . $ordertype,
						  				'limit'		=> array( $st, 20 ),
						  				'add_join'	=> array(
						  									array(
						  										'select'	=> 'd.*',
						  										'from'		=> array( 'downloads_files' => 'f' ),
						  										'where'		=> 'd.dfid=f.file_id',
						  										'type'		=> 'left'
						  										)
						  									)
								)		);
		$files = $this->DB->execute();
		
		while( $file = $this->DB->fetch($files) )
		{
			$records[] = $file;
		}

       	return $this->registry->getClass('output')->getTemplate('downloads_external')->myDownloads( $page_links, $records );
	}

	/**
	 * UserCP Form Check
	 *
	 * @access	public
	 * @author	Brandon Farber
	 * @param	string	Current area as defined by 'get_links'
	 * @return	string	Processed HTML
	 */
	public function saveForm( $current_area )
	{
		//-----------------------------------------
		// Where to go, what to see?
		//-----------------------------------------
		
		return '';
	}
}