<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.3.0
 * Returns HTML for the downloads (optional class, not required)
 * Last Updated: $Date: 2010-02-19 01:29:54 +0000 (Fri, 19 Feb 2010) $
 * </pre>
 *
 * @author 		$author$
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Board
 * @subpackage	Downloads
 * @link		http://ipb.mxneo.ru
 * @version		$Rev: 5855 $
 **/

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class search_form_downloads
{
	/**
	 * Construct
	 *
	 * @return	void
	 */
	public function __construct()
	{
		/* Make object */
		$this->registry   =  ipsRegistry::instance();
		$this->DB         =  $this->registry->DB();
		$this->settings   =& $this->registry->fetchSettings();
		$this->request    =& $this->registry->fetchRequest();
		$this->lang       =  $this->registry->getClass('class_localization');
		$this->member     =  $this->registry->member();
		$this->memberData =& $this->registry->member()->fetchMemberData();
		$this->cache      =  $this->registry->cache();
		$this->caches     =& $this->registry->cache()->fetchCaches();
		
		$this->registry->class_localization->loadLanguageFile( array( 'public_downloads' ), 'downloads' );

	}
	
	/**
	 * Return sort drop down
	 * 
	 * @return	array
	 */
	public function fetchSortDropDown()
	{
		$array = array( 
						'date'		=> $this->lang->words['search_sort_submitted'],
						'update'	=> $this->lang->words['search_sort_updated'],
					    'title'		=> $this->lang->words['search_sort_title'],
					    'views'		=> $this->lang->words['search_sort_views'],
					    'downloads'	=> $this->lang->words['search_sort_downloads'],
					    'rating'	=> $this->lang->words['search_sort_rating'],
					);
		
		return $array;
	}

	/**
	 * Retuns the html for displaying the forum category filter on the advanced search page
	 *
	 * @return	string	Filter HTML
	 */
	public function getHtml()
	{
		/* Make sure class_forums is setup */
		if( ipsRegistry::isClassLoaded('categories') !== TRUE )
		{
			/* Get category class */
			$classToLoad	= IPSLib::loadLibrary( IPSLib::getAppDir( 'downloads' ) . "/sources/classes/categories.php", 'class_categories', 'downloads' );
			
			$this->registry->setClass( 'categories', new $classToLoad( $this->registry ) );
			$this->registry->getClass('categories')->normalInit();
			$this->registry->getClass('categories')->setMemberPermissions();
		}

		return array( 'title' => IPSLib::getAppTitle('downloads'), 'html' => ipsRegistry::getClass('output')->getTemplate('downloads_external')->downloadsAdvancedSearchFilters( $this->registry->getClass('categories')->catJumpList( true, 'show' ) ) );
	}
}
