<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Downloads - Items Extension
 * Last Updated: $Date: 2010-06-04 07:28:06 -0400 (Fri, 04 Jun 2010) $
 * </pre>
 *
 * @author 		$Author: mark $
 * @copyright	(c) 2010 Invision Power Services, Inc.
 * @license		http://ipb.mxneo.ru/community/board/license.html
 * @package		IP.Downloads
 * @link		http://ipb.mxneo.ru
 * @since		26th January 2010
 * @version		$Revision: 6461 $
 */

class items_downloads
{
	private $fileCache = array();

	/**
	 * Get Package Image
	 *
	 * @param	string	App
	 * @param	string	Item type
	 * @param	mixed	Item ID
	 * @return	string	URL to image
	 */
	public function getPackageImage( $app, $type, $id )
	{
		if ( $type != 'file' )
		{
			return NULL;
		}
		
		if ( !array_key_exists( $id, $this->fileCache ) )
		{
			$file = ipsRegistry::DB()->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_files_records', 'where' => "record_file_id={$id} AND ( record_type='ssupload' or record_type='sslink' )", 'limit' => 1 ) );
			if ( $file['record_id'] )
			{
				switch ( $file['record_storagetype'] )
				{
					case 'web':
						$this->fileCache[$id] = substr( str_replace( '{root_path}', '', ipsRegistry::$settings['idm_localsspath'] ) . '/' . $file['record_location'], 1 );
						break;
						
					default:
						$this->fileCache[$id] = NULL;
				}
			}
		}
						
		if ( $this->fileCache[$id] and file_exists( $this->fileCache[$id] ) )
		{
			return $this->fileCache[$id];
		}
		else
		{
			return ipsRegistry::$settings['img_url'] . '/nexus/default_product.png';
		}
	}

	/**
	 * Get item types
	 *
	 * @return	array	Items this application provides
	 */
	public function getItems()
	{
		$return['file'] = "File";
		return $return;
	}
	
	/**
	 * Init HTML
	 * Called before any form_* methods so that the skin_cp can be loaded
	 */
	public function init_html()
	{
		$this->html = ipsRegistry::getClass('output')->loadTemplate( 'cp_skin_idm_nexus', 'downloads' );
	}
	
	/**
	 * Add Item
	 *
	 * @param	invoice	Invoice object
	 * @return	string	HTML to display
	 */
	public function form_file( $invoice )
	{
		//-----------------------------------------
		// How many paid files do we have?
		//-----------------------------------------
	
		$files = array();
		$count = ipsRegistry::DB()->buildAndFetch( array( 'select' => 'count(*) as count', 'from' => 'downloads_files', 'where' => 'file_cost > 0' ) );
		if ( !$count['count'] )
		{
			ipsRegistry::getClass('output')->showError( "There are no paid files.", 12345 );
		}
		elseif ( $count['count'] < 20 )
		{
			ipsRegistry::DB()->build( array( 'select' => 'file_id, file_name', 'from' => 'downloads_files', 'where' => 'file_cost > 0' ) );
			ipsRegistry::DB()->execute();
			while ( $r = ipsRegistry::DB()->fetch() )
			{
				$files[] = array( $r['file_id'], $r['file_name'] );
			}
		}
	
		return $this->html->add( $invoice->id, $files );
	}
	
	/**
	 * Save Item
	 *
	 * @param	invoice	Invoice object
	 * @return	array	Data to pass to invoiceModel::addItem without 'app' or 'type'
	 */
	public function save_file( $invoice )
	{
		if ( ipsRegistry::$request['file_id'] )
		{
			$id = intval( ipsRegistry::$request['file_id'] );
			$file = ipsRegistry::DB()->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_files', 'where' => 'file_id='.$id ) );
		}
		else
		{
			$name = ipsRegistry::DB()->addSlashes( ipsRegistry::$request['file_name'] );
			$file = ipsRegistry::DB()->buildAndFetch( array( 'select' => '*', 'from' => 'downloads_files', 'where' => "file_name='{$name}'" ) );
		}
		
		if ( !$file['file_id'] )
		{
			ipsRegistry::getClass('output')->showError( "Could not locate file.", 12345 );
		}
	
		return array(
			'act'		=> 'new',
			'cost'		=> $file['file_cost'],
			'itemName'	=> $file['file_name'],
			'physical'	=> FALSE,
			'itemID'	=> $file['file_id'],
			'itemURI'	=> "app=downloads&module=display&section=file&id={$file['file_id']}",
			'payTo'		=> $file['file_submitter'],
			'commission'=> ipsRegistry::$settings['idm_nexus_percent'],
			);
	}

}