<?php
/**
 * cp_skin_dashboard.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

/**
 * Main class
 */
class cp_skin_dashboard
{
	/**
	 * Registry
	 *
     * @access private
	 */
	private $registry;

	/**
	 * Settings
	 *
     * @access private
	 */
	private $settings;

	/**
	 * Language
	 *
     * @access private
	 */
	private $lang;

	/**
	 * Main function
	 *
	 * @access public
	 */
	public function __construct( ipsRegistry $registry )
	{
		//---------------------------------------
		// Registry objects
		//---------------------------------------

		$this->registry 	= $registry;
		$this->settings		= &$this->registry->fetchSettings();
		$this->lang 		= $this->registry->class_localization;
	}

	/**
	 * Overview template
	 *
	 * @access public
	 */
    public function viewOverview( $stats, $array, $status, $version, $response, $news )
    {
        $HTML = "";

        $HTML .= <<<EOF
        <div class='section_title'>
	        <h2>{$this->lang->words['overview']}</h2>
            <center>{$response}</center>
        </div>
EOF;



        if ( $stats['STREAMSTATUS'] == 'error' )
        {
            if( ! $this->settings['host'] OR ! $this->settings['port'] )
            {
                $HTML .= <<<EOF
                <div class='warning'>
                    <p><center><strong>{$this->lang->words['no_details']}</strong>&nbsp;{$this->lang->words['no_details_text']}</center></p>
                </div>
            <br />
EOF;
            }

            else
            {
                $HTML .= <<<EOF
                <div class='warning'>
	                <p>{$stats['ERROR']}</p>
                </div>
            <br />
EOF;
            }
        }

        $HTML .= <<<EOF
        <div class="acp-box" style="float:left; width:50%">
	        <h3>{$this->lang->words['shoutcast_statistics']}</h3>
	        <table class="ipsTable">
		        <tbody>
                    <tr>
			            <td width="60%"><strong>{$this->lang->words['server_status']}</strong></td>
			            <td width="40%">{$array['streamimage']}</td>
		            </tr>

		            <tr>
			            <td><strong>{$this->lang->words['web_hits_count']}</strong></td>
			            <td>{$array['webhits']}</td>
		            </tr>

		            <tr>
			            <td><strong>{$this->lang->words['stream_hits_count']}</strong></td>
			            <td>{$array['streamhits']}</td>
		            </tr>

		            <tr>
			            <td><strong>{$this->lang->words['reported_listeners']}</strong></td>
			            <td>{$array['reportedlisteners']}</td>
		            </tr>

		            <tr>
			            <td><strong>{$this->lang->words['average_listen_time']}</strong></td>
			            <td>{$array['averagelistentime']}</td>
		            </tr>
                </tbody>
            </table>
        </div>

        <div class="acp-box" style="float:right; margin-top:2%; width:48%">
	        <h3>{$this->lang->words['application_information']}</h3>
	        <table class="ipsTable">
		        <tbody>
		            <tr>
			            <td><strong>{$this->lang->words['current_status']}</strong></td>
			            <td><img src='{$this->settings['img_url']}/musicbox/extras/{$status}' /></td>
		            </tr>

		            <tr>
			            <td width="60%"><strong>{$this->lang->words['current_version']}</strong></td>
			            <td width="40%">v{$version}</td>
		            </tr>

		            <tr>
			            <td><strong>{$this->lang->words['application_author']}</strong></td>
			            <td>MrShaun</td>
		            </tr>
                </tbody>
            </table>

            <div class="acp-actionbar">
                <form action="https://www.paypal.com/cgi-bin/webscr" target="_blank" title="{$this->lang->words['suport_project']}" method="post">
                    <input type="hidden" name="cmd" value="_donations">
                    <input type="hidden" name="business" value="mr_shaun@hotmail.co.uk">
                    <input type="hidden" name="lc" value="GB">
                    <input type="hidden" name="item_name" value="MusicBox Donations">
                    <input type="hidden" name="no_note" value="0">
                    <input type="hidden" name="currency_code" value="GBP">
                    <input type="hidden" name="bn" value="PP-DonationsBF:btn_donate_SM.gif:NonHostedGuest">
                    <input type="image" src="" border="0" name="submit" value="{$this->lang->words['donate_now']}" class="button primary">
                </form>
            </div>
        </div>
<br class="clear" />
EOF;

        return $HTML;
    }

	/**
	 * Listeners template
	 *
	 * @access public
	 */
    public function viewListenerHistory( $stats, $listeners )
    {
        $HTML = "";

        if( $listeners == 0 )
        {
            $HTML .= <<<EOF
            <br class="clear" />
            <div class="acp-box">
	            <h3>{$this->lang->words['shoutcast_listeners']}</h3>
	            <table class="ipsTable">
                <tbody>
                    <tr>
		                <td colspan='1'><center>No Reported Listeners Avaliable...</center></td>
	                </tr>
                </tbody>
            </table>
        </div>
    <br />
EOF;

        }

    else
    {
        $HTML .= <<<EOF
        <br class="clear" />
        <div class='acp-box'>
        <h3>{$this->lang->words['shoutcast_listeners']}</h3>
	        <table class='ipsTable'>
            <tbody>
		        <tr>
			        <th width='25%'><center>{$this->lang->words['address']}</center></th>
                    <th width='25%'><center>{$this->lang->words['connect_time']}</center></th>
                    <th width='25%'><center>{$this->lang->words['user_agent']}</center></th>
                    <th width='25%'><center>{$this->lang->words['under_runs']}</center></th>
		        </tr>
EOF;
                foreach( $listeners AS $row )
                {
                    $HTML .= <<<EOF
		            <tr>
		                <td><center>{$row['hostname']}</center></td>
			            <td><center>{$row['connecttime']}</center></td>
                        <td><center>{$row['useragent']}</center></td>
                        <td><center>{$row['underruns']}</center></td>
		            </tr>
EOF;
                }

                $HTML .= <<<EOF
                </tbody>
	        </table>
        </div>
    <br />
EOF;
    }
        return $HTML;
    }

	/**
	 * Songs template
	 *
	 * @access public
	 */
    public function viewSongHistory( $stats, $historys )
    {
        $HTML = "";

        if( $historys == 0 )
        {
            $HTML .= <<<EOF
            <br class="clear" />
            <div class="acp-box">
	            <h3>{$this->lang->words['song_history_last_10']}</h3>
	            <table class="ipsTable">
                <tbody>
                    <tr>
		                <td colspan='1'><center>No Recent Song History Available...</center></td>
	                </tr>
                </tbody>
            </table>
        </div>
    <br />
EOF;

        }

    else
    {
        $HTML .= <<<EOF
        <div class='acp-box'>
        <h3>{$this->lang->words['song_history_last_10']}</h3>
	        <table class='ipsTable'>
            <tbody>
		        <tr>
			        <th width='60%'>{$this->lang->words['song_title']}</th>
			        <th width='40%'>{$this->lang->words['song_date']}</th>
		        </tr>
EOF;

                foreach( $historys AS $row )
                {
                    $HTML .= <<<EOF
		            <tr>
		                <td>{$row['title']}</td>
			            <td>{$row['playedat']}</td>
		            </tr>
EOF;
                }

                $HTML .= <<<EOF
                </tbody>
	        </table>
        </div>
    <br />
EOF;
    }
        return $HTML;
    }

	/**
	 * Version template
	 *
	 * @access public
	 */
    public function viewVersionHistory( $upgrades )
    {
        $HTML = "";

        $HTML .= <<<EOF
        <div class='acp-box'>
        <h3>{$this->lang->words['version_history']}</h3>
	        <table class='ipsTable'>
            <tbody>
                <tr>
			        <th style='width: 60%'>{$this->lang->words['history_version']}</th>
			        <th style='width: 40%'>{$this->lang->words['history_date']}</th>
		        </tr>
EOF;

        foreach( $upgrades AS $upgrade )
        {
            $HTML .= <<<EOF
		    <tr>
		        <td>v{$upgrade['upgrade_version_human']} ({$upgrade['upgrade_version_id']})</td>
			    <td>{$upgrade['date']}</td>
		    </tr>
EOF;
    }

        $HTML .= <<<EOF
            </tbody>
	    </table>
    </div>
EOF;
        return $HTML;
    }
}