<?php
/**
 * ajax.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

/**
 * Main class
 */
class public_musicbox_functions_ajax extends ipsCommand
{
    /**
     * Ajax
     *
     * @access public
     */
    public $ajax;

    /**
     * Stats
     *
     * @access public
     */
	public $stats;

	/**
	 * Main function
	 *
	 * @access public
	 */
	public function doExecute( ipsRegistry $registry )
	{
		//---------------------------------------
		// Registry objects
		//---------------------------------------

		$this->registry = ipsRegistry::instance();
		$this->settings = &$this->registry->fetchSettings();

		//---------------------------------------
		// Load language
		//---------------------------------------

		$this->registry->class_localization->loadLanguageFile( array( 'public_musicbox' ) );

		//---------------------------------------
		// Load ajax class
		//---------------------------------------

		require_once( IPS_KERNEL_PATH . 'classAjax.php' );
		$this->ajax = new classAjax();

		//---------------------------------------
		// Load stats class
		//---------------------------------------

		require_once( IPSLib::getAppDir( 'musicbox' ) . '/modules_public/functions/stats.php' );
		$class = new viewXML( $this->registry );
		$this->stats = $class->getStats();

		//---------------------------------------
		// What to get...
		//---------------------------------------

	    switch( $this->request['get'] )
        {
	        case 'dj':
		        $this->viewDJ();
			break;
		    case 'song':
		        $this->viewSong();
			break;
		    case 'genre':
		        $this->viewGenre();
			break;
		    case 'bitrate':
		        $this->viewBitrate();
			break;
		    case 'listeners':
		        $this->viewListeners();
			break;
		    case 'peaklisteners':
		        $this->viewPeakListeners();
			break;
        }
    }

    /**
     * Dj function
     *
     * @access private
     */
    private function viewDJ()
    {
        if( $this->stats['STREAMSTATUS'] == '1' )
        {
	        return $this->ajax->returnHtml( $this->stats['SERVERTITLE'] );
	    }

        if( $this->stats['STREAMSTATUS'] == '0' )
        {
	        return $this->ajax->returnHtml( $this->lang->words['offline'] );
	    }

	    if( $this->stats['STREAMSTATUS'] == 'error' )
        {
		    return $this->ajax->returnHtml( $this->lang->words['error'] );
	    }
    }

    /**
     * Song function
     *
     * @access private
     */
    private function viewSong()
    {
        if( $this->stats['STREAMSTATUS'] == '1' )
        {
	        return $this->ajax->returnHtml( $this->stats['SONGTITLE'] );
	    }

        if( $this->stats['STREAMSTATUS'] == '0' )
        {
	        return $this->ajax->returnHtml( $this->lang->words['offline'] );
	    }

	    if( $this->stats['STREAMSTATUS'] == 'error' )
        {
		    return $this->ajax->returnHtml( $this->lang->words['error'] );
	    }
    }

    /**
     * Genre function
     *
     * @access private
     */
    private function viewGenre()
    {
        if( $this->stats['STREAMSTATUS'] == '1' )
        {
	        return $this->ajax->returnHtml( $this->stats['SERVERGENRE'] );
	    }

        if( $this->stats['STREAMSTATUS'] == '0' )
        {
	        return $this->ajax->returnHtml( $this->lang->words['offline'] );
	    }

	    if( $this->stats['STREAMSTATUS'] == 'error' )
        {
		    return $this->ajax->returnHtml( $this->lang->words['error'] );
	    }
    }

    /**
     * Bitrate function
     *
     * @access private
     */
    private function viewBitrate()
    {
        if( $this->stats['STREAMSTATUS'] == '1' )
        {
	        return $this->ajax->returnHtml( $this->stats['BITRATE']."&nbsp;kbit/s" );
	    }

        if( $this->stats['STREAMSTATUS'] == '0' )
        {
	        return $this->ajax->returnHtml( $this->lang->words['offline'] );
	    }

	    if( $this->stats['STREAMSTATUS'] == 'error' )
        {
		    return $this->ajax->returnHtml( $this->lang->words['error'] );
	    }
    }

    /**
     * Peak function
     *
     * @access private
     */
    private function viewPeakListeners ()
    {
        if( $this->stats['STREAMSTATUS'] == '1' )
        {
	        return $this->ajax->returnHtml( $this->stats['PEAKLISTENERS']."&nbsp;Of&nbsp;".$this->stats['MAXLISTENERS'] );
        }

        if( $this->stats['STREAMSTATUS'] == '0' )
        {
	        return $this->ajax->returnHtml( $this->lang->words['offline'] );
	    }

	    if( $this->stats['STREAMSTATUS'] == 'error' )
        {
		    return $this->ajax->returnHtml( $this->lang->words['error'] );
	    }
    }

    /**
     * Listeners function
     *
     * @access private
     */
    private function viewListeners()
    {
        if( $this->stats['STREAMSTATUS'] == '1' )
        {
	        return $this->ajax->returnHtml( $this->stats['CURRENTLISTENERS']."&nbsp;Of&nbsp;".$this->stats['MAXLISTENERS'] );
	    }

        if( $this->stats['STREAMSTATUS'] == '0' )
        {
	        return $this->ajax->returnHtml( $this->lang->words['offline'] );
	    }

	    if( $this->stats['STREAMSTATUS'] == 'error' )
        {
		    return $this->ajax->returnHtml( $this->lang->words['error'] );
	    }
    }
}