<?php
/**
 * dashboard.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_ACP' ) )
{
    print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded 'admin.php'.";
    exit();
}

/**
 * Refresh
 */
header( 'Refresh: 60;' );

/**
 * Main class
 */
class admin_musicbox_overview_dashboard extends ipsCommand
{
	/**
	 * Skin object
	 *
     * @access private
	 */
	private $html;

	/**
	 * Shortcut for url
	 *
     * @access private
	 */
	private $form_code;

	/**
	 * Shortcut for url (javascript)
	 *
     * @access private
	 */
	private $form_code_js;

	/**
	 * Main function
	 *
	 * @access public
	 */
    public function doExecute( ipsRegistry $registry )
    {
		//---------------------------------------
		// Load skin
		//---------------------------------------

		$this->html = $this->registry->output->loadTemplate( 'cp_skin_dashboard' );

		//---------------------------------------
		// Load language
		//---------------------------------------

		$this->registry->class_localization->loadLanguageFile( array( 'admin_musicbox' ) );

		//---------------------------------------
		// Setup form codes
		//---------------------------------------

		$this->form_code	= $this->html->form_code	= 'module=overview&amp;section=dashboard';
		$this->form_code_js	= $this->html->form_code_js	= 'module=overview&section=dashboard';

		//---------------------------------------
		// What to do?
		//---------------------------------------

        switch ($this->request['do'])
        {
            case 'overview':
            default:
                $this->viewOverview();
            break;
        }

		//---------------------------------------
		// Pass to CP output hander
		//---------------------------------------

		$this->registry->output->html_main .= $this->registry->output->global_template->global_frame_wrapper();
		$this->registry->output->sendOutput();
    }

	/**
	 * Main overview
	 *
	 * @access public
	 */
    public function viewOverview()
    {
		//---------------------------------------
		// Load xml class
		//---------------------------------------

		require_once( IPS_KERNEL_PATH . 'class_xml.php' );
		$xml = new class_xml();
        $url = base64_decode( "aHR0cDovL3d3dy5iYW5naW50dW5lei5jby51ay9tdXNpY2JveC92ZXJzaW9uLnhtbA==" );

		//---------------------------------------
		// Load stats class
		//---------------------------------------

		require_once( IPSLib::getAppDir( 'musicbox' ) . '/modules_public/functions/stats.php' );
		$class = new viewXML( $this->registry );
		$stats = $class->getStats();

		//---------------------------------------
		// Curl init
		//---------------------------------------

        if ( function_exists( "curl_init" ) )
        {
            $ch = curl_init();
            $timeout = 0;
            curl_setopt( $ch, CURLOPT_URL, $url );
            curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
            curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, $timeout );
            $content = curl_exec( $ch );
            curl_close( $ch );
        }

        else
        {
            $handle = @fopen( $url, "r" );

            if ( $handle !== false )
            {
                @fclose( $handle );
                $content = @file_get_contents( $url );
            }
        }

		//---------------------------------------
		// Xml parser
		//---------------------------------------

        $parser  = $xml->xml_parse_document( $content );

        $news    = $xml->xml_array['information']['data']['news']['VALUE'];
        $up2date = $xml->xml_array['information']['data']['version']['VALUE'];

          $t1 = "<a href='";
          $t2 = "' target='_blank'>";
          $t3 = "</a>";

          $news = preg_replace("/{STARTURL}/i", $t1, $news);
          $news = preg_replace("/{ENDURL}/i", $t2, $news);
          $news = preg_replace("/{CLICKHERE}/i", $t3, $news);

		//---------------------------------------
		// Build are stats array
		//---------------------------------------

        $array = array( 'webhits'           => 0,
                        'streamhits'        => 0,
                        'reportedlisteners' => 0,
                        'averagelistentime' => 0,
                        'streamimage'       => 0 );

		//---------------------------------------
		// Setup are stats array
		//---------------------------------------

        $array['webhits']           = $stats['WEBHITS'];
        $array['streamhits']        = $stats['STREAMHITS'];
        $array['reportedlisteners'] = $stats['REPORTEDLISTENERS'];
        $array['averagelistentime'] = $stats['AVERAGETIME'];
        $array['streamimage']       = $stats['STREAMIMAGE'];

		//---------------------------------------
		// Our we enabled?
		//---------------------------------------

        $status = $this->settings['panel'] ? 'online.png' : 'offline.png';

		//---------------------------------------
		// Version information
		//---------------------------------------

        $v = array( 'app_version' => '' );

        $this->DB->build( array( 'select' => '*',
                                 'from'   => 'core_applications',
                                 'where'  => "app_directory='musicbox'",
                                 'order'  => 'app_version DESC',
                                 'limit'  => array( 1 ) ) );

        $this->DB->execute();

        while ( $row = $this->DB->fetch() )
        {
            $v = $row;
        }

        $version = $v['app_version'];

        if ( $up2date > $version )
        {
            $response = "<div class='information-box'><center><strong>{$this->lang->words['new_version_available']}</strong>&nbsp;{$news}</center></div><br />";
        }

        else
        {
            $response = "";
        }

		//---------------------------------------
		// Pass to CP skin file
		//---------------------------------------

        $this->registry->output->html .= $this->html->viewOverview( $stats, $array, $status, $version, $response, $news );

		//---------------------------------------
		// Listeners information
		//---------------------------------------

		$listeners = $stats['LISTENERLIST'];

		if ( is_array( $listeners ) )
        {
		    for ( $i = 0; $i < sizeof( $listeners ); $i++ )
            {

			}
		}

		//---------------------------------------
		// Pass to CP skin file
		//---------------------------------------

        $this->registry->output->html .= $this->html->viewListenerHistory( $stats, $listeners );

		//---------------------------------------
		// Song history information
		//---------------------------------------

		$history = $stats['SONGHISTORY'];

		if ( is_array( $history ) )
        {
			for ( $i = 0; $i < sizeof( $history ); $i++ )
            {

			}
		}

		//---------------------------------------
		// Pass to CP skin file
		//---------------------------------------

        $this->registry->output->html .= $this->html->viewSongHistory( $stats, $history );

		//---------------------------------------
		// Pass to CP skin file
		//---------------------------------------

        $versionHistory = array();

        $this->DB->build( array( 'select' => 'upgrade_date, upgrade_version_id, upgrade_version_human',
                                 'from'   => 'upgrade_history',
                                 'where'  => "upgrade_app='musicbox'",
                                 'order'  => 'upgrade_version_id DESC',
                                 'limit'  => array( 0, 5 ) ) );

        $this->DB->execute();

        while ( $row = $this->DB->fetch() )
        {
            $row['date'] = $this->lang->getDate( $row['upgrade_date'], 'SHORT' );
            $versionHistory[] = $row;
        }

		//---------------------------------------
		// Pass to CP skin file
		//---------------------------------------

        $this->registry->output->html .= $this->html->viewVersionHistory( $versionHistory );
    }
}