<?php
/**
 * stats.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

/**
 * Main class
 */
class viewXML
{
    /**
     * Host
     *
     * @access public
     */
    public $host;

    /**
     * Port
     *
     * @access public
     */
    public $port;

    /**
     * Password
     *
     * @access public
     */
    public $pass;

    /**
     * Stats
     *
     * @access public
     */
    public $stats = array();

    /**
     * Xml
     *
     * @access private
     */
    private $xml;

    /**
     * Error
     *
     * @access private
     */
	private $error;

	/**
	 * Main function
	 *
	 * @access public
	 */
	public function __construct( ipsRegistry $registry )
	{
		//---------------------------------------
		// Registry objects
		//---------------------------------------

		$this->registry = ipsRegistry::instance();
		$this->settings	= &$this->registry->fetchSettings();

		//---------------------------------------
		// Load language
		//---------------------------------------

		$this->registry->class_localization->loadLanguageFile( array( 'public_musicbox' ) );

		//---------------------------------------
		// Setup host, port & pass
		//---------------------------------------

        $this->host = $this->settings['host'];
        $this->port = $this->settings['port'];
        $this->pass = $this->settings['pass'];
	}

    /**
     * Get file contents
     *
     * @access private
     */
	private function getFileContents()
    {
		$fp = @fsockopen( $this->host, $this->port, $errno, $errstr, 1 );

		if ( ! $fp )
        {
		    $this->error = "<center><strong>An Error Occurred:</strong> $errstr ($errno)</center>";
            return;
		}

        else
        {
		    fputs( $fp, "GET /admin.cgi?pass=".$this->pass."&mode=viewxml HTTP/1.0\r\n" );
            fputs( $fp, "User-Agent: Mozilla\r\n\r\n" );
		    while ( ! feof( $fp ) )
            {
     	   		$this->xml .= fgets( $fp, 1024 );
		    }

		    fclose( $fp );

		    if ( stristr( $this->xml, "HTTP/1.0 200 OK" ) == true )
            {
    			$this->xml = trim( substr( $this->xml, 42 ) );
			}

            else
            {
			    $this->error = "<center><strong>Invalid Password:</strong> Wrong password to connect to your radio server. Note that passwords are (CaSe SeNsItIvE)</center>";
                return;
			}

			$xmlparser = xml_parser_create();

			if ( ! xml_parse_into_struct( $xmlparser, $this->xml, $this->values, $this->indexes ) )
            {
				$this->error = "<center><strong>Unparsable XML:</strong> Reset xml in the admin control panel option to left.";
                return;
			}

			xml_parser_free( $xmlparser );
			return $xmlparser;
		}
	}

    /**
     * Server status
     *
     * @access private
     */
	private function getServerStatus()
    {
		return $this->values[$this->indexes["STREAMSTATUS"][0]]["value"];
	}

    /**
     * Server title
     *
     * @access private
     */
	private function getServerTitle()
    {
		return $this->values[$this->indexes["SERVERTITLE"][0]]["value"];
	}

    /**
     * Song title
     *
     * @access private
     */
	private function getSongTitle()
    {
		return $this->values[$this->indexes["SONGTITLE"][0]]["value"];
	}

    /**
     * Server genre
     *
     * @access private
     */
	private function getServerGenre()
    {
		return $this->values[$this->indexes["SERVERGENRE"][0]]["value"];
	}

    /**
     * Bitrate
     *
     * @access private
     */
	private function getBitRate()
    {
		return $this->values[$this->indexes["BITRATE"][0]]["value"];
	}

    /**
     * Peak listeners
     *
     * @access private
     */
	private function getPeakListeners()
    {
		return $this->values[$this->indexes["PEAKLISTENERS"][0]]["value"];
	}

    /**
     * Current listeners
     *
     * @access private
     */
	private function getCurrentListeners()
    {
		return $this->values[$this->indexes["CURRENTLISTENERS"][0]]["value"];
	}

    /**
     * Max listeners
     *
     * @access private
     */
	private function getMaxListeners()
    {
		return $this->values[$this->indexes["MAXLISTENERS"][0]]["value"];
	}

    /**
     * Web hits
     *
     * @access private
     */
	private function getWebHits()
    {
		return $this->values[$this->indexes["WEBHITS"][0]]["value"];
	}

    /**
     * Stream hits
     *
     * @access private
     */
	private function getStreamHits()
    {
		return $this->values[$this->indexes["STREAMHITS"][0]]["value"];
	}

    /**
     * Reported listeners
     *
     * @access private
     */
	private function getReportedListeners()
    {
		return $this->values[$this->indexes["REPORTEDLISTENERS"][0]]["value"];
	}

    /**
     * Average time
     *
     * @access private
     */
	private function getAverageTime()
    {
		return $this->values[$this->indexes["AVERAGETIME"][0]]["value"];
	}

    /**
     * Song history
     *
     * @access private
     */
	private function getSongHistory()
    {
        $i = 0;

	    while( $i < sizeof( $this->indexes['TITLE'] ) )
        {
		    $history[$i] = array(
            "title"    => $this->values[$this->indexes['TITLE'][$i]]['value'],
			"playedat" => $this->registry->getClass( 'class_localization' )->getDate( $this->values[$this->indexes['PLAYEDAT'][$i]]['value'], 'SHORT' ) );
            $i++;
		}

		return $history;
	}

    /**
     * Listeners list
     *
     * @access private
     */
	private function getListeners()
    {
        $i = 0;

		while( $i < sizeof( $this->indexes['USERAGENT'] ) )
        {
		    $listeners[$i] = array(
			"hostname"    => $this->values[$this->indexes['HOSTNAME'][$i]]['value'],
			"useragent"   => $this->values[$this->indexes['USERAGENT'][$i]]['value'],
			"underruns"   => $this->values[$this->indexes['UNDERRUNS'][$i]]['value'],
			"connecttime" => $this->convertSeconds( $this->values[$this->indexes['CONNECTTIME'][$i]]['value'] ),
			"pointer"     => $this->values[$this->indexes['POINTER'][$i]]['value'],
			"uid"         => $this->values[$this->indexes['UID'][$i]]['value'], );
            $i++;
		}

		return $listeners;
	}

    /**
     * Convert hms
     *
     * @access private
     */
    private function convertSeconds( $seconds )
    {
	    $tmpseconds = substr( "00".$seconds % 60, -2 )."s";
	        if ( $seconds > 59 )
            {
		        if ( $seconds > 3599 )
                {
			        $tmphours = substr( "0".intval( $seconds / 3600 ), -2 );
			        $tmpminutes = substr( "0".intval( $seconds / 60 - ( 60 * $tmphours ) ), -2 );

			        return ( $tmphours."h:".$tmpminutes."m:".$tmpseconds );
		        }

                else
                {
			        return ( "00h:".substr( "0".intval( $seconds / 60 ), -2 )."m:".$tmpseconds );
		        }

	        }

            else
            {
		        return ( "00h:00m:".$tmpseconds );
	        }
    }

    /**
     * Error message
     *
     * @access private
     */
	private function getErrorMessage()
    {
        return $this->error;
    }

    /**
     * Get stats
     *
     * @access public
     */
    public function getStats()
    {
        if ( $this->getFileContents() )
        {
	        if ( $this->getServerStatus() )
            {
                $stats['STREAMSTATUS']      = $this->getServerStatus();
                $stats['STREAMIMAGE']       = "<span class='ipsBadge badge_green'>Online</span>";
                $stats['IMAGESTATUS']       = 'online.png';
                $stats['SERVERTITLE']       = $this->getServerTitle();
                $stats['SONGTITLE']         = $this->getSongTitle();
                $stats['SERVERGENRE']       = $this->getServerGenre();
                $stats['BITRATE']           = $this->getBitRate();
	            $stats['PEAKLISTENERS']     = $this->getPeakListeners();
                $stats['CURRENTLISTENERS']  = $this->getCurrentListeners();
                $stats['MAXLISTENERS']      = $this->getMaxListeners();
                $stats['WEBHITS']           = number_format( $this->getWebHits() );
                $stats['STREAMHITS']        = number_format( $this->getStreamHits() );
                $stats['REPORTEDLISTENERS'] = $this->getReportedListeners();
                $stats['AVERAGETIME']       = $this->convertSeconds( $this->getAverageTime() );
                $stats['LISTENERLIST']      = $this->getListeners();
                $stats['SONGHISTORY']       = $this->getSongHistory();

                return $stats;
	        }

		        $stats['STREAMSTATUS']      = '0';
                $stats['STREAMIMAGE']       = "<span class='ipsBadge badge_red'>Offline</span>";
                $stats['IMAGESTATUS']       = "offline.png";
                $stats['WEBHITS']           = number_format( $this->getWebHits() );
                $stats['STREAMHITS']        = number_format( $this->getStreamHits() );
                $stats['REPORTEDLISTENERS'] = "0";
                $stats['AVERAGETIME']       = "00h:00m:00s";
                $stats['LISTENERLIST']      = "No Reported Listeners Right Now...";
                $stats['SONGHISTORY']       = $this->getSongHistory();

                return $stats;
            }

            $stats['STREAMSTATUS']      = 'error';
            $stats['STREAMIMAGE']       = "<span class='ipsBadge badge_purple'>Error</span>";
            $stats['IMAGESTATUS']       = 'error.png';
            $stats['ERROR']             = $this->getErrorMessage();
            $stats['WEBHITS']           = "An Error Occurred";
            $stats['STREAMHITS']        = "An Error Occurred";
            $stats['REPORTEDLISTENERS'] = "An Error Occurred";
            $stats['AVERAGETIME']       = "An Error Occurred";
            $stats['LISTENERLIST']      = "An Error Occurred";
            $stats['SONGHISTORY']       = "An Error Occurred";

            return $stats;
    }
}