<?php
/**
 * view.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

/**
 * Main class
 */
class public_musicbox_display_view extends ipsCommand
{
	/**
	 * Main function
	 *
	 * @access public
	 */
	public function doExecute( ipsRegistry $registry )
	{
		//---------------------------------------
		// Load language
		//---------------------------------------

		$this->registry->class_localization->loadLanguageFile( array( 'admin_musicbox' ) );

		//---------------------------------------
		// Parse stuff
		//---------------------------------------

		IPSText::getTextClass( 'bbcode' )->parse_html    = 1;
		IPSText::getTextClass( 'bbcode' )->parse_nl2br   = 1;
		IPSText::getTextClass( 'bbcode' )->parse_bbcode  = 1;
		IPSText::getTextClass( 'bbcode' )->parse_smilies = 1;

		//---------------------------------------
		// Set Title
		//---------------------------------------

		$this->registry->output->setTitle( 'MusicBox' . ' - ' . 'Under Construction' );

		//---------------------------------------
		// Add navigation
		//---------------------------------------

		$this->registry->output->addNavigation( 'MusicBox', 'app=musicbox', 'false', 'app=musicbox' );

		//---------------------------------------
		// Show content
		//---------------------------------------

        $this->registry->getClass('output')->showError( "Forbidden: This section is under construction.", 403, false );

		//---------------------------------------
		// Send output
		//---------------------------------------

		$this->registry->output->sendOutput();
	}
}