<?php
/**
 * toggle.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_ACP' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded 'admin.php'.";
	exit();
}

/**
 * Main class
 */
class admin_musicbox_manage_toggle extends ipsCommand
{
	/**
	 * Skin object
	 *
     * @access private
	 */
	private $html;

	/**
	 * Shortcut for url
	 *
     * @access private
	 */
	private $form_code;

	/**
	 * Shortcut for url (javascript)
	 *
     * @access private
	 */
	private $form_code_js;

	/**
	 * Main function
	 *
	 * @access public
	 */
	public function doExecute( ipsRegistry $registry )
	{
		//---------------------------------------
		// Load skin
		//---------------------------------------

		$this->html = $this->registry->output->loadTemplate( 'cp_skin_dashboard' );

		//---------------------------------------
		// Load language
		//---------------------------------------

		$this->registry->class_localization->loadLanguageFile( array( 'admin_musicbox' ) );

		//---------------------------------------
		// Setup form code
		//---------------------------------------

		$this->form_code	= $this->html->form_code	= 'module=manage&amp;section=toggle';
		$this->form_code_js	= $this->html->form_code_js	= 'module=manage&section=toggle';

		//---------------------------------------
		// Global message
		//---------------------------------------

		if( $this->request['save'] == 1 )
		{
			$this->registry->output->global_message = $this->lang->words['settings_updated'];
		}

		//---------------------------------------
		// What to do?
		//---------------------------------------

		switch( $this->request['do'] )
		{
			case 'toggle':
            default:
				$this->settings();
			break;
		}

		//---------------------------------------
		// Pass to CP output hander
		//---------------------------------------

		$this->registry->output->html_main .= $this->registry->output->global_template->global_frame_wrapper();
		$this->registry->output->sendOutput();
	}

	/**
	 * Settings function
	 *
	 * @access private
	 */
	private function settings()
	{
		//---------------------------------------
		// Load settings library
		//---------------------------------------

		$classToLoad = IPSLib::loadLibrary( IPSLib::getAppDir( 'core' ).'/modules_admin/settings/settings.php', 'admin_core_settings_settings' );
		$settings = new $classToLoad( $this->registry );
		$settings->makeRegistryShortcuts( $this->registry );

		//---------------------------------------
		// Load skin
		//---------------------------------------

		$settings->html = $this->registry->output->loadTemplate( 'cp_skin_settings', 'core' );

		//---------------------------------------
		// Load language
		//---------------------------------------

		$this->lang->loadLanguageFile( array( 'admin_tools' ), 'core' );

		//---------------------------------------
		// Setup form code
		//---------------------------------------

		$settings->form_code    = $settings->html->form_code    = 'module=settings&amp;section=settings';
		$settings->form_code_js = $settings->html->form_code_js = 'module=settings&section=settings';

		//---------------------------------------
		// Return after saving
		//---------------------------------------

		$this->request['conf_title_keyword'] = 'conf_toggle';
		$settings->return_after_save = $this->settings['base_url'].$this->form_code.'&save=1';

		//---------------------------------------
		// Display the settings
		//---------------------------------------

		$settings->_viewSettings();
	}
}