<?php
/**
 * help.php
 *
 * @author:      MrShaun <mr_shaun@hotmail.co.uk>
 * @package:     MusicBox
 * @copyright:   (c) 2011 All Rights Reserved
 * @version:     v1.0.2 (10002)
 * @license:     http://www.gnu.org/licenses/gpl-3.0.html
 */

if ( ! defined( 'IN_ACP' ) )
{
    print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded 'admin.php'.";
    exit();
}

/**
 * Main class
 */
class admin_musicbox_support_help extends ipsCommand
{
	/**
	 * Main function
	 *
	 * @access public
	 */
	public function doExecute( ipsRegistry $registry )
	{
		//---------------------------------------
		// Setup id
		//---------------------------------------

		$id = $this->request['id'];
		
		if( $this->request['do'] == 'redirect' )
		{
			$this->redirectURL( $id );
		}
	}

	/**
	 * Main function
	 *
	 * @access public
	 */
	public function redirectURL( $id )
	{
		//---------------------------------------
		// What to do...
		//---------------------------------------

		switch( $id )
		{
			case 'feedback':
				$url = "http://www.bangintunez.co.uk/index.php/forum/84-submit-feedback/";
			break;

			case 'support':
				$url = "http://www.bangintunez.co.uk/index.php/forum/85-get-support/";
			break;

			case 'features':
				$url = "http://www.bangintunez.co.uk/index.php/forum/86-request-features/";
			break;

			case 'bugs':
				$url = "http://www.bangintunez.co.uk/index.php/forum/87-report-a-bug/";
			break;
			
			case 'faq':
				$url = "http://www.bangintunez.co.uk/index.php/forum/88-questions-answers/";
			break;
		}

		//---------------------------------------
		// Redirect
		//---------------------------------------

		$this->registry->output->silentRedirect( $url );
	}
}