<?php
/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.4.1
 * Basic downloads Search
 * Last Updated: $Date: 2011-07-08 15:07:09 -0400 (Fri, 08 Jul 2011) $
 * </pre>
 *
 * @author 		$Author: ips_terabyte $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Board
 * @subpackage	Downloads
 * @link		http://www.invisionpower.com
 * @version		$Rev: 9189 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class search_engine_downloads extends search_engine
{
	/**
	 * Categories we have access to
	 * 
	 * @var	array
	 */
 	protected $categories	= array();
 	
	/**
	 * Constructor
	 */
	public function __construct( ipsRegistry $registry )
	{		
		parent::__construct( $registry );
	}
	
	/**
	 * Perform a search.
	 * Returns an array of a total count (total number of matches)
	 * and an array of IDs ( 0 => 1203, 1 => 928, 2 => 2938 ).. matching the required number based on pagination. The ids returned would be based on the filters and type of search
	 *
	 * So if we had 1000 replies, and we are on page 2 of 25 per page, we'd return 25 items offset by 25
	 *
	 * @access public
	 * @return array
	 */
	public function search()
	{
		/* INIT */
		$sort_by		= IPSSearchRegistry::get('in.search_sort_by');
		$sort_order		= IPSSearchRegistry::get('in.search_sort_order');
		$search_term	= IPSSearchRegistry::get('in.clean_search_term');
		$sortKey		= '';
		$rows			= array();

		/* Sorting */
		switch( $sort_by )
		{
			default:
			case 'date':
				$sortKey  = 'f.file_submitted';
			break;
			case 'update':
				$sortKey  = 'f.file_updated';
			break;
			case 'title':
				$sortKey  = 'f.file_name';
			break;
			case 'views':
				$sortKey  = 'f.file_views';
			break;
			case 'rating':
				$sortKey  = 'f.file_rating';
			break;
			case 'downloads':
				$sortKey  = 'f.file_downloads';
			break;
		}

		//-----------------------------------------
		// Get categories
		//-----------------------------------------
		
		if( !count($this->categories) )
		{
			$this->DB->build( array( 'select' => 'perm_type_id as category_id', 'from' => 'permission_index', 'where' => "app='downloads' AND perm_type='cat' AND " . $this->DB->buildRegexp( "perm_view", $this->member->perm_id_array ) ) );
			$this->DB->execute();
			
			while( $r = $this->DB->fetch() )
			{
				$this->categories[]	= $r['category_id'];
			}
		}
		
		/* Query the count */	
		$count = $this->DB->buildAndFetch( array( 'select' => 'COUNT(*) as total_results',
												  'from'   => 'downloads_files',
 												  'where'  => str_replace( 'f.', '', $this->_buildWhereStatement( $search_term ) ),
										 )		 );
		
		/* Do the search */
		$this->DB->build( array('select'   => "f.*",
								'from'	   => array( 'downloads_files' => 'f' ),
								'where'	   => $this->_buildWhereStatement( $search_term ),
								'order'    => $sortKey . ' ' . $sort_order,
								'limit'    => array( IPSSearchRegistry::get('in.start'), IPSSearchRegistry::get('opt.search_per_page') ),
								'add_join' => array( array( 'select' => 'mem.member_id, mem.members_seo_name, mem.members_display_name, mem.member_group_id, mem.mgroup_others',
															'from'   => array( 'members' => 'mem' ),
															'where'  => "mem.member_id=f.file_submitter",
															'type'   => 'left', ) )
						 )		);
		$this->DB->execute();
		
		/* Sort */
		while( $r = $this->DB->fetch() )
		{
			$rows[] = $r;
		}
	
		/* Return it */
		return array( 'count' => $count['total_results'], 'resultSet' => $rows );
	}
	
	/**
	 * Perform the viewNewContent search
	 * Populates $this->_count and $this->_results
	 *
	 * @access	public
	 * @return	nothin'
	 */
	public function viewNewContent()
	{
		/* Loop through the forums and build a list of forums we're allowed access to */
		$start			= IPSSearchRegistry::get('in.start');
		$perPage		= IPSSearchRegistry::get('opt.search_per_page');
		$seconds		= IPSSearchRegistry::get('in.period_in_seconds');
		$followedOnly	= IPSSearchRegistry::get('in.vncFollowFilterOn' );
		
		IPSSearchRegistry::set('in.search_sort_by'   , 'date' );
		IPSSearchRegistry::set('in.search_sort_order', 'desc' );
		IPSSearchRegistry::set('opt.searchType' , 'titles' );
		IPSSearchRegistry::set('opt.noPostPreview'   , true );

		/* Finalize times */
		if ( IPSSearchRegistry::get('in.period_in_seconds') !== false )
		{
			$this->search_begin_timestamp	= intval( IPS_UNIX_TIME_NOW - $seconds );
		}
		else
		{
			$fileIds	= $this->registry->getClass('classItemMarking')->fetchCookieData( 'downloads', 'items' );
			$oldStamp	= $this->registry->getClass('classItemMarking')->fetchOldestUnreadTimestamp( array(), 'downloads' );
		
			if ( ! $oldStamp OR $oldStamp == IPS_UNIX_TIME_NOW )
			{
				$oldStamp = intval( $this->memberData['last_visit'] );
			}
			
			if ( $this->memberData['_cache']['gb_mark__downloads'] && ( $this->memberData['_cache']['gb_mark__downloads'] < $oldStamp ) )
			{
				$oldStamp = $this->memberData['_cache']['gb_mark__downloads'];
			}
			
			IPSSearchRegistry::set('set.resultCutToDate', $oldStamp );

			$this->search_begin_timestamp	= $oldStamp;
			
			/* Set read tids */
			if ( count( $fileIds ) )
			{
				$this->whereConditions['AND'][] = "f.file_id NOT IN (" . implode( ",", array_keys( $fileIds ) ) . ')';
			}
		}

		//-----------------------------------------
		// Only content we are following?
		//-----------------------------------------
		
		if ( $followedOnly )
		{
			require_once( IPS_ROOT_PATH . 'sources/classes/like/composite.php' );/*noLibHook*/
			$like = classes_like::bootstrap( 'downloads', 'files' );
			
			$followedFiles	= $like->getDataByMemberIdAndArea( $this->memberData['member_id'] );
			$followedFiles = ( $followedEvents === null ) ? array() : array_keys( $followedFiles );
			
			if( !count($followedFiles) )
			{
				return array( 'count' => 0, 'resultSet' => array() );
			}
			else
			{
				$this->whereConditions['AND'][]	= "f.file_id IN(" . implode( ',', $followedFiles ) . ")";
			}
		}

		//-----------------------------------------
		// Only content we have participated in?
		//-----------------------------------------
		
		if( IPSSearchRegistry::get('in.userMode') )
		{
			switch( IPSSearchRegistry::get('in.userMode') )
			{
				default:
				case 'all': 
					$_fileIds	= $this->_getFileIdsFromComments();
					
					if( count($_fileIds) )
					{
						$this->whereConditions['AND'][]	= "(f.file_submitter=" . $this->memberData['member_id'] . " OR f.file_id IN(" . implode( ',', $_fileIds ) . "))";
					}
					else
					{
						$this->whereConditions['AND'][]	= "f.file_submitter=" . $this->memberData['member_id'];
					}
				break;
				case 'title': 
					$this->whereConditions['AND'][]	= "f.file_submitter=" . $this->memberData['member_id'];
				break;
			}
		}
		
		return $this->search();
	}

	/**
	 * Find files we have commented on
	 *
	 * @return	array
	 */
	protected function _getFileIdsFromComments()
	{
		$ids	= array();
		
		$this->DB->build( array(
								'select'	=> $this->DB->buildDistinct('comment_fid'),
								'from'		=> 'downloads_comments',
								'where'		=> 'comment_open=1 AND comment_mid=' . $this->memberData['member_id'],
								'limit'		=> array( 0, 200 )
						)		);
		$this->DB->execute();
		
		while( $r = $this->DB->fetch() )
		{
			$ids[]	= $r['comment_fid'];
		}
		
		return $ids;
	}

	/**
	 * Perform the viewUserContent search
	 * Populates $this->_count and $this->_results
	 *
	 * @access	public
	 * @return	nothin'
	 */
	public function viewUserContent( $member )
	{
		/* Search by author */
		$this->whereConditions['AND'][]	= "f.file_submitter=" . intval( $member['member_id'] );
	
		return $this->search();
	}
		
	/**
	 * Builds the where portion of a search string
	 *
	 * @access	protected
	 * @param	string	$search_term		The string to use in the search
	 * @return	string
	 */
	protected function _buildWhereStatement( $search_term )
	{		
		/* INI */
		$where_clause = array();
				
		if( $search_term )
		{
			$search_term = str_replace( '&quot;', '"', $search_term );
			
			switch( IPSSearchRegistry::get('opt.searchType') )
			{
				case 'both':
				default:
					$where_clause[] = '(' . $this->DB->buildSearchStatement( 'f.file_name', $search_term, true, false, ipsRegistry::$settings['use_fulltext'] ) . ' OR ' . $this->DB->buildSearchStatement( 'f.file_desc', $search_term, true, false, ipsRegistry::$settings['use_fulltext'] ) . ')';
				break;
				
				case 'titles':
					$where_clause[] = $this->DB->buildSearchStatement( 'f.file_name', $search_term, true, false, ipsRegistry::$settings['use_fulltext'] );
				break;
				
				case 'content':
					$where_clause[] = $this->DB->buildSearchStatement( 'f.file_desc', $search_term, true, false, ipsRegistry::$settings['use_fulltext'] );
				break;
			}
		}
		
		/* Date Restrict */
		if( $this->search_begin_timestamp && $this->search_end_timestamp )
		{
			$where_clause[] = $this->DB->buildBetween( "f.file_updated", $this->search_begin_timestamp, $this->search_end_timestamp );
		}
		else
		{
			if( $this->search_begin_timestamp )
			{
				$where_clause[] = "f.file_updated > {$this->search_begin_timestamp}";
			}
			
			if( $this->search_end_timestamp )
			{
				$where_clause[] = "f.file_updated < {$this->search_end_timestamp}";
			}
		}
		
		/* What categories do we have access to? */
		if( count($this->categories) )
		{
			$categories	= array();
			
			foreach( $this->categories as $category )
			{
				$categories[ $category ]	= $category;
			}
		}
		else
		{
			$categories	= array( 0 );
		}
		
		/* We have categories? We aren't checking permissions here because the i.perm_view filter covers that already */

		if ( ! empty( ipsRegistry::$request['search_app_filters']['downloads']['downloads'] ) AND count( ipsRegistry::$request['search_app_filters']['downloads']['downloads'] ) )
		{
			foreach( $categories as $cat )
			{
				if( !in_array( $cat, ipsRegistry::$request['search_app_filters']['downloads']['downloads'] ) )
				{
					unset( $categories[ $cat ] );
				}
			}
		}

		if( count($categories) )
		{
			$where_clause[]	= "f.file_cat IN(" . implode( ',', $categories ) . ")";
		}
		else
		{
			$where_clause[]	= "f.file_cat=0";
		}
		
		/* Filtering by paid or free? */
		if ( ! empty( ipsRegistry::$request['search_app_filters']['downloads']['freepaid'] ) )
		{
			switch( ipsRegistry::$request['search_app_filters']['downloads']['freepaid'] )
			{
				case 'free':
					$where_clause[]	= "f.file_cost=0";
				break;
				
				case 'paid':
					$where_clause[]	= "f.file_cost > 0";
				break;
			}
		}
		
		/* Add in AND where conditions */
		if( isset( $this->whereConditions['AND'] ) && count( $this->whereConditions['AND'] ) )
		{
			$where_clause = array_merge( $where_clause, $this->whereConditions['AND'] );
		}
		
		/* ADD in OR where conditions */
		if( isset( $this->whereConditions['OR'] ) && count( $this->whereConditions['OR'] ) )
		{
			$where_clause[] = '( ' . implode( ' OR ', $this->whereConditions['OR'] ) . ' )';
		}

		/* Permissions */
		if( !$this->memberData['g_is_supmod'] )
		{
			$where_clause[]	= "f.file_open=1";
		}
	
		/* Build and return the string */
		return implode( " AND ", $where_clause );
	}	
	
	/**
	 * Remap standard columns (Apps can override )
	 *
	 * @access	public
	 * @param	string	$column		sql table column for this condition
	 * @return	string				column
	 * @return	@e void
	 */
	public function remapColumn( $column )
	{
		$column = $column == 'member_id' ? 'f.file_submitter' : $column;

		return $column;
	}
		
	/**
	 * Returns an array used in the searchplugin's setCondition method
	 *
	 * @access	public
	 * @param	array 	$data	Array of forums to view
	 * @return	array 	Array with column, operator, and value keys, for use in the setCondition call
	 */
	public function buildFilterSQL( $data )
	{
		return array();
	}

	/**
	 * Can handle boolean searching
	 *
	 * @access	public
	 * @return	boolean
	 */
	public function isBoolean()
	{
		return true;
	}
}