<?php

/**
 * <pre>
 * Invision Power Services
 * IP.Board v2.4.1
 * IDM topic posting library
 * Last Updated: $Date: 2011-05-05 07:03:47 -0400 (Thu, 05 May 2011) $
 * </pre>
 *
 * @author 		$Author: ips_terabyte $
 * @copyright	(c) 2001 - 2009 Invision Power Services, Inc.
 * @license		http://www.invisionpower.com/community/board/license.html
 * @package		IP.Downloads
 * @link		http://www.invisionpower.com
 * @since		6/24/2008
 * @version		$Revision: 8644 $
 */

if ( ! defined( 'IN_IPB' ) )
{
	print "<h1>Incorrect access</h1>You cannot access this file directly. If you have recently upgraded, make sure you upgraded all the relevant files.";
	exit();
}

class topicsLibrary
{
	/**
	 * Moderator library
	 *
	 * @access	protected
	 * @var 	object
	 */
	protected $moderatorLibrary;

	/**
	 * Posting library
	 *
	 * @access	protected
	 * @var 	object
	 */
	protected $post;
	
	/**
	 * Forum data
	 *
	 * @access	protected
	 * @var 	array
	 */
	protected $forum		= array();

	/**
	 * Current topic data
	 *
	 * @access	protected
	 * @var 	array
	 */
	protected $topic		= array();
	
	/**
	 * Base URL
	 *
	 * @access	protected
	 * @var 	string
	 */
	protected $base_url		= "";
	
	/**
	 * Registry object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $registry;
	
	/**
	 * Database object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $DB;
	
	/**
	 * Settings object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $settings;
	
	/**
	 * Request object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $request;
	
	/**
	 * Language object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $lang;
	
	/**
	 * Member object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $member;
	protected $memberData;
	
	/**
	 * Cache object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $cache;
	protected $caches;
	
	/**
	 * Custom fields kernel object
	 *
	 * @access	protected
	 * @var		object
	 */	
	protected $cfields;	
	
	/**
	 * Current type
	 *
	 * @access	protected
	 * @var		string
	 */	
	protected $type;	
		
	/**
	 * Constructor
	 *
	 * @access	public
	 * @param	object		Registry object
	 * @return	@e void
	 */
	public function __construct( ipsRegistry $registry )
	{
		/* Make object */
		$this->registry = $registry;
		$this->DB       = $this->registry->DB();
		$this->settings =& $this->registry->fetchSettings();
		$this->request  =& $this->registry->fetchRequest();
		$this->lang     = $this->registry->getClass('class_localization');
		$this->member   = $this->registry->member();
		$this->memberData =& $this->registry->member()->fetchMemberData();
		$this->cache    = $this->registry->cache();
		$this->caches   =& $this->registry->cache()->fetchCaches();
	}
	
	/**
	 * Sort out the topic
	 *
	 * @access	public
	 * @param	array 		File information
	 * @param	array 		Category information
	 * @param 	string		Type [new|edit]
	 * @param	boolean		Do not set mid to current member's id if type=new
	 * @return	boolean		Posted successfully
	 */	
	public function sortTopic( $file, $category, $type = 'new', $mid_override = 0 )
	{
		//---------------------------------------------------------
		// Some init
		//---------------------------------------------------------
		
		$this->base_url	= $this->settings['board_url'] . '/index.php?';
		$this->cfields	= '';
		
		$this->registry->class_localization->loadLanguageFile( array( 'public_global' ), 'core' );

		//---------------------------------------------------------
		// Is file open?
		//---------------------------------------------------------

		if( !$file['file_open'] )
		{
			return false;
		}
		
		//---------------------------------------------------------
		// Custom fields added to topic?
		//---------------------------------------------------------

		if( $category['ccfields'] )
		{
			$classToLoad		= IPSLib::loadLibrary( IPSLib::getAppDir('downloads') . '/sources/classes/cfields.php', 'customFields', 'downloads' );
    		$fields				= new $classToLoad( $this->registry );
    		$fields->file_id	= $file['file_id'];
    		$fields->cat_id		= $category['ccfields'];
    		$fields->cache_data	= $this->cache->getCache('idm_cfields');
    	
    		$fields->init_data( 'view' );
    		$fields->parseToView();
    		
    		foreach( $fields->out_fields as $id => $data )
    		{
	    		if( $fields->cache_data[ $id ]['cf_topic'] )
	    		{
		    		$data = $data ? $data : $this->lang->words['cat_no_info'];
		    		
					$this->cfields .= '[b]' . $fields->field_names[ $id ] . '[/b]: ' . $data . "<br />";
				}
    		}
		}
		
		//---------------------------------------------------------
		// Should topic be posted at all?
		//---------------------------------------------------------

		if( $category['coptions']['opt_topice'] == 1 )
		{
			if( $category['coptions']['opt_topicf'] )
			{
				//---------------------------------------------------------
				// Get some libraries we need
				//---------------------------------------------------------

				$classToLoad			= IPSLib::loadLibrary( IPSLib::getAppDir( 'forums' ) . '/sources/classes/moderate.php', 'moderatorLibrary', 'forums' );
				$this->moderatorLibrary	= new $classToLoad( $this->registry );

				$classToLoad			= IPSLib::loadLibrary( IPSLib::getAppDir( 'forums' ) . '/sources/classes/post/classPost.php', 'classPost', 'forums' );
				$classToLoad			= IPSLib::loadLibrary( IPSLib::getAppDir( 'forums' ) . '/sources/classes/post/classPostForms.php', 'classPostForms', 'forums' );
				$this->post				= new $classToLoad( $this->registry );
				
				ipsRegistry::getAppClass( 'forums' );

				//---------------------------------------------------------
				// Format prefix/suffix
				//---------------------------------------------------------
		
				$category['coptions']['opt_topics'] = str_replace( "{catname}", $category['cname'], $category['coptions']['opt_topics'] );
				$category['coptions']['opt_topicp'] = str_replace( "{catname}", $category['cname'], $category['coptions']['opt_topicp'] );
				
				//---------------------------------------------------------
				// Verify topic "poster"
				//---------------------------------------------------------

				if( !$mid_override )
				{
					$file['file_submitter'] = ( $type == 'new' ) ? $this->memberData['member_id'] : $file['file_submitter'];
				}
				
				if( $file['file_submitter'] == 0 AND !$file['file_submitter_name'] )
				{
					$file['file_submitter_name'] = $this->lang->words['global_guestname'];
				}

				//---------------------------------------------------------
				// Update topic or post a new one?
				//---------------------------------------------------------
				
				if(	$type == 'new' )
				{
					$this->_postNewTopic( $file, $category );
				}
				else
				{
					$this->_postUpdatedTopic( $file, $category );
				}
				
				return true;
			}
		}
		
		return false;
	}
	
	/**
	 * Post a new topic
	 *
	 * @access	protected
	 * @param	array 		File information
	 * @param	array 		Category information
	 * @return	boolean
	 */	
	protected function _postNewTopic( $file, $category )
	{
		$this->forum	= $this->registry->getClass('class_forums')->allForums[ $category['coptions']['opt_topicf'] ];
										
		$ttitle			= $file['file_name'];
		
		if( $category['coptions']['opt_topicp'] )
		{
			$ttitle		= $category['coptions']['opt_topicp'] . $ttitle;
		}
		if( $category['coptions']['opt_topics'] )
		{
			$ttitle		.= $category['coptions']['opt_topics'];
		}					
		
		$post_content	= $this->_buildPostContent( $file, $category );

		$this->topic = array(
							'title'				=> $ttitle,
							'state'				=> 'open',
							'posts'				=> 0,
							'starter_id'		=> $file['file_submitter'],
							'starter_name'		=> $file['file_submitter_name'],
							'start_date'		=> time(),
							'last_poster_id'	=> $file['file_submitter'],
							'last_poster_name'	=> $file['file_submitter_name'],
							'last_post'			=> time(),
							'icon_id'			=> 0,
							'author_mode'		=> 1,
							'poll_state'		=> 0,
							'last_vote'			=> 0,
							'views'				=> 0,
							'forum_id'			=> $category['coptions']['opt_topicf'],
							'approved'			=> 1,
							'pinned'			=> 0,
							'title_seo'			=> IPSText::makeSeoTitle( $ttitle ),
							'seo_last_name'		=> IPSText::makeSeoTitle( $file['file_submitter_name'] ),
							'seo_first_name'	=> IPSText::makeSeoTitle( $file['file_submitter_name'] ),
			);

		$this->DB->insert( 'topics', $this->topic );
		$this->topic['tid']     = $this->DB->getInsertId();

		$this->post->sendOutTrackedForumEmails( $this->topic['forum_id'], $this->topic['tid'], $this->topic['title'], $this->forum['name'], $post_content, $file['file_submitter'], $file['file_submitter_name'] );
		
		$post = array(
					'author_id'			=> $file['file_submitter'],
					'use_sig'			=> 1,
					'use_emo'			=> 1,
					'ip_address'		=> $this->member->ip_address,
					'post_date'			=> time(),
					'icon_id'			=> 0,
					'post'				=> $post_content,
					'author_name'		=> $file['file_submitter_name'],
					'topic_id'			=> $this->topic['tid'],
					'queued'			=> 0,
					'post_htmlstate'	=> 0,
					'post_key'			=> md5( microtime() ),
			 );
			 
		$this->DB->insert( 'posts', $post );
		$pid	= $this->DB->getInsertId();
		
		$this->moderatorLibrary->rebuildTopic( $this->topic['tid'], false );
		
		if ( $this->forum['inc_postcount'] )
		{
			$this->post->setPublished( true );
			$this->post->setAuthor( IPSMember::load( $file['file_submitter'] ) );
			$this->post->setForumData( $this->forum );
			$this->post->incrementUsersPostCount();
		}
				
		$this->moderatorLibrary->forumRecount( $category['coptions']['opt_topicf'] );
		$this->cache->rebuildCache( 'stats', 'global' );
			 
		$this->DB->update( "downloads_files", array( 'file_topicid' => $this->topic['tid'], 'file_topicseoname' => $this->topic['title_seo'] ), "file_id=" . $file['file_id'] );		
		
		return true;
	}
	
	/**
	 * Update an existing topic
	 *
	 * @access	protected
	 * @param	array 		File information
	 * @param	array 		Category information
	 * @return	boolean
	 */	
	protected function _postUpdatedTopic( $file, $category )
	{
		$tid	= $file['file_topicid'];

		if( $tid > 0 && $file['file_open'] )
		{
			$ttitle		= $file['file_name'];
			
			if( $category['coptions']['opt_topicp'] )
			{
				$ttitle	= $category['coptions']['opt_topicp'].$ttitle;
			}
			if( $category['coptions']['opt_topics'] )
			{
				$ttitle	.= $category['coptions']['opt_topics'];
			}
										
			$this->DB->update( "topics", array( 'title' => $ttitle, 'title_seo' => IPSText::makeSeoTitle( $ttitle ), 'forum_id' => $category['coptions']['opt_topicf'] ), "tid=" . $tid );
			$this->DB->update( "downloads_files", array( 'file_topicseoname' => IPSText::makeSeoTitle( $ttitle ) ), "file_id=" . $file['file_id'] );		
			
			$firstpost	= $this->DB->buildAndFetch( array( 'select'	=> 'topic_firstpost',
															'from'	=> 'topics',
															'where'	=> 'tid=' . $tid
													)		);
			
			if( $firstpost['topic_firstpost'] )
			{
				$post_content	= $this->_buildPostContent( $file, $category, true );

				$this->DB->update( 'posts', array( 'post' => $post_content, 'edit_time' => time(), 'edit_name' => $file['file_submitter_name'] ), 'pid=' . $firstpost['topic_firstpost'] );
				IPSContentCache::drop( 'post', array( $firstpost['topic_firstpost'] ) );
	
				$this->moderatorLibrary->forumRecount( $category['coptions']['opt_topicf'] );
				$this->cache->rebuildCache( 'stats', 'global' );
			}
		}
		
		return true;
	}
	
	/**
	 * Build the actual post content
	 *
	 * @access	protected
	 * @param	array 		File information
	 * @param	array 		Category information
	 * @param	boolean		Whether or not to add "updated" flag
	 * @return	boolean
	 */	
	protected function _buildPostContent( $file, $category, $addUpdated=false )
	{
		$post_content	= "";

		if( $category['coptions']['opt_topicss'] )
		{
			//-----------------------------------------
			// SS data is not present, so we need to
			// query to see if there is a SS
			//-----------------------------------------
			
			$_check	= $this->DB->buildAndFetch( array( 'select' => 'COUNT(*) as screenshots', 'from' => 'downloads_files_records', 'where' => "record_file_id={$file['file_id']} AND record_backup=0 AND record_type IN ('sslink','ssupload')" ) );
			//print_r($_check);exit;
			if( $_check['screenshots'] )
			{
				$post_content	= "[center][img]{$this->base_url}app=downloads&module=display&section=screenshot&id={$file['file_id']}[/img][/center]<br />";
			}
		}
		
		$post_content			.= "[b]{$this->lang->words['t_filename']}[/b]: {$file['file_name']}<br />";
		
		if( $file['file_submitter'] )
		{
			$post_content		.= "[b]{$this->lang->words['t_fileauthor']}[/b]: [url=" . $this->registry->output->formatUrl( $this->base_url . "showuser={$file['file_submitter']}", IPSText::makeSeoTitle( $file['file_submitter_name'] ), 'showuser' ) . "]{$file['file_submitter_name']}[/url]<br />";
		}
		else
		{
			$post_content		.= "[b]{$this->lang->words['t_fileauthor']}[/b]: {$file['file_submitter_name']}<br />";
		}
		
		$post_content			.= "[b]{$this->lang->words['t_submitted']}[/b]: " . $this->registry->getClass('class_localization')->getDate( $file['file_submitted'], 'DATE', true ) . "<br />";
		
		if( $addUpdated )
		{
			$post_content		.= "[b]{$this->lang->words['t_updated']}[/b]: [i]" . $this->registry->getClass('class_localization')->getDate( $file['file_updated'], 'DATE', true ) . "[/i]<br />";
		}

		$post_content			.= "[b]{$this->lang->words['t_category']}[/b]: [url=" . $this->registry->output->formatUrl( $this->base_url . "app=downloads&showcat={$file['file_cat']}", $category['cname_furl'], 'idmshowcat' ) . "]" . $category['cname'] . "[/url]<br />";
		
		if( $this->cfields )
		{
			$post_content		.= $this->cfields;
		}
		
		// Make sure this is added after the cfields
		$post_content			.= "<br />";
		
		$post_content			.= $file['file_desc'];
		
		$post_content			.= "<br /><br />[url=" . $this->registry->output->formatUrl( $this->base_url . "app=downloads&showfile={$file['file_id']}", $file['file_name_furl'], 'idmshowfile' ) . "]{$this->lang->words['t_clickhere']}[/url]";

		IPSText::getTextClass('bbcode')->parse_html		= $this->registry->getClass('class_forums')->allForums[ $category['coptions']['opt_topicf'] ]['use_html'] ? 1 : 0;
		IPSText::getTextClass('bbcode')->parse_nl2br	= 0;
		IPSText::getTextClass('bbcode')->parse_smilies	= 1;
		IPSText::getTextClass('bbcode')->parse_bbcode	= $this->registry->getClass('class_forums')->allForums[ $category['coptions']['opt_topicf'] ]['use_ibc'] ? 1 : 0;
		IPSText::getTextClass('bbcode')->parsing_section		= 'idm_submit';

		$post_content			= IPSText::getTextClass('bbcode')->preDbParse( $post_content );
		
		return $post_content;
	}

}
