<?php

function fetch_reputation_table(&$userperms, &$userinfo, $show_name='reputation_repa', $add_opt=true) {
global $vbulletin,$show,$db,$stylevar,$vbphrase,$vbcollapse;
$return_value='';
$id=(!empty($userinfo['userid']))? $userinfo['userid']:$vbulletin->userinfo['userid'];
if (!$id) return $return_value;
if (!in_array($show_name,array('reputation_repa','reputation_given'))) return $return_value;

$show_rep=($add_opt OR $userinfo['showreputation']);
$show[$show_name] = false;

if ($vbulletin->options['reputationenable'] AND ($show_rep OR !($userperms['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canhiderep'])))
{
	$vbulletin->options['showuserrates'] = intval($vbulletin->options['showuserrates']);
	$vbulletin->options['showuserraters'] = $vbulletin->userinfo['permissions']['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canseeownrep'];
	if ($show_name=='reputation_repa') {
		$query="SELECT
			reputation.whoadded, reputation.postid, reputation.reputation, reputation.reason, reputation.dateline,
			user.userid, user.username, post.threadid, thread.title, thread.forumid
		FROM " . TABLE_PREFIX . "reputation AS reputation
		LEFT JOIN " . TABLE_PREFIX . "post AS post ON (reputation.postid = post.postid AND post.visible = 1)
		LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid AND thread.visible = 1)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = reputation.whoadded)
		WHERE reputation.userid = " . $id . "
			" . iif($vbulletin->options['showuserraters'] AND trim($vbulletin->userinfo['ignorelist']), " AND reputation.whoadded NOT IN (0," . str_replace(' ', ',', trim($vbulletin->userinfo['ignorelist'])). ")") . "
		ORDER BY reputation.dateline DESC
		LIMIT 0, " . $vbulletin->options['showuserrates'];
		$userbit='whoadded';
		$sumbit='userid';
	} else if ($show_name=='reputation_given') {
		$query="SELECT
			reputation.whoadded, reputation.postid, reputation.reputation, reputation.reason, reputation.dateline,
			user.userid, user.username, post.threadid, thread.title, thread.forumid
		FROM " . TABLE_PREFIX . "reputation AS reputation
		LEFT JOIN " . TABLE_PREFIX . "post AS post ON (reputation.postid = post.postid AND post.visible = 1)
		LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid AND thread.visible = 1)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = reputation.userid)
		WHERE reputation.whoadded = " . $id . "
		        " . iif($vbulletin->options['showuserraters'] AND trim($vbulletin->userinfo['ignorelist']), " AND reputation.userid NOT IN (0," . str_replace(' ', ',', trim($vbulletin->userinfo['ignorelist'])). ")") . "
		ORDER BY reputation.dateline DESC
		LIMIT 0, " . $vbulletin->options['showuserrates'];
		$userbit='userid';
		$sumbit='whoadded';
	}
	if ($vbulletin->options['repa_explain'] AND ($userinfo['showreputation'] OR !($userperms['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canhiderep'])))
	{
		if ($repa_sum = $db->query_first_slave("SELECT sum(IF(reputation>0,reputation,0)) as posrep, sum(IF(reputation<0,reputation,0)) as negrep
		FROM " . TABLE_PREFIX . "reputation AS reputation
		WHERE reputation.".$sumbit." = " . $id))
		{
			$repa_sum['posrep']+=0;
			$repa_sum['negrep']= -($repa_sum['negrep']+0);
			$repa_sum['sumrep']=$repa_sum['posrep']-$repa_sum['negrep'];
			$show[$show_name.'_sum']=true;
		}
	}
	
	$reputations = $db->query_read_slave($query);

	$reputationcommentbits = '';
	if ($vbulletin->options['showuserraters'])
	{
		$reputationcolspan = 5;
		$reputationbgclass = 'alt2';
	}
	else
	{
		$reputationcolspan = 4;
		$reputationbgclass = 'alt1';
	}

	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	while ($reputation = $db->fetch_array($reputations))
	{
		if ($reputation['reputation'] > 0)
		{
			$posneg = 'pos';
		}
		else if ($reputation['reputation'] < 0)
		{
			$posneg = 'neg';
		}
		else
		{
			$posneg = 'balance';
		}
		if ($id != $vbulletin->userinfo['userid'])
		{
            		$forumperms = fetch_permissions($reputation['forumid']); 
            		if (!(($forumperms & $vbulletin->bf_ugp_forumpermissions['canview']) AND ($forumperms & $vbulletin->bf_ugp_forumpermissions['canviewthreads'])))
            		{
				$reputation['title'] = '';
				if ($vbulletin->options['repa_hidecomments']) $reputation['reason']='';
            		}
		}
		$reputation['timeline'] = vbdate($vbulletin->options['timeformat'], $reputation['dateline']);
		$reputation['dateline'] = vbdate($vbulletin->options['dateformat'], $reputation['dateline']);
		$reputation['reason'] = $bbcode_parser->parse($reputation['reason']);
		if ($vbulletin->options['repa_titlelen'] AND (vbstrlen($reputation['title']) >= $vbulletin->options['repa_titlelen']))
		{
			$reputation['title'] = fetch_trimmed_title($reputation['title'], $vbulletin->options['repa_titlelen']);
		}
		$reputation['userbit'] = $reputation[$userbit];
		eval('$reputationcommentbits .= "' . fetch_template('repa_tablebits') . '";');
		$show[$show_name] = true;
	}
	unset($bbcode_parser);

}
if ($show[$show_name])
	eval('$return_value = "' . fetch_template('repa_table') . '";');
	
return $return_value;
}

?>
