<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Rank System v4.1.4 by TheLastSuperman                # ||
|| # Copyright  2011 by Innovation by Instinct, LLC.                 # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 4.0.x                             # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.innovationbyinstinct.com                              # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'rank_version_info.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

$this_script = 'rank_requests';

global $vbulletin;

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
print_cp_header($vbphrase['ranks']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'display';
}

if ($_REQUEST['do'] == 'display')
{
		
	// Grab List of Requests
	$rankRequests = $db->query_read("
	SELECT r.*, rank.rank_name, vb.username AS UserFor, vb2.username AS UserFrom
FROM " . TABLE_PREFIX . "rank_requests AS r, " . TABLE_PREFIX . "rank AS rank, " . TABLE_PREFIX . "user AS vb, " . TABLE_PREFIX . "user AS vb2
WHERE r.rank_req_aid = rank.rank_id AND r.rank_rec_uid = vb.userid AND r.rank_req_uid = vb2.userid
	");
	
	// Construct Table Header
	print_form_header('', '');
	print_table_header($vbphrase['rank_requests'], 6);
	print_cells_row(array(
			$vbphrase['rank_request_time'],
			$vbphrase['rank_request_user_from'],
			$vbphrase['rank_request_user_for'],
			$vbphrase['rank_request_rank_name'],
			$vbphrase['rank_request_reason'],
			$vbphrase['controls']
			), 1, '', -1);
			
		while ($celldata = $db->fetch_array($rankRequests))
		{
		
		$cell = array();
		
		$cell[] = $celldata[rank_req_timestamp];
		$cell[] = $celldata[UserFrom];
		$cell[] = $celldata[UserFor];
		$cell[] = $celldata[rank_name];
		$cell[] = $celldata[rank_req_reason];
		$cell[] = "<a href='rank.php?do=rankusers&rank_id=$celldata[rank_req_aid]&user_id=$celldata[rank_rec_uid]&issue_reason=$celldata[rank_req_reason]'>Grant</a><br /><a href='rank_requests.php?do=delete&taskid=$celldata[rank_req_id]'>Delete</a>";
		
	print_cells_row($cell, 0, '', 1);
	}
	 print_table_footer(6, '', '', 0);  
}

if ($_REQUEST['do'] == 'delete')
{
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "rank_requests WHERE (rank_req_id = '$_GET[taskid]')");
	define('CP_REDIRECT', 'rank_requests.php?do=display');
	print_stop_message('rank_request_task_deleted');
}

############################################################################

print_cp_footer();

?>