<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Rank System v4.1.4 by TheLastSuperman                # ||
|| # Copyright  2011 by Innovation by Instinct, LLC.                 # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 4.0.x                             # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.innovationbyinstinct.com                              # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'ranks.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'RANKS',
	'ranks_categorybit',
	'ranks_category',
	'ranks_rankbit',
	'ranks_rankusers_bit',
	'ranks_viewrank',
	'ranks_postbit_display'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_bbcode.php');
$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ###################### Start get rank_cat_cache #######################

function cache_rank_cats($rank_cat_id = -1, $depth = 0, $display_rank_cat_id=0)
{
	// returns an array of rank cats with correct parenting and depth information
	// see makeforumchooser for an example of usage

	global $db, $rank_cat_cache, $count;
	static $fcache, $i;
	
	if (!is_array($fcache))
	{
	// check to see if we have already have the results from database
		$fcache = array();
		$rank_cats = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "rank_cat
		" . iif($display_rank_cat_id, "WHERE rank_cat_id = $display_rank_cat_id", '') . "
			ORDER BY rank_cat_displayorder
		");
		while ($rank_cat = $db->fetch_array($rank_cats))
		{
			if ($display_rank_cat_id)
			{
			$rank_cat[rank_cat_parentid] = -1;
			}
			$fcache["$rank_cat[rank_cat_parentid]"]["$rank_cat[rank_cat_displayorder]"]["$rank_cat[rank_cat_id]"] = $rank_cat;
		}
	}

	// database has already been queried
	if (is_array($fcache["$rank_cat_id"]))
	{
		foreach ($fcache["$rank_cat_id"] AS $holder)
		{
			foreach ($holder AS $rank_cat)
			{
				$rank_cat_cache["$rank_cat[rank_cat_id]"] = $rank_cat;
				$rank_cat_cache["$rank_cat[rank_cat_id]"]['depth'] = $depth;
				unset($fcache["$rank_cat_id"]);
				cache_rank_cats($rank_cat['rank_cat_id'], $depth + 1, $display_rank_cat_id);
			} // end foreach ($val1 AS $key2 => $forum)
		} // end foreach ($fcache["$forumid"] AS $key1 => $val1)
	} // end if (found $fcache["$forumid"])
}

// ###################### Start makedepthmark #######################
function construct_depth_mark($depth, $depthchar, $depthmark = '')
{
// repeats the supplied $depthmark for the number of times supplied by $depth
// and appends it onto $depthmark
	for ($i = 0; $i < $depth; $i++)
	{
		$depthmark .= $depthchar;
	}
	return $depthmark;
}
// end functions
// ************************************************************
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'viewall';
}

if ($_REQUEST['do'] == 'viewall')
{
$vbulletin->input->clean_array_gpc('r', array(
		'rank_cat_id' => TYPE_UINT
	));

// work out total columns
$totalcols = $vbulletin->options['ra_showicon']+ $vbulletin->options['ra_showimage'] + $vbulletin->options['ra_showdesc'] + $vbulletin->options['ra_showmembers'] + $vbulletin->options['ra_actioncolumn'];
	
	//	echo "rank_cat_id $rank_cat_id";
	$getranks = $db->query_read("
		SELECT rank.*, rank_cat.rank_cat_title
		FROM " . TABLE_PREFIX . "rank AS rank
		LEFT JOIN " . TABLE_PREFIX . "rank_cat AS rank_cat USING (rank_cat_id)
		" . iif($vbulletin->GPC['rank_cat_id'], "WHERE rank.rank_cat_id = ". $vbulletin->GPC['rank_cat_id'] ."", '') . "
		ORDER BY rank_cat.rank_cat_displayorder,rank.rank_displayorder
	");
	
	while ($ra = $db->fetch_array($getranks))
	{
		if ($ra['rank_cat_id'] == -1)
		{
			$globalrank[] = $ra;
		}
		else
		{
			$rankcache[$ra['rank_cat_id']][$ra['rank_id']] = $ra;
		}
	}

	$db->free_result($getranks);

			// Obtain list of users for each rank
			$allrankusers =  $db->query_read("
			SELECT u.userid, u.username, ru.rank_id
			FROM " . TABLE_PREFIX . "rank_user AS ru
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = ru.userid)
			GROUP BY u.userid, u.username, ru.rank_id
			ORDER BY u.userid
			");
			while( $ru = $db->fetch_array($allrankusers))
			{
				$rankuserscache[$ru['rank_id']][$ru['userid']] = $ru;
			}
			$db->free_result($allrankusers);	
	
	cache_rank_cats(-1,0,$vbulletin->GPC['rank_cat_id']);

	foreach($rank_cat_cache AS $key => $rank_cat)
	{
//		$rank_categories = '';
		$rank = array();
		$ranksbits = '';
		if (is_array($rankcache[$rank_cat['rank_cat_id']]))
		{
			foreach($rankcache[$rank_cat['rank_cat_id']] AS $rank_id => $rank)
			{
				if ($rank['rank_active'] == 1)
				{
					
					$rankuserslist = '';
					$rank['rank_desc'] = $bbcode_parser->parse($rank['rank_desc']);
					if (is_array($rankuserscache[$rank['rank_id']]))
					{
						$ra_ui = 0;
						foreach($rankuserscache[$rank['rank_id']] AS $userid => $rankusers)
						{
							$ra_ui++;
							if (($vbulletin->options['ra_display_memberlimit'] == 0) OR ($ra_ui <= $vbulletin->options['ra_display_memberlimit']))
							{
								//- VB3 -// eval('$rankuserslist .= ", ' . fetch_template('ranks_rankusers_bit') . '";');
								//- BEGIN VB4 -//
								$templater = vB_Template::create('ranks_rankusers_bit');
									$templater->register('rankusers', $rankusers);
								$rankuserslist .= $templater->render();
								//- END VB4 -//
							}
						}
						$rankuserslist = substr($rankuserslist , 2); // get rid of initial comma
						if (($vbulletin->options['ra_display_memberlimit'] > 0) AND ($ra_ui > $vbulletin->options['ra_display_memberlimit']))
						{
							$rankuserslist .= "<br> <div align=\"right\"><font size=\"-1\"><a href=\"ranks.php?do=viewrank&rank_id=$rank[rank_id]\">$vbphrase[ra_more_users]</a></font></div>";
						}
					}
					exec_switch_bg();
					//- VB3 -// eval('$ranksbits .= "' . fetch_template('ranks_rankbit') . '";');
					//- BEGIN VB4 -//
					$templater = vB_Template::create('ranks_rankbit');
						$templater->register('rank', $rank);
						$templater->register('rankuserslist', $rankuserslist);
						$templater->register('ra_ui', $ra_ui);
						$templater->register('rank_cat', $rank_cat);
						$templater->register('ranksbits', $ranksbits);
					$ranksbits .= $templater->render();
					//- END VB4 -//
					
				}
			} //foreach $rankcache
		} //if is_array

			//- VB3 -// 
			//eval('$rank_categotybit = "'. construct_depth_mark($rank_cat['depth'], '- - ', '') . fetch_template('ranks_categorybit') . '";');
			//- BEGIN VB4 -//
			$templater = vB_Template::create('ranks_categorybit');
				$templater->register('rank_cat', $rank_cat);
			$rank_categotybit .= $templater->render();
			$rank_categotybit = construct_depth_mark($rank_cat['depth'], '- - ', '');
			//- VB3 -// 
			// eval('$rank_categories .= "' . fetch_template('ranks_category') . '";');
			//- BEGIN VB4 -//
			$templater = vB_Template::create('ranks_category');
				$templater->register('rank', $rank);
				$templater->register('rank_cat', $rank_cat);
				$templater->register('rankuserslist', $rankuserslist);
				$templater->register('ra_ui', $ra_ui);
				$templater->register('rank_categotybit', $rank_categotybit);
				$templater->register('ranksbits', $ranksbits);
			$rank_categories .= $templater->render();
			//- END VB4 -//
			
	} //foreach $rank_cat_cache

$navbits = construct_navbits(array('' => $vbphrase['ranks']));
	
	//- VB3 -// eval('$navbar = "' . fetch_template('navbar') . '";');
	//- BEGIN VB4 -//
	$navbar = render_navbar_template($navbits); 
	//- END VB4 -//

	//- VB3 -// construct_forum_jump();

	//- VB3 -// eval('print_output("' . fetch_template('RANKS') . '");');
	//- BEGIN VB4 -//
	$templater = vB_Template::create('RANKS'); 
		$templater->register_page_templates(); 
		$templater->register('navbar', $navbar); 
		$templater->register('rank_categories', $rank_categories); 
		$templater->register('raversion', $raversion);
	print_output($templater->render()); 
	//- END VB4 -//
}

if ($_REQUEST['do'] == 'viewrank')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'rank_id' => TYPE_UINT
	));

	if ($vbulletin->GPC['rank_id'] == 0)
	{
			eval(standard_error(fetch_error('invalidid', "rankid", $vbulletin->options['contactuslink'])));
	}

			// Obtain list of users for each rank
			$allrankusers =  $db->query_read("
			SELECT u.userid, u.username, ru.rank_id
			FROM " . TABLE_PREFIX . "rank_user AS ru
			LEFT JOIN " . TABLE_PREFIX . "user AS u ON (u.userid = ru.userid)
			WHERE ru.rank_id = " . $vbulletin->GPC['rank_id'] . "
			GROUP BY u.userid, u.username, ru.rank_id
			ORDER BY u.userid
			");
			while( $ru = $db->fetch_array($allrankusers))
			{
				$rankuserscache[$ru['rank_id']][$ru['userid']] = $ru;
			}
			$db->free_result($allrankusers);	

			$rank = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "rank WHERE rank_id = ".$vbulletin->GPC['rank_id'] ."");

				if ($rank['rank_active'] == 1)
				{
					$rank['rank_desc'] = $bbcode_parser->parse($rank['rank_desc']);
					
					$rankuserslist = '';
					if (is_array($rankuserscache[$rank['rank_id']]))
					{
						$ra_ui = 0;
						foreach($rankuserscache[$rank['rank_id']] AS $userid => $rankusers)
						{
								$ra_ui++;
								//- VB3 -// eval('$rankuserslist .= ", ' . fetch_template('ranks_rankusers_bit') . '";');
								//- BEGIN VB4 -//
								$newTemplate = vB_Template::create('ranks_rankusers_bit');
									$newTemplate->register('rankusers', $rankusers);
								$rankuserslist .= $newTemplate->render();  	
								//- END VB4 -//								
								
						}
					}
					$rankuserslist = substr($rankuserslist , 2); // get rid of initial comma
				}

	$navbits = construct_navbits(array('' => $vbphrase['ranks']));
	//- VB3 -// eval('$navbar = "' . fetch_template('navbar') . '";');
	//- BEGIN VB4 -//
	$navbar = render_navbar_template($navbits); 
	//- END VB4 -//
	
	//- VB3 -// construct_forum_jump();
	//- VB3 -// eval('print_output("' . fetch_template('ranks_viewrank') . '");');
	
	//- BEGIN VB4 -//
	$templater = vB_Template::create('ranks_viewrank'); 
		$templater->register_page_templates(); 
		$templater->register('rankuserslist', $rankuserslist); 
		$templater->register('rank', $rank); 
		$templater->register('ra_ui', $ra_ui); 
		$templater->register('navbar', $navbar); 
	print_output($templater->render()); 
	//- END VB4 -//
}
?>